#!/bin/sh 

set -e

#command --upstream-version version filename

[ $# -eq 3 ] || exit 255

echo

version="$2"
filename="$3"
dfsgfilename=`echo $3 | sed 's,\.orig\.,+dfsg.orig.,'`

tar xfj ${filename} 

dir=`tar tfj ${filename} | head -1 | sed 's,/.*,,g'`
rm -f ${filename}

for c in patience rangoon-d rangoon-e rangoon-r tksol
do \
    rm -rf ${dir}/cardset-${c}; \
done
mv ${dir} ${dir}+dfsg

tar cf - ${dir}+dfsg | bzip2 -9 > ${dfsgfilename}

rm -rf ${dir}+dfsg

echo "${dfsgfilename} created."

