# PyEPL: hardware/graphics/font.py
#
# Copyright (C) 2003-2005 Michael J. Kahana
# Authors: Ian Schleifer, Per Sederberg, Aaron Geller, Josh Jacobs
# URL: http://memory.psych.upenn.edu/programming/pyepl
#
# Distributed under the terms of the GNU Lesser General Public License
# (LGPL). See the license.txt that came with this file.

"""
Low level font access.
"""

import pygame
from pygame.locals import *
import image

class LowFont:
    """
    Represents a loaded TrueType font.
    """
    def __init__(self, filename):
        """
        Create LowFont.
        """
        self.filename = filename
        self.size = None
        self.font = None
    def setSize(self, size):
        """
        """
        if size != self.size:
            self.font = pygame.font.Font(self.filename, size)
            self.size = size
    def write(self, text, size, color):
        """
        Render string text onto new LowImage with point size size.
        """
        self.setSize(size)
        r = int(color[0] * 255)
        g = int(color[1] * 255)
        b = int(color[2] * 255)
        try:
            a = int(color[3] * 255)
        except KeyError:
            a = 255
        return image.LowImage(self.font.render(text, True, (r, g, b, a)))
    def getSize(self, text, size):
        """
        Return a 2-tuple of the x, y pixel size of text rendered in
        this font at point size size.
        """
        self.setSize(size)
        return self.font.size(text)
