import recode

declares = [('BPI-JUCA-Translit', 'tjuca')]

class JucaTranslit(recode.GenericStep):
    internal_coding = recode.UNICODE_STRING
    external_coding = 'BPI-JUCA-Translit'
    data = [
        (u'<', '\\<'),
        (u'>', '\\>'),
        (u'A\xc1', "AA\\'"),
        (u'A\xc2', 'AA^'),
        (u'A\u0186', 'AO['),
        (u'A\u0327', 'A\\,'),
        (u'A\u0327\u0300', 'A,`'),
        (u'A\u0327\u0301', "A,'"),
        (u'A\u0327\u030c', 'A,\\v'),
        (u'A\u0331', 'A\\m'),
        (u"CH'", "CH' "),
        (u'CH\u02bc', "CH?'"),
        (u'D\u01b5', 'DZ\\x'),
        (u'D\u01b7', 'DZ]'),
        (u'D\u02bc', "D?'"),
        (u'D\u02bcY', "D?'Y"),
        (u'E\xc9', "EE\\'"),
        (u'E\xca', 'EE^'),
        (u'E\u0327', 'E\\,'),
        (u'E\u0327\u0300', 'E,`'),
        (u'E\u0327\u0301', "E,'"),
        (u'E\u0327\u030c', 'E,\\v'),
        (u'E\u0331', 'E\\m'),
        (u'GH\u0332', 'GH\\m'),
        (u'G\u0323', 'G\\d'),
        (u'H\u02bc', "H?'"),
        (u'I\xcd', "II\\'"),
        (u'I\xce', 'II^'),
        (u'I\u0327', 'I\\,'),
        (u'I\u0327\u0300', 'I,`'),
        (u'I\u0327\u0301', "I,'"),
        (u'I\u0327\u030c', 'I,\\v'),
        (u'I\u0331', 'I\\m'),
        (u'K\u02bc', "K?'"),
        (u'K\u02bcW', "K?'W"),
        (u'L\u0315', 'L\\A'),
        (u'NG\u02bc', "NG?'"),
        (u'N\u0193', 'NG['),
        (u'N\u02bcG', "N?'G"),
        (u'N\u0302', 'N^'),
        (u'N\u0308', 'N"'),
        (u'O\xd3', "OO\\'"),
        (u'O\xd4', 'OO^'),
        (u'O\u0307', 'O\\D'),
        (u'O\u0327', 'O\\,'),
        (u'O\u0327\u0300', 'O,`'),
        (u'O\u0327\u0301', "O,'"),
        (u'O\u0327\u030c', 'O,\\v'),
        (u'O\u0331', 'O\\m'),
        (u'P\u02bc', "P?'"),
        (u'R\u0335', 'R\\x'),
        (u'SH\u0332', 'SH\\m'),
        (u'SS', 'SS+'),
        (u'S\u0321', 'S\\q'),
        (u'TS\u02bc', "TS?'"),
        (u'T\u01a9', 'TS]'),
        (u'T\u02bc', "T?'"),
        (u'T\u0321', 'T\\q'),
        (u'T\u0328', 'T\\g'),
        (u'UE', 'UE+'),
        (u'U\xda', "UU\\'"),
        (u'U\xdb', 'UU^'),
        (u'U\u0327', 'U\\,'),
        (u'U\u0327\u0300', 'U,`'),
        (u'U\u0327\u0301', "U,'"),
        (u'U\u0327\u030c', 'U,\\v'),
        (u'U\u0331', 'U\\m'),
        (u'U\u0336', 'U\\x'),
        (u'U\u0336\u0300', 'U\\x`'),
        (u'U\u0336\u0301', "U\\x'"),
        (u'U\u0336\u0302', 'U\\x^'),
        (u'U\u0336\u0304', 'U\\x='),
        (u'U\u0336\u030c', 'U\\x\\v'),
        (u'W\xc0', 'WA`'),
        (u'W\xc8', 'WE`'),
        (u'W\xcc', 'WI`'),
        (u'W\xcd', "WI\\'"),
        (u'W\xce', 'WI^'),
        (u'W\u01cf', 'WI\\v'),
        (u'Z\u0321', 'Z\\q'),
        (u'ax', 'aw'),
        (u'a\xe1', "aa\\'"),
        (u'a\xe2', 'aa^'),
        (u'a\u0254', 'ao['),
        (u'a\u0327', 'a\\,'),
        (u'a\u0327\u0300', 'a,`'),
        (u'a\u0327\u0301', "a,'"),
        (u'a\u0327\u030c', 'a,\\v'),
        (u'a\u0331', 'a\\m'),
        (u'ch\u02bc', "ch?'"),
        (u'd\u01b6', 'dz\\x'),
        (u'd\u0292', 'dz]'),
        (u'd\u02bc', "d?'"),
        (u'd\u02bcy', "d?'y"),
        (u'd\u0315', 'd\\A'),
        (u'e\xe9', "ee\\'"),
        (u'e\xea', 'ee^'),
        (u'e\u0327', 'e\\,'),
        (u'e\u0327\u0300', 'e,`'),
        (u'e\u0327\u0301', "e,'"),
        (u'e\u0327\u030c', 'e,\\v'),
        (u'e\u0331', 'e\\m'),
        (u'gh\u0332', 'gh\\m'),
        (u'g\u0323', 'g\\d'),
        (u'hx', 'hw'),
        (u'h\u02bc', "h?'"),
        (u'i\xed', "ii\\'"),
        (u'i\xee', 'ii^'),
        (u'i\u0327', 'i\\,'),
        (u'i\u0327\u0300', 'i,`'),
        (u'i\u0327\u0301', "i,'"),
        (u'i\u0327\u030c', 'i,\\v'),
        (u'i\u0331', 'i\\m'),
        (u'k\u02bc', "k?'"),
        (u'k\u02bcw', "k?'w"),
        (u'l\u0315', 'l\\A'),
        (u'ng\u02bc', "ng?'"),
        (u'n\u0260', 'ng['),
        (u'n\u02bcg', "n?'g"),
        (u'n\u0302', 'n^'),
        (u'n\u0308', 'n"'),
        (u'o\xf3', "oo\\'"),
        (u'o\xf4', 'oo^'),
        (u'o\u0307', 'o\\D'),
        (u'o\u0327', 'o\\,'),
        (u'o\u0327\u0300', 'o,`'),
        (u'o\u0327\u0301', "o,'"),
        (u'o\u0327\u030c', 'o,\\v'),
        (u'o\u0331', 'o\\m'),
        (u'p\u02bc', "p?'"),
        (u'r\u0335', 'r\\x'),
        (u'sh\u0332', 'sh\\m'),
        (u's\u0321', 's\\q'),
        (u'ts\u02bc', "ts?'"),
        (u't\u02bc', "t?'"),
        (u't\u0315', 't\\A'),
        (u't\u0328', 't\\g'),
        (u'ue', 'ue+'),
        (u'u\xfa', "uu\\'"),
        (u'u\xfb', 'uu^'),
        (u'u\u0327', 'u\\,'),
        (u'u\u0327\u0300', 'u,`'),
        (u'u\u0327\u0301', "u,'"),
        (u'u\u0327\u030c', 'u,\\v'),
        (u'u\u0331', 'u\\m'),
        (u'w\xe0', 'wa`'),
        (u'w\xe8', 'we`'),
        (u'w\xec', 'wi`'),
        (u'w\xed', "wi\\'"),
        (u'w\xee', 'wi^'),
        (u'w\u01d0', 'wi\\v'),
        (u'z\u0321', 'z\\q'),
        (u'\xa0', '/_'),
        (u'\xa1', '!\\<'),
        (u'\xa2', '_Ct'),
        (u'\xa3', '_Pd'),
        (u'\xa4', '_Cu'),
        (u'\xa5', '_Ye'),
        (u'\xa6', '_BB'),
        (u'\xa7', '_SE'),
        (u'\xa8', '/\\"'),
        (u'\xa9', '_Co'),
        (u'\xaa', '_Fo'),
        (u'\xab', '\\<\\<'),
        (u'\xac', '_NO'),
        (u'\xad', '\\-'),
        (u'\xae', '_Rg'),
        (u'\xaf', '/\\='),
        (u'\xb0', '_DG'),
        (u'\xb1', '_+-'),
        (u'\xb2', '2^'),
        (u'\xb3', '3^'),
        (u'\xb4', "/\\'"),
        (u'\xb5', '_My'),
        (u'\xb6', '_PI'),
        (u'\xb7', '_MD'),
        (u'\xb8', '/\\,'),
        (u'\xb9', '1^'),
        (u'\xba', '_Mo'),
        (u'\xbb', '\\>\\>'),
        (u'\xbc', '_14'),
        (u'\xbd', '_12'),
        (u'\xbe', '_34'),
        (u'\xbf', '?\\<'),
        (u'\xc0', 'A`'),
        (u'\xc0A', 'A`A'),
        (u'\xc1', "A\\'"),
        (u'\xc1A', "A\\'A"),
        (u'\xc2', 'A^'),
        (u'\xc2A', 'A^A'),
        (u'\xc3', 'A~'),
        (u'\xc4', 'A"'),
        (u'\xc4A', 'A"A'),
        (u'\xc5', 'A\\R'),
        (u'\xc6', 'AE+'),
        (u'\xc7', 'C\\,'),
        (u'\xc8', 'E`'),
        (u'\xc8E', 'E`E'),
        (u'\xc9', "E\\'"),
        (u'\xc9E', "E\\'E"),
        (u'\xca', 'E^'),
        (u'\xcaE', 'E^E'),
        (u'\xcb', 'E"'),
        (u'\xcbE', 'E"E'),
        (u'\xcc', 'I`'),
        (u'\xcd', "I\\'"),
        (u'\xcdI', "I\\'I"),
        (u'\xce', 'I^'),
        (u'\xceI', 'I^I'),
        (u'\xcf', 'I"'),
        (u'\xcfI', 'I"I'),
        (u'\xd0', 'D\\x'),
        (u'\xd1', 'N~'),
        (u'\xd2', 'O`'),
        (u'\xd2O', 'O`O'),
        (u'\xd3', "O\\'"),
        (u'\xd3O', "O\\'O"),
        (u'\xd4', 'O^'),
        (u'\xd4O', 'O^O'),
        (u'\xd5', 'O~'),
        (u'\xd6', 'O"'),
        (u'\xd6O', 'O"O'),
        (u'\xd7', '_Xs'),
        (u'\xd8', 'O\\X'),
        (u'\xd8\u0302', 'O\\x^'),
        (u'\xd8\u030c', 'O\\x\\v'),
        (u'\xd9', 'U`'),
        (u'\xda', "U\\'"),
        (u'\xdaU', "U\\'U"),
        (u'\xdb', 'U^'),
        (u'\xdbU', 'U^U'),
        (u'\xdc', 'U"'),
        (u'\xdcU', 'U"U'),
        (u'\xdd', "Y\\'"),
        (u'\xde', '_TH'),
        (u'\xdf', 'ss+'),
        (u'\xe0', 'a`'),
        (u'\xe0a', 'a`a'),
        (u'\xe1', "a\\'"),
        (u'\xe1a', "a\\'a"),
        (u'\xe2', 'a^'),
        (u'\xe2a', 'a^a'),
        (u'\xe3', 'a~'),
        (u'\xe4', 'a"'),
        (u'\xe4a', 'a"a'),
        (u'\xe5', 'a\\R'),
        (u'\xe6', 'ae+'),
        (u'\xe7', 'c\\,'),
        (u'\xe8', 'e`'),
        (u'\xe8e', 'e`e'),
        (u'\xe9', "e\\'"),
        (u'\xe9e', "e\\'e"),
        (u'\xea', 'e^'),
        (u'\xeae', 'e^e'),
        (u'\xeb', 'e"'),
        (u'\xebe', 'e"e'),
        (u'\xec', 'i`'),
        (u'\xed', "i\\'"),
        (u'\xedi', "i\\'i"),
        (u'\xee', 'i^'),
        (u'\xeei', 'i^i'),
        (u'\xef', 'i"'),
        (u'\xefi', 'i"i'),
        (u'\xf0', 'd\\x'),
        (u'\xf1', 'n~'),
        (u'\xf2', 'o`'),
        (u'\xf2o', 'o`o'),
        (u'\xf3', "o\\'"),
        (u'\xf3o', "o\\'o"),
        (u'\xf4', 'o^'),
        (u'\xf4o', 'o^o'),
        (u'\xf5', 'o~'),
        (u'\xf6', 'o"'),
        (u'\xf6o', 'o"o'),
        (u'\xf7', '_Ds'),
        (u'\xf8', 'o\\X'),
        (u'\xf8\u0302', 'o\\x^'),
        (u'\xf8\u030c', 'o\\x\\v'),
        (u'\xf9', 'u`'),
        (u'\xfa', "u\\'"),
        (u'\xfau', "u\\'u"),
        (u'\xfb', 'u^'),
        (u'\xfbu', 'u^u'),
        (u'\xfc', 'u"'),
        (u'\xfcu', 'u"u'),
        (u'\xfd', "y\\'"),
        (u'\xfe', '_th'),
        (u'\xff', 'y"'),
        (u'\u0100', 'A='),
        (u'\u0101', 'a='),
        (u'\u0102', 'A\\u'),
        (u'\u0103', 'a\\u'),
        (u'\u0104', 'A\\g'),
        (u'\u0105', 'a\\g'),
        (u'\u0106', "C\\'"),
        (u'\u0107', "c\\'"),
        (u'\u0108', 'C^'),
        (u'\u0109', 'c^'),
        (u'\u010a', 'C\\D'),
        (u'\u010b', 'c\\D'),
        (u'\u010c', 'C\\v'),
        (u'\u010d', 'c\\v'),
        (u'\u010e', 'D\\v'),
        (u'\u010f', 'd\\v'),
        (u'\u0110', 'D\\X'),
        (u'\u0111', 'd\\X'),
        (u'\u0112', 'E='),
        (u'\u0113', 'e='),
        (u'\u0116', 'E\\D'),
        (u'\u0117', 'e\\D'),
        (u'\u0118', 'E\\g'),
        (u'\u0119', 'e\\g'),
        (u'\u011a', 'E\\v'),
        (u'\u011b', 'e\\v'),
        (u'\u011c', 'G^'),
        (u'\u011d', 'g^'),
        (u'\u011e', 'G\\u'),
        (u'\u011f', 'g\\u'),
        (u'\u0120', 'G\\D'),
        (u'\u0121', 'g\\D'),
        (u'\u0122', 'G\\,'),
        (u'\u0123', 'g\\,'),
        (u'\u0124', 'H^'),
        (u'\u0125', 'h^'),
        (u'\u0126', 'H\\x'),
        (u'\u0127', 'h\\x'),
        (u'\u0128', 'I~'),
        (u'\u0129', 'i~'),
        (u'\u012a', 'I='),
        (u'\u012b', 'i='),
        (u'\u012e', 'I\\g'),
        (u'\u012f', 'i\\g'),
        (u'\u0130', 'I\\D'),
        (u'\u0132', 'IJ+'),
        (u'\u0133', 'ij+'),
        (u'\u0134', 'J^'),
        (u'\u0135', 'j^'),
        (u'\u0136', 'K\\,'),
        (u'\u0137', 'k\\,'),
        (u'\u0139', "L\\'"),
        (u'\u013a', "l\\'"),
        (u'\u013b', 'L\\,'),
        (u'\u013c', 'l\\,'),
        (u'\u013d', 'L\\v'),
        (u'\u013e', 'l\\v'),
        (u'\u0141', 'L\\X'),
        (u'\u0142', 'l\\X'),
        (u'\u0143', "N\\'"),
        (u'\u0144', "n\\'"),
        (u'\u0145', 'N\\,'),
        (u'\u0146', 'n\\,'),
        (u'\u0147', 'N\\v'),
        (u'\u0148', 'n\\v'),
        (u'\u014a', 'N['),
        (u'\u014aG', 'N[G'),
        (u'\u014aGB', 'N[GB'),
        (u'\u014aGW', 'N[GW'),
        (u'\u014aM', 'N[M'),
        (u'\u014aW', 'N[W'),
        (u'\u014aY', 'N[Y'),
        (u'\u014b', 'n['),
        (u'\u014bg', 'n[g'),
        (u'\u014bgb', 'n[gb'),
        (u'\u014bgw', 'n[gw'),
        (u'\u014bm', 'n[m'),
        (u'\u014bw', 'n[w'),
        (u'\u014by', 'n[y'),
        (u'\u014c', 'O='),
        (u'\u014d', 'o='),
        (u'\u0150', 'O\\H'),
        (u'\u0151', 'o\\H'),
        (u'\u0152', 'OE+'),
        (u'\u0153', 'oe+'),
        (u'\u0154', "R\\'"),
        (u'\u0155', "r\\'"),
        (u'\u0156', 'R\\,'),
        (u'\u0157', 'r\\,'),
        (u'\u0158', 'R\\v'),
        (u'\u0159', 'r\\v'),
        (u'\u015a', "S\\'"),
        (u'\u015b', "s\\'"),
        (u'\u015c', 'S^'),
        (u'\u015d', 's^'),
        (u'\u015e', 'S\\,'),
        (u'\u015f', 's\\,'),
        (u'\u0160', 'S\\v'),
        (u'\u0161', 's\\v'),
        (u'\u0162', 'T\\,'),
        (u'\u0163', 't\\,'),
        (u'\u0164', 'T\\v'),
        (u'\u0165', 't\\v'),
        (u'\u0166', 'T\\X'),
        (u'\u0167', 't\\X'),
        (u'\u0168', 'U~'),
        (u'\u0169', 'u~'),
        (u'\u016a', 'U='),
        (u'\u016b', 'u='),
        (u'\u016c', 'U\\u'),
        (u'\u016d', 'u\\u'),
        (u'\u016e', 'U\\R'),
        (u'\u016f', 'u\\R'),
        (u'\u0170', 'U\\H'),
        (u'\u0171', 'u\\H'),
        (u'\u0172', 'U\\g'),
        (u'\u0173', 'u\\g'),
        (u'\u0174', 'W^'),
        (u'\u0175', 'w^'),
        (u'\u0176', 'Y^'),
        (u'\u0177', 'y^'),
        (u'\u0178', 'Y"'),
        (u'\u0179', "Z\\'"),
        (u'\u017a', "z\\'"),
        (u'\u017b', 'Z\\D'),
        (u'\u017c', 'z\\D'),
        (u'\u017d', 'Z\\v'),
        (u'\u017e', 'z\\v'),
        (u'\u0181', 'B['),
        (u'\u0186', 'O['),
        (u'\u0186Y', 'O[Y'),
        (u'\u0186\u0186', 'O[O['),
        (u'\u0186\u0186\u0301', "O[O['"),
        (u'\u0186\u0300', 'O[`'),
        (u'\u0186\u0301', "O['"),
        (u'\u0186\u0301\u0186', "O['O["),
        (u'\u0186\u0302', 'O[^'),
        (u'\u0186\u0303', 'O[~'),
        (u'\u0186\u0304', 'O[='),
        (u'\u0186\u030c', 'O[\\v'),
        (u'\u0186\u0327', 'O[,'),
        (u'\u0187', 'C['),
        (u'\u0188', 'c['),
        (u'\u0189', 'D]'),
        (u'\u018a', 'D['),
        (u'\u018aY', 'D[Y'),
        (u'\u018e', 'E\\<'),
        (u'\u018e\u018e', 'E\\<E\\<'),
        (u'\u018e\u018e\u0301', "E\\<E\\<'"),
        (u'\u018e\u0300', 'E\\<`'),
        (u'\u018e\u0301', "E\\<'"),
        (u'\u018e\u0301\u018e', "E\\<'E\\<"),
        (u'\u018e\u0302', 'E\\<^'),
        (u'\u018e\u0303', 'E\\<~'),
        (u'\u018e\u030c', 'E\\<\\v'),
        (u'\u018e\u0331', 'E\\<='),
        (u'\u0190', 'E['),
        (u'\u0190A', 'E[A'),
        (u'\u0190\u0190', 'E[E['),
        (u'\u0190\u0190\u0301', "E[E['"),
        (u'\u0190\u0300', 'E[`'),
        (u'\u0190\u0301', "E['"),
        (u'\u0190\u0301\u0190', "E['E["),
        (u'\u0190\u0302', 'E[^'),
        (u'\u0190\u0303', 'E[~'),
        (u'\u0190\u0304', 'E[='),
        (u'\u0190\u030c', 'E[\\v'),
        (u'\u0190\u0327', 'E[,'),
        (u'\u0191', 'F]'),
        (u'\u0192', 'f]'),
        (u'\u0193', 'G['),
        (u'\u0194', 'G]'),
        (u'\u0196', 'I['),
        (u'\u0196\u0196', 'I[I['),
        (u'\u0196\u0300', 'I[`'),
        (u'\u0196\u0301', "I['"),
        (u'\u0196\u0302', 'I[^'),
        (u'\u0196\u0303', 'I[~'),
        (u'\u0196\u030c', 'I[\\v'),
        (u'\u0197', 'I\\x'),
        (u'\u0197\u0300', 'I\\x`'),
        (u'\u0197\u0301', "I\\x'"),
        (u'\u0197\u0302', 'I\\x^'),
        (u'\u0197\u0304', 'I\\x='),
        (u'\u0197\u030c', 'I\\x\\v'),
        (u'\u0198', 'K['),
        (u'\u0198W', 'K[W'),
        (u'\u0198Y', 'K[Y'),
        (u'\u0199', 'k['),
        (u'\u0199w', 'k[w'),
        (u'\u0199y', 'k[y'),
        (u'\u019d', 'N]'),
        (u'\u01a4', 'P['),
        (u'\u01a5', 'p['),
        (u'\u01a6', 'R['),
        (u'\u01a9', 'S]'),
        (u'\u01ab', 't\\q'),
        (u'\u01ac', 'T['),
        (u'\u01ad', 't['),
        (u'\u01ae', 'T]'),
        (u'\u01b2', 'V['),
        (u'\u01b2\u0300', 'V[`'),
        (u'\u01b2\u0301', "V['"),
        (u'\u01b2\u0302', 'V[^'),
        (u'\u01b2\u0303', 'V[~'),
        (u'\u01b2\u030c', 'V[\\v'),
        (u'\u01b3', 'Y['),
        (u'\u01b4', 'y['),
        (u'\u01b7', 'Z]'),
        (u'\u01c0', '?|'),
        (u'\u01c1', '?]'),
        (u'\u01c2', '?='),
        (u'\u01c3', '?!'),
        (u'\u01cd', 'A\\v'),
        (u'\u01ce', 'a\\v'),
        (u'\u01cf', 'I\\v'),
        (u'\u01d0', 'i\\v'),
        (u'\u01d1', 'O\\v'),
        (u'\u01d2', 'o\\v'),
        (u'\u01d3', 'U\\v'),
        (u'\u01d4', 'u\\v'),
        (u'\u01dd', 'e\\<'),
        (u'\u01dd\u01dd', 'e\\<e\\<'),
        (u'\u01dd\u01dd\u0301', "e\\<e\\<'"),
        (u'\u01dd\u0300', 'e\\<`'),
        (u'\u01dd\u0301', "e\\<'"),
        (u'\u01dd\u0301\u01dd', "e\\<'e\\<"),
        (u'\u01dd\u0302', 'e\\<^'),
        (u'\u01dd\u0303', 'e\\<~'),
        (u'\u01dd\u030c', 'e\\<\\v'),
        (u'\u01dd\u0331', 'e\\<='),
        (u'\u01fe', "O\\x'"),
        (u'\u01ff', "o\\x'"),
        (u'\u0251', 'a]'),
        (u'\u0251\u0301', "a]'"),
        (u'\u0251\u0302', 'a]^'),
        (u'\u0251\u0304', 'a]='),
        (u'\u0251\u030c', 'a]\\v'),
        (u'\u0253', 'b['),
        (u'\u0254', 'o['),
        (u'\u0254y', 'o[y'),
        (u'\u0254\u0254', 'o[o['),
        (u'\u0254\u0254\u0301', "o[o['"),
        (u'\u0254\u0300', 'o[`'),
        (u'\u0254\u0301', "o['"),
        (u'\u0254\u0301\u0254', "o['o["),
        (u'\u0254\u0302', 'o[^'),
        (u'\u0254\u0303', 'o[~'),
        (u'\u0254\u0304', 'o[='),
        (u'\u0254\u030c', 'o[\\v'),
        (u'\u0254\u0327', 'o[,'),
        (u'\u0256', 'd]'),
        (u'\u0257', 'd['),
        (u'\u0257y', 'd[y'),
        (u'\u025b', 'e['),
        (u'\u025ba', 'e[a'),
        (u'\u025b\u025b', 'e[e['),
        (u'\u025b\u025b\u0301', "e[e['"),
        (u'\u025b\u0300', 'e[`'),
        (u'\u025b\u0301', "e['"),
        (u'\u025b\u0301\u025b', "e['e["),
        (u'\u025b\u0302', 'e[^'),
        (u'\u025b\u0303', 'e[~'),
        (u'\u025b\u0304', 'e[='),
        (u'\u025b\u030c', 'e[\\v'),
        (u'\u025b\u0327', 'e[,'),
        (u'\u0260', 'g['),
        (u'\u0263', 'g]'),
        (u'\u0266', 'h['),
        (u'\u0268', 'i\\x'),
        (u'\u0268\u0300', 'i\\x`'),
        (u'\u0268\u0301', "i\\x'"),
        (u'\u0268\u0302', 'i\\x^'),
        (u'\u0268\u0304', 'i\\x='),
        (u'\u0268\u030c', 'i\\x\\v'),
        (u'\u0269', 'i['),
        (u'\u0269\u0269', 'i[i['),
        (u'\u0269\u0300', 'i[`'),
        (u'\u0269\u0301', "i['"),
        (u'\u0269\u0302', 'i[^'),
        (u'\u0269\u0303', 'i[~'),
        (u'\u0269\u030c', 'i[\\v'),
        (u'\u0272', 'n]'),
        (u'\u027d', 'r['),
        (u'\u0283', 's]'),
        (u'\u0288', 't]'),
        (u'\u0289', 'u\\x'),
        (u'\u0289\u0300', 'u\\x`'),
        (u'\u0289\u0301', "u\\x'"),
        (u'\u0289\u0302', 'u\\x^'),
        (u'\u0289\u0304', 'u\\x='),
        (u'\u0289\u030c', 'u\\x\\v'),
        (u'\u028b', 'v['),
        (u'\u028b\u0300', 'v[`'),
        (u'\u028b\u0301', "v['"),
        (u'\u028b\u0302', 'v[^'),
        (u'\u028b\u0303', 'v[~'),
        (u'\u028b\u030c', 'v[\\v'),
        (u'\u028c', 'a\\<'),
        (u'\u0292', 'z]'),
        (u'\u0294', '?^'),
        (u'\u0294L', '?^L'),
        (u'\u0294W', '?^W'),
        (u'\u0294l', '?^l'),
        (u'\u0294w', '?^w'),
        (u'\u0295', '?\\>'),
        (u'\u0298', '?['),
        (u'\u02a7', 'ts]'),
        (u'\u02bc', "?'"),
        (u'\u02bcB', "?'B"),
        (u'\u02bcD', "?'D"),
        (u'\u02bcJ', "?'J"),
        (u'\u02bcL', "?'L"),
        (u'\u02bcP', "?'P"),
        (u'\u02bcW', "?'W"),
        (u'\u02bcY', "?'Y"),
        (u'\u02bcb', "?'b"),
        (u'\u02bcd', "?'d"),
        (u'\u02bcj', "?'j"),
        (u'\u02bcl', "?'l"),
        (u'\u02bcp', "?'p"),
        (u'\u02bcw', "?'w"),
        (u'\u02bcy', "?'y"),
        (u'\u0300', '_/`'),
        (u'\u0301', "_/'"),
        (u'\u0302', '_/^'),
        (u'\u0303', '_/~'),
        (u'\u0304', '_/='),
        (u'\u0306', '_/u'),
        (u'\u0307', '_/D'),
        (u'\u0308', '_/"'),
        (u'\u030a', '_/R'),
        (u'\u030b', '_/H'),
        (u'\u030c', '_/v'),
        (u'\u030d', '_+u'),
        (u'\u030e', '_+U'),
        (u'\u030f', '_+H'),
        (u'\u0323', '_/d'),
        (u'\u0327', '_/,'),
        (u'\u0328', '_/g'),
        (u'\u0331', '_/m'),
        (u'\u0332', '"_'),
        (u'\u0337', '_/x'),
        (u'\u0391', 'A]'),
        (u'\u0391\u0301', "A]'"),
        (u'\u0391\u0302', 'A]^'),
        (u'\u0391\u0304', 'A]='),
        (u'\u0391\u030c', 'A]\\v'),
        (u'\u0392', '%B'),
        (u'\u0393', '%G'),
        (u'\u0394', '%D'),
        (u'\u0395', '%E'),
        (u'\u0396', '%Z'),
        (u'\u0397', '%H'),
        (u'\u0398', '%T'),
        (u'\u0399', '%I'),
        (u'\u039a', '%K'),
        (u'\u039b', '%L'),
        (u'\u039c', '%M'),
        (u'\u039d', '%N'),
        (u'\u039e', '%C'),
        (u'\u039f', '%O'),
        (u'\u03a0', '%P'),
        (u'\u03a1', '%R'),
        (u'\u03a3', '%S'),
        (u'\u03a4', '%J'),
        (u'\u03a5', '%U'),
        (u'\u03a6', '%F'),
        (u'\u03a7', '%X'),
        (u'\u03a8', '%Y'),
        (u'\u03a9', '%W'),
        (u'\u03b2', '%b'),
        (u'\u03b3', '%g'),
        (u'\u03b4', '%d'),
        (u'\u03b5', '%e'),
        (u'\u03b6', '%z'),
        (u'\u03b7', '%h'),
        (u'\u03b8', '%t'),
        (u'\u03b9', '%i'),
        (u'\u03ba', '%k'),
        (u'\u03bb', '%l'),
        (u'\u03bc', '%m'),
        (u'\u03bd', '%n'),
        (u'\u03be', '%c'),
        (u'\u03bf', '%o'),
        (u'\u03c0', '%p'),
        (u'\u03c1', '%r'),
        (u'\u03c3', '%s'),
        (u'\u03c4', '%j'),
        (u'\u03c5', '%u'),
        (u'\u03c6', '%f'),
        (u'\u03c7', '%x'),
        (u'\u03c8', '%y'),
        (u'\u03c9', '%w'),
        (u'\u1e04', 'B\\d'),
        (u'\u1e05', 'b\\d'),
        (u'\u1e0c', 'D\\d'),
        (u'\u1e0d', 'd\\d'),
        (u'\u1e0e', 'D\\m'),
        (u'\u1e0f', 'd\\m'),
        (u'\u1e24', 'H\\d'),
        (u'\u1e25', 'h\\d'),
        (u'\u1e34H', 'KH\\m'),
        (u'\u1e35\u1e96', 'kh\\m'),
        (u'\u1e36', 'L\\d'),
        (u'\u1e37', 'l\\d'),
        (u'\u1e3e', "M\\'"),
        (u'\u1e3f', "m\\'"),
        (u'\u1e44', 'N\\D'),
        (u'\u1e45', 'n\\D'),
        (u'\u1e46', 'N\\d'),
        (u'\u1e47', 'n\\d'),
        (u'\u1e48', 'N\\m'),
        (u'\u1e49', 'n\\m'),
        (u'\u1e62', 'S\\d'),
        (u'\u1e63', 's\\d'),
        (u'\u1e6c', 'T\\d'),
        (u'\u1e6d', 't\\d'),
        (u'\u1e6e', 'T\\m'),
        (u'\u1e6f', 't\\m'),
        (u'\u1e84', 'W"'),
        (u'\u1e85', 'w"'),
        (u'\u1e92', 'Z\\d'),
        (u'\u1e93', 'z\\d'),
        (u'\u1ea0', 'A\\d'),
        (u'\u1ea1', 'a\\d'),
        (u'\u1eb8', 'E\\d'),
        (u'\u1eb9', 'e\\d'),
        (u'\u1ebc', 'E~'),
        (u'\u1ebd', 'e~'),
        (u'\u1eca', 'I\\d'),
        (u'\u1ecb', 'i\\d'),
        (u'\u1ecc', 'O\\d'),
        (u'\u1ecd', 'o\\d'),
        (u'\u1ee4', 'U\\d'),
        (u'\u1ee5', 'u\\d'),
        (u'\u2013', '_-'),
        (u'\u2014', '_-+'),
        (u'\u2017', '_=2'),
        (u'\u201a', '_,'),
        (u'\u201c', '``'),
        (u'\u201d', "''"),
        (u'\u201e', ',,'),
        (u'\u2039', '_\\<'),
        (u'\u203a', '_\\>'),
        (u'\u2070', '0^'),
        (u'\u2074', '4^'),
        (u'\u2075', '5^'),
        (u'\u2076', '6^'),
        (u'\u2077', '7^'),
        (u'\u2078', '8^'),
        (u'\u2079', '9^'),
        (u'\u207f', 'n\\^'),
        (u'\u20a7', '_Pt'),
        (u'\u20d1', '"7'),
        (u'\u2122', '_TM'),
        (u'\u2126', '_Om'),
        (u'\u215b', '_18'),
        (u'\u215c', '_38'),
        (u'\u215d', '_58'),
        (u'\u215e', '_78'),
        (u'\u2190', '\\<-'),
        (u'\u2191', '-!'),
        (u'\u2192', '-\\>'),
        (u'\u2193', '_v'),
        (u'\u220e', '_FP'),
        (u'\u221a', '_RT'),
        (u'\u221e', '_00'),
        (u'\u2229', '_(U'),
        (u'\u2248', '_?2'),
        (u'\u2260', '!='),
        (u'\u2261', '_=3'),
        (u'\u2264', '=\\<'),
        (u'\u2265', '/>='),
        (u'\u2310', '_NI'),
        (u'\u2320', '_Iu'),
        (u'\u2321', '_Il'),
        (u'\u2500', '_hh'),
        (u'\u2501', '_='),
        (u'\u2502', '_vv'),
        (u'\u250c', '_dr'),
        (u'\u2510', '_dl'),
        (u'\u2514', '_ur'),
        (u'\u2518', '_ul'),
        (u'\u251c', '_vr'),
        (u'\u2524', '_vl'),
        (u'\u252c', '_dh'),
        (u'\u2534', '_uh'),
        (u'\u253c', '_vh'),
        (u'\u2550', '_HH'),
        (u'\u2551', '_VV'),
        (u'\u2552', '_dR'),
        (u'\u2553', '_Dr'),
        (u'\u2554', '_DR'),
        (u'\u2555', '_dL'),
        (u'\u2556', '_Dl'),
        (u'\u2557', '_LD'),
        (u'\u2558', '_uR'),
        (u'\u2559', '_Ur'),
        (u'\u255a', '_UR'),
        (u'\u255b', '_uL'),
        (u'\u255c', '_Ul'),
        (u'\u255d', '_UL'),
        (u'\u255e', '_vR'),
        (u'\u255f', '_Vr'),
        (u'\u2560', '_VR'),
        (u'\u2561', '_vL'),
        (u'\u2562', '_Vl'),
        (u'\u2563', '_VL'),
        (u'\u2564', '_dH'),
        (u'\u2565', '_Dh'),
        (u'\u2566', '_DH'),
        (u'\u2567', '_uH'),
        (u'\u2568', '_Uh'),
        (u'\u2569', '_UH'),
        (u'\u256a', '_vH'),
        (u'\u256b', '_Vh'),
        (u'\u256c', '_VH'),
        (u'\u2571', '_\\>//'),
        (u'\u2572', '_\\<\\'),
        (u'\u2580', '_TB'),
        (u'\u2584', '_LB'),
        (u'\u2588', '_FB'),
        (u'\u258c', '_lB'),
        (u'\u2590', '_RB'),
        (u'\u2591', '_LS'),
        (u'\u2592', '_MS'),
        (u'\u2593', '_DS'),
        (u'\u25a0', '_fS'),
        (u'\u25e2', '_.\\>//'),
        (u'\u25e3', '_.\\<\\'),
        (u'\u266a', '_d!'),
        ]
