/*
    EditingPreference.m

    Implementation of the EditorLooksPreferences class for the
    ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import "EditorLooksPreferences.h"

#import <Foundation/NSBundle.h>
#import <Foundation/NSData.h>
#import <Foundation/NSKeyedArchiver.h>
#import <Foundation/NSString.h>
#import <Foundation/NSUserDefaults.h>

#import <AppKit/NSColor.h>
#import <AppKit/NSColorWell.h>
#import <AppKit/NSFont.h>
#import <AppKit/NSMatrix.h>
#import <AppKit/NSNibLoading.h>
#import <AppKit/NSTextField.h>
#import <AppKit/NSView.h>

@implementation EditorLooksPreferences

+ (NSString *) name
{
  return _(@"Code Editor Looks");
}

- (void) dealloc
{
  TEST_RELEASE(view);

  [super dealloc];
}

- (void) awakeFromNib
{
  NSUserDefaults * df = [NSUserDefaults standardUserDefaults];

  NSString * fontName;
  float fontSize;
  NSFont * font;
  NSData * data;

  [view retain];
  [view removeFromSuperview];
  DESTROY(bogusWindow);

  fontName = [df objectForKey: @"HKFont"];
  fontSize = [df floatForKey: @"HKFontSize"];
  if (fontName != nil)
    {
      font = [NSFont fontWithName: fontName size: fontSize];
    }
  else
    {
      font = nil;
    }

   // either no font name specified, or no such font found
  if (font == nil)
    {
      ASSIGN(font, [NSFont userFixedPitchFontOfSize: fontSize]);
    }
  [editorFontField setFont: font];
  [editorFontField setStringValue: [NSString stringWithFormat:
    @"%@ %.1fpt", [font fontName], [font pointSize]]];

  data = [df dataForKey: @"EditorTextColor"];
  if (data != nil)
    {
      [textColor setColor: [NSKeyedUnarchiver unarchiveObjectWithData: data]];
    }

  data = [df dataForKey: @"EditorHighlightColor"];
  if (data != nil)
    {
      [highlightColor setColor: [NSKeyedUnarchiver unarchiveObjectWithData:
        data]];
    }

  data = [df dataForKey: @"EditorBackgroundColor"];
  if (data != nil)
    {
      [backgroundColor setColor: [NSKeyedUnarchiver unarchiveObjectWithData:
        data]];
    }

  data = [df dataForKey: @"CrosshairsColor"];
  if (data != nil)
    {
      [crosshairsColor setColor: [NSKeyedUnarchiver unarchiveObjectWithData:
        data]];
    }

  data = [df dataForKey: @"RulerHighlightColor"];
  if (data != nil)
    {
      [rulerHighlightColor setColor: [NSKeyedUnarchiver
        unarchiveObjectWithData: data]];
    }

  data = [df dataForKey: @"GuidelinesColor"];
  if (data != nil)
    {
      [guidelinesColor setColor: [NSKeyedUnarchiver unarchiveObjectWithData:
        data]];
    }

  data = [df dataForKey: @"GuidelinesHighlightColor"];
  if (data != nil)
    {
      [guidelinesHighlightColor setColor: [NSKeyedUnarchiver
        unarchiveObjectWithData: data]];
    }

  data = [df dataForKey: @"EditorInsertionPointColor"];
  if (data != nil)
    {
      [cursorColor setColor: [NSKeyedUnarchiver
        unarchiveObjectWithData: data]];
    }

  [pattern selectCellWithTag: [df integerForKey: @"GuidelinesStyle"]];
}

- (NSView *) view
{
  if (view == nil)
    {
      [NSBundle loadNibNamed: @"EditorLooksPreferences" owner: self];
    }

  return view;
}

- (void) fontChangedInField: (NSTextField *) aTextField
{
  NSString * name;
  NSFont * font = [aTextField font];
  NSUserDefaults * df = [NSUserDefaults standardUserDefaults];

  [df setObject: [font fontName] forKey: @"HKFont"];
  [df setFloat: [font pointSize] forKey: @"HKFontSize"];
}

- (void) changeCursorColor: sender
{
  [[NSUserDefaults standardUserDefaults]
    setObject: [NSKeyedArchiver archivedDataWithRootObject: [cursorColor color]]
       forKey: @"EditorInsertionPointColor"];
}

- (void) changeTextColor: sender
{
  [[NSUserDefaults standardUserDefaults]
    setObject: [NSKeyedArchiver archivedDataWithRootObject: [textColor color]]
       forKey: @"EditorTextColor"];
}

- (void) changeHighlightColor: sender
{
  [[NSUserDefaults standardUserDefaults]
    setObject: [NSKeyedArchiver archivedDataWithRootObject: [highlightColor color]]
       forKey: @"EditorHighlightColor"];
}

- (void) changeBackgroundColor: sender
{
  [[NSUserDefaults standardUserDefaults]
    setObject: [NSKeyedArchiver archivedDataWithRootObject: [backgroundColor color]]
       forKey: @"EditorBackgroundColor"];
}

- (void) changeGuidelinesColor: sender
{
  [[NSUserDefaults standardUserDefaults]
    setObject: [NSKeyedArchiver archivedDataWithRootObject: [guidelinesColor color]]
       forKey: @"GuidelinesColor"];
}

- (void) changeGuidelinesHighlightColor: (id)sender
{
  [[NSUserDefaults standardUserDefaults]
    setObject: [NSKeyedArchiver archivedDataWithRootObject:
    [guidelinesHighlightColor color]]
       forKey: @"GuidelinesHighlightColor"];
}

- (void) changeRulerHighlightColor: sender
{
  [[NSUserDefaults standardUserDefaults]
    setObject: [NSKeyedArchiver archivedDataWithRootObject: [rulerHighlightColor
    color]]
       forKey: @"RulerHighlightColor"];
}

- (void) changeCrosshairsColor: (id)sender
{
  [[NSUserDefaults standardUserDefaults]
    setObject: [NSKeyedArchiver archivedDataWithRootObject: [crosshairsColor
    color]]
       forKey: @"CrosshairsColor"];
}

- (void) changeGuidelinesPattern: (id)sender
{
  [[NSUserDefaults standardUserDefaults]
    setInteger: [[pattern selectedCell] tag]
        forKey: @"GuidelinesStyle"];
}

@end
