
#import "NSImageAdditions.h"

#import <Foundation/NSBundle.h>

@implementation NSImage (PMAdditions)

/**
 * Locates and initializes a named image from the bundle of an object.
 *
 * @param aName The name of the image, without an extension.
 * @param owner The object who's bundle will be searched.
 *
 * This method is more suitable for loading images from external bundles,
 * since the normal +[NSImage imageNamed:] doesn't look there.
 *
 * @return An initialized and autoreleased image object or `nil'
 *      if the image wasn't found.
 */
+ (NSImage *) imageNamed: (NSString *) aName owner: (id) owner
{
  NSBundle * bundle;
  NSString * imagePath;
  NSImage * image;

  bundle = [NSBundle bundleForClass: [owner class]];
  // try file extensions "tiff", "jpg", "jpeg", "png" and "gif"
  (imagePath = [bundle pathForResource: aName ofType: @"tiff"]) ||
    (imagePath = [bundle pathForResource: aName ofType: @"jpg"]) ||
    (imagePath = [bundle pathForResource: aName ofType: @"jpeg"]) ||
    (imagePath = [bundle pathForResource: aName ofType: @"png"]) ||
    (imagePath = [bundle pathForResource: aName ofType: @"gif"]);

  if (imagePath != nil)
    {
      return [[[NSImage alloc] initByReferencingFile: imagePath] autorelease];
    }
  else
    {
      return nil;
    }
}

@end
