/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import java.io.PrintStream;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMember;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.shrink.UsageMarker;

public class UsagePrinter
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor {
    private final UsageMarker usageMarker;
    private final boolean printUnusedItems;
    private final PrintStream ps;
    private String className;

    public UsagePrinter(UsageMarker usageMarker, boolean bl) {
        this(usageMarker, bl, System.out);
    }

    public UsagePrinter(UsageMarker usageMarker, boolean bl, PrintStream printStream) {
        this.usageMarker = usageMarker;
        this.printUnusedItems = bl;
        this.ps = printStream;
    }

    public void visitProgramClass(ProgramClass programClass) {
        if (this.usageMarker.isUsed(programClass)) {
            if (this.printUnusedItems) {
                this.className = programClass.getName();
                programClass.fieldsAccept(this);
                programClass.methodsAccept(this);
                this.className = null;
            } else {
                this.ps.println(ClassUtil.externalClassName(programClass.getName()));
            }
        } else if (this.printUnusedItems) {
            this.ps.println(ClassUtil.externalClassName(programClass.getName()));
        }
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (this.usageMarker.isUsed(programField) ^ this.printUnusedItems) {
            this.printClassNameHeader();
            this.ps.println("    " + UsagePrinter.lineNumberRange(programClass, programField) + ClassUtil.externalFullFieldDescription(programField.getAccessFlags(), programField.getName(programClass), programField.getDescriptor(programClass)));
        }
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (this.usageMarker.isUsed(programMethod) ^ this.printUnusedItems) {
            this.printClassNameHeader();
            this.ps.println("    " + UsagePrinter.lineNumberRange(programClass, programMethod) + ClassUtil.externalFullMethodDescription(programClass.getName(), programMethod.getAccessFlags(), programMethod.getName(programClass), programMethod.getDescriptor(programClass)));
        }
    }

    private void printClassNameHeader() {
        if (this.className != null) {
            this.ps.println(ClassUtil.externalClassName(this.className) + ":");
            this.className = null;
        }
    }

    private static String lineNumberRange(ProgramClass programClass, ProgramMember programMember) {
        String string = programMember.getLineNumberRange(programClass);
        return string != null ? string + ":" : "";
    }
}

