
#ifndef __CGI_LIB_H
#define __CGI_LIB_H

#ifdef __cplusplus
  extern "C" {
#endif

#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>       

#define CMAXENVVAR 500
typedef char ENVVAR[CMAXENVVAR + 1];

short accept_image(void);

/* form processing routines */
void unescape_url(char *url);
int read_cgi_input(llist* entries, char *UPLOADBASEDIRATTACHS);
char *cgi_val(llist l,char *name);
char **cgi_val_multi(llist l, char *name);
char *cgi_name(llist l,char *value);
char **cgi_name_multi(llist l, char *value);

/* miscellaneous CGI routines */
int parse_cookies(llist *entries);
void print_cgi_env(void);
void print_entries(llist l);
char *escape_input(char *str);

/* boolean functions */
short is_form_empty(llist l);
short is_field_exists(llist l, char *str);
short is_field_empty(llist l, char *str);

const char *env2file (llist l, const char *linea_separadora);

const char *SERVER_SOFTWARE (void);
const char *SERVER_NAME (void);
const char *GATEWAY_INTERFACE (void);
const char *SERVER_PROTOCOL (void);
const char *SERVER_PORT (void);
const char *REQUEST_METHOD (void);
const char *PATH_INFO (void);
const char *PATH_TRANSLATED (void);
const char *SCRIPT_NAME (void);
const char *QUERY_STRING (void);
const char *REMOTE_HOST (void);
const char *REMOTE_ADDR (void);
const char *AUTH_TYPE (void);
const char *REMOTE_USER (void);
const char *REMOTE_IDENT (void);
const char *CONTENT_TYPE (void);
const char *CONTENT_LENGTH (void);
const char *HTTP_USER_AGENT (void);
const char *HTTP_ACCEPT (void);

#ifdef __cplusplus
  }
#endif
             
             
#endif
