//
// ApacheCodeWriter.cpp
//
// $Id: //poco/1.4/PageCompiler/src/ApacheCodeWriter.cpp#1 $
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "ApacheCodeWriter.h"
#include "Page.h"


ApacheCodeWriter::ApacheCodeWriter(const Page& page, const std::string& clazz):
	CodeWriter(page, clazz)
{
}


ApacheCodeWriter::~ApacheCodeWriter()
{
}


void ApacheCodeWriter::writeHeaderIncludes(std::ostream& ostr)
{
	CodeWriter::writeHeaderIncludes(ostr);
	ostr << "#include \"Poco/Net/HTTPRequestHandlerFactory.h\"\n";
}


void ApacheCodeWriter::writeFactoryClass(std::ostream& ostr)
{
	ostr << "\n\n";
	factoryClass(ostr, "Poco::Net::HTTPRequestHandlerFactory");
}


void ApacheCodeWriter::writeImplIncludes(std::ostream& ostr)
{
	CodeWriter::writeImplIncludes(ostr);
	ostr << "#include \"Poco/ClassLibrary.h\"\n";
}


void ApacheCodeWriter::writeFactory(std::ostream& ostr)
{
	ostr << "\n\n";
	factoryImpl(ostr, "");
}


void ApacheCodeWriter::writeManifest(std::ostream& ostr)
{
	std::string ns = page().get("page.namespace", "");
	if (!ns.empty()) ns += "::";
	ostr << "\n\n";
	ostr << "POCO_BEGIN_MANIFEST(Poco::Net::HTTPRequestHandlerFactory)\n";
	ostr << "\tPOCO_EXPORT_CLASS(" << ns << clazz() << "Factory)\n";
	ostr << "POCO_END_MANIFEST\n";
}
