/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.27
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};
#endif

/***********************************************************************
 *
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 *
 ************************************************************************/

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
#  if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#    define SWIGTEMPLATEDISAMBIGUATOR template
#  else
#    define SWIGTEMPLATEDISAMBIGUATOR 
#  endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__) || defined(__ICC)
#   define SWIGUNUSED __attribute__ ((unused)) 
# else
#   define SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods for Windows DLLs */
#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   define SWIGEXPORT
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif



/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTELC__)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" } };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else


#if defined(SWIG_NOINCLUDE) || defined(SWIG_NOARRAYS)


int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input);
void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input);
jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz);


int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input);
void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input);
jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz);


int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input);
void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input);
jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz);


int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input);
void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input);
jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz);


int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input);
void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input);
jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz);


int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input);
void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input);
jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz);


int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input);
void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz);


int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input);
void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input);
jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz);


int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input);
void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz);


int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input);
void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz);


int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input);
void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input);
jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz);


int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input);
void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input);
jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz);


#else


/* bool[] support */
int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetBooleanArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new bool[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = ((*jarr)[i] != 0);
  return 1;
}

void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jboolean)carr[i];
  jenv->ReleaseBooleanArrayElements(input, jarr, 0);
}

jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz) {
  jboolean *arr;
  int i;
  jbooleanArray jresult = jenv->NewBooleanArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetBooleanArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jboolean)result[i];
  jenv->ReleaseBooleanArrayElements(jresult, arr, 0);
  return jresult;
}


/* signed char[] support */
int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetByteArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new signed char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (signed char)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jbyte)carr[i];
  jenv->ReleaseByteArrayElements(input, jarr, 0);
}

jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz) {
  jbyte *arr;
  int i;
  jbyteArray jresult = jenv->NewByteArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetByteArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jbyte)result[i];
  jenv->ReleaseByteArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned char[] support */
int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned char)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* short[] support */
int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (short)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned short[] support */
int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned short)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* int[] support */
int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (int)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned int[] support */
int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned int)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* long[] support */
int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (long)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned long[] support */
int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned long)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* jlong[] support */
int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new jlong[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (jlong)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* float[] support */
int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetFloatArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new float[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (float)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jfloat)carr[i];
  jenv->ReleaseFloatArrayElements(input, jarr, 0);
}

jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz) {
  jfloat *arr;
  int i;
  jfloatArray jresult = jenv->NewFloatArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetFloatArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jfloat)result[i];
  jenv->ReleaseFloatArrayElements(jresult, arr, 0);
  return jresult;
}


/* double[] support */
int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetDoubleArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new double[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (double)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jdouble)carr[i];
  jenv->ReleaseDoubleArrayElements(input, jarr, 0);
}

jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz) {
  jdouble *arr;
  int i;
  jdoubleArray jresult = jenv->NewDoubleArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetDoubleArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jdouble)result[i];
  jenv->ReleaseDoubleArrayElements(jresult, arr, 0);
  return jresult;
}


#endif


#include <libplayertcp/playertcp.h>
#include <libplayerxdr/functiontable.h>


#ifdef __cplusplus
extern "C" {
#endif

JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_PLAYERTCP_1DEFAULT_1PORT_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 6665;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_PLAYERTCP_1READBUFFER_1SIZE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 65536;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_PLAYERTCP_1WRITEBUFFER_1SIZE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 65536;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_new_1PlayerTCP(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    PlayerTCP *result;
    
    (void)jenv;
    (void)jcls;
    result = (PlayerTCP *)new PlayerTCP();
    
    *(PlayerTCP **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_delete_1PlayerTCP(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    PlayerTCP *arg1 = (PlayerTCP *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(PlayerTCP **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_PlayerTCP_1thread_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    PlayerTCP *arg1 = (PlayerTCP *) 0 ;
    pthread_t arg2 ;
    pthread_t *argp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(PlayerTCP **)(void *)&jarg1; 
    argp2 = *(pthread_t **)(void *)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null pthread_t");
        return ;
    }
    arg2 = *argp2; 
    if (arg1) (arg1)->thread = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_PlayerTCP_1thread_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    PlayerTCP *arg1 = (PlayerTCP *) 0 ;
    pthread_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(PlayerTCP **)(void *)&jarg1; 
    result =  ((arg1)->thread);
    
    *(pthread_t **)(void *)&jresult = new pthread_t((pthread_t &)result); 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_PlayerTCP_1Listen(JNIEnv *jenv, jclass jcls, jlong jarg1, jintArray jarg2, jint jarg3) {
    jint jresult = 0 ;
    PlayerTCP *arg1 = (PlayerTCP *) 0 ;
    int *arg2 = (int *) 0 ;
    int arg3 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(PlayerTCP **)(void *)&jarg1; 
    {
        arg2 = (int*)(jenv->GetIntArrayElements(jarg2, 0));
    }
    arg3 = (int)jarg3; 
    result = (int)(arg1)->Listen(arg2,arg3);
    
    jresult = (jint)result; 
    {
        
    }
    {
        jenv->ReleaseIntArrayElements(jarg2, (jint*)arg2, 0);
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_PlayerTCP_1AddClient(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jint jarg5, jboolean jarg6, jintArray jarg7) {
    jlong jresult = 0 ;
    PlayerTCP *arg1 = (PlayerTCP *) 0 ;
    sockaddr_in *arg2 = (sockaddr_in *) 0 ;
    unsigned int arg3 ;
    unsigned int arg4 ;
    int arg5 ;
    bool arg6 ;
    int *arg7 = (int *) 0 ;
    MessageQueue *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(PlayerTCP **)(void *)&jarg1; 
    arg2 = *(sockaddr_in **)(void *)&jarg2; 
    arg3 = (unsigned int)jarg3; 
    arg4 = (unsigned int)jarg4; 
    arg5 = (int)jarg5; 
    arg6 = jarg6 ? true : false; 
    {
        arg7 = (int*)(jenv->GetIntArrayElements(jarg7, 0));
    }
    result = (MessageQueue *)(arg1)->AddClient(arg2,arg3,arg4,arg5,arg6,arg7);
    
    *(MessageQueue **)(void *)&jresult = result; 
    {
        
    }
    {
        jenv->ReleaseIntArrayElements(jarg7, (jint*)arg7, 0);
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_PlayerTCP_1Accept(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    PlayerTCP *arg1 = (PlayerTCP *) 0 ;
    int arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(PlayerTCP **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    result = (int)(arg1)->Accept(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_PlayerTCP_1Close(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    PlayerTCP *arg1 = (PlayerTCP *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(PlayerTCP **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    (arg1)->Close(arg2);
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_PlayerTCP_1ReadClient(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    PlayerTCP *arg1 = (PlayerTCP *) 0 ;
    int arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(PlayerTCP **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    result = (int)(arg1)->ReadClient(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_PlayerTCP_1Read(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    PlayerTCP *arg1 = (PlayerTCP *) 0 ;
    int arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(PlayerTCP **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    result = (int)(arg1)->Read(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_PlayerTCP_1Write(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    PlayerTCP *arg1 = (PlayerTCP *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(PlayerTCP **)(void *)&jarg1; 
    result = (int)(arg1)->Write();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_PlayerTCP_1WriteClient(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    PlayerTCP *arg1 = (PlayerTCP *) 0 ;
    int arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(PlayerTCP **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    result = (int)(arg1)->WriteClient(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_PlayerTCP_1DeleteClients(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    PlayerTCP *arg1 = (PlayerTCP *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(PlayerTCP **)(void *)&jarg1; 
    (arg1)->DeleteClients();
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_PlayerTCP_1ParseBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    PlayerTCP *arg1 = (PlayerTCP *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(PlayerTCP **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    (arg1)->ParseBuffer(arg2);
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_PlayerTCP_1HandlePlayerMessage(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3) {
    jint jresult = 0 ;
    PlayerTCP *arg1 = (PlayerTCP *) 0 ;
    int arg2 ;
    Message *arg3 = (Message *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(PlayerTCP **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = *(Message **)(void *)&jarg3; 
    result = (int)(arg1)->HandlePlayerMessage(arg2,arg3);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_PlayerTCP_1DeleteClient(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    PlayerTCP *arg1 = (PlayerTCP *) 0 ;
    MessageQueue *arg2 = (MessageQueue *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(PlayerTCP **)(void *)&jarg1; 
    arg2 = *(MessageQueue **)(void *)&jarg2; 
    (arg1)->DeleteClient(arg2);
    
}


JNIEXPORT jboolean JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_PlayerTCP_1Listening(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jboolean jresult = 0 ;
    PlayerTCP *arg1 = (PlayerTCP *) 0 ;
    int arg2 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(PlayerTCP **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    result = (bool)(arg1)->Listening(arg2);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_PlayerTCP_1GetHost(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    PlayerTCP *arg1 = (PlayerTCP *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(PlayerTCP **)(void *)&jarg1; 
    result = (arg1)->GetHost();
    
    *(uint32_t **)(void *)&jresult = new uint32_t((uint32_t &)result); 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_playerxdr_1function_1t_1interf_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    playerxdr_function_t *arg1 = (playerxdr_function_t *) 0 ;
    uint16_t arg2 ;
    uint16_t *argp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(playerxdr_function_t **)(void *)&jarg1; 
    argp2 = *(uint16_t **)(void *)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null uint16_t");
        return ;
    }
    arg2 = *argp2; 
    if (arg1) (arg1)->interf = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_playerxdr_1function_1t_1interf_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    playerxdr_function_t *arg1 = (playerxdr_function_t *) 0 ;
    uint16_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(playerxdr_function_t **)(void *)&jarg1; 
    result =  ((arg1)->interf);
    
    *(uint16_t **)(void *)&jresult = new uint16_t((uint16_t &)result); 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_playerxdr_1function_1t_1type_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    playerxdr_function_t *arg1 = (playerxdr_function_t *) 0 ;
    uint8_t arg2 ;
    uint8_t *argp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(playerxdr_function_t **)(void *)&jarg1; 
    argp2 = *(uint8_t **)(void *)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null uint8_t");
        return ;
    }
    arg2 = *argp2; 
    if (arg1) (arg1)->type = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_playerxdr_1function_1t_1type_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    playerxdr_function_t *arg1 = (playerxdr_function_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(playerxdr_function_t **)(void *)&jarg1; 
    result =  ((arg1)->type);
    
    *(uint8_t **)(void *)&jresult = new uint8_t((uint8_t &)result); 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_playerxdr_1function_1t_1subtype_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    playerxdr_function_t *arg1 = (playerxdr_function_t *) 0 ;
    uint8_t arg2 ;
    uint8_t *argp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(playerxdr_function_t **)(void *)&jarg1; 
    argp2 = *(uint8_t **)(void *)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null uint8_t");
        return ;
    }
    arg2 = *argp2; 
    if (arg1) (arg1)->subtype = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_playerxdr_1function_1t_1subtype_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    playerxdr_function_t *arg1 = (playerxdr_function_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(playerxdr_function_t **)(void *)&jarg1; 
    result =  ((arg1)->subtype);
    
    *(uint8_t **)(void *)&jresult = new uint8_t((uint8_t &)result); 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_playerxdr_1function_1t_1func_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    playerxdr_function_t *arg1 = (playerxdr_function_t *) 0 ;
    player_pack_fn_t arg2 = (player_pack_fn_t) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(playerxdr_function_t **)(void *)&jarg1; 
    arg2 = *(player_pack_fn_t *)(void *)&jarg2; 
    if (arg1) (arg1)->func = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_playerxdr_1function_1t_1func_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    playerxdr_function_t *arg1 = (playerxdr_function_t *) 0 ;
    player_pack_fn_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(playerxdr_function_t **)(void *)&jarg1; 
    result = (player_pack_fn_t) ((arg1)->func);
    
    *(player_pack_fn_t *)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_new_1playerxdr_1function_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    playerxdr_function_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (playerxdr_function_t *)new playerxdr_function_t();
    
    *(playerxdr_function_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_delete_1playerxdr_1function_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    playerxdr_function_t *arg1 = (playerxdr_function_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(playerxdr_function_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_playerxdr_1get_1func(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jlong jresult = 0 ;
    uint16_t arg1 ;
    uint8_t arg2 ;
    uint8_t arg3 ;
    player_pack_fn_t result;
    uint16_t *argp1 ;
    uint8_t *argp2 ;
    uint8_t *argp3 ;
    
    (void)jenv;
    (void)jcls;
    argp1 = *(uint16_t **)(void *)&jarg1; 
    if (!argp1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null uint16_t");
        return 0;
    }
    arg1 = *argp1; 
    argp2 = *(uint8_t **)(void *)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null uint8_t");
        return 0;
    }
    arg2 = *argp2; 
    argp3 = *(uint8_t **)(void *)&jarg3; 
    if (!argp3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null uint8_t");
        return 0;
    }
    arg3 = *argp3; 
    result = (player_pack_fn_t)playerxdr_get_func(arg1,arg2,arg3);
    
    *(player_pack_fn_t *)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_playerxdr_1ftable_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    playerxdr_function_t arg1 ;
    int arg2 ;
    int result;
    playerxdr_function_t *argp1 ;
    
    (void)jenv;
    (void)jcls;
    argp1 = *(playerxdr_function_t **)(void *)&jarg1; 
    if (!argp1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null playerxdr_function_t");
        return 0;
    }
    arg1 = *argp1; 
    arg2 = (int)jarg2; 
    result = (int)playerxdr_ftable_add(arg1,arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayertcp_playertcp_1javaJNI_playerxdr_1ftable_1init(JNIEnv *jenv, jclass jcls) {
    (void)jenv;
    (void)jcls;
    playerxdr_ftable_init();
    
}


#ifdef __cplusplus
}
#endif

