/* Generated from "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod" by precompile.pike
 *
 * Do NOT edit this file.
 */

#undef PRECOMPILE_API_VERSION
#define PRECOMPILE_API_VERSION 2


#line 1 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
/* -*- c -*-
|| This file is part of Pike. For copyright information see COPYRIGHT.
|| Pike is distributed under GPL, LGPL and MPL. See the file COPYING
|| for more information.
|| $Id: dea8d33472ae421ef08268b9eb1d9fc57434508d $
*/

#include "global.h"
#include "interpret.h"
#include "svalue.h"
#include "pike_macros.h"
#include "object.h"
#include "program.h"
#include "array.h"
#include "pike_error.h"
#include "constants.h"
#include "mapping.h"
#include "stralloc.h"
#include "multiset.h"
#include "pike_types.h"
#include "pike_memory.h"
#include "threads.h"
#include "module_support.h"
#include "cyclic.h"
#include "bignum.h"
#include "main.h"
#include "operators.h"
#include "builtin_functions.h"
#include "fsort.h"
#include "port.h"
#include "gc.h"
#include "block_alloc.h"
#include "pikecode.h"

#include <assert.h>
#include <ctype.h>
#include <errno.h>
#include <math.h>

#ifndef DEFAULT_CMOD_STORAGE
#define DEFAULT_CMOD_STORAGE
#endif
/*! @decl array(array(int|string|type)) describe_program(program p)
 *! @belongs Debug
 *!
 *! Debug function for showing the symbol table of a program.
 *!
 *! @returns
 *!   Returns an array of arrays with the following information
 *!   for each symbol in @[p]:
 *!   @array
 *!     @elem int modifiers
 *!       Bitfield with the modifiers for the symbol.
 *!     @elem string symbol_name
 *!       Name of the symbol.
 *!     @elem type value_type
 *!       Value type for the symbol.
 *!     @elem int symbol_type
 *!       Type of symbol.
 *!     @elem int symbol_offset
 *!       Offset into the code or data area for the symbol.
 *!     @elem int inherit_offset
 *!       Offset in the inherit table to the inherit containing
 *!       the symbol.
 *!     @elem int inherit_level
 *!       Depth in the inherit tree for the inherit containing
 *!       the symbol.
 *!   @endarray
 *!
 *! @note
 *!   The API for this function is not fixed, and has changed
 *!   since Pike 7.6. In particular it would make sense to return
 *!   an array of objects instead, and more information about the
 *!   symbols might be added.
 */
#line 75 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_cq__describe_program_defined
DEFAULT_CMOD_STORAGE void f_cq__describe_program(INT32 args) {
#line 76 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * x;
#line 76 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("_describe_program",args,1);
#line 76 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
x=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 78 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  struct program *p;
  struct array *res;
  int i;

  if (!(p = program_from_svalue(Pike_sp - args)))
    SIMPLE_BAD_ARG_ERROR("_describe_program", 1, "program");

  for (i=0; i < (int)p->num_identifier_references;i++) {
    struct reference *ref = p->identifier_references + i;
    struct identifier *id = ID_FROM_PTR(p, ref);
    struct inherit *inh = INHERIT_FROM_PTR(p, ref);
    push_int(ref->id_flags);
    ref_push_string(id->name);
    ref_push_type_value(id->type);
    push_int(id->identifier_flags);
    if (IDENTIFIER_IS_C_FUNCTION(id->identifier_flags)) {
      push_int(-2);
    } else {
      push_int(id->func.offset);
    }
    push_int(ref->inherit_offset);
    push_int(inh->inherit_level);
    f_aggregate(7);
  }
  f_aggregate(p->num_identifier_references);
  dmalloc_touch_svalue(Pike_sp-1);
  res = Pike_sp[-1].u.array;
  Pike_sp--;
  pop_n_elems(args);
  push_array(res);
}

}
/*! @decl string basetype(mixed x)
 *!
 *! Same as sprintf("%t",x);
 *!
 *! @seealso
 *! @[sprintf()]
 */
#line 118 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_basetype_defined
DEFAULT_CMOD_STORAGE void f_basetype(INT32 args) {
#line 119 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * x;
#line 119 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("basetype",args,1);
#line 119 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
x=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 122 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  int t=x->type;
  struct program *p;
  if(x->type == T_OBJECT && (p = x->u.object->prog))
  {
    ptrdiff_t fun = FIND_LFUN(p->inherits[x->subtype].prog, LFUN__SPRINTF);
    if(fun != -1)
    {
      push_int('t');
      f_aggregate_mapping(0);
      apply_low(x->u.object,
		fun + p->inherits[x->subtype].identifier_level, 2);
      if(Pike_sp[-1].type == T_STRING)
      {
	stack_swap();
	pop_stack();
	return;
      } else if (UNSAFE_IS_ZERO(Pike_sp-1)) {
	pop_n_elems(2);
	push_constant_text("object");
	return;
      } else {
	Pike_error("Non-string returned from _sprintf()\n");
      }
    }
  }
  pop_stack();
  switch(t)
  {
    case T_ARRAY: push_constant_text("array"); break;
    case T_FLOAT: push_constant_text("float"); break;
    case T_FUNCTION: push_constant_text("function"); break;
    case T_INT: push_constant_text("int"); break;
    case T_MAPPING: push_constant_text("mapping"); break;
    case T_MULTISET: push_constant_text("multiset"); break;
    case T_OBJECT: push_constant_text("object"); break;
    case T_PROGRAM: push_constant_text("program"); break;
    case T_STRING: push_constant_text("string"); break;
    case T_TYPE: push_constant_text("type"); break;
    case T_ZERO: push_constant_text("zero"); break;
    case T_VOID: push_constant_text("void"); break;
      /* The following are internal and shouldn't be applicable in normal use. */
    case T_SVALUE_PTR: push_constant_text("svalue_ptr"); break;
    case T_OBJ_INDEX: push_constant_text("obj_index"); break;
    case T_MAPPING_DATA: push_constant_text("mapping_data"); break;
    case T_PIKE_FRAME: push_constant_text("pike_frame"); break;
    case T_MULTISET_DATA: push_constant_text("multiset_data"); break;
    default: push_constant_text("unknown"); break;
  }
}


}
/*! @decl string int2char(int x)
 *! @appears String.int2char
 *!
 *! Same as sprintf("%c",x);
 *!
 *! @seealso
 *! @[sprintf()]
 */
#line 182 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_int2char_defined
DEFAULT_CMOD_STORAGE void f_int2char(INT32 args) {
#line 183 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * x;
#line 183 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("int2char",args,1);
#line 183 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
x=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 186 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  int c;
  struct program *p;
  if(x->type == T_OBJECT && (p = x->u.object->prog))
  {
    ptrdiff_t fun = FIND_LFUN(p->inherits[x->subtype].prog, LFUN__SPRINTF);
    if(fun != -1)
    {
      push_int('c');
      f_aggregate_mapping(0);
      apply_low(x->u.object,
		fun + p->inherits[x->subtype].identifier_level, 2);
      if(Pike_sp[-1].type == T_STRING)
      {
	stack_swap();
	pop_stack();
	return;
      }
      Pike_error("Non-string returned from _sprintf()\n");
    }
  }
  if(x->type != T_INT)
    SIMPLE_BAD_ARG_ERROR("int2char", 1, "int");

  c=x->u.integer;

  if(c>=0 && c<256)
  {
    struct pike_string *s;
    s=begin_shared_string(1);
    s->str[0]=c;
    do { struct pike_string * ret_=(end_shared_string(s)); pop_stack(); push_string(ret_); return; }while(0);
#line 218 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}else{
    struct string_builder tmp;
    init_string_builder(&tmp,0);
    string_builder_putchar(&tmp, c);
    do { struct pike_string * ret_=(finish_string_builder(&tmp)); pop_stack(); push_string(ret_); return; }while(0);
#line 223 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}
}

}
/*! @decl string int2hex(int x)
 *! @appears String.int2hex
 *!
 *! Same as @expr{sprintf("%x",x);@}, i.e. returns the integer @[x] in
 *! hexadecimal base using lower cased symbols.
 *!
 *! @seealso
 *! @[sprintf()]
 */
#line 235 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_int2hex_defined
DEFAULT_CMOD_STORAGE void f_int2hex(INT32 args) {
#line 236 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * x;
#line 236 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("int2hex",args,1);
#line 236 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
x=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 239 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  INT_TYPE c;
  unsigned INT_TYPE n;
  int len;
  struct pike_string *s;
  struct program *p;

  if(x->type == T_OBJECT && (p = x->u.object->prog))
  {
    ptrdiff_t fun = FIND_LFUN(p->inherits[x->subtype].prog, LFUN__SPRINTF);
    if(fun != -1)
    {
      push_int('x');
      f_aggregate_mapping(0);
      apply_low(x->u.object,
		fun + p->inherits[x->subtype].identifier_level, 2);
      if(Pike_sp[-1].type == T_STRING)
      {
	stack_swap();
	pop_stack();
	return;
      }
      Pike_error("Non-string returned from _sprintf()\n");
    }
  }
  if(x->type != T_INT)
    SIMPLE_BAD_ARG_ERROR("int2hex", 1, "int");

  c=x->u.integer;

  len=1;
  if(c<0) {
    len++;
    n=(-c)&((unsigned INT_TYPE)(-1));
  }else{
    n=c;
  }
  while(n>65535) { n>>=16; len+=4; }
  while(n>15) { n>>=4; len++; }
  
  s=begin_shared_string(len);
  if(!c)
  {
    s->str[0]='0';
  }else{
    if(c<0)
    {
      s->str[0]='-';
      n=(-c)&((unsigned INT_TYPE)(-1));
    }else{
      n=c;
    }
    while(len && n)
    {
      s->str[--len]="0123456789abcdef"[n&0xf];
      n>>=4;
    }
  }
  do { struct pike_string * ret_=(end_shared_string(s)); pop_stack(); push_string(ret_); return; }while(0);
#line 298 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}


}
#line 301 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
static INLINE int hexchar( int v )
{
  return v<10 ? v+'0' : (v-10)+'a';
}

/*! @decl string string2hex(string data)
 *! @appears String.string2hex
 *!
 *! Convert a string of binary data to a hexadecimal string.
 *!
 *! @seealso
 *!   @[hex2string()]
 */
PMOD_EXPORT
#define f_string2hex_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_string2hex_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_string2hex(INT32 args) {
#line 315 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_string * s;
#line 315 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("String.string2hex",args,1);
#line 315 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("String.string2hex",1,"string");
#line 315 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(s=Pike_sp[0-1].u.string);
#line 318 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  struct pike_string *hex;
  unsigned char *st = (unsigned char *)s->str;
  int i;

  if (s->size_shift)
    Pike_error("Bad argument 1 to string2hex(), expected 8-bit string.\n");

  hex = begin_shared_string(2 * s->len);

  for (i=0; i<s->len; i++) {
    hex->str[i<<1] = hexchar(st[i]>>4);
    hex->str[i<<1|1] = hexchar(st[i]&15);
   }

  do { struct pike_string * ret_=(end_shared_string(hex)); pop_stack(); push_string(ret_); return; }while(0);
#line 334 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

}
/*! @decl string hex2string(string hex)
 *! @appears String.hex2string
 *!
 *! Convert a string of hexadecimal digits to binary data.
 *!
 *! @seealso
 *!   @[string2hex()]
 */
#line 344 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_hex2string_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_hex2string_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_hex2string(INT32 args) {
#line 345 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_string * hex;
#line 345 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("String.hex2string",args,1);
#line 345 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("String.hex2string",1,"string");
#line 345 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(hex=Pike_sp[0-1].u.string);
#line 348 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  struct pike_string *s;
  int i, o=0;
  unsigned char *q = (unsigned char *)hex->str;
  int l = hex->len>>1;
  if(hex->size_shift) Pike_error("Only hex digits allowed.\n");
  if(hex->len&1) Pike_error("Can't have odd number of digits.\n");

  s = begin_shared_string(l);
  for (i=0; i<l; i++)
  {
      s->str[i]  = (q[o]<='9' ? q[o]-'0' :((q[o]+9)&15))<<4; o++;
      s->str[i] |= (q[o]<='9' ? q[o]-'0': ((q[o]+9)&15));    o++;
  }
  do { struct pike_string * ret_=(end_shared_string(s)); pop_stack(); push_string(ret_); return; }while(0);
#line 363 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

}
/*! @decl array column(array data, mixed index)
 *!
 *! Extract a column from a two-dimensional array.
 *!
 *! This function is exactly equivalent to:
 *! @code
 *! map(@[data], lambda(mixed x,mixed y) { return x[y]; }, @[index])
 *! @endcode
 *!
 *! Except of course it is a lot shorter and faster.
 *! That is, it indices every index in the array data on the value of
 *! the argument index and returns an array with the results.
 *!
 *! @seealso
 *! @[rows()]
 */
#line 381 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_column_defined
DEFAULT_CMOD_STORAGE void f_column(INT32 args) {
#line 382 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct array * data;
#line 382 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * index;
#line 382 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 2) wrong_number_of_args_error("column",args,2);
#line 382 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-2].type != PIKE_T_ARRAY) SIMPLE_ARG_TYPE_ERROR("column",1,"array");
#line 382 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(data=Pike_sp[0-2].u.array);
#line 382 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
index=Pike_sp+1-2; dmalloc_touch_svalue(Pike_sp+1-2);
#line 385 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  do { struct array * ret_=(array_column (data, index, 1)); pop_n_elems(2); push_array(ret_); return; }while(0);
#line 387 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

}
/*! @decl multiset mkmultiset(array a)
 *!
 *! This function creates a multiset from an array.
 *!
 *! @seealso
 *! @[aggregate_multiset()]
 *!
 */
#line 397 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_mkmultiset_defined
DEFAULT_CMOD_STORAGE void f_mkmultiset(INT32 args) {
#line 398 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct array * a;
#line 398 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("mkmultiset",args,1);
#line 398 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_ARRAY) SIMPLE_ARG_TYPE_ERROR("mkmultiset",1,"array");
#line 398 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(a=Pike_sp[0-1].u.array);
#line 401 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  do { struct multiset * ret_=(mkmultiset(a)); pop_stack(); push_multiset(ret_); return; }while(0);
#line 403 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

}
/*! @decl int trace(int level, void|string facility, void|int all_threads)
 *!
 *! This function changes the trace level for the subsystem identified
 *! by @[facility] to @[level]. If @[facility] is zero or left out, it
 *! changes the global trace level which affects all subsystems.
 *!
 *! Enabling tracing causes messages to be printed to stderr. A higher
 *! trace level includes the output from all lower levels. The lowest
 *! level is zero which disables all trace messages.
 *!
 *! See the @tt{-t@} command-line option for more information.
 *!
 *! @param level
 *!   If @[facility] is specified then there is typically only one
 *!   trace level for it, i.e. it's an on-or-off toggle. The global
 *!   trace levels, when @[facility] isn't specified, are:
 *!
 *!   @int
 *!   @value 1
 *!  	Trace calls to Pike functions and garbage collector runs.
 *!   @value 2
 *!  	Trace calls to builtin functions.
 *!   @value 3
 *!  	Trace every interpreted opcode.
 *!   @value 4
 *!  	Also trace the opcode arguments.
 *!   @endint
 *!
 *! @param facility
 *!   Valid facilities are:
 *!
 *!   @string
 *!   @value "gc"
 *!     Trace the doings of the garbage collector. The setting is
 *!     never thread local. @[level] has two different meanings:
 *!     @dl
 *!     @item 1..2
 *!       Trace the start and end of each gc run.
 *!     @item 3..
 *!       Additionally show info about the collected garbage, to aid
 *!       hunting down garbage problems. This currently shows gc'd
 *!       trampolines. Note that the output can be very bulky and is
 *!       somewhat low-level technical. Also note that pike currently
 *!       has to be configured with @expr{--with-rtldebug@} to enable
 *!       this.
 *!     @enddl
 *!   @endstring
 *!
 *! @param all_threads
 *!   Trace levels are normally thread local, so changes affect only
 *!   the current thread. To change the level in all threads, pass a
 *!   nonzero value in this argument.
 *!
 *! @returns
 *!   The old trace level in the current thread is returned.
 */
#line 461 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_trace_defined
DEFAULT_CMOD_STORAGE void f_trace(INT32 args) {
#line 462 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
INT_TYPE level;
#line 462 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_string * facility;
#line 462 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
INT_TYPE all_threads;
#line 462 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args < 1) wrong_number_of_args_error("trace",args,1);
#line 462 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args > 3) wrong_number_of_args_error("trace",args,3);
#line 462 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-args].type != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("trace",1,"int");
#line 462 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
level=Pike_sp[0-args].u.integer;
#line 462 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if (args > 1 &&    (Pike_sp[1-args].type != PIKE_T_INT ||     Pike_sp[1-args].u.integer)) {
#line 462 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[1-args].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("trace",2,"void|string");
#line 462 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(facility=Pike_sp[1-args].u.string);
#line 462 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
} else facility = NULL;
#line 462 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if (args > 2) {
#line 462 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[2-args].type != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("trace",3,"void|int");
#line 462 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
all_threads=Pike_sp[2-args].u.integer;
#line 462 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
} else all_threads = 0;
#line 465 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  INT32 old_level;
  if (facility) {
    struct pike_string *gc_str;
    MAKE_CONST_STRING(gc_str, "gc");
    if (facility == gc_str) {
      old_level = gc_trace;
      gc_trace = level;
    }
    else {
      bad_arg_error("trace", Pike_sp-args, args, 2,
		   "trace facility identifier", Pike_sp-args+1,
                   "Bad argument 2 to trace(). Unknown trace facility.");
    }
  }
  else {
    old_level = Pike_interpreter.trace_level;
#ifdef PIKE_THREADS
    if (!all_threads)
      Pike_interpreter.trace_level = level;
    else {
      struct thread_state *s;
      FOR_EACH_THREAD(s, s->state.trace_level = level);
    }
#else
    Pike_interpreter.trace_level = level;
#endif
  }
  do { INT_TYPE ret_=(old_level); pop_n_elems(args); push_int(ret_); return; }while(0);
#line 494 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

}
/*! @decl mapping(string:float) gc_parameters (void|mapping(string:mixed) params)
 *! @belongs Pike
 *!
 *! Set and get various parameters that control the operation of the
 *! garbage collector. The passed mapping contains the parameters to
 *! set. If a parameter is missing from the mapping, the current value
 *! will be filled in instead. The same mapping is returned. Thus an
 *! empty mapping, or no argument at all, causes a mapping with all
 *! current settings to be returned.
 *!
 *! The following parameters are recognized:
 *!
 *! @mapping
 *! @member int "enabled"
 *!   If this is 1 then the gc is enabled as usual. If it's 0 then all
 *!   automatically scheduled gc runs are disabled and the parameters
 *!   below have no effect, but explicit runs through the @[gc]
 *!   function still works as usual. If it's -1 then the gc is
 *!   completely disabled so that even explicit @[gc] calls won't do
 *!   anything.
 *! @member float "garbage_ratio_low"
 *!   As long as the gc time is less than time_ratio below, aim to run
 *!   the gc approximately every time the ratio between the garbage
 *!   and the total amount of allocated things is this.
 *! @member float "time_ratio"
 *!   When more than this fraction of the time is spent in the gc, aim
 *!   for garbage_ratio_high instead of garbage_ratio_low.
 *! @member float "garbage_ratio_high"
 *!   Upper limit for the garbage ratio - run the gc as often as it
 *!   takes to keep it below this.
 *! @member float "min_gc_time_ratio"
 *!   This puts an upper limit on the gc interval, in addition to the
 *!   factors above. It is specified as the minimum amount of time
 *!   spent doing gc, as a factor of the total time. The reason for
 *!   this limit is that the current amount of garbage can only be
 *!   measured in a gc run, and if the gc starts to run very seldom
 *!   due to very little garbage, it might get too slow to react to an
 *!   increase in garbage generation. Set to 0.0 to turn this limit
 *!   off.
 *! @member float "average_slowness"
 *!   When predicting the next gc interval, use a decaying average
 *!   with this slowness factor. It should be a value between 0.0 and
 *!   1.0 that specifies the weight to give to the old average value.
 *!   The remaining weight up to 1.0 is given to the last reading.
 *! @endmapping
 *!
 *! @seealso
 *!   @[gc], @[Debug.gc_status]
 */
#line 545 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_gc_parameters_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_gc_parameters_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_gc_parameters(INT32 args) {
#line 546 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct mapping * params;
#line 546 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args > 1) wrong_number_of_args_error("gc_parameters",args,1);
#line 546 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if (args > 0 &&    (Pike_sp[0-args].type != PIKE_T_INT ||     Pike_sp[0-args].u.integer)) {
#line 546 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-args].type != PIKE_T_MAPPING) SIMPLE_ARG_TYPE_ERROR("Pike.gc_parameters",1,"void|mapping(string:mixed)");
#line 546 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(params=Pike_sp[0-args].u.mapping);
#line 546 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
} else params = NULL;
#line 549 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  struct pike_string *str;
  struct svalue *set;
  struct svalue get;

  if (!params) {
    push_mapping (allocate_mapping (6));
    params = Pike_sp[-1].u.mapping;
  }

#define HANDLE_PARAM(NAME, CHECK_AND_SET, GET) do {			\
    MAKE_CONST_STRING (str, NAME);					\
    if ((set = low_mapping_string_lookup (params, str))) {		\
      CHECK_AND_SET;							\
    }									\
    else {								\
      GET;								\
      mapping_string_insert (params, str, &get);			\
    }									\
  } while (0)

#define HANDLE_FLOAT_FACTOR(NAME, VAR)					\
  HANDLE_PARAM (NAME, {							\
      if (set->type != T_FLOAT ||					\
	  set->u.float_number < 0.0 || set->u.float_number > 1.0)	\
	SIMPLE_BAD_ARG_ERROR ("Pike.gc_parameters", 1,			\
			      "float between 0.0 and 1.0 for " NAME);	\
      VAR = DO_NOT_WARN ((double) set->u.float_number);			\
    }, {								\
      get.type = T_FLOAT;						\
      get.u.float_number = DO_NOT_WARN ((FLOAT_TYPE) VAR);		\
    });

  HANDLE_PARAM ("enabled", {
      if (set->type != T_INT || set->u.integer < -1 || set->u.integer > 1)
	SIMPLE_BAD_ARG_ERROR ("Pike.gc_parameters", 1,
			      "integer in the range -1..1 for 'enabled'");
      if (gc_enabled != set->u.integer) {
	if (gc_enabled > 0)
	  gc_enabled = set->u.integer;
	else {
	  gc_enabled = 1;
	  if (alloc_threshold == GC_MAX_ALLOC_THRESHOLD)
	    alloc_threshold = GC_MIN_ALLOC_THRESHOLD;
	}
      }
    }, {
      get.type = T_INT;
      get.subtype = NUMBER_NUMBER;
      get.u.integer = gc_enabled;
    });
  HANDLE_FLOAT_FACTOR ("garbage_ratio_low", gc_garbage_ratio_low);
  HANDLE_FLOAT_FACTOR ("time_ratio", gc_time_ratio);
  HANDLE_FLOAT_FACTOR ("garbage_ratio_high", gc_garbage_ratio_high);
  HANDLE_FLOAT_FACTOR ("min_gc_time_ratio", gc_min_time_ratio);
  HANDLE_FLOAT_FACTOR ("average_slowness", gc_average_slowness);

#undef HANDLE_PARAM
#undef HANDLE_FLOAT_FACTOR

  do { struct mapping * ret_=(params); add_ref(ret_); pop_n_elems(args); push_mapping(ret_); return; }while(0);
#line 610 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

}
/*! @decl string ctime(int timestamp)
 *!
 *! Convert the output from a previous call to @[time()] into a readable
 *! string containing the current year, month, day and time.
 *!
 *! Like @[localtime], this function might throw an error if the
 *! ctime(2) call failed on the system. It's platform dependent what
 *! time ranges that function can handle, e.g. Windows doesn't handle
 *! a negative @[timestamp].
 *!
 *! @seealso
 *! @[time()], @[localtime()], @[mktime()], @[gmtime()]
 */
#line 625 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_ctime_defined
DEFAULT_CMOD_STORAGE void f_ctime(INT32 args) {
#line 626 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
LONGEST timestamp;
#line 626 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("ctime",args,1);
#line 626 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if (Pike_sp[0-1].type != PIKE_T_INT
#ifdef AUTO_BIGNUM
#line 626 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  && !is_bignum_object_in_svalue (Pike_sp+0-1)
#endif
#line 626 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
) SIMPLE_ARG_TYPE_ERROR("ctime",1,"int");

#ifdef AUTO_BIGNUM
#line 626 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if (Pike_sp[0-1].type == PIKE_T_INT)
#line 626 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
 timestamp = Pike_sp[0-1].u.integer;
#line 626 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
else
#if SIZEOF_LONGEST > SIZEOF_INT_TYPE
#line 626 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if (!int64_from_bignum (&(timestamp), Pike_sp[0-1].u.object))

#endif
#line 626 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
 SIMPLE_ARG_ERROR ("ctime", 1, "Integer too large.");

#else
#line 626 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
timestamp = Pike_sp[0-1].u.integer;

#endif
{
  time_t i;
  char *s;

#if SIZEOF_TIME_T < SIZEOF_LONGEST
  if (timestamp > MAX_TIME_T || timestamp < MIN_TIME_T)
    SIMPLE_ARG_ERROR ("ctime", 1, "Timestamp outside valid range.");
#endif

  i = (time_t) timestamp;
  s = ctime (&i);
  if (!s) Pike_error ("ctime() on this system cannot handle "
		      "the timestamp %ld.\n", (long) i);
  do { struct pike_string * ret_=(make_shared_string(s)); pop_stack(); push_string(ret_); return; }while(0);
#line 643 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

}
/*! @decl mapping mkmapping(array ind, array val)
 *!
 *! Make a mapping from two arrays.
 *!
 *! Makes a mapping @[ind[x]]:@[val[x]], @tt{0 <= x < sizeof(ind)@}.
 *!
 *! @[ind] and @[val] must have the same size.
 *!
 *! This is the inverse operation of @[indices()] and @[values()].
 *!
 *! @seealso
 *! @[indices()], @[values()]
 */
#line 658 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_mkmapping_defined
DEFAULT_CMOD_STORAGE void f_mkmapping(INT32 args) {
#line 659 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct array * ind;
#line 659 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct array * val;
#line 659 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 2) wrong_number_of_args_error("mkmapping",args,2);
#line 659 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-2].type != PIKE_T_ARRAY) SIMPLE_ARG_TYPE_ERROR("mkmapping",1,"array");
#line 659 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(ind=Pike_sp[0-2].u.array);
#line 659 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[1-2].type != PIKE_T_ARRAY) SIMPLE_ARG_TYPE_ERROR("mkmapping",2,"array");
#line 659 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(val=Pike_sp[1-2].u.array);
#line 662 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  if(ind->size != val->size)
    bad_arg_error("mkmapping", Pike_sp-args, args, 2, "array", Pike_sp+1-args,
		  "mkmapping called on arrays of different sizes (%d != %d)\n",
		  ind->size, val->size);

  do { struct mapping * ret_=(mkmapping(ind, val)); pop_n_elems(2); push_mapping(ret_); return; }while(0);
#line 669 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

}
/*! @decl void secure(string str)
 *! @belongs String
 *!
 *! Marks the string as secure, which will clear the memory area
 *! before freeing the string.
 */
#define f_string_secure_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_string_secure_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_string_secure(INT32 args) {
#line 677 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_string * str;
#line 677 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("string_secure",args,1);
#line 677 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("string_secure",1,"string");
#line 677 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(str=Pike_sp[0-1].u.string);
#line 680 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  str->flags |= STRING_CLEAR_ON_EXIT;
  do { struct pike_string * ret_=(str); add_ref(ret_); pop_stack(); push_string(ret_); return; }while(0);
#line 683 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

}
/*! @decl int count(string haystack, string needle)
 *! @belongs String
 *!
 *! Count the number of non-overlapping times the string @[needle]
 *! occurs in the string @[haystack]. The special cases for the needle
 *! @expr{""@} is that it occurs one time in the empty string, zero
 *! times in a one character string and between every character
 *! (length-1) in any other string.
 *!
 *! @seealso
 *! @[search()], @[`/()]
 */
#line 697 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_string_count_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_string_count_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_string_count(INT32 args) {
#line 698 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_string * haystack;
#line 698 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_string * needle;
#line 698 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 2) wrong_number_of_args_error("String.count",args,2);
#line 698 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-2].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("String.count",1,"string");
#line 698 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(haystack=Pike_sp[0-2].u.string);
#line 698 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[1-2].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("String.count",2,"string");
#line 698 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(needle=Pike_sp[1-2].u.string);
#line 701 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
   ptrdiff_t c = 0;
   ptrdiff_t i, j;

   switch (needle->len)
   {
     case 0:
       switch (haystack->len)
       {
	 case 0: c=1; break; /* "" appears one time in "" */
	 case 1: c=0; break; /* "" doesn't appear in "x" */
	 default: c=haystack->len-1; /* one time between each character */
       }
       break;
     case 1:
       /* maybe optimize? */
       /* It is already fairly optimized in pike_search_engine. */
     default:
       for (i=0; i<haystack->len; i++)
       {
	 j=string_search(haystack,needle,i);
	 if (j==-1) break;
	 i=j+needle->len-1;
	 c++;
       }
       break;
   }
   do { INT_TYPE ret_=(DO_NOT_WARN((INT_TYPE)c)); pop_n_elems(2); push_int(ret_); return; }while(0);
#line 729 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

}
/*! @decl string trim_whites (string s)
 *! @belongs String
 *!
 *! Trim leading and trailing spaces and tabs from the string @[s].
 */
#line 736 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_string_trim_whites_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_string_trim_whites_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_string_trim_whites(INT32 args) {
#line 737 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_string * s;
#line 737 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("String.trim_whites",args,1);
#line 737 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("String.trim_whites",1,"string");
#line 737 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(s=Pike_sp[0-1].u.string);
#line 740 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  ptrdiff_t start = 0, end = s->len;
  int chr;
  switch (s->size_shift) {
#define DO_IT(TYPE)							\
    {									\
      for (; start < s->len; start++) {					\
	chr = ((TYPE *) s->str)[start];					\
	if (chr != ' ' && chr != '\t') break;				\
      }									\
      while (--end > start) {						\
	chr = ((TYPE *) s->str)[end];					\
	if (chr != ' ' && chr != '\t') break;				\
      }									\
    }
    case 0: DO_IT (p_wchar0); break;
    case 1: DO_IT (p_wchar1); break;
    case 2: DO_IT (p_wchar2); break;
#undef DO_IT
  }
  do { struct pike_string * ret_=(string_slice (s, start, end + 1 - start)); pop_stack(); push_string(ret_); return; }while(0);
#line 761 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

}
/*! @decl string normalize_space (string s, string|void whitespace)
 *! @belongs String
 *!
 *! @param s
 *! Is returned after white space in it has been normalised.
 *! White space is normalised by stripping leading and trailing white space
 *! and replacing sequences of white space characters with a single space.
 *!
 *! @param whitespace
 *! Defines what is considered to be white space eligible for normalisation.
 *! It has a default value that starts with @expr{" \t\r\n\v\f"@} and in
 *! addition to that contains all whitespace characters part of Unicode.
 *! The first character denotes the character for replacing whitespace
 *! sequences.
 *!
 *! @note
 *! Trailing and leading whitespace around \r and \n characters
 *! is stripped as well (only useful if they're not in the @[whitespace] set).
 *!
 *! @note
 *! This function is a lot faster with just one argument (i.e. the builtin
 *! whitespace set has an optimised code path).
 */
#line 786 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_string_normalize_space_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_string_normalize_space_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_string_normalize_space(INT32 args) {
#line 787 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_string * s;
#line 787 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_string * whitespace;
#line 787 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args < 1) wrong_number_of_args_error("string_normalize_space",args,1);
#line 787 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args > 2) wrong_number_of_args_error("string_normalize_space",args,2);
#line 787 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-args].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("String.normalize_space",1,"string");
#line 787 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(s=Pike_sp[0-args].u.string);
#line 787 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if (args > 1 &&    (Pike_sp[1-args].type != PIKE_T_INT ||     Pike_sp[1-args].u.integer)) {
#line 787 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[1-args].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("String.normalize_space",2,"string|void");
#line 787 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(whitespace=Pike_sp[1-args].u.string);
#line 787 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
} else whitespace = NULL;
#line 790 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  size_t len = s->len, wlen;
  const void *src = s->str;
  unsigned shift = s->size_shift, replspace;
  const void *ws;
  void *wstemp = 0;
  struct string_builder sb;
  unsigned foundspace = 0;

  wlen = replspace = 0;    /* useless, but suppresses silly compiler warning */

  {
    unsigned bshift = shift, wshift;
    if(whitespace)
      if(!(wlen = whitespace->len))
        do { struct pike_string * ret_=(s); add_ref(ret_); pop_n_elems(args); push_string(ret_); return; }while(0);
#line 806 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
else {
        ws = whitespace->str; wshift = whitespace->size_shift;
        replspace = index_shared_string(whitespace, 0);
	if(replspace > 0xffff)
	  bshift = 2;
	else if(replspace > 0xff && !bshift)
	  bshift = 1;
	if(wshift!=shift) {	/* convert whitespace to shift of input */
	  PCHARP pcnws;
	  wstemp = xalloc(wlen<<shift);
	  pcnws = MKPCHARP(wstemp, shift);
	  if(wshift>shift) {
	    PCHARP pcows = MKPCHARP_STR(whitespace);
	    size_t clen = wlen, i;
	    i = wlen = 0;
	    do {
	      unsigned chr = INDEX_PCHARP(pcows, i++);
	      if (chr<=0xff || (chr<=0xffff && shift))	/* shift is 0 or 1 */
		SET_INDEX_PCHARP(pcnws, wlen++, chr);
	    } while(--clen);
	  } else
	    pike_string_cpy(pcnws, whitespace);
	  ws = wstemp;
	}
      }
    else
      ws = 0;

    init_string_builder_alloc (&sb, len, bshift);
    if(bshift == shift)
      sb.known_shift = bshift;
  }
#define SPACECASE8							\
       case ' ':case '\t':case '\r':case '\n':case '\v':case '\f':	\
       case 0x85:case 0xa0:
#include "whitespace.h"

  switch (shift) {
#define NORMALISE_TIGHT_LOOP(TYPE,CASE)					\
    {									\
      const TYPE *start = src, *end = start+len;			\
      if (!ws) {							\
        TYPE *dst = (void*)sb.s->str;					\
        for (; start < end; start++) {					\
	  switch(*start) {						\
	    CASE							\
	      continue;							\
          }								\
          break;							\
        }								\
        for (; start < end; start++) {					\
	  if(*start<=' ' || *start>=0x85)  /* optimise common case */	\
	    switch(*start) {						\
	      CASE							\
	        if (!foundspace)					\
	          *dst++ = ' ', foundspace=1;				\
	        continue;						\
	      default:goto found##TYPE;					\
	    }								\
	  else								\
found##TYPE:								\
	    foundspace=0;						\
	  *dst++ = *start;						\
	}								\
	sb.s->len = dst - (TYPE*)sb.s->str;				\
      } else {								\
	const TYPE*ps = (const TYPE*)ws+wlen;				\
        for (; start < end; start++) {					\
	  size_t clen = wlen;						\
          do {								\
            if (ps[0-clen] == *start)					\
              goto lead##TYPE;						\
          } while(--clen);						\
          break;							\
lead##TYPE:;								\
        }								\
        for (; start < end; start++) {					\
	  TYPE chr = *start;						\
	  size_t clen = wlen;						\
          do								\
            if (ps[0-clen] == chr) {					\
	      if (!foundspace)						\
	        string_builder_putchar(&sb, replspace), foundspace=1;	\
              goto skip##TYPE;						\
            }								\
          while(--clen);						\
	  if (foundspace && (chr=='\n' || chr=='\r')) {			\
	    sb.s->len--; string_builder_putchar(&sb, chr);		\
	    foundspace=0;						\
            goto lead##TYPE;						\
	  }								\
	  string_builder_putchar(&sb, chr); foundspace=0;		\
skip##TYPE:;								\
        }								\
      }									\
    }
    case 0: NORMALISE_TIGHT_LOOP (p_wchar0,SPACECASE8); break;
    case 1: NORMALISE_TIGHT_LOOP (p_wchar1,SPACECASE16); break;
    case 2: NORMALISE_TIGHT_LOOP (p_wchar2,SPACECASE16); break;
#undef NORMALISE_TIGHT_LOOP
#undef SPACECASE8
#undef SPACECASE16
  }
  if (wstemp)
    free(wstemp);
  if (foundspace)
    sb.s->len--;
  do { struct pike_string * ret_=(finish_string_builder (&sb)); pop_n_elems(args); push_string(ret_); return; }while(0);
#line 914 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

}
/*! @decl string trim_all_whites (string s)
 *! @belongs String
 *!
 *! Trim leading and trailing white spaces characters (space, tab,
 *! newline, carriage return, form feed, vertical tab and all the
 *! white spaces defined in Unicode) from the string @[s].
 */
#line 923 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_string_trim_all_whites_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_string_trim_all_whites_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_string_trim_all_whites(INT32 args) {
#line 924 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_string * s;
#line 924 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("String.trim_all_whites",args,1);
#line 924 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("String.trim_all_whites",1,"string");
#line 924 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(s=Pike_sp[0-1].u.string);
#line 927 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  ptrdiff_t start = 0, end = s->len;
  int chr;
  switch (s->size_shift) {
#define SPACECASE8							\
       case ' ':case '\t':case '\r':case '\n':case '\v':case '\f':	\
       case 0x85:case 0xa0:
#include "whitespace.h"

#define DO_IT(TYPE,CASE)						\
    {									\
      for (; start < end; start++) {					\
	chr = ((TYPE *) s->str)[start];					\
	switch(chr) {							\
	  CASE								\
	    continue;							\
	}								\
	break;								\
      }									\
      while (--end > start) {						\
	chr = ((TYPE *) s->str)[end];					\
	switch(chr) {							\
	  CASE								\
	    continue;							\
	}								\
	break;								\
      }									\
    }
    case 0: DO_IT (p_wchar0,SPACECASE8); break;
    case 1: DO_IT (p_wchar1,SPACECASE16); break;
    case 2: DO_IT (p_wchar2,SPACECASE16); break;
#undef DO_IT
#undef SPACECASE8
#undef SPACECASE16
  }
  do { struct pike_string * ret_=(string_slice (s, start, end + 1 - start)); pop_stack(); push_string(ret_); return; }while(0);
#line 963 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

}
/*! @decl int implements(program prog, program api)
 *! @belongs Program
 *!
 *! Returns 1 if @[prog] implements @[api].
 */
#line 970 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_program_implements_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_program_implements_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_program_implements(INT32 args) {
#line 971 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct program * prog;
#line 971 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct program * api;
#line 971 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 2) wrong_number_of_args_error("Program.implements",args,2);
#line 971 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(!(prog=program_from_svalue(Pike_sp+0-2))) SIMPLE_ARG_TYPE_ERROR("Program.implements",1,"program");
#line 971 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(!(api=program_from_svalue(Pike_sp+1-2))) SIMPLE_ARG_TYPE_ERROR("Program.implements",2,"program");
#line 974 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  do { INT_TYPE ret_=(implements(prog, api)); pop_n_elems(2); push_int(ret_); return; }while(0);
#line 976 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

}
/*! @decl int inherits(program child, program parent)
 *! @belongs Program
 *!
 *! Returns 1 if @[child] has inherited @[parent].
 */
#line 983 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_program_inherits_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_program_inherits_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_program_inherits(INT32 args) {
#line 984 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct program * parent;
#line 984 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct program * child;
#line 984 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 2) wrong_number_of_args_error("Program.inherits",args,2);
#line 984 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(!(parent=program_from_svalue(Pike_sp+0-2))) SIMPLE_ARG_TYPE_ERROR("Program.inherits",1,"program");
#line 984 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(!(child=program_from_svalue(Pike_sp+1-2))) SIMPLE_ARG_TYPE_ERROR("Program.inherits",2,"program");
#line 987 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  do { INT_TYPE ret_=(low_get_storage(parent, child) != -1); pop_n_elems(2); push_int(ret_); return; }while(0);
#line 989 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

}
/*! @decl string defined(program p)
 *! @belongs Program
 *!
 *! Returns a string with filename and linenumber describing where
 *! the program @[p] was defined.
 *!
 *! The returned string is of the format @expr{"filename:linenumber"@}.
 *!
 *! If it cannot be determined where the program was defined, @expr{0@}
 *! (zero) will be returned.
 */
#line 1002 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_program_defined_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_program_defined_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_program_defined(INT32 args) {
#line 1003 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct program * p;
#line 1003 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("Program.defined",args,1);
#line 1003 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(!(p=program_from_svalue(Pike_sp+0-1))) SIMPLE_ARG_TYPE_ERROR("Program.defined",1,"program");
#line 1006 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  INT32 line;
  struct pike_string *tmp = low_get_program_line(p, &line);

  pop_n_elems(args);

  if (tmp) {
    push_string(tmp);
    if(line >= 1)
    {
      push_constant_text(":");
      push_int(line);
      f_add(3);
    }
  }
  else
    push_int(0);
}

}
/*! @decl int(8..8)|int(16..16)|int(32..32) width(string s)
 *! @belongs String
 *!
 *! Returns the width of a string.
 *!
 *! Three return values are possible:
 *! @int
 *!   @value 8
 *!     The string @[s] only contains characters <= 255.
 *!   @value 16
 *!     The string @[s] only contains characters <= 65535.
 *!   @value 32
 *!     The string @[s] contains characters >= 65536.
 *! @endint
 */
#line 1040 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_string_width_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_string_width_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_string_width(INT32 args) {
#line 1041 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_string * s;
#line 1041 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("String.width",args,1);
#line 1041 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("String.width",1,"string");
#line 1041 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(s=Pike_sp[0-1].u.string);
#line 1044 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  do { INT_TYPE ret_=(8 * (1 << s->size_shift)); pop_stack(); push_int(ret_); return; }while(0);
#line 1046 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

}
/*! @decl mixed m_delete(object|mapping map, mixed index)
 *!
 *! If @[map] is an object that implements @[lfun::_m_delete()],
 *! that function will be called with @[index] as its single argument.
 *!
 *! Otherwise if @[map] is a mapping the entry with index @[index]
 *! will be removed from @[map] destructively.
 *!
 *! If the mapping does not have an entry with index @[index], nothing is done.
 *!
 *! @returns
 *!   The value that was removed will be returned.
 *!
 *! @note
 *!   Note that @[m_delete()] changes @[map] destructively.
 *!
 *! @seealso
 *!   @[mappingp()]
 */
#line 1067 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_m_delete_defined
DEFAULT_CMOD_STORAGE void f_m_delete(INT32 args) {
#line 1068 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * map;
#line 1068 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * index;
#line 1068 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 2) wrong_number_of_args_error("m_delete",args,2);
#line 1068 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
map=Pike_sp+0-2; dmalloc_touch_svalue(Pike_sp+0-2);
#line 1068 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
index=Pike_sp+1-2; dmalloc_touch_svalue(Pike_sp+1-2);
#line 1072 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  struct program *p;
  if( map->type == T_MAPPING )
  {
    struct svalue s;
    map_delete_no_free(map->u.mapping, index, &s);
    pop_n_elems(args);
    *Pike_sp=s;
    Pike_sp++;
    dmalloc_touch_svalue(Pike_sp-1);
  }
  else if (map->type == T_OBJECT && (p = map->u.object->prog))
  {
    int id = FIND_LFUN(p->inherits[map->subtype].prog, LFUN__M_DELETE);

    if( id == -1 )
      SIMPLE_BAD_ARG_ERROR("m_delete", 1, "object containing the _m_delete method");
    
    apply_low(map->u.object,
	      id + p->inherits[map->subtype].identifier_level, 1);
    stack_swap();
    pop_stack();
  } else {
    SIMPLE_BAD_ARG_ERROR("m_delete", 1, "object|mapping");
  }
}

}
/*! @decl int get_weak_flag(array|mapping|multiset m)
 *!
 *! Returns the weak flag settings for @[m]. It's a combination of
 *! @[Pike.WEAK_INDICES] and @[Pike.WEAK_VALUES].
 */
#line 1104 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_get_weak_flag_1_defined
DEFAULT_CMOD_STORAGE void f_get_weak_flag_1(INT32 args) {
#line 1105 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct array * m;
#line 1105 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("get_weak_flag",args,1);
#line 1105 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_ARRAY) SIMPLE_ARG_TYPE_ERROR("get_weak_flag",1,"array");
#line 1105 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(m=Pike_sp[0-1].u.array);
#line 1108 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  do { INT_TYPE ret_=((m->flags & ARRAY_WEAK_FLAG) ? PIKE_WEAK_VALUES : 0); pop_stack(); push_int(ret_); return; }while(0);
#line 1110 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

}
#line 1112 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_get_weak_flag_2_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_get_weak_flag_2_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_get_weak_flag_2(INT32 args) {
#line 1113 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct mapping * m;
#line 1113 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("get_weak_flag",args,1);
#line 1113 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_MAPPING) SIMPLE_ARG_TYPE_ERROR("get_weak_flag",1,"mapping(mixed:mixed)");
#line 1113 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(m=Pike_sp[0-1].u.mapping);
{
  do { INT_TYPE ret_=(mapping_get_flags(m) & MAPPING_WEAK); pop_stack(); push_int(ret_); return; }while(0);
#line 1116 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

}
#line 1118 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_get_weak_flag_3_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_get_weak_flag_3_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_get_weak_flag_3(INT32 args) {
#line 1119 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct multiset * m;
#line 1119 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("get_weak_flag",args,1);
#line 1119 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_MULTISET) SIMPLE_ARG_TYPE_ERROR("get_weak_flag",1,"multiset");
#line 1119 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(m=Pike_sp[0-1].u.multiset);
{
  do { INT_TYPE ret_=(multiset_get_flags(m) & MULTISET_WEAK); pop_stack(); push_int(ret_); return; }while(0);
#line 1122 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

}

#if defined(f_get_weak_flag_1_defined) || defined(f_get_weak_flag_2_defined) || defined(f_get_weak_flag_3_defined)
#define f_get_weak_flag_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_get_weak_flag_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_get_weak_flag(INT32 args) {
  if(args < 1) wrong_number_of_args_error("get_weak_flag",args,1);
  switch(Pike_sp[0-args].type) {
   case PIKE_T_MULTISET:

#ifdef f_get_weak_flag_3_defined
    f_get_weak_flag_3(args);
    return;

#endif /* f_get_weak_flag_3_defined */
    break;
   case PIKE_T_MAPPING:

#ifdef f_get_weak_flag_2_defined
    f_get_weak_flag_2(args);
    return;

#endif /* f_get_weak_flag_2_defined */
    break;
   case PIKE_T_ARRAY:

#ifdef f_get_weak_flag_1_defined
    f_get_weak_flag_1(args);
    return;

#endif /* f_get_weak_flag_1_defined */
    break;
   default:
    SIMPLE_BAD_ARG_ERROR("get_weak_flag",1,"multiset|mapping|array");
  }
}

#endif /* f_get_weak_flag_1_defined, f_get_weak_flag_2_defined, f_get_weak_flag_3_defined */
/*! @decl program __empty_program(int|void line, string|void file)
 */
#define f_cq___empty_program_defined
DEFAULT_CMOD_STORAGE void f_cq___empty_program(INT32 args) {
#line 1126 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
INT_TYPE line;
#line 1126 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_string * file;
#line 1126 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args > 2) wrong_number_of_args_error("__empty_program",args,2);
#line 1126 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if (args > 0) {
#line 1126 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-args].type != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("__empty_program",1,"int|void");
#line 1126 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
line=Pike_sp[0-args].u.integer;
#line 1126 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
} else line = 0;
#line 1126 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if (args > 1 &&    (Pike_sp[1-args].type != PIKE_T_INT ||     Pike_sp[1-args].u.integer)) {
#line 1126 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[1-args].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("__empty_program",2,"string|void");
#line 1126 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(file=Pike_sp[1-args].u.string);
#line 1126 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
} else file = NULL;
#line 1129 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  struct program *prog = low_allocate_program();
  if (file) ext_store_program_line (prog, line, file);
#if 0
  push_program (prog);
  safe_pike_fprintf (stderr, "Creating empty program %O (%x)\n",
		     Pike_sp - 1, Pike_sp[-1].u.program);
  Pike_sp--;
#endif
  do { struct program * ret_=(prog); pop_n_elems(args); push_program(ret_); return; }while(0);
#line 1139 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

}
#line 1141 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
/* Cut the string at the first NUL. */
static struct pike_string *delambda(struct pike_string *str)
{
  PCHARP pcharp = MKPCHARP_STR(str);
  ptrdiff_t len = pcharp_strlen(pcharp);
  if (len == str->len) {
    /* Common case. */
    add_ref(str);
    return str;
  }
  return make_shared_binary_pcharp(pcharp, len);
}

/*! @decl string function_name(function f)
 *!
 *! Return the name of the function @[f].
 *!
 *! If @[f] is a global function defined in the runtime @expr{0@}
 *! (zero) will be returned.
 *!
 *! @seealso
 *! @[function_object()]
 */
PMOD_EXPORT
#define f_function_name_defined
DEFAULT_CMOD_STORAGE void f_function_name(INT32 args) {
#line 1165 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * func;
#line 1165 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("function_name",args,1);
#line 1165 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
func=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 1168 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  switch(func->type)
  {
    default:
      SIMPLE_BAD_ARG_ERROR("function_name", 1, "function|program");
      return; /* NOTREACHED */
	
    case PIKE_T_PROGRAM:
    {
      struct program *p=func->u.program;

      if(p->parent)
      {
	int e;
	p=p->parent;
	/* search constants in parent for this
	 * program...
	 */
	
	for(e = p->num_identifier_references; e--; )
	{
	  struct identifier *id;
	  if (p->identifier_references[e].id_flags & ID_HIDDEN)
	    continue;

	  id = ID_FROM_INT(p, e);
	  if (IDENTIFIER_IS_CONSTANT(id->identifier_flags) &&
	      (id->func.offset >= 0) &&
	      is_eq( & PROG_FROM_INT(p, e)->constants[id->func.offset].sval,
		     func))
	    do { struct pike_string * ret_=(id->name); add_ref(ret_); pop_stack(); push_string(ret_); return; }while(0);
#line 1199 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}
#ifdef PIKE_DEBUG
	if (d_flag>5) {
	  fprintf(stderr,
		  "Failed to find symbol for program %p\n"
		  "Parent program info:\n",
		  func->u.program);
	  dump_program_tables(func->u.program->parent, 0);
	}
#endif
      }
      break;
    }

    case PIKE_T_FUNCTION:
      if(func->subtype == FUNCTION_BUILTIN) break;
      if(!func->u.object->prog)
	bad_arg_error("function_name", Pike_sp-args, args, 1,
		      "function", Pike_sp-args,
		      "Destructed object.\n");
      if(func->u.object->prog == pike_trampoline_program)
      {
	struct pike_trampoline *t;
	t=((struct pike_trampoline *)func->u.object->storage);

	if(t->frame->current_object->prog)
	  do { struct pike_string * ret_=(delambda(ID_FROM_INT(t->frame->current_object->prog,
				      t->func)->name)); pop_stack(); push_string(ret_); return; }while(0);
#line 1227 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

      do { struct pike_string * ret_=(delambda(ID_FROM_INT(func->u.object->prog, func->subtype)->name)); pop_stack(); push_string(ret_); return; }while(0);
#line 1230 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}
  pop_n_elems(args);
  push_int(0);
}

}
/*! @decl object function_object(function f)
 *!
 *!   Return the object the function @[f] is in.
 *!
 *!   If @[f] is a global function defined in the runtime @expr{0@}
 *!   (zero) will be returned.
 *!
 *!   Zero will also be returned if @[f] is a constant in the
 *!   parent class. In that case @[function_program()] can be
 *!   used to get the parent program.
 *!
 *! @seealso
 *!   @[function_name()], @[function_program()]
 */
#line 1249 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_function_object_defined
DEFAULT_CMOD_STORAGE void f_function_object(INT32 args) {
#line 1250 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * func;
#line 1250 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("function_object",args,1);
#line 1250 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
func=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 1254 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  switch(func->type)
  {
    case PIKE_T_PROGRAM:
      break;
      
    case PIKE_T_FUNCTION:
      if(func->subtype == FUNCTION_BUILTIN) break;
      if(func->u.object->prog == pike_trampoline_program)
      {
	struct object *o;
	o=((struct pike_trampoline *)func->u.object->storage)->frame->current_object;
	add_ref(o);
	pop_n_elems(args);
	push_object(o);
	return;
      }
      func->type=T_OBJECT;
      func->subtype = 0;
      return;


    default:
      SIMPLE_BAD_ARG_ERROR("function_object",1,"function");
  }
  pop_n_elems(args);
  push_int(0);
}

}
/*! @decl program function_program(function|program f)
 *!
 *!   Return the program the function @[f] is in.
 *!
 *!   If @[f] is a global function defined in the runtime @expr{0@}
 *!   (zero) will be returned.
 *!
 *! @seealso
 *!   @[function_name()], @[function_object()]
 */
#line 1293 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_function_program_defined
DEFAULT_CMOD_STORAGE void f_function_program(INT32 args) {
#line 1294 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * func;
#line 1294 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("function_program",args,1);
#line 1294 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
func=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 1297 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  switch(func->type)
  {
    case PIKE_T_PROGRAM:
    {
      struct program *p;
      if(!(p=func->u.program->parent)) break;
      add_ref(p);
      free_program(func->u.program);
      func->u.program=p;
      return;
    }
      
    case PIKE_T_FUNCTION:
      {
	struct program *p;
	if(func->subtype == FUNCTION_BUILTIN)
	  p = func->u.efun->prog;
	else
	  p = func->u.object->prog;
	if(p == pike_trampoline_program)
	{
	  p = ((struct pike_trampoline *)func->u.object->storage)->
	    frame->current_object->prog;
	}
	if (p) {
	  ref_push_program(p);
	  stack_pop_n_elems_keep_top(args);
	  return;
	}
      }
      break;

    default:
      SIMPLE_BAD_ARG_ERROR("function_program", 1, "function");
  }
  pop_n_elems(args);
  push_int(0);
}


}
/*! @decl mixed random(object o)
 *!   If random is called with an object, @[lfun::random] will be
 *!   called in the object.
 *! @seealso
 *!  @[lfun::_random]
 */

/*! @decl mixed lfun::_random()
 *!   Called by @[random]. Typical uses is when the object implements
 *!   a ADT, then a call to this lfun should return a random member of
 *!   the ADT or range implied by the ADT.
 *! @seealso
 *!   @[predef::random()]
 */

#line 1353 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_random_1_defined
DEFAULT_CMOD_STORAGE void f_random_1(INT32 args) {
#line 1354 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct object * o;
#line 1354 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("random",args,1);
#line 1354 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_OBJECT) SIMPLE_ARG_TYPE_ERROR("random",1,"object");
#line 1354 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(o=Pike_sp[0-1].u.object);
#line 1357 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  apply(o,"_random",0);
  stack_swap();
  pop_stack();
}

}
/*! @decl int random(int max)
 *! @decl float random(float max)
 *!
 *!   This function returns a random number in the range 0 - @[max]-1.
 *!
 *! @seealso
 *!   @[random_seed()]
 */

#line 1372 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_random_2_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_random_2_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_random_2(INT32 args) {
#line 1373 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
INT_TYPE i;
#line 1373 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("random",args,1);
#line 1373 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("random",1,"int");
#line 1373 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
i=Pike_sp[0-1].u.integer;
{
  if(i <= 0) do { INT_TYPE ret_=(0); pop_stack(); push_int(ret_); return; }while(0);
#line 1376 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
#ifdef AUTO_BIGNUM
  if(i >> 31) {
    unsigned INT_TYPE a = my_rand();
    unsigned INT_TYPE b = my_rand();
    do { INT_TYPE ret_=((INT_TYPE)(((a<<32)|b) % i)); pop_stack(); push_int(ret_); return; }while(0);
#line 1381 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}
#endif
  do { INT_TYPE ret_=(my_rand() % i); pop_stack(); push_int(ret_); return; }while(0);
#line 1384 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}      

}
#line 1386 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_random_3_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_random_3_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_random_3(INT32 args) {
#line 1387 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
FLOAT_TYPE f;
#line 1387 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("random",args,1);
#line 1387 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_FLOAT) SIMPLE_ARG_TYPE_ERROR("random",1,"float");
#line 1387 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
f=Pike_sp[0-1].u.float_number;
{
  if(f<=0.0) do { FLOAT_TYPE ret_=(0.0); pop_stack(); push_float(ret_); return; }while(0);
#line 1390 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
#define N 1048576
  do { FLOAT_TYPE ret_=(f * (my_rand()%N/((float)N)) +
    f * (my_rand()%N/( ((float)N) * ((float)N) ))); pop_stack(); push_float(ret_); return; }while(0);
#line 1394 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

}
/*! @decl mixed random(array|multiset x)
 *!   Returns a random element from @[x].
 */

#line 1400 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_random_4_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_random_4_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_random_4(INT32 args) {
#line 1401 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct array * a;
#line 1401 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("random",args,1);
#line 1401 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_ARRAY) SIMPLE_ARG_TYPE_ERROR("random",1,"array");
#line 1401 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(a=Pike_sp[0-1].u.array);
#line 1403 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  if(!a->size)
    SIMPLE_BAD_ARG_ERROR("random", 1, "array with elements in it");
  push_svalue(a->item + (my_rand() % a->size));
  stack_swap();
  pop_stack();
}

}
#line 1411 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_random_5_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_random_5_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_random_5(INT32 args) {
#line 1412 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct multiset * m;
#line 1412 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("random",args,1);
#line 1412 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_MULTISET) SIMPLE_ARG_TYPE_ERROR("random",1,"multiset");
#line 1412 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(m=Pike_sp[0-1].u.multiset);
#line 1414 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  if(multiset_is_empty (m))
    SIMPLE_BAD_ARG_ERROR("random", 1, "multiset with elements in it");
  if (multiset_indval (m)) {
    ptrdiff_t nodepos = multiset_get_nth (m, my_rand() % multiset_sizeof (m));
    push_multiset_index (m, nodepos);
    push_multiset_value (m, nodepos);
    sub_msnode_ref (m);
    f_aggregate (2);
  }
  else {
    push_multiset_index (m, multiset_get_nth (m, my_rand() %
					      multiset_sizeof (m)));
    sub_msnode_ref (m);
  }
  stack_swap();
  pop_stack();
}

}
/*! @decl array random(mapping m)
 *!   Returns a random index-value pair from the mapping.
 */

#line 1437 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PMOD_EXPORT
#define f_random_6_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_random_6_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_random_6(INT32 args) {
#line 1438 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct mapping * m;
#line 1438 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("random",args,1);
#line 1438 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_MAPPING) SIMPLE_ARG_TYPE_ERROR("random",1,"mapping(mixed:mixed)");
#line 1438 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(m=Pike_sp[0-1].u.mapping);
{
  struct mapping_data *md=m->data;
  size_t bucket, count;
  struct keypair *k;
  
  if(!m_sizeof(m))
    SIMPLE_BAD_ARG_ERROR("random", 1, "mapping with elements in it");
  
  /* Find a random, nonempty bucket */
  bucket=my_rand() % md->hashsize;
  while(! md->hash[bucket] )
    if(++bucket > (size_t)md->hashsize)
      bucket=0;
  
  /* Count entries in bucket */
  count=0;
  for(k=md->hash[bucket];k;k=k->next) count++;
  
  /* Select a random entry in this bucket */
  count = my_rand() % count;
  k=md->hash[bucket];
  while(count-- > 0) k=k->next;
  
  /* Push result and return */
  push_svalue(&k->ind);
  push_svalue(&k->val);
  f_aggregate(2);
  stack_swap();
  pop_stack();
}

}

#if defined(f_random_1_defined) || defined(f_random_2_defined) || defined(f_random_3_defined) || defined(f_random_4_defined) || defined(f_random_5_defined) || defined(f_random_6_defined)
#define f_random_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_random_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_random(INT32 args) {
  if(args < 1) wrong_number_of_args_error("random",args,1);
  switch(Pike_sp[0-args].type) {
   case PIKE_T_MAPPING:

#ifdef f_random_6_defined
    f_random_6(args);
    return;

#endif /* f_random_6_defined */
    break;
   case PIKE_T_MULTISET:

#ifdef f_random_5_defined
    f_random_5(args);
    return;

#endif /* f_random_5_defined */
    break;
   case PIKE_T_ARRAY:

#ifdef f_random_4_defined
    f_random_4(args);
    return;

#endif /* f_random_4_defined */
    break;
   case PIKE_T_FLOAT:

#ifdef f_random_3_defined
    f_random_3(args);
    return;

#endif /* f_random_3_defined */
    break;
   case PIKE_T_INT:

#ifdef f_random_2_defined
    f_random_2(args);
    return;

#endif /* f_random_2_defined */
    break;
   case PIKE_T_OBJECT:

#ifdef f_random_1_defined
    f_random_1(args);
    return;

#endif /* f_random_1_defined */
    break;
   default:
    SIMPLE_BAD_ARG_ERROR("random",1,"mapping|multiset|array|float|int|object");
  }
}

#endif /* f_random_1_defined, f_random_2_defined, f_random_3_defined, f_random_4_defined, f_random_5_defined, f_random_6_defined */
#line 1470 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
#if defined(HAVE_SETENV) && defined(HAVE_UNSETENV)
#define USE_SETENV
#else
/* Used to hold refs to the strings that we feed to putenv. Indexed on
 * variable names, values are the "name=value" strings.
 *
 * This is not needed when using {,un}setenv(), since they maintain
 * their own corresponding table. */
static struct mapping *env_allocs = NULL;
#endif

/* Works exactly like the getenv efun defined in the master, but only
 * accesses the real environment. Everyone should use the caching
 * version in the master instead. */
#define f_cq__getenv_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_cq__getenv_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_cq__getenv(INT32 args) {
#line 1484 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_string * var;
#line 1484 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args > 1) wrong_number_of_args_error("_getenv",args,1);
#line 1484 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if (args > 0 &&    (Pike_sp[0-args].type != PIKE_T_INT ||     Pike_sp[0-args].u.integer)) {
#line 1484 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-args].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("_getenv",1,"void|string");
#line 1484 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(var=Pike_sp[0-args].u.string);
#line 1484 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
} else var = NULL;
#line 1486 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  /* FIXME: Perhaps add the amigaos4 stuff from pike_push_env here too. */

  if (var) {
    if (var->size_shift)
      SIMPLE_ARG_TYPE_ERROR ("getenv", 1, "void|string(0..255)");

    if (string_has_null (var)) {
      /* Won't find a variable name like this. */
      pop_stack();
      push_int (0);
    }

    else {
      char *entry = getenv (var->str);
      pop_stack();
      if (!entry)
	push_int (0);
      else {
	char *eq = STRCHR (entry, '=');
	/* There should always be a '=' in the entry, but you never know.. */
	push_string (make_shared_string (eq ? eq + 1 : entry));
      }
    }
  }

  else {
#ifdef DECLARE_ENVIRON
    extern char **environ;
#endif
    struct mapping *m, *new_env_allocs;
    int n;

    /* Iterate the environment backwards below so that earlier
     * variables will override later ones in case the same variable
     * occur multiple times (which it shouldn't). That makes the
     * result similar to what getenv(3) commonly returns (at least the
     * one in gnu libc). */
    for (n = 0; environ[n]; n++) {}

    m = allocate_mapping (n);
#ifndef USE_SETENV
    if (env_allocs)
      new_env_allocs = allocate_mapping (m_sizeof (env_allocs));
#endif /* !USE_SETENV */

    while (--n >= 0) {
      char *entry = environ[n], *eq = STRCHR (entry, '=');
      if (eq) { /* gnu libc getenv ignores variables without '='. */
	struct pike_string *var = make_shared_binary_string (entry, eq - entry);
	struct pike_string *val = make_shared_string (eq + 1);
	mapping_string_insert_string (m, var, val);

#ifndef USE_SETENV
	/* Populate new_env_allocs with the env_allocs entries that
	 * are still in use. */
	if (env_allocs) {
	  struct svalue *ea_val = low_mapping_string_lookup (env_allocs, var);
	  if (ea_val && ea_val->u.string->str == entry)
	    mapping_string_insert (new_env_allocs, var, ea_val);
	}
#endif /* !USE_SETENV */

	free_string (var);
	free_string (val);
      }
    }

#ifndef USE_SETENV
    if (env_allocs) {
      free_mapping (env_allocs);
      env_allocs = new_env_allocs;
    }
#endif /* !USE_SETENV */

    push_mapping (m);
  }
}

}
#line 1565 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
/* Works exactly like the putenv efun defined in the master, but only
 * updates the real environment. Everyone should use the version in
 * the master instead so that the cache doesn't get stale. */
#define f_cq__putenv_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_cq__putenv_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_cq__putenv(INT32 args) {
#line 1568 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_string * var;
#line 1568 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_string * val;
#line 1568 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args < 1) wrong_number_of_args_error("_putenv",args,1);
#line 1568 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args > 2) wrong_number_of_args_error("_putenv",args,2);
#line 1568 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-args].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("_putenv",1,"string");
#line 1568 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(var=Pike_sp[0-args].u.string);
#line 1568 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if (args > 1 &&    (Pike_sp[1-args].type != PIKE_T_INT ||     Pike_sp[1-args].u.integer)) {
#line 1568 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[1-args].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("_putenv",2,"void|string");
#line 1568 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(val=Pike_sp[1-args].u.string);
#line 1568 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
} else val = NULL;
{
#ifndef USE_SETENV
  struct pike_string *putenv_str, *env_alloc_var;
#endif

  if (var->size_shift)
    SIMPLE_ARG_TYPE_ERROR ("putenv", 1, "string(0..255)");
  if (string_has_null (var) || STRCHR (var->str, '='))
    SIMPLE_ARG_ERROR ("putenv", 1, "Variable name cannot contain '=' or NUL.");

  if (val) {
#ifndef USE_SETENV
    struct string_builder sb;
#endif

    if (val->size_shift)
      SIMPLE_ARG_TYPE_ERROR ("putenv", 2, "void|string(0..255)");
    if (string_has_null (val))
      SIMPLE_ARG_ERROR ("putenv", 2, "Variable value cannot contain NUL.");

#ifdef USE_SETENV
    if (setenv(var->str, val->str, 1)) {
      if (errno == ENOMEM)
	SIMPLE_OUT_OF_MEMORY_ERROR ("putenv", 0);
      else
	Pike_error ("Error from setenv(3): %s\n", strerror (errno));
    }
#else /* !USE_SETENV */
    init_string_builder (&sb, 0);
    string_builder_shared_strcat (&sb, var);
    string_builder_putchar (&sb, '=');
    string_builder_shared_strcat (&sb, val);
    putenv_str = finish_string_builder (&sb);
    push_string (putenv_str); /* Let mega_apply pop. */
#endif /* USE_SETENV */
  }
  else {
#ifdef USE_SETENV
    /* Note: Some versions of glibc have a unsetenv(3) that returns void,
     *       thus no checking of the return value here.
     */
    unsetenv(var->str);
#else /* !USE_SETENV */
#ifdef PUTENV_ALWAYS_REQUIRES_EQUAL
    /* Windows can never get things quite right.. :P */
    struct string_builder sb;
    init_string_builder (&sb, 0);
    string_builder_shared_strcat (&sb, var);
    string_builder_putchar (&sb, '=');
    putenv_str = finish_string_builder (&sb);
    push_string (putenv_str); /* Let mega_apply pop. */
#else
    putenv_str = var;
#endif
#endif  /* USE_SETENV */
  }

#ifndef USE_SETENV
  if (putenv (putenv_str->str)) {
    if (errno == ENOMEM)
      SIMPLE_OUT_OF_MEMORY_ERROR ("putenv", 0);
    else
      Pike_error ("Error from putenv(3): %s\n", strerror (errno));
  }

#ifdef __NT__
  ref_push_string (var);
  f_lower_case (1);
  assert (Pike_sp[-1].type == T_STRING);
  env_alloc_var = Pike_sp[-1].u.string;
  /* Let mega_apply pop. */
#else
  env_alloc_var = var;
#endif

  if (!env_allocs) env_allocs = allocate_mapping (4);

  if (val)
    /* Must keep the string passed to putenv allocated (and we
     * assume no other entities are naughty enough to modify it). */
    mapping_string_insert_string (env_allocs, env_alloc_var, putenv_str);
  else {
    struct svalue key;
    key.type = T_STRING;
    key.u.string = env_alloc_var;
    map_delete (env_allocs, &key);
  }
#endif /* !USE_SETENV */
}

}
#line 1659 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
/*
 * Backtrace handling.
 */

/*! @module Pike
 */

/*! @class BacktraceFrame
 */


#undef class_backtrace_frame_defined
#define class_backtrace_frame_defined
DEFAULT_CMOD_STORAGE struct program *backtrace_frame_program=NULL;
static int backtrace_frame_program_fun_num=-1;

#undef var_cq__fun_backtrace_frame_defined
#define var_cq__fun_backtrace_frame_defined
#line 1672 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
#ifdef PIKE_DEBUG
  
#undef var_oprog_backtrace_frame_defined
#define var_oprog_backtrace_frame_defined
#line 1674 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
#endif
  
#undef var_args_backtrace_frame_defined
#define var_args_backtrace_frame_defined
#line 1677 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
/* These are cleared when filename and lineno have been initialized
   * from them. */
  
#undef var_prog_backtrace_frame_defined
#define var_prog_backtrace_frame_defined

#undef var_pc_backtrace_frame_defined
#define var_pc_backtrace_frame_defined
#line 1682 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
/* These two are considered to be uninitialized from prog, pc and
   * fun as long as lineno == -1. */
  
#undef var_filename_backtrace_frame_defined
#define var_filename_backtrace_frame_defined

#undef var_lineno_backtrace_frame_defined
#define var_lineno_backtrace_frame_defined

#undef THIS
#define THIS ((struct backtrace_frame_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_BACKTRACE_FRAME
#define THIS_BACKTRACE_FRAME ((struct backtrace_frame_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_BACKTRACE_FRAME
#define OBJ2_BACKTRACE_FRAME(o) ((struct backtrace_frame_struct *)(o->storage+backtrace_frame_storage_offset))

#undef GET_BACKTRACE_FRAME_STORAGE
#define GET_BACKTRACE_FRAME_STORAGE ((struct backtrace_frame_struct *)(o->storage+backtrace_frame_storage_offset)
static ptrdiff_t backtrace_frame_storage_offset;
struct backtrace_frame_struct {

#ifdef var_cq__fun_backtrace_frame_defined
  struct svalue _fun;

#endif /* var_cq__fun_backtrace_frame_defined */

#ifdef var_oprog_backtrace_frame_defined
  struct program * oprog;

#endif /* var_oprog_backtrace_frame_defined */

#ifdef var_args_backtrace_frame_defined
  struct array * args;

#endif /* var_args_backtrace_frame_defined */

#ifdef var_prog_backtrace_frame_defined
  struct program * prog;

#endif /* var_prog_backtrace_frame_defined */

#ifdef var_pc_backtrace_frame_defined
#line 1680 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
PIKE_OPCODE_T *pc;
#endif /* var_pc_backtrace_frame_defined */

#ifdef var_filename_backtrace_frame_defined
struct pike_string *filename;
#endif /* var_filename_backtrace_frame_defined */

#ifdef var_lineno_backtrace_frame_defined
#line 1685 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
INT32 lineno;
#endif /* var_lineno_backtrace_frame_defined */
};
#ifdef PIKE_DEBUG
/* Ensure the struct is used in a variable declaration, or else gdb might not see it. */
static struct backtrace_frame_struct *backtrace_frame_gdb_dummy_ptr;
#endif

#undef internal_init_backtrace_frame_defined
#define internal_init_backtrace_frame_defined

#undef backtrace_frame_event_handler_defined
#define backtrace_frame_event_handler_defined
static void init_backtrace_frame_struct(void)
#line 1688 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
    THIS->pc = NULL;
    THIS->lineno = -1;
    THIS->filename = NULL;
  }

  
#undef internal_exit_backtrace_frame_defined
#define internal_exit_backtrace_frame_defined

#undef backtrace_frame_event_handler_defined
#define backtrace_frame_event_handler_defined
static void exit_backtrace_frame_struct(void)
#line 1696 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
    if (THIS->filename) {
      free_string(THIS->filename);
      THIS->filename = NULL;
    }
    THIS->pc = NULL;
    THIS->lineno = -1;
  }

  /* NOTE: Use old-style getter/setter syntax for compatibility with
   *       old Parser.Pike.split() used by precompile.pike.
   */

  #define f_backtrace_frame_cq__backtick_2D_3Efun_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_backtrace_frame_cq__backtick_2D_3Efun_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_backtrace_frame_cq__backtick_2D_3Efun(INT32 args) {
#line 1709 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("`->fun",args,0);
{
    push_svalue(&THIS->_fun);
  }

  }
#define f_backtrace_frame_cq__backtick_2D_3Efun_eq_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_backtrace_frame_cq__backtick_2D_3Efun_eq_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_backtrace_frame_cq__backtick_2D_3Efun_eq(INT32 args) {
#line 1714 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * val;
#line 1714 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("`->fun=",args,1);
#line 1714 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
val=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
{
    /* FIXME: Should we allow this at all?
     *        Linenumber info etc won't match.
     */
#ifdef PIKE_DEBUG
    if ((val->type == T_FUNCTION) && (val->subtype != FUNCTION_BUILTIN)) {
      assign_short_svalue((union anything *)&THIS->oprog,
			  (union anything *)&val->u.object->prog, T_PROGRAM);
    }
#endif
    assign_svalue(&THIS->_fun, val);
  }

  }
/*! @decl int(0..1) _is_type(string t)
   *! This object claims to be an array for backward compatibility.
   */
  #define f_backtrace_frame_cq__is_type_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_backtrace_frame_cq__is_type_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_backtrace_frame_cq__is_type(INT32 args) {
#line 1731 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_string * t;
#line 1731 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("_is_type",args,1);
#line 1731 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("_is_type",1,"string");
#line 1731 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(t=Pike_sp[0-1].u.string);
{
    INT_TYPE res = (t == findstring("array"));
    pop_n_elems(args);
    push_int(res);
  }

  }
#line 1738 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
static void fill_in_file_and_line()
  {
    struct pike_string *file = NULL;
    assert (THIS->lineno == -1);

    if (THIS->pc && THIS->prog) {
      file = low_get_line(THIS->pc, THIS->prog, &THIS->lineno);
      THIS->pc = NULL;
    }
    else if (THIS->_fun.type == PIKE_T_FUNCTION) {
#ifdef PIKE_DEBUG
      if (THIS->_fun.u.object->prog &&
	  THIS->_fun.u.object->prog != THIS->oprog) {
	struct identifier *id = ID_FROM_INT(THIS->oprog, THIS->_fun.subtype);
	/* FIXME: Dump dmalloc info for the object? */
	Pike_fatal("Lost track of function pointer! Function name was %s.\n",
		   id->name?id->name->str:"<no name>");
      }
#endif
      file = low_get_function_line (THIS->_fun.u.object, THIS->_fun.subtype,
				    &THIS->lineno);
    }
    else if (THIS->prog) {
      file = low_get_program_line (THIS->prog, &THIS->lineno);
    }

    if (file) {
      if (!THIS->filename) THIS->filename = file;
      else free_string (file);
    }

    if (THIS->prog) {
      free_program(THIS->prog);
      THIS->prog = NULL;
    }
  }

  /*! @decl string _sprintf(int c, mapping|void opts)
   */
  #define f_backtrace_frame_cq__sprintf_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_backtrace_frame_cq__sprintf_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_backtrace_frame_cq__sprintf(INT32 args) {
#line 1777 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
INT_TYPE c;
#line 1777 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct mapping * opts;
#line 1777 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args < 1) wrong_number_of_args_error("_sprintf",args,1);
#line 1777 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args > 2) wrong_number_of_args_error("_sprintf",args,2);
#line 1777 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-args].type != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("_sprintf",1,"int");
#line 1777 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
c=Pike_sp[0-args].u.integer;
#line 1777 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if (args > 1 &&    (Pike_sp[1-args].type != PIKE_T_INT ||     Pike_sp[1-args].u.integer)) {
#line 1777 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[1-args].type != PIKE_T_MAPPING) SIMPLE_ARG_TYPE_ERROR("_sprintf",2,"mapping(mixed:mixed)|void");
#line 1777 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(opts=Pike_sp[1-args].u.mapping);
#line 1777 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
} else opts = NULL;
{
    pop_n_elems(args);

    if (c != 'O') {
      push_undefined ();
      return;
    }

    push_text("backtrace_frame(");

    if (THIS->lineno == -1) fill_in_file_and_line();

    if (THIS->filename) {
      ref_push_string(THIS->filename);
      push_text(":");
      push_int(THIS->lineno);
      push_text(", ");
      f_add(4);
    } else {
      push_text("Unknown file, ");
    }
    if (THIS->_fun.type == PIKE_T_FUNCTION) {
      if (THIS->_fun.u.object->prog) {
#ifdef PIKE_DEBUG
	if (THIS->_fun.u.object->prog != THIS->oprog) {
	  struct identifier *id = ID_FROM_INT(THIS->oprog, THIS->_fun.subtype);
	  /* FIXME: Dump dmalloc info for the object? */
	  Pike_fatal("Lost track of function pointer! Function name was %s.\n",
		     id->name?id->name->str:"<no name>");
	}
#endif
	push_svalue(&THIS->_fun);
	f_function_name(1);
	push_text("(), ");
	f_add(2);
      } else {
	free_svalue(&THIS->_fun);
	THIS->_fun.type = PIKE_T_INT;
	THIS->_fun.u.integer = 0;
	THIS->_fun.subtype = NUMBER_DESTRUCTED;
	push_text("destructed_function(), ");	
      }
    } else {
      push_text("destructed_function(), ");
    }

    if (THIS->args) {
      push_text("Args: ");
      push_int(THIS->args->size);
      f_add(2);
    } else {
      push_text("No args");
    }
    push_text(")");
    f_add(5);
  }

  }
/*! @decl int(3..) _sizeof()
   */
  #define f_backtrace_frame_cq__sizeof_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_backtrace_frame_cq__sizeof_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_backtrace_frame_cq__sizeof(INT32 args) {
#line 1837 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("_sizeof",args,0);
{
    if (THIS->args) {
      push_int(THIS->args->size + 3);
    } else {
      push_int(3);
    }
  }

  }
/*! @decl mixed `[](int index, int|void end_or_none)
   *! The BacktraceFrame object can be indexed as an array.
   */
  #define f_backtrace_frame_cq__backtick_5B_5D_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_backtrace_frame_cq__backtick_5B_5D_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_backtrace_frame_cq__backtick_5B_5D(INT32 args) {
#line 1849 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
INT_TYPE index;
#line 1849 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * end_or_none;
#line 1849 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args < 1) wrong_number_of_args_error("`[]",args,1);
#line 1849 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args > 2) wrong_number_of_args_error("`[]",args,2);
#line 1849 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-args].type != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("`[]",1,"int");
#line 1849 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
index=Pike_sp[0-args].u.integer;
#line 1849 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if (args > 1) {
#line 1849 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[1-args].type != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("`[]",2,"int|void");
#line 1849 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
end_or_none=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
#line 1849 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
} else end_or_none = NULL;
{
    INT_TYPE end = index;
    INT32 numargs = 0;
    INT32 i;

    if (THIS->args) {
      numargs = THIS->args->size;
    }

    numargs += 3;

    if (!end_or_none) {
      if (index < 0) {
	index_error("pike_frame->`[]", Pike_sp-args, args, NULL, Pike_sp-args,
		    "Indexing with negative index (%"PRINTPIKEINT"d)\n", index);
      } else if (index >= numargs) {
	index_error("pike_frame->`[]", Pike_sp-args, args, NULL, Pike_sp-args,
		    "Indexing with too large index (%"PRINTPIKEINT"d)\n", index);
      }
    } else {
      if (end_or_none->type != PIKE_T_INT) {
	SIMPLE_BAD_ARG_ERROR("`[]",2,"int|void");
      }
      end = end_or_none->u.integer;
    }

    pop_n_elems(args);

    if (end_or_none) {
      if ((end < 0) || (end < index) || (index >= numargs)) {
	f_aggregate(0);
	return;
      }

      if (end >= numargs) {
	end = numargs-1;
      }
    }

    for (i = index; i <= end; i++) {
      switch(i) {
      case 0:	/* Filename */
	if (THIS->lineno == -1) fill_in_file_and_line();
	if (THIS->filename) {
	  ref_push_string(THIS->filename);
	} else {
	  push_int(0);
	}
	break;
      case 1:	/* Linenumber */
	if (THIS->lineno == -1) fill_in_file_and_line();
	push_int(THIS->lineno);
	break;
      case 2:	/* Function */
        push_svalue(&THIS->_fun);
        break;
      default:	/* Arguments */
        {
	  if ((i > 2) && (THIS->args) && (i-3 < THIS->args->size)) {
	    push_svalue(THIS->args->item + (i - 3));
	    break;
	  }
	  bad_arg_error("backtrace_frame->`[]", Pike_sp-args, args, 1,
			"int(0..)", Pike_sp-args,
			"Bad argument 1 to backtrace_frame->`[](): "
			"Expected int(0..%d)\n",
			numargs + 2);
	}
        /* NOT_REACHED */
        break;
      }
    }
    if (end_or_none) {
      f_aggregate(1 + end - index);
    }
  }

  }
/*! @decl mixed `[]=(int index, mixed value)
   */
  #define f_backtrace_frame_cq__backtick_5B_5D_eq_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_backtrace_frame_cq__backtick_5B_5D_eq_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_backtrace_frame_cq__backtick_5B_5D_eq(INT32 args) {
#line 1929 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
INT_TYPE index;
#line 1929 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * value;
#line 1929 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 2) wrong_number_of_args_error("`[]=",args,2);
#line 1929 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-2].type != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("`[]=",1,"int");
#line 1929 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
index=Pike_sp[0-2].u.integer;
#line 1929 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
value=Pike_sp+1-2; dmalloc_touch_svalue(Pike_sp+1-2);
{
    INT32 numargs = 0;

    if (THIS->args) {
      numargs = THIS->args->size;
    }

    numargs += 3;

    if ((index < -numargs) || (index >= numargs)) {
	index_error("pike_frame->`[]=", Pike_sp-args, args, NULL, Pike_sp-args,
		    "Index %"PRINTPIKEINT"d is out of array range 0..%d,\n",
		    index, numargs-1);
    } else if (index < 0) {
      index += numargs;
    }

    if (args > 2) {
      pop_n_elems(args - 2);
      args = 2;
    }

    switch(index) {
    case 0:	/* Filename */
      if (THIS->lineno == -1) fill_in_file_and_line();
      if (value->type != PIKE_T_STRING) {
	if ((value->type != PIKE_T_INT) ||
	    (value->u.integer)) {
	  SIMPLE_BAD_ARG_ERROR("backtrace_frame->`[]=", 2,
			       "string|int(0..0)");
	}
	if (THIS->filename) {
	  free_string(THIS->filename);
	  THIS->filename = NULL;
	}
      } else {
	if (THIS->filename) {
	  free_string(THIS->filename);
	  THIS->filename = NULL;
	}
	copy_shared_string(THIS->filename, value->u.string);
      }
      break;

    case 1:	/* Linenumber */
      if (THIS->lineno == -1) fill_in_file_and_line();
      if (value->type != PIKE_T_INT) {
	SIMPLE_BAD_ARG_ERROR("backtrace_frame->`[]=", 2, "int(1..)");
      }
      THIS->lineno = value->u.integer;
      break;

    case 2:	/* Function */
      if (THIS->lineno == -1) fill_in_file_and_line();
      assign_svalue(&THIS->_fun, value);
      break;
    default:	/* Arguments */
      assign_svalue(THIS->args->item + index - 3, value);
      break;
    }
    stack_swap();
    pop_stack();
  }

}

#ifdef backtrace_frame_event_handler_defined
static void backtrace_frame_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_backtrace_frame_defined
  case PROG_EVENT_INIT: init_backtrace_frame_struct(); break;

#endif /* internal_init_backtrace_frame_defined */

#ifdef internal_exit_backtrace_frame_defined
  case PROG_EVENT_EXIT: exit_backtrace_frame_struct(); break;

#endif /* internal_exit_backtrace_frame_defined */
  default: break; 
  }
}

#endif /* backtrace_frame_event_handler_defined */
#line 1994 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
;

/*! @endclass
 */

/*! @decl mapping(string:int|string) get_runtime_info()
 *!
 *! Get information about the Pike runtime.
 *!
 *! @returns
 *!   Returns a mapping with the following content:
 *!   @mapping
 *!     @member string "bytecode_method"
 *!       A string describing the bytecode method used by
 *!       the Pike interpreter.
 *!     @member int "abi"
 *!       The number of bits in the ABI. Usually @expr{32@} or @expr{64@}.
 *!     @member int "native_byteorder"
 *!       The byte order used by the native cpu.
 *!       Usually @expr{1234@} (aka little endian) or
 *!       @expr{4321@} (aka bigendian).
 *!     @member int "int_size"
 *!       The number of bits in the native integer type.
 *!       Usually @expr{32@} or @expr{64@}.
 *!     @member int "float_size"
 *!       The number of bits in the native floating point type.
 *!       Usually @expr{32@} or @expr{64@}.
 *!     @member int(0..1) "auto_bignum"
 *!       Present if integers larger than the native size are automatically
 *!       converted into bignums.
 *!   @endmapping
 */
#define f_get_runtime_info_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_get_runtime_info_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_get_runtime_info(INT32 args) {
#line 2026 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("get_runtime_info",args,0);
#line 2028 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  pop_n_elems(args);
  push_constant_text("bytecode_method");
  push_constant_text(PIKE_BYTECODE_METHOD_NAME);
  push_constant_text("abi");
  push_int(sizeof(void *) * 8);
  push_constant_text("native_byteorder");
  push_int(PIKE_BYTEORDER);
  push_constant_text("int_size");
  push_int(sizeof(INT_TYPE) * 8);
  push_constant_text("float_size");
  push_int(sizeof(FLOAT_TYPE) * 8);
#ifdef AUTO_BIGNUM
  push_constant_text("auto_bignum");
  push_int(1);
  f_aggregate_mapping(6*2);
#else
  f_aggregate_mapping(5*2);
#endif
}

}
/*! @endmodule
 */

#line 2052 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
void low_backtrace(struct Pike_interpreter *i)
{
  struct svalue *stack_top = i->stack_pointer;
  struct pike_frame *f, *of = 0;
  int size = 0;
  struct array *res = NULL;

  for (f = i->frame_pointer; f; f = f->next) {
    size++;
  }

  res = allocate_array_no_init(size, 0);
  push_array(res);

  for (f = i->frame_pointer; f && size; f = (of = f)->next) {
    struct object *o = low_clone(backtrace_frame_program);
    struct backtrace_frame_struct *bf;
    struct identifier *function = NULL;

    call_c_initializers(o);

    size--;

    res->item[size].u.object = o;
    res->item[size].type = PIKE_T_OBJECT;
    res->item[size].subtype = 0;

    bf = OBJ2_BACKTRACE_FRAME(o);

    if ((bf->prog = f->context->prog)) {
      add_ref(bf->prog);
      bf->pc = f->pc;
    }

    if ((bf->_fun.u.object = f->current_object) &&
	(bf->_fun.u.object->prog)) {
      add_ref(bf->_fun.u.object);
#ifdef PIKE_DEBUG
      add_ref(bf->oprog = bf->_fun.u.object->prog);
#endif
      bf->_fun.subtype = CHECK_IDREF_RANGE(f->fun, f->current_object->prog);
      bf->_fun.type = PIKE_T_FUNCTION;
      function = ID_FROM_INT(f->current_object->prog, f->fun);
    } else {
      bf->_fun.u.integer = 0;
      bf->_fun.subtype = NUMBER_DESTRUCTED;
      bf->_fun.type = PIKE_T_INT;
    }

    if (f->locals) {
      INT32 numargs = DO_NOT_WARN((INT32) MINIMUM(f->num_args,
						  stack_top - f->locals));
      INT32 varargs = 0;

      if(of && of->locals) {
	/* f->num_args can be too large, so this is necessary for some
	 * reason. I don't know why. /mast */
	numargs = DO_NOT_WARN((INT32)MINIMUM(f->num_args,of->locals - f->locals));
      }

      numargs = MAXIMUM(numargs, 0);

      /* Handle varargs... */
      if (function && (function->identifier_flags & IDENTIFIER_VARARGS) &&
	  (f->locals + numargs < stack_top) &&
	  (f->locals[numargs].type == T_ARRAY)) {
	varargs = f->locals[numargs].u.array->size;
      }

      if (numargs + varargs) {
	bf->args = allocate_array_no_init(numargs + varargs, 0);
	bf->args->type_field =
	  assign_svalues_no_free(bf->args->item, f->locals, numargs, BIT_MIXED);
	if (varargs) {
	  bf->args->type_field |=
	    assign_svalues_no_free(bf->args->item + numargs,
				   f->locals[numargs].u.array->item,
				   varargs, BIT_MIXED);
	}
      }
    }
  }
  res->type_field = BIT_OBJECT;
  /* NOTE: res has already been pushed on the stack. */
}

/*! @decl array(Pike.BacktraceFrame) backtrace()
 *!
 *!   FIXME: This documentation is not up to date!
 *!
 *!   Get a description of the current call stack.
 *!
 *!   The description is returned as an array with one entry for each call
 *!   frame on the stack.
 *!
 *!   Each entry has this format:
 *!   @array
 *!     @elem string file
 *!       A string with the filename if known, else zero.
 *!     @elem int line
 *!       An integer containing the linenumber if known, else zero.
 *!     @elem function fun
 *!       The function that was called at this level.
 *!     @elem mixed|void ... args
 *!       The arguments that the function was called with.
 *!   @endarray
 *!
 *!   The current call frame will be last in the array.
 *!
 *! @note
 *!   Please note that the frame order may be reversed in a later version
 *!   (than 7.1) of Pike to accommodate for deferred backtraces.
 *!
 *!   Note that the arguments reported in the backtrace are the current
 *!   values of the variables, and not the ones that were at call-time.
 *!   This can be used to hide sensitive information from backtraces
 *!   (eg passwords).
 *!
 *! @seealso
 *!   @[catch()], @[throw()]
 */
PMOD_EXPORT
#define f_backtrace_defined
DEFAULT_CMOD_STORAGE void f_backtrace(INT32 args) {
#line 2174 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("backtrace",args,0);
#line 2177 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  low_backtrace(& Pike_interpreter);
}

}
/*! @module String
 */

/*! @class Buffer
 *!    A buffer, used for building strings. It's
 *!    conceptually similar to a string, but you can only @[add]
 *!    strings to it, and you can only @[get] the value from it once.
 *!
 *!    There is a reason for those seemingly rather odd limitations,
 *!    it makes it possible to do some optimizations that really speed
 *!    things up.
 *!
 *!    You do not need to use this class unless you add very many
 *!    strings together, or very large strings.
 *!
 *! @example
 *!    For the fastest possible operation, write your code like this:
 *!
 *! @code
 *! String.Buffer b = String.Buffer( );
 *!
 *! function add = b->add;
 *!
 *! .. call add several times in code ...
 *!
 *! string result = b->get(); // also clears the buffer
 *! @endcode
 */

#undef class_Buffer_defined
#define class_Buffer_defined
DEFAULT_CMOD_STORAGE struct program *Buffer_program=NULL;
static int Buffer_program_fun_num=-1;

#undef var_str_Buffer_defined
#define var_str_Buffer_defined

#undef var_initial_Buffer_defined
#define var_initial_Buffer_defined

#undef THIS
#define THIS ((struct Buffer_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_BUFFER
#define THIS_BUFFER ((struct Buffer_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_BUFFER
#define OBJ2_BUFFER(o) ((struct Buffer_struct *)(o->storage+Buffer_storage_offset))

#undef GET_BUFFER_STORAGE
#define GET_BUFFER_STORAGE ((struct Buffer_struct *)(o->storage+Buffer_storage_offset)
static ptrdiff_t Buffer_storage_offset;
struct Buffer_struct {

#ifdef var_str_Buffer_defined
#line 2211 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct string_builder str;
#endif /* var_str_Buffer_defined */

#ifdef var_initial_Buffer_defined
#line 2212 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
int initial;
#endif /* var_initial_Buffer_defined */
};
#ifdef PIKE_DEBUG
/* Ensure the struct is used in a variable declaration, or else gdb might not see it. */
static struct Buffer_struct *Buffer_gdb_dummy_ptr;
#endif
#line 2214 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
void f_Buffer_get_copy( INT32 args );
  void f_Buffer_get( INT32 args );
  void f_Buffer_add( INT32 args );


  /*! @decl void create(int initial_size)
   *!
   *!   Initializes a new buffer.
   *!
   *!   If no @[initial_size] is specified, 256 is used. If you
   *!   know approximately how big the buffer will be, you can optimize
   *!   the operation of @[add()] (slightly) by passing the size to this
   *!   function.
   */
  #define f_Buffer_create_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_create_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_Buffer_create(INT32 args) {
#line 2228 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * size;
#line 2228 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args > 1) wrong_number_of_args_error("create",args,1);
#line 2228 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if (args > 0) {
#line 2228 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-args].type != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("create",1,"int|void");
#line 2228 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
size=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
#line 2228 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
} else size = NULL;
{
    struct Buffer_struct *str = THIS;
    if( args )
      str->initial = MAXIMUM( size->u.integer, 512 );
    else
      str->initial = 256;
  }

  }
/*! @decl string _sprintf( int flag, mapping flags )
   *! It is possible to @[sprintf] a String.Buffer object
   *! as @tt{%s@} just as if it was a string.
   */
  #define f_Buffer_cq__sprintf_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_cq__sprintf_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_Buffer_cq__sprintf(INT32 args) {
#line 2241 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
INT_TYPE flag;
#line 2241 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct mapping * flags;
#line 2241 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 2) wrong_number_of_args_error("_sprintf",args,2);
#line 2241 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-2].type != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("_sprintf",1,"int");
#line 2241 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
flag=Pike_sp[0-2].u.integer;
#line 2241 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[1-2].type != PIKE_T_MAPPING) SIMPLE_ARG_TYPE_ERROR("_sprintf",2,"mapping(mixed:mixed)");
#line 2241 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(flags=Pike_sp[1-2].u.mapping);
{
    switch( flag )
    {
      case 'O':
	{
	  struct pike_string *res;
	  struct Buffer_struct *str = THIS;
	  push_text( "Buffer(%d /* %d */)" );
	  if( str->str.s )
	  {
	    push_int(str->str.s->len);
	    push_int(str->str.malloced);
	  }
	  else
	  {
	    push_int( 0 );
	    push_int( 0 );
	  }
	  f_sprintf( 3 );
	  dmalloc_touch_svalue(Pike_sp-1);
	  res = Pike_sp[-1].u.string;
	  Pike_sp--;
	  do { struct pike_string * ret_=(res); pop_n_elems(2); push_string(ret_); return; }while(0);
#line 2265 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

      case 's':
	{
	  pop_n_elems( args );
	  if( Pike_fp->current_object->refs != 1 )
	    f_Buffer_get_copy( 0 );
	  else
	    f_Buffer_get( 0 );
	}
	return;
	
      case 't':
	do { struct pike_string * ret_=(make_shared_binary_string("Buffer",6)); pop_n_elems(2); push_string(ret_); return; }while(0);
#line 2279 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}
    pop_n_elems( args );
    push_int( 0 );
    Pike_sp[-1].subtype = 1;
  }

  }
/*! @decl mixed cast( string type )
   *! It is possible to cast a String.Buffer object to
   *! a @expr{string@} and an @expr{int@}.
   */
  #define f_Buffer_cast_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_cast_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_Buffer_cast(INT32 args) {
#line 2289 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_string * type;
#line 2289 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("cast",args,1);
#line 2289 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("cast",1,"string");
#line 2289 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(type=Pike_sp[0-1].u.string);
{
    struct pike_string *string_t;
    struct pike_string *int_t;
    MAKE_CONST_STRING( string_t, "string" );
    MAKE_CONST_STRING( int_t, "int" );

    if( type == string_t )
    {
      pop_n_elems( args );
      if( Pike_fp->current_object->refs != 1 )
	f_Buffer_get_copy( 0 );
      else
	f_Buffer_get( 0 );
      return;
    }

    if( type == int_t )
    {
      struct Buffer_struct *str = THIS;
      pop_stack();
      if( Pike_fp->current_object->refs != 1 )
	f_Buffer_get_copy( 0 );
      else
	f_Buffer_get( 0 );
      o_cast_to_int( );
      return;
    }
    Pike_error("Cannot cast to %S\n", type);
  }
  
  }
/*! @decl String.Buffer `+( string what )
   */
  #define f_Buffer_cq__backtick_add_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_cq__backtick_add_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_Buffer_cq__backtick_add(INT32 args) {
#line 2322 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_string * what;
#line 2322 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("`+",args,1);
#line 2322 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("`+",1,"string");
#line 2322 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(what=Pike_sp[0-1].u.string);
{
    struct Buffer_struct *str = THIS, *str2;
    struct object *res = fast_clone_object( Buffer_program );
    str2 = OBJ2_BUFFER( res );
    str2->initial = str->initial;
    if( str->str.s )
      init_string_builder_copy (&str2->str, &str->str);
    apply( res, "add", 1 );
    do { struct object * ret_=(res); pop_stack(); push_object(ret_); return; }while(0);
#line 2332 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

  }
/*! @decl String.Buffer `+=( string what )
   */
  #define f_Buffer_cq__backtick_add_eq_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_cq__backtick_add_eq_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_Buffer_cq__backtick_add_eq(INT32 args) {
#line 2336 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_string * what;
#line 2336 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("`+=",args,1);
#line 2336 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("`+=",1,"string");
#line 2336 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(what=Pike_sp[0-1].u.string);
{
    f_Buffer_add( 1 );
    do { struct object * ret_=(Pike_fp->current_object); add_ref(ret_); pop_stack(); push_object(ret_); return; }while(0);
#line 2340 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

  }
/*! @decl int add(string ... data)
   *!
   *!   Adds @[data] to the buffer. Returns the size of the buffer.
   *!
   */
  #define f_Buffer_add_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_add_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_Buffer_add(INT32 args) {
#line 2347 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * arg1;
#line 2347 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 2347 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0+argcnt-args].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("add",1+argcnt,"string");
#line 2347 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  } while (++argcnt < args-0);
  arg1=Pike_sp+0-args;
} else arg1=0;
#line 2348 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
    struct Buffer_struct *str = THIS;
    int init_from_arg0 = 0, j;

    if (!str->str.s && args) {
      ptrdiff_t sum = 0;
      int shift = 0;
      for (j=0; j < args; j++) {
	struct pike_string *a = Pike_sp[j-args].u.string;
	sum += a->len;
	shift |= a->size_shift;
      }
      if (sum < str->initial)
	sum = str->initial;
      else if (sum > str->initial)
	sum <<= 1;
      shift = shift & ~(shift >> 1);

      if (shift == Pike_sp[-args].u.string->size_shift &&
	  init_string_builder_with_string (&str->str, Pike_sp[-args].u.string)) {
	mark_free_svalue (Pike_sp - args);
	if (sum > str->str.s->len)
	  string_build_mkspace (&str->str, sum - str->str.s->len, shift);
	init_from_arg0 = 1;
      }
      else
	init_string_builder_alloc(&str->str, sum, shift);

      /* We know it will be a string that really is this wide. */
      str->str.known_shift = shift;
    }

    for( j = init_from_arg0; j<args; j++ )
    {
      struct pike_string *a = Pike_sp[j-args].u.string;
      string_builder_shared_strcat( &str->str, a );
    }

    if (str->str.s) {
      do { INT_TYPE ret_=(str->str.s->len); pop_n_elems(args); push_int(ret_); return; }while(0);
#line 2388 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
} else {
      do { INT_TYPE ret_=(0); pop_n_elems(args); push_int(ret_); return; }while(0);
#line 2390 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}
  }

  }
/*! @decl void putchar(int c)
   *! Appends the character @[c] at the end of the string.
   */
  #define f_Buffer_putchar_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_putchar_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_Buffer_putchar(INT32 args) {
#line 2396 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
INT_TYPE c;
#line 2396 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("putchar",args,1);
#line 2396 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("putchar",1,"int");
#line 2396 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
c=Pike_sp[0-1].u.integer;
#line 2396 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
    struct Buffer_struct *str = THIS;
    if(!str->str.s)
      init_string_builder_alloc(&str->str, str->initial, 0);
    string_builder_putchar(&str->str, c);
  }

  }
/*! @decl string get_copy()
   *!
   *!   Get the data from the buffer. Significantly slower than @[get],
   *!   but does not clear the buffer.
   */
  #define f_Buffer_get_copy_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_get_copy_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_Buffer_get_copy(INT32 args) {
#line 2408 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("get_copy",args,0);
{
    struct pike_string *str = THIS->str.s;
    if( str )
    {
      ptrdiff_t len = str->len;
      if( len > 0 )
      {
	char *d = (char *)str->str;
	switch( str->size_shift )
	{
	  case 0:
	    do { struct pike_string * ret_=(make_shared_binary_string0((p_wchar0 *)d,len));  push_string(ret_); return; }while(0);
#line 2421 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
break;
	  case 1:
	    do { struct pike_string * ret_=(make_shared_binary_string1((p_wchar1 *)d,len));  push_string(ret_); return; }while(0);
#line 2424 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
break;
	  case 2:
	    do { struct pike_string * ret_=(make_shared_binary_string2((p_wchar2 *)d,len));  push_string(ret_); return; }while(0);
#line 2427 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
break;
	}
      }
    }
    push_empty_string();
    return;
  }

  }
/*! @decl string get()
   *!
   *!   Get the data from the buffer.
   *!
   *! @note
   *!   This will clear the data in the buffer
   */
  #define f_Buffer_get_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_get_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_Buffer_get(INT32 args) {
#line 2442 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("get",args,0);
{
    struct Buffer_struct *str = THIS;
    if( str->str.s )
    {
      struct pike_string *s = finish_string_builder( &str->str );
      str->str.malloced = 0;
      str->str.s = NULL;
      do { struct pike_string * ret_=(s);  push_string(ret_); return; }while(0);
#line 2451 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}
    pop_n_elems(args);
    push_empty_string();
    return;
  }

  }
/*! @decl int _sizeof()
   *!
   *!   Returns the size of the buffer.
   */
  #define f_Buffer_cq__sizeof_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_cq__sizeof_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_Buffer_cq__sizeof(INT32 args) {
#line 2461 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("_sizeof",args,0);
{
    struct Buffer_struct *str = THIS;
    do { INT_TYPE ret_=(str->str.s ? str->str.s->len : 0);  push_int(ret_); return; }while(0);
#line 2465 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

  }

#undef internal_init_Buffer_defined
#define internal_init_Buffer_defined

#undef Buffer_event_handler_defined
#define Buffer_event_handler_defined
static void init_Buffer_struct(void)
#line 2468 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
      struct Buffer_struct *str = THIS;
      MEMSET( str, 0, sizeof( *str ) );
    }

  
#undef internal_exit_Buffer_defined
#define internal_exit_Buffer_defined

#undef Buffer_event_handler_defined
#define Buffer_event_handler_defined
static void exit_Buffer_struct(void)
#line 2475 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
      struct Buffer_struct *str = THIS;
      if( str->str.s )
	free_string_builder( &str->str );
    }

  
#undef internal_gc_recurse_Buffer_defined
#define internal_gc_recurse_Buffer_defined

#undef Buffer_event_handler_defined
#define Buffer_event_handler_defined
static void gc_recurse_Buffer_struct(void)
#line 2482 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
    if (mc_count_bytes (Pike_fp->current_object) && THIS->str.s)
      mc_counted_bytes += THIS->str.malloced;
  }

#ifdef Buffer_event_handler_defined
static void Buffer_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_Buffer_defined
  case PROG_EVENT_INIT: init_Buffer_struct(); break;

#endif /* internal_init_Buffer_defined */

#ifdef internal_exit_Buffer_defined
  case PROG_EVENT_EXIT: exit_Buffer_struct(); break;

#endif /* internal_exit_Buffer_defined */

#ifdef internal_gc_recurse_Buffer_defined
  case PROG_EVENT_GC_RECURSE: gc_recurse_Buffer_struct(); break;

#endif /* internal_gc_recurse_Buffer_defined */
  default: break; 
  }
}

#endif /* Buffer_event_handler_defined */
/*! @endclass
 */

/*! @class Replace
 *!
 *! This is a "compiled" version of the @[replace] function applied on
 *! a string, with more than one replace string. The replace strings
 *! are given to the create method as a @i{from@} and @i{to@} array
 *! and are then analyzed. The @expr{`()@} is then called with a
 *! string and the replace rules in the Replace object will be
 *! applied. The Replace object is used internally by the Pike
 *! optimizer and need not be used manually.
 */

#undef class_multi_string_replace_defined
#define class_multi_string_replace_defined
DEFAULT_CMOD_STORAGE struct program *multi_string_replace_program=NULL;
static int multi_string_replace_program_fun_num=-1;

#undef var_ctx_multi_string_replace_defined
#define var_ctx_multi_string_replace_defined
#line 2504 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
/* NOTE: from and to are only kept for _encode()'s use. */
  
#undef var_from_multi_string_replace_defined
#define var_from_multi_string_replace_defined

#undef var_to_multi_string_replace_defined
#define var_to_multi_string_replace_defined

#undef THIS
#define THIS ((struct multi_string_replace_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_MULTI_STRING_REPLACE
#define THIS_MULTI_STRING_REPLACE ((struct multi_string_replace_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_MULTI_STRING_REPLACE
#define OBJ2_MULTI_STRING_REPLACE(o) ((struct multi_string_replace_struct *)(o->storage+multi_string_replace_storage_offset))

#undef GET_MULTI_STRING_REPLACE_STORAGE
#define GET_MULTI_STRING_REPLACE_STORAGE ((struct multi_string_replace_struct *)(o->storage+multi_string_replace_storage_offset)
static ptrdiff_t multi_string_replace_storage_offset;
struct multi_string_replace_struct {

#ifdef var_ctx_multi_string_replace_defined
#line 2503 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct replace_many_context ctx;
#endif /* var_ctx_multi_string_replace_defined */

#ifdef var_from_multi_string_replace_defined
  struct array * from;

#endif /* var_from_multi_string_replace_defined */

#ifdef var_to_multi_string_replace_defined
  struct array * to;

#endif /* var_to_multi_string_replace_defined */
};
#ifdef PIKE_DEBUG
/* Ensure the struct is used in a variable declaration, or else gdb might not see it. */
static struct multi_string_replace_struct *multi_string_replace_gdb_dummy_ptr;
#endif
/*! @decl void create(array(string)|mapping(string:string)|void from, @
   *!                   array(string)|string|void to)
   */
  #define f_multi_string_replace_create_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_multi_string_replace_create_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_multi_string_replace_create(INT32 args) {
#line 2511 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * from_arg;
struct svalue * to_arg;
#line 2511 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args > 2) wrong_number_of_args_error("create",args,2);
#line 2511 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if (args > 0) {
#line 2511 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
from_arg=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
#line 2511 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
} else from_arg = NULL;
if (args > 1) {
#line 2512 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
to_arg=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
#line 2512 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
} else to_arg = NULL;
{
    if (THIS->from) {
      free_array(THIS->from);
      THIS->from = NULL;
    }
    if (THIS->to) {
      free_array(THIS->to);
      THIS->to = NULL;
    }
    if (THIS->ctx.v)
      free_replace_many_context(&THIS->ctx);

    if (!args) {
      push_int(0);
      return;
    }
    if (from_arg && from_arg->type == T_MAPPING) {
      if (to_arg) {
	Pike_error("Bad number of arguments to create().\n");
      }
      THIS->from = mapping_indices(from_arg->u.mapping);
      THIS->to = mapping_values(from_arg->u.mapping);
      pop_n_elems(args);
      args = 0;
    } else {
      /* FIXME: Why is from declared |void, when it isn't allowed
       *        to be void?
       *        /grubba 2004-09-02
       *
       * It probably has to do with the "if (!args)" above: It should
       * be possible to create an empty instance. /mast
       */
      if (!from_arg || !to_arg) {
	Pike_error("Bad number of arguments to create().\n");
      }
      pop_n_elems(args-2);
      args = 2;
      if (from_arg->type != T_ARRAY) {
	SIMPLE_BAD_ARG_ERROR("Replace", 1,
			     "array(string)|mapping(string:string)");
      }
      if (to_arg->type == T_STRING) {
	push_int(from_arg->u.array->size);
	stack_swap();
	f_allocate(2);
      }
      if (to_arg->type != T_ARRAY) {
	SIMPLE_BAD_ARG_ERROR("Replace", 2, "array(string)|string");
      }
      if (from_arg->u.array->size != to_arg->u.array->size) {
	Pike_error("Replace must have equal-sized from and to arrays.\n");
      }
      add_ref(THIS->from = from_arg->u.array);
      add_ref(THIS->to = to_arg->u.array);
    }

    if (!THIS->from->size) {
      /* Enter no-op mode. */
      pop_n_elems(args);
      push_int(0);
      return;
    }

    if( (THIS->from->type_field & ~BIT_STRING) &&
	(array_fix_type_field(THIS->from) & ~BIT_STRING) )
      SIMPLE_BAD_ARG_ERROR("Replace", 1,
			   "array(string)|mapping(string:string)");

    if( (THIS->to->type_field & ~BIT_STRING) &&
	(array_fix_type_field(THIS->to) & ~BIT_STRING) )
      SIMPLE_BAD_ARG_ERROR("Replace", 2, "array(string)|string");

    compile_replace_many(&THIS->ctx, THIS->from, THIS->to, 1);

    pop_n_elems(args);
    push_int(0);
  }

  }
/*! @decl string `()(string str)
   */
  #define f_multi_string_replace_cq__backtick_28_29_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_multi_string_replace_cq__backtick_28_29_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_multi_string_replace_cq__backtick_28_29(INT32 args) {
#line 2593 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_string * str;
#line 2593 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("`()",args,1);
#line 2593 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("`()",1,"string");
#line 2593 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(str=Pike_sp[0-1].u.string);
{
    if (!THIS->ctx.v) {
      /* The result is already on the stack in the correct place... */
      return;
    }

    do { struct pike_string * ret_=(execute_replace_many(&THIS->ctx, str)); pop_stack(); push_string(ret_); return; }while(0);
#line 2601 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

  }
/*! @decl array(array(string)) _encode()
   */
  #define f_multi_string_replace_cq__encode_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_multi_string_replace_cq__encode_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_multi_string_replace_cq__encode(INT32 args) {
#line 2605 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("_encode",args,0);
{
    if (THIS->from) {
      ref_push_array(THIS->from);
    } else {
      push_undefined();
    }
    if (THIS->to) {
      ref_push_array(THIS->to);
    } else {
      push_undefined();
    }
    f_aggregate(2);
  }

  }
/*! @decl void _decode(array(array(string)) encoded)
   */
  #define f_multi_string_replace_cq__decode_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_multi_string_replace_cq__decode_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_multi_string_replace_cq__decode(INT32 args) {
#line 2622 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct array * encoded;
#line 2622 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("_decode",args,1);
#line 2622 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_ARRAY) SIMPLE_ARG_TYPE_ERROR("_decode",1,"array(array(string))");
#line 2622 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(encoded=Pike_sp[0-1].u.array);
{
    INT32 i;
    for (i=0; i < encoded->size; i++) {
      push_svalue(encoded->item + i);
      stack_swap();
    }
    pop_stack();

    f_multi_string_replace_create(i);
  }

  }

#undef internal_init_multi_string_replace_defined
#define internal_init_multi_string_replace_defined

#undef multi_string_replace_event_handler_defined
#define multi_string_replace_event_handler_defined
static void init_multi_string_replace_struct(void)
#line 2635 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
    MEMSET(&THIS->ctx, 0, sizeof(struct replace_many_context));
  }

  
#undef internal_exit_multi_string_replace_defined
#define internal_exit_multi_string_replace_defined

#undef multi_string_replace_event_handler_defined
#define multi_string_replace_event_handler_defined
static void exit_multi_string_replace_struct(void)
#line 2641 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
    free_replace_many_context(&THIS->ctx);
  }

#ifdef multi_string_replace_event_handler_defined
static void multi_string_replace_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_multi_string_replace_defined
  case PROG_EVENT_INIT: init_multi_string_replace_struct(); break;

#endif /* internal_init_multi_string_replace_defined */

#ifdef internal_exit_multi_string_replace_defined
  case PROG_EVENT_EXIT: exit_multi_string_replace_struct(); break;

#endif /* internal_exit_multi_string_replace_defined */
  default: break; 
  }
}

#endif /* multi_string_replace_event_handler_defined */
/*! @endclass
 */

/*! @class SingleReplace
 *!
 *! This is a "compiled" version of the @[replace] function applied on
 *! a string, with just one replace string. The replace strings are
 *! given to the create method as a @i{from@} and @i{tom@} string and
 *! are then analyzed. The @expr{`()@} is then called with a string
 *! and the replace rule in the Replace object will be applied. The
 *! Replace object is used internally by the Pike optimizer and need
 *! not be used manually.
 */

#undef class_single_string_replace_defined
#define class_single_string_replace_defined
DEFAULT_CMOD_STORAGE struct program *single_string_replace_program=NULL;
static int single_string_replace_program_fun_num=-1;

#undef var_mojt_single_string_replace_defined
#define var_mojt_single_string_replace_defined

#undef var_del_single_string_replace_defined
#define var_del_single_string_replace_defined

#undef var_to_single_string_replace_defined
#define var_to_single_string_replace_defined

#undef THIS
#define THIS ((struct single_string_replace_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_SINGLE_STRING_REPLACE
#define THIS_SINGLE_STRING_REPLACE ((struct single_string_replace_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_SINGLE_STRING_REPLACE
#define OBJ2_SINGLE_STRING_REPLACE(o) ((struct single_string_replace_struct *)(o->storage+single_string_replace_storage_offset))

#undef GET_SINGLE_STRING_REPLACE_STORAGE
#define GET_SINGLE_STRING_REPLACE_STORAGE ((struct single_string_replace_struct *)(o->storage+single_string_replace_storage_offset)
static ptrdiff_t single_string_replace_storage_offset;
struct single_string_replace_struct {

#ifdef var_mojt_single_string_replace_defined
#line 2661 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
SearchMojt mojt;
#endif /* var_mojt_single_string_replace_defined */

#ifdef var_del_single_string_replace_defined
  struct pike_string * del;

#endif /* var_del_single_string_replace_defined */

#ifdef var_to_single_string_replace_defined
  struct pike_string * to;

#endif /* var_to_single_string_replace_defined */
};
#ifdef PIKE_DEBUG
/* Ensure the struct is used in a variable declaration, or else gdb might not see it. */
static struct single_string_replace_struct *single_string_replace_gdb_dummy_ptr;
#endif

#undef extra_single_string_replace_defined
#define extra_single_string_replace_defined
/*! @decl void create(string|void from, string|void to)
   *!
   *! @note
   *!   May be called with either zero or two arguments.
   */
  #define f_single_string_replace_create_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_single_string_replace_create_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_single_string_replace_create(INT32 args) {
#line 2678 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_string * del;
#line 2678 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_string * to;
#line 2678 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args > 2) wrong_number_of_args_error("create",args,2);
#line 2678 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if (args > 0 &&    (Pike_sp[0-args].type != PIKE_T_INT ||     Pike_sp[0-args].u.integer)) {
#line 2678 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-args].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("create",1,"string|void");
#line 2678 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(del=Pike_sp[0-args].u.string);
#line 2678 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
} else del = NULL;
#line 2678 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if (args > 1 &&    (Pike_sp[1-args].type != PIKE_T_INT ||     Pike_sp[1-args].u.integer)) {
#line 2678 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[1-args].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("create",2,"string|void");
#line 2678 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(to=Pike_sp[1-args].u.string);
#line 2678 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
} else to = NULL;
{
    if (THIS->del) {
      free_string(THIS->del);
      THIS->del = NULL;
    }
    if (THIS->to) {
      free_string(THIS->to);
      THIS->to = NULL;
    }

    if (!del) return;

    if (!to) {
      SIMPLE_BAD_ARG_ERROR("String.SingleReplace->create", 2, "string");
    }

    if (del == to) {
      /* No-op... */
      return;
    }

    copy_shared_string(THIS->del, del);
    copy_shared_string(THIS->to, to);

    if (del->len) {
      THIS->mojt = simple_compile_memsearcher(del);
    }
  }

  }
#line 2708 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
/*** replace function ***/
  typedef char *(* replace_searchfunc)(void *,void *,size_t);

  /*! @decl string `()(string str)
   */
  #define f_single_string_replace_cq__backtick_28_29_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_single_string_replace_cq__backtick_28_29_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_single_string_replace_cq__backtick_28_29(INT32 args) {
#line 2713 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_string * str;
#line 2713 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("`()",args,1);
#line 2713 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("`()",1,"string");
#line 2713 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(str=Pike_sp[0-1].u.string);
{
    int shift;
    struct pike_string *del = THIS->del;
    struct pike_string *to = THIS->to;
    struct pike_string *ret = NULL;

    if (!str->len || !del || !to) {
      /* The result is already on the stack in the correct place... */
      return;
    }

    shift = MAXIMUM(str->size_shift, to->size_shift);

    if (!del->len) {
      int e, pos;
      ret = begin_wide_shared_string(str->len + to->len * (str->len-1),
				     shift);
      low_set_index(ret, 0, index_shared_string(str, 0));
      for(pos=e=1;e<str->len;e++)
      {
	pike_string_cpy(MKPCHARP_STR_OFF(ret,pos), to);
	pos+=to->len;
	low_set_index(ret,pos++,index_shared_string(str,e));
      }
    } else {
      char *s, *end, *tmp;
      replace_searchfunc f = (replace_searchfunc)0;
      void *mojt_data = THIS->mojt.data;
      PCHARP r;

      end = str->str+(str->len<<str->size_shift);

      switch(str->size_shift)
      {
      case 0: f = (replace_searchfunc)THIS->mojt.vtab->func0; break;
      case 1: f = (replace_searchfunc)THIS->mojt.vtab->func1; break;
      case 2: f = (replace_searchfunc)THIS->mojt.vtab->func2; break;
#ifdef PIKE_DEBUG
      default: Pike_fatal("Illegal shift.\n");
#endif
      }

      if(del->len == to->len)
      {
	ret = begin_wide_shared_string(str->len, shift);
      } else {
	INT32 delimiters = 0;

	s = str->str;

	while((s = f(mojt_data, s, (end-s)>>str->size_shift)))
	{
	  delimiters++;
	  s += del->len << str->size_shift;
	}

	if (!delimiters) {
	  /* The result is already on the stack in the correct place... */
	  return;
	}

	ret = begin_wide_shared_string(str->len +
				       (to->len-del->len)*delimiters, shift);
      }

      s = str->str;
      r = MKPCHARP_STR(ret);

      while((tmp = f(mojt_data, s, (end-s)>>str->size_shift)))
      {
#ifdef PIKE_DEBUG
	if(tmp + (del->len << str->size_shift) > end)
	  Pike_fatal("SearchMojt found a match beyond end of string!\n");
#endif
	generic_memcpy(r,MKPCHARP(s,str->size_shift),(tmp-s)>>str->size_shift);
	INC_PCHARP(r,(tmp-s)>>str->size_shift);
	pike_string_cpy(r,to);
	INC_PCHARP(r,to->len);
	s=tmp+(del->len << str->size_shift);
      }
      generic_memcpy(r,MKPCHARP(s,str->size_shift),(end-s)>>str->size_shift);
    }
    do { struct pike_string * ret_=(end_shared_string(ret)); pop_stack(); push_string(ret_); return; }while(0);
#line 2797 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

  }
/*! @decl array(string) _encode()
   */
  #define f_single_string_replace_cq__encode_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_single_string_replace_cq__encode_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_single_string_replace_cq__encode(INT32 args) {
#line 2801 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("_encode",args,0);
{
    if (THIS->del) {
      ref_push_string(THIS->del);
      ref_push_string(THIS->to);
      f_aggregate(2);
    } else {
      push_int(0);
    }
  }

  }
/*! @decl void _decode(array(string)|int(0..0) encoded)
   */
  #define f_single_string_replace_cq__decode_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_single_string_replace_cq__decode_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_single_string_replace_cq__decode(INT32 args) {
#line 2814 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * encoded_;
#line 2814 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("_decode",args,1);
#line 2814 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
encoded_=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
{    
    INT32 i = 0;
    if (encoded_->type == PIKE_T_ARRAY) {
      struct array *encoded = encoded_->u.array;

      for (i=0; i < encoded->size; i++) {
	push_svalue(encoded->item + i);
	stack_swap();
      }
    }
    pop_stack();
      
    f_single_string_replace_create(i);
  }
}
/*! @endclass
 */

/*! @class Bootstring
 *!
 *! This class implements the "Bootstring" string transcoder described in
 *! @url{ftp://ftp.rfc-editor.org/in-notes/rfc3492.txt@}.
 */

#undef class_bootstring_defined
#define class_bootstring_defined
DEFAULT_CMOD_STORAGE struct program *bootstring_program=NULL;
static int bootstring_program_fun_num=-1;

#undef var_damp_bootstring_defined
#define var_damp_bootstring_defined

#undef var_initial_n_bootstring_defined
#define var_initial_n_bootstring_defined

#undef var_delim_bootstring_defined
#define var_delim_bootstring_defined

#undef var_digits_bootstring_defined
#define var_digits_bootstring_defined

#undef THIS
#define THIS ((struct bootstring_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_BOOTSTRING
#define THIS_BOOTSTRING ((struct bootstring_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_BOOTSTRING
#define OBJ2_BOOTSTRING(o) ((struct bootstring_struct *)(o->storage+bootstring_storage_offset))

#undef GET_BOOTSTRING_STORAGE
#define GET_BOOTSTRING_STORAGE ((struct bootstring_struct *)(o->storage+bootstring_storage_offset)
static ptrdiff_t bootstring_storage_offset;
struct bootstring_struct {

#ifdef var_damp_bootstring_defined
#line 2841 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
INT_TYPE base, tmin, tmax, skew, damp;
#endif /* var_damp_bootstring_defined */

#ifdef var_initial_n_bootstring_defined
#line 2842 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
INT_TYPE initial_bias, initial_n;
#endif /* var_initial_n_bootstring_defined */

#ifdef var_delim_bootstring_defined
#line 2843 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
p_wchar2 delim;
#endif /* var_delim_bootstring_defined */

#ifdef var_digits_bootstring_defined
  struct pike_string * digits;

#endif /* var_digits_bootstring_defined */
};
#ifdef PIKE_DEBUG
/* Ensure the struct is used in a variable declaration, or else gdb might not see it. */
static struct bootstring_struct *bootstring_gdb_dummy_ptr;
#endif
#line 2846 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
static INT_TYPE bootstring_cp_to_digit(p_wchar2 ch)
  {
    ptrdiff_t digit = THIS->digits->len;
    PCHARP digits = MKPCHARP_STR( THIS->digits );
    while (digit>=0)
      if (INDEX_PCHARP( digits, digit ) == ch)
	return digit;
      else
	--digit;
    return -1;
  }

  static INT_TYPE bootstring_adapt(INT_TYPE delta, INT_TYPE numpoints,
				   int firsttime)
  {
    struct bootstring_struct *bs = THIS;
    INT_TYPE k = 0, b = bs->base;
    INT_TYPE a = b - bs->tmin;
    INT_TYPE limit = (a * bs->tmax) >> 1;
    if (firsttime)
      delta /= bs->damp;
    else
      delta >>= 1;
    delta += delta / numpoints;
    while (delta > limit) {
      delta /= a;
      k += b;
    }
    return k + (a + 1)*delta / (delta + bs->skew);
  }

  /*! @decl string decode(string s)
   *!
   *! Decodes a Bootstring encoded string of "basic" code points back
   *! to the original string space.
   */
  #define f_bootstring_decode_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_bootstring_decode_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_bootstring_decode(INT32 args) {
#line 2882 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_string * s;
#line 2882 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("decode",args,1);
#line 2882 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("decode",1,"string");
#line 2882 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(s=Pike_sp[0-1].u.string);
{
    struct bootstring_struct *bs = THIS;
    INT_TYPE n = bs->initial_n;
    INT_TYPE i = 0;
    INT_TYPE bias = bs->initial_bias;
    ptrdiff_t pos, input_left;
    PCHARP input;
    struct string_builder output;
    init_string_builder( &output,0 );
    input = MKPCHARP_STR( s );
    input_left = s->len;
    for (pos = input_left-1; pos > 0; --pos)
      if (INDEX_PCHARP( input, pos ) == bs->delim) {
	string_builder_append( &output, input, pos );
	INC_PCHARP( input, pos+1 );
	input_left -= pos+1;
	break;
      }

    while (input_left > 0) {
      INT_TYPE oldi = i;
      INT_TYPE w = 1;
      INT_TYPE k;
      for (k=bs->base; ; k+=bs->base) {
	INT_TYPE digit, t;
	if (input_left < 1 ||
	    (digit = bootstring_cp_to_digit( EXTRACT_PCHARP( input ) )) < 0) {
	  free_string_builder( &output );
	  Pike_error( "Invalid variable-length integer.\n" );
	}
	INC_PCHARP( input, 1 );
	--input_left;
	i += digit * w;	/* fail on overflow... */
	if (k <= bias + bs->tmin)
	  t = bs->tmin;
	else if (k >= bias + bs->tmax)
	  t = bs->tmax;
	else
	  t = k - bias;
	if (digit < t) break;
	w *= (bs->base - t);
      }
      bias = bootstring_adapt( i - oldi, output.s->len+1, !oldi );
      n += i / (output.s->len+1);
      i %= output.s->len+1;
      string_builder_putchar( &output, n );
      if (i != output.s->len-1)
	switch (output.s->size_shift) {
	case 0:
	  {
	    p_wchar0 *s = STR0(output.s);
	    INT_TYPE p = output.s->len;
	    while (--p>i)
	      s[p] = s[p-1];
	    s[p] = DO_NOT_WARN ((p_wchar0) n);
	  }
	  break;
	case 1:
	  {
	    p_wchar1 *s = STR1(output.s);
	    INT_TYPE p = output.s->len;
	    while (--p>i)
	      s[p] = s[p-1];
	    s[p] = DO_NOT_WARN ((p_wchar1) n);
	  }
	  break;
	case 2:
	  {
	    p_wchar2 *s = STR2(output.s);
	    INT_TYPE p = output.s->len;
	    while (--p>i)
	      s[p] = s[p-1];
	    s[p] = DO_NOT_WARN ((p_wchar2) n);
	  }
	  break;
#ifdef PIKE_DEBUG
	default:
	  Pike_fatal("Illegal shift size!\n");
#endif
	}
      i++;
    }

    do { struct pike_string * ret_=(finish_string_builder( &output )); pop_stack(); push_string(ret_); return; }while(0);
#line 2967 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

  }
/*! @decl string encode(string s)
   *!
   *! Encodes a string using Bootstring encoding into a string constisting
   *! only of "basic" code points (< initial_n).
   */
  #define f_bootstring_encode_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_bootstring_encode_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_bootstring_encode(INT32 args) {
#line 2974 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_string * s;
#line 2974 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("encode",args,1);
#line 2974 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("encode",1,"string");
#line 2974 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(s=Pike_sp[0-1].u.string);
{
    struct bootstring_struct *bs = THIS;
    INT_TYPE n = bs->initial_n;
    INT_TYPE delta = 0;
    INT_TYPE bias = bs->initial_bias;
    INT_TYPE c, h, b = 0;
    ptrdiff_t pos, input_left;
    PCHARP input;
    struct string_builder output;
    init_string_builder( &output,0 );
    input = MKPCHARP_STR( s );
    input_left = s->len;
    for (pos=0; pos<input_left; pos++)
      if ((c = INDEX_PCHARP( input, pos )) < n) {
	string_builder_putchar( &output, c );
	b++;
      }
    if ((h = b))
      string_builder_putchar( &output, bs->delim );
    while (h < input_left) {
      INT_TYPE m = -1;
      for (pos=0; pos<input_left; pos++)
	if ((c = INDEX_PCHARP( input, pos )) >= n &&
	    (m < 0 || c < m))
	  m = c;
      delta = delta + (m - n) * (h + 1); /* fail on overflow... */
      n = m;
      for (pos=0; pos<input_left; pos++)
	if ((c = INDEX_PCHARP( input, pos )) < n)
	  delta++;
	else if (c == n) {
	  INT_TYPE k, q = delta;
	  for (k=bs->base; ; k+=bs->base) {
	    INT_TYPE t, bt;
	    if (k <= bias + bs->tmin)
	      t = bs->tmin;
	    else if(k >= bias + bs->tmax)
	      t = bs->tmax;
	    else
	      t = k-bias;
	    if (q < t)
	      break;
	    bt = bs->base - t;
	    string_builder_putchar( &output,
				    index_shared_string( bs->digits,
							 t + (q-t)%bt ) );
	    q = (q-t) / bt;
	  }
	  string_builder_putchar( &output,
				  index_shared_string( bs->digits, q ) );
	  bias = bootstring_adapt( delta, h+1, h==b );
	  delta = 0;
	  h++;
	}
      delta++;
      n++;
    }

    do { struct pike_string * ret_=(finish_string_builder( &output )); pop_stack(); push_string(ret_); return; }while(0);
#line 3034 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

  }
/*! @decl void create(int base, int tmin, int tmax, int skew,		@
   *!                   int damp, int initial_bias, int initial_n,	@
   *!			int delim, string digits)
   *!
   *! Creates a Bootstring transcoder instance using the specified parameters.
   *!
   *! @param base
   *!   The base used by the variable-length integers.
   *! @param tmin
   *!   The minimum threshold digit value for the variable-length integers.
   *!   Must be >=0 and <= tmax.
   *! @param tmax
   *!   The maximum threshold digit value for the variable-length integers.
   *!   Must be <= base-1.
   *! @param skew
   *!   The skew term for the bias adapation.  Must be >= 1.
   *! @param damp
   *!   The damping factor for the bias adaption.  Must be >= 2.
   *! @param initial_bias
   *!   The initial bias for the variable-length integer thresholding.
   *!   initial_bias % base must be <= base - tmin.
   *! @param initial_n
   *!   The first code point outside the "basic" set of code points.
   *! @param delim
   *!   The "basic" code point used as the delimiter.
   *! @param digits
   *!   The "basic" code points used as digits.  The length of the string
   *!   should be the same as the base parameter.
   */
  #define f_bootstring_create_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_bootstring_create_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_bootstring_create(INT32 args) {
#line 3065 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
INT_TYPE base;
#line 3065 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
INT_TYPE tmin;
#line 3065 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
INT_TYPE tmax;
INT_TYPE skew;
#line 3066 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
INT_TYPE damp;
INT_TYPE initial_bias;
#line 3067 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
INT_TYPE initial_n;
INT_TYPE delim;
#line 3068 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_string * digits;
#line 3065 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 9) wrong_number_of_args_error("create",args,9);
#line 3065 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-9].type != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("create",1,"int");
#line 3065 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
base=Pike_sp[0-9].u.integer;
#line 3065 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[1-9].type != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("create",2,"int");
#line 3065 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
tmin=Pike_sp[1-9].u.integer;
#line 3065 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[2-9].type != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("create",3,"int");
#line 3065 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
tmax=Pike_sp[2-9].u.integer;
if(Pike_sp[3-9].type != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("create",4,"int");
#line 3066 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
skew=Pike_sp[3-9].u.integer;
#line 3066 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[4-9].type != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("create",5,"int");
#line 3066 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
damp=Pike_sp[4-9].u.integer;
if(Pike_sp[5-9].type != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("create",6,"int");
#line 3067 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
initial_bias=Pike_sp[5-9].u.integer;
#line 3067 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[6-9].type != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("create",7,"int");
#line 3067 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
initial_n=Pike_sp[6-9].u.integer;
if(Pike_sp[7-9].type != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("create",8,"int");
#line 3068 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
delim=Pike_sp[7-9].u.integer;
#line 3068 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[8-9].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("create",9,"string");
#line 3068 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(digits=Pike_sp[8-9].u.string);
#line 3070 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
    struct bootstring_struct *bs = THIS;
    if (base<2)
      Pike_error("Bogus base\n");
    if (tmin<0 || tmax<tmin || base-1<tmax)
      Pike_error("Parameters violate 0 <= tmin <= tmax <= base-1\n");
    if (skew < 1)
      Pike_error("Parameters violate skew >= 1\n");
    if (damp < 2)
      Pike_error("Parameters violate damp >= 2\n");
    if (initial_bias%base > base-tmin)
      Pike_error("Parameters violate initial_bias%%base <= base-tmin\n");
    if (digits->len != base)
      Pike_error("Length of digits string does not match base.\n");
    bs->base = base;  bs->tmin = tmin;  bs->tmax = tmax;
    bs->skew = skew;  bs->damp = damp;
    bs->initial_bias = initial_bias;  bs->initial_n = initial_n;
    bs->delim = delim;
    if (bs->digits) {
      free_string( bs->digits );
      bs->digits = NULL;
    }
    copy_shared_string( bs->digits, digits );
  }

}
/*! @endclass
 */

/*! @endmodule
 */

/*! @module System
 */

/*! @class Time
 *!
 *! The current time as a structure containing a sec and a usec
 *! member.
 */

#undef class_Time_defined
#define class_Time_defined
DEFAULT_CMOD_STORAGE struct program *Time_program=NULL;
static int Time_program_fun_num=-1;

#undef var_hard_update_Time_defined
#define var_hard_update_Time_defined

#undef THIS
#define THIS ((struct Time_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_TIME
#define THIS_TIME ((struct Time_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_TIME
#define OBJ2_TIME(o) ((struct Time_struct *)(o->storage+Time_storage_offset))

#undef GET_TIME_STORAGE
#define GET_TIME_STORAGE ((struct Time_struct *)(o->storage+Time_storage_offset)
static ptrdiff_t Time_storage_offset;
struct Time_struct {

#ifdef var_hard_update_Time_defined
#line 3113 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
int hard_update;
#endif /* var_hard_update_Time_defined */
};
#ifdef PIKE_DEBUG
/* Ensure the struct is used in a variable declaration, or else gdb might not see it. */
static struct Time_struct *Time_gdb_dummy_ptr;
#endif
/*! @decl int sec;
   *! @decl int usec;
   *!
   *!   The number of seconds and microseconds since the epoch and the
   *!   last whole second, respectively. (See also @[predef::time()])
   *!
   *!   Please note that these variables will continually update when
   *!   they are requested, there is no need to create new Time()
   *!   objects.
   */

  /*! @decl int usec_full;
   *!
   *!   The number of microseconds since the epoch. Please note that
   *!   pike has to have been compiled with bignum support for this
   *!   variable to contain sensible values.
   */

  #define f_Time_cq__backtick_2D_3E_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_Time_cq__backtick_2D_3E_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_Time_cq__backtick_2D_3E(INT32 args) {
#line 3133 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_string * x;
#line 3133 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("`->",args,1);
#line 3133 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("`->",1,"string");
#line 3133 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(x=Pike_sp[0-1].u.string);
{
    extern struct timeval current_time;
    struct pike_string *usec;
    struct pike_string *sec, *usec_full;

    MAKE_CONST_STRING( sec, "sec" );
    MAKE_CONST_STRING( usec, "usec" );
    MAKE_CONST_STRING (usec_full, "usec_full");

    if( !x ) {
      push_undefined();
      return;
    }

    if( THIS->hard_update )
      GETTIMEOFDAY( &current_time );

    if( x == usec )
      do { INT_TYPE ret_=(current_time.tv_usec); pop_stack(); push_int(ret_); return; }while(0);
#line 3153 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if( x == sec )
      do { INT_TYPE ret_=(current_time.tv_sec); pop_stack(); push_int(ret_); return; }while(0);
#line 3155 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if (x != usec_full) {
      push_undefined();
      return;
    }

#ifdef AUTO_BIGNUM
    pop_stack();
    push_int( current_time.tv_sec );
    push_int( 1000000 );
    f_multiply( 2 );
    push_int( current_time.tv_usec );
    f_add( 2 );
    return;
#else
    do { INT_TYPE ret_=((current_time.tv_sec * 1000000 + current_time.tv_usec)); pop_stack(); push_int(ret_); return; }while(0);
#line 3170 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
#endif
  }
  
  }
#define f_Time_cq__backtick_5B_5D_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_Time_cq__backtick_5B_5D_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_Time_cq__backtick_5B_5D(INT32 args) {
#line 3173 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_string * x;
#line 3173 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("`[]",args,1);
#line 3173 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("`[]",1,"string");
#line 3173 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(x=Pike_sp[0-1].u.string);
{
    f_Time_cq__backtick_2D_3E( args );
  }

  }
/*! @decl protected void create( int fast );
   *!
   *! If @[fast] is true, do not request a new time from the system,
   *! instead use the global current time variable.
   *!
   *! This will only work in callbacks, but can save significant amounts
   *! of CPU.
   */
  #define f_Time_create_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_Time_create_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_Time_create(INT32 args) {
#line 3186 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
INT_TYPE fast;
#line 3186 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args > 1) wrong_number_of_args_error("create",args,1);
#line 3186 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if (args > 0) {
#line 3186 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-args].type != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("create",1,"int|void");
#line 3186 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
fast=Pike_sp[0-args].u.integer;
#line 3186 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
} else fast = 0;
{
    THIS->hard_update = !fast;
  }
}
/*! @endclass
 */

/*! @class Timer
 */

#undef class_Timer_defined
#define class_Timer_defined
DEFAULT_CMOD_STORAGE struct program *Timer_program=NULL;
static int Timer_program_fun_num=-1;

#undef var_last_time_Timer_defined
#define var_last_time_Timer_defined

#undef var_hard_update_Timer_defined
#define var_hard_update_Timer_defined

#undef THIS
#define THIS ((struct Timer_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_TIMER
#define THIS_TIMER ((struct Timer_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_TIMER
#define OBJ2_TIMER(o) ((struct Timer_struct *)(o->storage+Timer_storage_offset))

#undef GET_TIMER_STORAGE
#define GET_TIMER_STORAGE ((struct Timer_struct *)(o->storage+Timer_storage_offset)
static ptrdiff_t Timer_storage_offset;
struct Timer_struct {

#ifdef var_last_time_Timer_defined
#line 3199 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct timeval last_time;
#endif /* var_last_time_Timer_defined */

#ifdef var_hard_update_Timer_defined
#line 3200 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
int hard_update;
#endif /* var_hard_update_Timer_defined */
};
#ifdef PIKE_DEBUG
/* Ensure the struct is used in a variable declaration, or else gdb might not see it. */
static struct Timer_struct *Timer_gdb_dummy_ptr;
#endif
/*! @decl float peek()
   *!   Return the time in seconds since the last time @[get] was called.
   */
  #define f_Timer_peek_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_Timer_peek_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_Timer_peek(INT32 args) {
#line 3205 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("peek",args,0);
{
    extern struct timeval current_time;
    FLOAT_TYPE res;
    if( THIS->hard_update )
      GETTIMEOFDAY( &current_time );
    res = current_time.tv_sec-THIS->last_time.tv_sec +
      (current_time.tv_usec-THIS->last_time.tv_usec)/(FLOAT_TYPE) 1000000.0;
    do { FLOAT_TYPE ret_=(res);  push_float(ret_); return; }while(0);
#line 3214 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

  }
/*! @decl float get()
   *!   Return the time in seconds since the last time get was called.
   *!   The first time this method is called the time since the object
   *!   was created is returned instead.
   */
  #define f_Timer_get_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_Timer_get_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_Timer_get(INT32 args) {
#line 3221 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("get",args,0);
{
    extern struct timeval current_time;
    f_Timer_peek( 0 );
    THIS->last_time = current_time;
    return;
  }

  }
/*! @decl protected void create( int|void fast )
   *!   Create a new timer object. The timer keeps track of relative time
   *!   with sub-second precision.
   *!   
   *!   If @[fast] is specified, the timer will not do system calls to get
   *!   the current time but instead use the one maintained by pike. This
   *!   will result in faster but more or less inexact timekeeping.
   *!   The pike maintained time is only updated when a @[Pike.Backend]
   *!   object stops waiting and starts executing code.
   */
  #define f_Timer_create_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_Timer_create_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_Timer_create(INT32 args) {
#line 3239 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
INT_TYPE fast;
#line 3239 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args > 1) wrong_number_of_args_error("create",args,1);
#line 3239 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if (args > 0) {
#line 3239 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-args].type != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("create",1,"int|void");
#line 3239 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
fast=Pike_sp[0-args].u.integer;
#line 3239 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
} else fast = 0;
{
    extern struct timeval current_time;
    THIS->hard_update = !fast;
    if( THIS->hard_update )
      GETTIMEOFDAY( &current_time );
    THIS->last_time = current_time; 
  }
}
/*! @endclass
 */

/*! @endmodule
 */



#undef class_automap_marker_defined
#define class_automap_marker_defined
DEFAULT_CMOD_STORAGE struct program *automap_marker_program=NULL;
static int automap_marker_program_fun_num=-1;

#undef var_arg_automap_marker_defined
#define var_arg_automap_marker_defined

#undef var_depth_automap_marker_defined
#define var_depth_automap_marker_defined

#undef THIS
#define THIS ((struct automap_marker_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_AUTOMAP_MARKER
#define THIS_AUTOMAP_MARKER ((struct automap_marker_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_AUTOMAP_MARKER
#define OBJ2_AUTOMAP_MARKER(o) ((struct automap_marker_struct *)(o->storage+automap_marker_storage_offset))

#undef GET_AUTOMAP_MARKER_STORAGE
#define GET_AUTOMAP_MARKER_STORAGE ((struct automap_marker_struct *)(o->storage+automap_marker_storage_offset)
static ptrdiff_t automap_marker_storage_offset;
struct automap_marker_struct {

#ifdef var_arg_automap_marker_defined
  struct array * arg;

#endif /* var_arg_automap_marker_defined */

#ifdef var_depth_automap_marker_defined
  INT_TYPE depth;

#endif /* var_depth_automap_marker_defined */
};
#ifdef PIKE_DEBUG
/* Ensure the struct is used in a variable declaration, or else gdb might not see it. */
static struct automap_marker_struct *automap_marker_gdb_dummy_ptr;
#endif
#define f_automap_marker_create_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_automap_marker_create_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_automap_marker_create(INT32 args) {
#line 3261 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct array * a;
#line 3261 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
INT_TYPE d;
#line 3261 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 2) wrong_number_of_args_error("create",args,2);
#line 3261 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-2].type != PIKE_T_ARRAY) SIMPLE_ARG_TYPE_ERROR("create",1,"array");
#line 3261 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(a=Pike_sp[0-2].u.array);
#line 3261 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[1-2].type != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("create",2,"int");
#line 3261 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
d=Pike_sp[1-2].u.integer;
{
      if(THIS->arg) free_array(THIS->arg);
      add_ref(THIS->arg=a);
      THIS->depth=d;
    }

  }
#define f_automap_marker_cq__sprintf_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_automap_marker_cq__sprintf_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_automap_marker_cq__sprintf(INT32 args) {
#line 3268 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
INT_TYPE mode;
#line 3268 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct mapping * flags;
#line 3268 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 2) wrong_number_of_args_error("_sprintf",args,2);
#line 3268 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-2].type != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("_sprintf",1,"int");
#line 3268 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
mode=Pike_sp[0-2].u.integer;
#line 3268 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[1-2].type != PIKE_T_MAPPING) SIMPLE_ARG_TYPE_ERROR("_sprintf",2,"mapping(mixed:mixed)");
#line 3268 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(flags=Pike_sp[1-2].u.mapping);
{
      pop_n_elems(args);
      if (mode != 'O') {
	push_undefined ();
	return;
      }
      push_text("%O%*'[*]'n");
      if(THIS->arg)
	ref_push_array(THIS->arg);
      else
	push_int(0);
      push_int(THIS->depth*3);
      f_sprintf(3);
    }
}
#line 3286 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
static void low_automap(int d,
			int depth,
			struct svalue *fun,
			struct svalue *real_args,
			INT32 args)
{
  INT32 x,e,tmp,size=0x7fffffff;
  struct svalue *tmpargs=Pike_sp - args;
  struct array *ret;
  TYPE_FIELD types;

  for(e=0;e<args;e++)
  {
    if(real_args[e].type==T_OBJECT &&
       real_args[e].u.object->prog == automap_marker_program &&
       OBJ2_AUTOMAP_MARKER(real_args[e].u.object)->depth >= d)
    {
      if(tmpargs[e].type != T_ARRAY)
	index_error("__automap__",
		    Pike_sp-args,
		    args,
		    tmpargs,
		    NULL,
		    "Automap on non-array.\n");
      tmp=tmpargs[e].u.array->size;
      if(tmp < size)
	size=tmp;
    }
  }

#ifdef PIKE_DEBUG
   if(size == 0x7fffffff)
    Pike_fatal("No automap markers found in low_automap\n");
#endif

  push_array(ret=allocate_array(size));
  types = 0;

  for(x=0;x<size;x++)
  {
    for(e=0;e<args;e++)
    {
      if(real_args[e].type==T_OBJECT &&
	 real_args[e].u.object->prog == automap_marker_program &&
	 OBJ2_AUTOMAP_MARKER(real_args[e].u.object)->depth >= d)
      {
#ifdef PIKE_DEBUG
	if(x >= tmpargs[e].u.array->size)
	  Pike_fatal("low_automap failed to determine size!\n");
#endif
	push_svalue(ITEM(tmpargs[e].u.array)+x);
      }else{
	push_svalue(tmpargs+e);
      }
    }
    
    if(d == depth)
      apply_svalue(fun,args);
    else
      low_automap(d+1,depth,fun,real_args,args);
    stack_pop_to_no_free (ITEM(ret) + x);
    types |= 1 << ITEM(ret)[x].type;
  }
  ret->type_field = types;
  stack_unlink(args);
}


#define f_cq___automap___defined
DEFAULT_CMOD_STORAGE void f_cq___automap__(INT32 args) {
#line 3354 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * fun;
#line 3354 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * tmpargs;
#line 3354 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args < 1) wrong_number_of_args_error("__automap__",args,1);
#line 3354 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
fun=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
#line 3354 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if (args > 1) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+1+argcnt-args);
#line 3354 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  } while (++argcnt < args-1);
  tmpargs=Pike_sp+1-args;
} else tmpargs=0;
#line 3356 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
  int e,depth=-1;
  check_stack(args);

  for(e=0;e<args-1;e++)
  {
    if(tmpargs[e].type==T_OBJECT &&
       tmpargs[e].u.object->prog == automap_marker_program)
    {
      int tmp=OBJ2_AUTOMAP_MARKER(tmpargs[e].u.object)->depth;
      if(tmp > depth) depth=tmp;
      ref_push_array(OBJ2_AUTOMAP_MARKER(tmpargs[e].u.object)->arg);
    }else{
      push_svalue(tmpargs+e);
    }
  }
  check_stack(depth * (args+1));
  low_automap(1,depth,fun,tmpargs,args-1);
  stack_unlink(args);
}

}
#line 3377 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
/* Linked list stuff.
 */
#undef INIT_BLOCK
#define INIT_BLOCK(NODE) do {				\
    (NODE)->next = (NODE)->prev = NULL;			\
    (NODE)->refs = 1;					\
    (NODE)->val.type = T_INT;				\
    (NODE)->val.subtype = NUMBER_UNDEFINED;		\
    (NODE)->val.u.integer = 0;				\
  } while(0) 

#undef EXIT_BLOCK
#define EXIT_BLOCK(NODE) do {				\
    if ((NODE)->prev) {					\
      free_list_node((NODE)->prev);			\
    }							\
    if ((NODE)->next) {					\
      free_list_node((NODE)->next);			\
    }							\
    free_svalue(&(NODE)->val);				\
  } while(0)

BLOCK_ALLOC_FILL_PAGES(pike_list_node, 4);

PMOD_EXPORT void free_list_node(struct pike_list_node *node)
{
  if (!sub_ref(node)) {
    really_free_pike_list_node(node);
  }
}

PMOD_EXPORT void unlink_list_node(struct pike_list_node *n)
{
#ifdef PIKE_DEBUG
  if (!n) {
    Pike_fatal("Unlinking NULL node.\n");
  }
  if (!n->next || !n->prev) {
    Pike_fatal("Unlinking unlinked node.\n");
  }
#endif /* PIKE_DEBUG */
  if (n->prev->next == n) {
#ifdef PIKE_DEBUG
    if (n->next->prev != n) {
      Pike_fatal("Partially detached node.\n");
    }
#endif /* PIKE_DEBUG */
    n->prev->next = n->next;
    n->next->prev = n->prev;
    n->next = n->prev = NULL;

    /* We've lost two references. */
    free_list_node(n);
    free_list_node(n);
  } else {
#ifdef PIKE_DEBUG
    if (n->next->prev == n) {
      Pike_fatal("Partially detached node.\n");
    }
#endif /* PIKE_DEBUG */
    /* The node is already detached. */
    n->next = n->prev = NULL;
  }
}

PMOD_EXPORT void detach_list_node(struct pike_list_node *n)
{
#ifdef PIKE_DEBUG
  if (!n) {
    Pike_fatal("Detaching NULL node.\n");
  }
  if (!n->next || !n->prev) {
    Pike_fatal("Detaching unlinked node.\n");
  }
#endif /* PIKE_DEBUG */
  if (n->prev->next == n) {
#ifdef PIKE_DEBUG
    if (n->next->prev != n) {
      Pike_fatal("Partially detached node.\n");
    }
#endif /* PIKE_DEBUG */
    n->prev->next = n->next;
    n->next->prev = n->prev;
    add_ref(n->next);
    add_ref(n->prev);

    /* We've lost two references. */
    free_list_node(n);
    free_list_node(n);
#ifdef PIKE_DEBUG
  } else if (n->next->prev == n) {
    Pike_fatal("Partially detached node.\n");
#endif /* PIKE_DEBUG */
  }
}

PMOD_EXPORT void prepend_list_node(struct pike_list_node *node,
				   struct pike_list_node *new_node)
{
#ifdef PIKE_DEBUG
  if (!node) {
    Pike_fatal("No node to prepend.\n");
  }
  if (!node->prev) {
    Pike_fatal("Prepending unhooked node.\n");
  }
  if (!new_node) {
    Pike_fatal("Prepending NULL node.\n");
  }
  if (new_node->next || new_node->prev) {
    Pike_fatal("Prepending hooked node.\n");
  }
#endif /* PIKE_DEBUG */
  new_node->next = node;
  new_node->prev = node->prev;
  new_node->prev->next = node->prev = new_node;
  add_ref(new_node);
  add_ref(new_node);
}

PMOD_EXPORT void append_list_node(struct pike_list_node *node,
				  struct pike_list_node *new_node)
{
#ifdef PIKE_DEBUG
  if (!node) {
    Pike_fatal("No node to append.\n");
  }
  if (!node->next) {
    Pike_fatal("Appending unhooked node.\n");
  }
  if (!new_node) {
    Pike_fatal("Appending NULL node.\n");
  }
  if (new_node->next || new_node->prev) {
    Pike_fatal("Appending hooked node.\n");
  }
#endif /* PIKE_DEBUG */
  new_node->next = node->next;
  new_node->prev = node;
  new_node->next->prev = node->next = new_node;
  add_ref(new_node);
  add_ref(new_node);
}

/*! @module Sql
 */

/*! @class Null
 *!
 *! This class is used to implement the SQL NULL value.
 *!
 *! @note
 *!   There's typically only one object of this class: @[Sql.NULL],
 *!   but some databases (eg Oracle) have multiple types of NULL,
 *!   in which case they all inherit this class.
 *!
 *! @deprecated Val.Null
 *!
 *! @seealso
 *!   @[Val.Null], @[Val.null], @[Sql.NULL]
 */

#undef class_SqlNull_defined
#define class_SqlNull_defined
DEFAULT_CMOD_STORAGE struct program *SqlNull_program=NULL;
static int SqlNull_program_fun_num=-1;

#undef extra_SqlNull_defined
#define extra_SqlNull_defined
#define f_SqlNull_cq__backtick_21_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_SqlNull_cq__backtick_21_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_SqlNull_cq__backtick_21(INT32 args) {
#line 3548 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("`!",args,0);
#line 3550 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
    do { INT_TYPE ret_=(1);  push_int(ret_); return; }while(0);
#line 3552 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

  }
#define f_SqlNull_cq__sprintf_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_SqlNull_cq__sprintf_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_SqlNull_cq__sprintf(INT32 args) {
#line 3554 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
INT_TYPE fmt;
#line 3554 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * extras;
#line 3554 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args < 1) wrong_number_of_args_error("_sprintf",args,1);
#line 3554 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-args].type != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("_sprintf",1,"int");
#line 3554 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
fmt=Pike_sp[0-args].u.integer;
#line 3554 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if (args > 1) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+1+argcnt-args);
#line 3554 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  } while (++argcnt < args-1);
  extras=Pike_sp+1-args;
} else extras=0;
#line 3556 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
    pop_n_elems(args);
    if (fmt == 'O') {
      push_constant_text("Sql.NULL");
    } else {
      push_undefined();
    }
  }

  }
#define f_SqlNull_cq___hash_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_SqlNull_cq___hash_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_SqlNull_cq___hash(INT32 args) {
#line 3565 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("__hash",args,0);
#line 3567 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
    pop_n_elems(args);
    push_int(17);
  }
    
  }
#define f_SqlNull_cq__backtick_eq_eq_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_SqlNull_cq__backtick_eq_eq_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_SqlNull_cq__backtick_eq_eq(INT32 args) {
#line 3572 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * other;
#line 3572 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("`==",args,1);
#line 3572 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
other=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 3574 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
    if (other->type != T_OBJECT) {
      pop_stack();
      push_int(0);
      return;
    }

    /* Look for the is_val_null constant directly in the program of
     * other, without going through its `[]. When this is called in a
     * codec, other can be a completely arbitrary object which may not
     * have a `[] that works in that context. */
    push_int (0);
    ref_push_program (other->u.object->prog);
    push_constant_text("is_sql_null");
    if (program_index_no_free (Pike_sp - 3, Pike_sp - 2, Pike_sp - 1) &&
	Pike_sp[-3].type == T_INT && Pike_sp[-3].u.integer) {
      pop_n_elems (4);
      push_int (1);
    }
    else {
      pop_n_elems (4);
      push_int (0);
    }
  }

  }
/*! @decl string encode_json()
   *!
   *! Defined for use with @[Standards.JSON.encode], so that it
   *! formats NULL as @expr{null@}.
   */
  #define f_SqlNull_encode_json_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_SqlNull_encode_json_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_SqlNull_encode_json(INT32 args) {
#line 3605 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
    push_constant_text ("null");
  }
}
/*! @endclass
 */

/*! @endmodule
 */

/*! @module ADT
 */

/*! @class List
 *!
 *!   Linked list of values.
 */

#undef class_List_defined
#define class_List_defined
DEFAULT_CMOD_STORAGE struct program *List_program=NULL;
static int List_program_fun_num=-1;

#undef var_head_List_defined
#define var_head_List_defined

#undef var_head_sentinel_refs_List_defined
#define var_head_sentinel_refs_List_defined

#undef var_tail_List_defined
#define var_tail_List_defined
#line 3627 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
/* Always NULL. */
  
#undef var_tail_sentinel_refs_List_defined
#define var_tail_sentinel_refs_List_defined

#undef var_tail_pred_List_defined
#define var_tail_pred_List_defined

#undef var_num_elems_List_defined
#define var_num_elems_List_defined

#undef THIS
#define THIS ((struct List_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_LIST
#define THIS_LIST ((struct List_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_LIST
#define OBJ2_LIST(o) ((struct List_struct *)(o->storage+List_storage_offset))

#undef GET_LIST_STORAGE
#define GET_LIST_STORAGE ((struct List_struct *)(o->storage+List_storage_offset)
static ptrdiff_t List_storage_offset;
struct List_struct {

#ifdef var_head_List_defined
#line 3625 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_list_node *head;
#endif /* var_head_List_defined */

#ifdef var_head_sentinel_refs_List_defined
#line 3626 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
INT32 head_sentinel_refs;
#endif /* var_head_sentinel_refs_List_defined */

#ifdef var_tail_List_defined
#line 3627 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_list_node *tail;
#endif /* var_tail_List_defined */

#ifdef var_tail_sentinel_refs_List_defined
#line 3628 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
INT32 tail_sentinel_refs;
#endif /* var_tail_sentinel_refs_List_defined */

#ifdef var_tail_pred_List_defined
#line 3629 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_list_node *tail_pred;
#endif /* var_tail_pred_List_defined */

#ifdef var_num_elems_List_defined
#line 3630 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
INT32 num_elems;
#endif /* var_num_elems_List_defined */
};
#ifdef PIKE_DEBUG
/* Ensure the struct is used in a variable declaration, or else gdb might not see it. */
static struct List_struct *List_gdb_dummy_ptr;
#endif
#line 3632 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
#define HEAD_SENTINEL(this)	((struct pike_list_node *)(&this->head))
#define TAIL_SENTINEL(this)	((struct pike_list_node *)(&this->tail))

  /* Sentinel overlap description:
   *
   * List			Head sentinel		Tail sentinel
   *   head			  next
   *   head_sentinel_refs	  refs
   *   tail			  prev			  next
   *   tail_sentinel_refs				  refs
   *   tail_pred					  prev
   */

  /* Suggestions for future functionality:
   *
   *   o Pop tail
   *   o Join
   *   o Copy segment
   *   o Detach segment (requires new iterator implementation)
   *   o Iterator copy
   *   o _equal() for iterators and lists.
   *   o _values(), _search(), cast()
   *   o _sizeof()?, _indices()??
   *   o Support for reverse(), filter() and map().
   *   o Initialization from array.
   *   o Support for Pike.count_memory.
   */

  
#undef internal_init_List_defined
#define internal_init_List_defined

#undef List_event_handler_defined
#define List_event_handler_defined
static void init_List_struct(void)
#line 3661 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
    THIS->tail = NULL;
    THIS->head = TAIL_SENTINEL(THIS);
    THIS->tail_pred = HEAD_SENTINEL(THIS);
    THIS->head_sentinel_refs = THIS->tail_sentinel_refs = 2;
    THIS->num_elems = 0;
  }

  
#undef internal_exit_List_defined
#define internal_exit_List_defined

#undef List_event_handler_defined
#define List_event_handler_defined
static void exit_List_struct(void)
#line 3671 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
    struct pike_list_node *node = THIS->head;
    struct pike_list_node *next;
    while ((next = node->next)) {
#ifdef PIKE_DEBUG
      if (node->refs != 2) {
	Pike_fatal("Unexpected number of references for node: %d\n",
		   node->refs);
      }
#endif /* PIKE_DEBUG */
      unlink_list_node(node);
      node = next;
    }
  }

  /* These two functions perform the same thing,
   * but are optimized to minimize recursion.
   */
  static void gc_check_list_node_backward(struct pike_list_node *node,
					  const char *msg);
  static void gc_check_list_node_forward(struct pike_list_node *node,
					 const char *msg)
  {
    while (node && !debug_gc_check(&node->refs, msg)) {
      if (node->next)
	debug_gc_check_svalues(&node->val, 1,  " as a list node value");
      gc_check_list_node_backward(node->prev, msg);
      node = node->next;
    }
  }

  static void gc_check_list_node_backward(struct pike_list_node *node,
					  const char *msg)
  {
    while (node && !debug_gc_check(&node->refs, msg)) {
      if (node->prev)
	debug_gc_check_svalues(&node->val, 1, " as a list node value");
      gc_check_list_node_forward(node->next, msg);
      node = node->prev;
    }
  }

  /* Called at gc_check time. */
  
#undef internal_gc_check_List_defined
#define internal_gc_check_List_defined

#undef List_event_handler_defined
#define List_event_handler_defined
static void gc_check_List_struct(void)
#line 3715 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
    gc_check_list_node_backward(HEAD_SENTINEL(THIS), " as a list node");
    gc_check_list_node_forward(TAIL_SENTINEL(THIS), " as a list node");
  }

  /* Called at gc_mark time */
  
#undef internal_gc_recurse_List_defined
#define internal_gc_recurse_List_defined

#undef List_event_handler_defined
#define List_event_handler_defined
static void gc_recurse_List_struct(void)
#line 3722 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
    struct pike_list_node *node = THIS->head;
    struct pike_list_node *next;
    while ((next = node->next)) {
      gc_recurse_svalues(&node->val, 1);
      node = next;
    }
    /* FIXME: mc_count_bytes */
  }

  /*! @decl int(0..1) is_empty()
   *!
   *!   Check if the list is empty.
   *!
   *! @returns
   *!   Returns @expr{1@} if the list is empty,
   *!   and @expr{0@} (zero) if there are elements in the list.
   */
  #define f_List_is_empty_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_List_is_empty_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_List_is_empty(INT32 args) {
#line 3740 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("is_empty",args,0);
{
    push_int(!THIS->head->next);
  }

  }
/*! @decl int(0..) _sizeof()
   *!
   *!   Returns the number of elements in the list.
   */
  #define f_List_cq__sizeof_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_List_cq__sizeof_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_List_cq__sizeof(INT32 args) {
#line 3749 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("_sizeof",args,0);
#line 3751 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
    push_int(THIS->num_elems);
  }

  }
/*! @decl string _sprintf(int c, mapping(string:mixed)|void attr)
   *!
   *!   Describe the list.
   *!
   *! @seealso
   *!   @[sprintf()], @[lfun::_sprintf()]
   */
  #define f_List_cq__sprintf_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_List_cq__sprintf_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_List_cq__sprintf(INT32 args) {
#line 3762 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
INT_TYPE c;
#line 3762 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct mapping * attr;
#line 3762 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args < 1) wrong_number_of_args_error("_sprintf",args,1);
#line 3762 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args > 2) wrong_number_of_args_error("_sprintf",args,2);
#line 3762 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-args].type != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("_sprintf",1,"int");
#line 3762 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
c=Pike_sp[0-args].u.integer;
#line 3762 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if (args > 1 &&    (Pike_sp[1-args].type != PIKE_T_INT ||     Pike_sp[1-args].u.integer)) {
#line 3762 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[1-args].type != PIKE_T_MAPPING) SIMPLE_ARG_TYPE_ERROR("_sprintf",2,"mapping(string:mixed)|void");
#line 3762 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(attr=Pike_sp[1-args].u.mapping);
#line 3762 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
} else attr = NULL;
#line 3764 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
    if (!THIS->num_elems) {
      push_constant_text("ADT.List(/* empty */)");
    } else if (c == 'O') {
      struct pike_list_node *node = THIS->head;
      if (THIS->num_elems == 1) {
	push_constant_text("ADT.List(/* 1 element */\n");
      } else {
	push_constant_text("ADT.List(/* %d elements */\n");
	push_int(THIS->num_elems);
	f_sprintf(2);
      }
      while (node->next) {
	if (node->next->next) {
	  push_constant_text("    %O,\n");
	} else {
	  push_constant_text("    %O\n");
	}
	push_svalue(&node->val);
	f_sprintf(2);
	node = node->next;
      }
      push_constant_text(")");
      f_add(THIS->num_elems + 2);
    } else {
      if (THIS->num_elems == 1) {
	push_constant_text("ADT.List(/* 1 element */)");
      } else {
	push_constant_text("ADT.List(/* %d elements */)");
	push_int(THIS->num_elems);
	f_sprintf(2);
      }
    }
    stack_pop_n_elems_keep_top(args);
  }

  }
/*! @decl mixed head()
   *!
   *!   Get the element at the head of the list.
   *!
   *! @throws
   *!   Throws an error if the list is empty.
   *!
   *! @seealso
   *!   @[is_empty()], @[tail()], @[pop()]
   */
  #define f_List_head_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_List_head_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_List_head(INT32 args) {
#line 3810 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("head",args,0);
{
    if (THIS->head->next) {
      push_svalue(&THIS->head->val);
    } else {
      Pike_error("Empty list.\n");
    }
  }

  }
/*! @decl mixed tail()
   *!
   *!   Get the element at the tail of the list.
   *!
   *! @throws
   *!   Throws an error if the list is empty.
   *!
   *! @seealso
   *!   @[is_empty()], @[head()], @[pop()]
   */
  #define f_List_tail_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_List_tail_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_List_tail(INT32 args) {
#line 3829 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("tail",args,0);
{
    if (THIS->tail->prev) {
      push_svalue(&THIS->tail->val);
    } else {
      Pike_error("Empty list.\n");
    }
  }

  }
/*! @decl mixed pop()
   *!
   *!   Pop the element at the head of the list from the list.
   *!
   *! @throws
   *!   Throws an error if the list is empty.
   *!
   *! @seealso
   *!   @[is_empty()], @[head()], @[tail()]
   */
  #define f_List_pop_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_List_pop_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_List_pop(INT32 args) {
#line 3848 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("pop",args,0);
{
    if (THIS->head->next) {
      push_svalue(&THIS->head->val);
      if (THIS->head->refs == 2) {
	unlink_list_node(THIS->head);
      } else {
	detach_list_node(THIS->head);
      }
      THIS->num_elems--;
    } else {
      Pike_error("Empty list.\n");
    }
  }

  }
/*! @decl void append(mixed ... values)
   *!
   *!   Append @[values] to the end of the list.
   *!
   *! @seealso
   *!   @[insert()]
   */
  #define f_List_append_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_List_append_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_List_append(INT32 args) {
#line 3870 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * values;
#line 3870 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 3870 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  } while (++argcnt < args-0);
  values=Pike_sp+0-args;
} else values=0;
#line 3871 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
    struct pike_list_node *node = TAIL_SENTINEL(THIS);
    while (args--) {
      struct pike_list_node *new_node = alloc_pike_list_node();
      new_node->val = *(--Pike_sp);
      prepend_list_node(node, new_node);
      free_list_node(node = new_node);
      THIS->num_elems++;
    }
    push_int(0);
  }

  }
/*! @decl void insert(mixed ... values)
   *!
   *!   Insert @[values] at the front of the list.
   *!
   *! @seealso
   *!   @[append()]
   */
  #define f_List_insert_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_List_insert_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_List_insert(INT32 args) {
#line 3890 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * values;
#line 3890 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 3890 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  } while (++argcnt < args-0);
  values=Pike_sp+0-args;
} else values=0;
#line 3891 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
    struct pike_list_node *node = THIS->head;
    while (args--) {
      struct pike_list_node *new_node = alloc_pike_list_node();
      new_node->val = *(--Pike_sp);
      prepend_list_node(node, new_node);
      free_list_node(node = new_node);
      THIS->num_elems++;
    }
    push_int(0);
  }

  }
/*! @decl void create(mixed ... values)
   *!
   *!   Create a new @[List], and initialize it with @[values].
   *!
   *! @fixme
   *!   Ought to reset the @[List] if called multiple times.
   */
  #define f_List_create_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_List_create_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_List_create(INT32 args) {
#line 3910 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * values;
#line 3910 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 3910 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  } while (++argcnt < args-0);
  values=Pike_sp+0-args;
} else values=0;
#line 3912 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
    /* FIXME: Reset the list? */
    apply_current(f_List_append_fun_num, args);
  }

  }
/*! @class _get_iterator
   *!
   *!   @[Iterator] that loops over the @[List].
   */
  
#undef class_List_cq__get_iterator_defined
#define class_List_cq__get_iterator_defined
DEFAULT_CMOD_STORAGE struct program *List_cq__get_iterator_program=NULL;
static int List_cq__get_iterator_program_fun_num=-1;

#undef var_cur_List_cq__get_iterator_defined
#define var_cur_List_cq__get_iterator_defined

#undef var_ind_List_cq__get_iterator_defined
#define var_ind_List_cq__get_iterator_defined

#undef THIS
#define THIS ((struct List_cq__get_iterator_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_LIST_CQ__GET_ITERATOR
#define THIS_LIST_CQ__GET_ITERATOR ((struct List_cq__get_iterator_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_LIST_CQ__GET_ITERATOR
#define OBJ2_LIST_CQ__GET_ITERATOR(o) ((struct List_cq__get_iterator_struct *)(o->storage+List_cq__get_iterator_storage_offset))

#undef GET_LIST_CQ__GET_ITERATOR_STORAGE
#define GET_LIST_CQ__GET_ITERATOR_STORAGE ((struct List_cq__get_iterator_struct *)(o->storage+List_cq__get_iterator_storage_offset)
static ptrdiff_t List_cq__get_iterator_storage_offset;
struct List_cq__get_iterator_struct {

#ifdef var_cur_List_cq__get_iterator_defined
#line 3925 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct pike_list_node *cur;
#endif /* var_cur_List_cq__get_iterator_defined */

#ifdef var_ind_List_cq__get_iterator_defined
#line 3926 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
INT32 ind;
#endif /* var_ind_List_cq__get_iterator_defined */
};
#ifdef PIKE_DEBUG
/* Ensure the struct is used in a variable declaration, or else gdb might not see it. */
static struct List_cq__get_iterator_struct *List_cq__get_iterator_gdb_dummy_ptr;
#endif
#line 3926 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
/* Not meaningful, but requred by the API. */

    /* NOTE: cur may never refer to an unlinked node.
     *       cur may however refer to a detached node, or to sentinels.
     */

    static struct List_struct *List__get_iterator_find_parent()
    {
      struct external_variable_context loc;

      loc.o = Pike_fp->current_object;
      loc.parent_identifier = Pike_fp->fun;
      loc.inherit = INHERIT_FROM_INT(loc.o->prog, loc.parent_identifier);
      find_external_context(&loc, 1);
      return (struct List_struct *)(loc.o->storage +
				    loc.inherit->storage_offset);
    }

    
#undef internal_init_List_cq__get_iterator_defined
#define internal_init_List_cq__get_iterator_defined

#undef List_cq__get_iterator_event_handler_defined
#define List_cq__get_iterator_event_handler_defined
static void init_List_cq__get_iterator_struct(void)
#line 3945 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
      add_ref(THIS->cur = List__get_iterator_find_parent()->head);
      THIS->ind = 0;
    }

    
#undef internal_exit_List_cq__get_iterator_defined
#define internal_exit_List_cq__get_iterator_defined

#undef List_cq__get_iterator_event_handler_defined
#define List_cq__get_iterator_event_handler_defined
static void exit_List_cq__get_iterator_struct(void)
#line 3952 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
      if (THIS->cur) {
	free_list_node(THIS->cur);
	THIS->cur = NULL;
      }
    }

    /* Called at gc_check time. */
    
#undef internal_gc_check_List_cq__get_iterator_defined
#define internal_gc_check_List_cq__get_iterator_defined

#undef List_cq__get_iterator_event_handler_defined
#define List_cq__get_iterator_event_handler_defined
static void gc_check_List_cq__get_iterator_struct(void)
#line 3961 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
      gc_check_list_node_forward(THIS->cur, " held by an iterator");
    }  

    /* These two functions perform the same thing,
     * but are optimized to minimize recursion.
     */
    static void gc_recurse_list_node_tree_backward(struct pike_list_node *node,
						   struct pike_list_node *back);
    static void gc_recurse_list_node_tree_forward(struct pike_list_node *node,
						  struct pike_list_node *back)
    {
      if (!node || !node->next) return;
      if (node->next->prev == node) {
	/* List member. Recursed from the list recurse code. */
#ifdef PIKE_DEBUG
	if (node->prev->next != node) {
	  Pike_fatal("Partially detached node.\n");
	}
#endif /* PIKE_DEBUG */
	return;
      }
#ifdef PIKE_DEBUG
      if (node->prev->next == node) {
	Pike_fatal("Partially detached node.\n");
      }
#endif /* PIKE_DEBUG */
      while (1) {
	gc_recurse_svalues(&node->val, 1);
	if (node->prev != back)
	  gc_recurse_list_node_tree_backward(node->prev, node->next);
	back = node->prev;
	node = node->next;
	if (!node->next || (node->next->prev == node)) {
	  /* List member. Recursed from the list recurse code. */
#ifdef PIKE_DEBUG
	  if (node->prev->next != node) {
	    Pike_fatal("Partially detached node.\n");
	  }
#endif /* PIKE_DEBUG */
	  break;
	}
#ifdef PIKE_DEBUG
	if (node->prev->next == node) {
	  Pike_fatal("Partially detached node.\n");
	}
#endif /* PIKE_DEBUG */
      }
    }

    static void gc_recurse_list_node_tree_backward(struct pike_list_node *node,
						   struct pike_list_node *next)
    {
      if (!node || !node->prev) return;
      if (node->prev->next == node) {
	/* List member. Checked from the list check code. */
#ifdef PIKE_DEBUG
	if (node->next->prev != node) {
	  Pike_fatal("Partially detached node.\n");
	}
#endif /* PIKE_DEBUG */
	return;
      }
#ifdef PIKE_DEBUG
      if (node->next->prev == node) {
	Pike_fatal("Partially detached node.\n");
      }
#endif /* PIKE_DEBUG */
      while (1) {
	gc_recurse_svalues(&node->val, 1);
	if (node->next != next)
	  gc_recurse_list_node_tree_forward(node->next, node->prev);
	next = node->next;
	node = node->prev;
	if (!node->prev || (node->prev->next == node)) {
	  /* List member. Recursed from the list recurse code. */
#ifdef PIKE_DEBUG
	  if (node->next->prev != node) {
	    Pike_fatal("Partially detached node.\n");
	  }
#endif /* PIKE_DEBUG */
	  break;
	}
#ifdef PIKE_DEBUG
	if (node->next->prev == node) {
	  Pike_fatal("Partially detached node.\n");
	}
#endif /* PIKE_DEBUG */
      }
    }

    /* Called at gc_mark time */
    
#undef internal_gc_recurse_List_cq__get_iterator_defined
#define internal_gc_recurse_List_cq__get_iterator_defined

#undef List_cq__get_iterator_event_handler_defined
#define List_cq__get_iterator_event_handler_defined
static void gc_recurse_List_cq__get_iterator_struct(void)
#line 4054 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
      if (!THIS->cur->next || !THIS->cur->prev) return;
      if (THIS->cur->next->prev == THIS->cur) {
#ifdef PIKE_DEBUG
	if (THIS->cur->prev->next != THIS->cur) {
	  Pike_fatal("Partially detached node.\n");
	}
#endif /* PIKE_DEBUG */
	return;
      }
#ifdef PIKE_DEBUG
      if (THIS->cur->prev->next == THIS->cur) {
	Pike_fatal("Partially detached node.\n");
      }
#endif /* PIKE_DEBUG */
      /* Detached node. */
      gc_recurse_svalues(&THIS->cur->val, 1);
      gc_recurse_list_node_tree_forward(THIS->cur->next, THIS->cur->prev);
      gc_recurse_list_node_tree_backward(THIS->cur->next, THIS->cur->prev);
    }

    #define f_List_cq__get_iterator_cq__backtick_21_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_List_cq__get_iterator_cq__backtick_21_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_List_cq__get_iterator_cq__backtick_21(INT32 args) {
#line 4075 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("`!",args,0);
#line 4077 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
      pop_n_elems(args);
      push_int(!THIS->cur->next || !THIS->cur->prev);
    }

    }
#define f_List_cq__get_iterator_index_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_List_cq__get_iterator_index_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_List_cq__get_iterator_index(INT32 args) {
#line 4082 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("index",args,0);
{
      pop_n_elems(args);
      if (THIS->cur->next && THIS->cur->prev) {
	push_int(THIS->ind);
      } else {
	push_undefined();
      }
    }

    }
/*! @decl mixed value()
     *!
     *! @returns
     *!   Returns the value at the current position.
     */
    #define f_List_cq__get_iterator_value_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_List_cq__get_iterator_value_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_List_cq__get_iterator_value(INT32 args) {
#line 4097 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("value",args,0);
{
      pop_n_elems(args);
      if (THIS->cur->next && THIS->cur->prev) {
	push_svalue(&THIS->cur->val);
      } else {
	push_undefined();
      }
    }

    }
/*! @decl int(0..1) first()
     *!
     *!   Reset the iterator to point to the first element in
     *!   the list.
     *!
     *! @returns
     *!   Returns @expr{1@} if there are elements in the list,
     *!   and @expr{0@} (zero) if the list is empty.
     */
    #define f_List_cq__get_iterator_first_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_List_cq__get_iterator_first_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_List_cq__get_iterator_first(INT32 args) {
#line 4116 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("first",args,0);
{
      struct external_variable_context loc;
      struct List_struct *parent;
      pop_n_elems(args);

      /* Find our parent. */
      loc.o = Pike_fp->current_object;
      loc.parent_identifier = Pike_fp->fun;
      loc.inherit = INHERIT_FROM_INT(loc.o->prog, loc.parent_identifier);
      find_external_context(&loc, 1);
      parent = (struct List_struct *)(loc.o->storage +
				      loc.inherit->storage_offset);
      free_list_node(THIS->cur);
      add_ref(THIS->cur = parent->head);
      THIS->ind = 0;
      pop_n_elems(args);
      if (THIS->cur->next) {
	push_int(1);
      } else {
	push_undefined();
      }
    }

    }
/*! @decl int(0..1) next()
     *!
     *!   Advance to the next element in the list.
     *!
     *! @returns
     *!   Returns @expr{1@} on success, and @expr{0@} (zero)
     *!   at the end of the list.
     *!
     *! @seealso
     *!   @[prev()]
     */
    #define f_List_cq__get_iterator_next_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_List_cq__get_iterator_next_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_List_cq__get_iterator_next(INT32 args) {
#line 4151 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("next",args,0);
{
      struct pike_list_node *next;
      if ((next = THIS->cur->next)) {
	free_list_node(THIS->cur);
	add_ref(THIS->cur = next);
	THIS->ind++;
	if (next->next) {
	  pop_n_elems(args);
	  push_int(1);
	  return;
	}
      }
      pop_n_elems(args);
      push_int(0);
    }

    }
/*! @decl int(0..1) prev()
     *!
     *!   Retrace to the previous element in the list.
     *!
     *! @returns
     *!   Returns @expr{1@} on success, and @expr{0@} (zero)
     *!   at the beginning of the list.
     *!
     *! @seealso
     *!   @[next()]
     */
    #define f_List_cq__get_iterator_prev_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_List_cq__get_iterator_prev_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_List_cq__get_iterator_prev(INT32 args) {
#line 4179 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("prev",args,0);
{
      struct pike_list_node *prev;
      if ((prev = THIS->cur->prev)) {
	free_list_node(THIS->cur);
	add_ref(THIS->cur = prev);
	THIS->ind--;
	if (prev->prev) {
	  pop_n_elems(args);
	  push_int(1);
	  return;
	}
      }
      pop_n_elems(args);
      push_int(0);
    }

    }
/*! @decl Iterator `+=(int steps)
     *!
     *!   Advance or retrace the specified number of @[steps].
     *!
     *! @seealso
     *!   @[next()], @[prev]
     */
    #define f_List_cq__get_iterator_cq__backtick_add_eq_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_List_cq__get_iterator_cq__backtick_add_eq_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_List_cq__get_iterator_cq__backtick_add_eq(INT32 args) {
#line 4203 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
INT_TYPE steps;
#line 4203 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("`+=",args,1);
#line 4203 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("`+=",1,"int");
#line 4203 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
steps=Pike_sp[0-1].u.integer;
{
      if (!steps) return;
      if (steps > 0) {
	while (steps--) {
	  apply_current(f_List_cq__get_iterator_next_fun_num, 0);
	  pop_stack();
	}
      } else {
	while (steps++) {
	  apply_current(f_List_cq__get_iterator_prev_fun_num, 0);
	  pop_stack();
	}
      }
      pop_n_elems(args);
      ref_push_object(Pike_fp->current_object);
    }

    }
/*! @decl void insert(mixed val)
     *!
     *!   Insert @[val] at the current position.
     *!
     *! @seealso
     *!   @[append()], @[delete()], @[set()]
     */
    #define f_List_cq__get_iterator_insert_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_List_cq__get_iterator_insert_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_List_cq__get_iterator_insert(INT32 args) {
#line 4228 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * val;
#line 4228 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("insert",args,1);
#line 4228 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
val=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
{
      struct pike_list_node *new_node;
      if (!THIS->cur->prev) {
	Pike_error("Attempt to insert before the start sentinel.\n");
      }
      new_node = alloc_pike_list_node();
      assign_svalue_no_free(&new_node->val, val);
      prepend_list_node(THIS->cur, new_node);
      free_list_node(THIS->cur);
      THIS->cur = new_node;
      List__get_iterator_find_parent()->num_elems++;
      pop_n_elems(args);
      push_int(0);
    }

    }
/*! @decl void append(mixed val)
     *!
     *!   Append @[val] after the current position.
     *!
     *! @seealso
     *!   @[insert()], @[delete()], @[set()]
     */
    #define f_List_cq__get_iterator_append_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_List_cq__get_iterator_append_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_List_cq__get_iterator_append(INT32 args) {
#line 4251 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * val;
#line 4251 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("append",args,1);
#line 4251 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
val=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
{
      struct pike_list_node *new_node;
      if (!THIS->cur->next) {
	Pike_error("Attempt to append after the end sentinel.\n");
      }
      new_node = alloc_pike_list_node();
      assign_svalue_no_free(&new_node->val, val);
      append_list_node(THIS->cur, new_node);
      free_list_node(new_node);
      List__get_iterator_find_parent()->num_elems++;
      pop_n_elems(args);
      push_int(0);
    }

    }
/*! @decl void delete()
     *!
     *!   Delete the current node.
     *!
     *!   The current position will advance to the next node.
     *!   This function thus performes the reverse operation
     *!   of @[insert()].
     *!
     *! @seealso
     *!   @[insert()], @[append()], @[set()]
     */
    #define f_List_cq__get_iterator_delete_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_List_cq__get_iterator_delete_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_List_cq__get_iterator_delete(INT32 args) {
#line 4277 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("delete",args,0);
{
      struct pike_list_node *next;
      if (!(next = THIS->cur->next) || !THIS->cur->prev) {
	Pike_error("Attempt to delete a sentinel.\n");
      }
      add_ref(next);
      if (next->prev == THIS->cur) {
	if (THIS->cur->refs == 3) {
	  unlink_list_node(THIS->cur);
	} else {
	  /* There's some other iterator holding references to this node. */
	  detach_list_node(THIS->cur);
	}
	List__get_iterator_find_parent()->num_elems--;
      }
      free_list_node(THIS->cur);
      THIS->cur = next;
      pop_n_elems(args);
      push_int(0);
    }

    }
/*! @decl void set(mixed val)
     *!
     *!   Set the value of the current position to @[val].
     *!
     *! @seealso
     *!   @[insert()], @[append()], @[delete()]
     */
    #define f_List_cq__get_iterator_set_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_List_cq__get_iterator_set_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_List_cq__get_iterator_set(INT32 args) {
#line 4306 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * val;
#line 4306 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("set",args,1);
#line 4306 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
val=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
{
      if (!THIS->cur->next || !THIS->cur->prev) {
	Pike_error("Attempt to set a sentinel.\n");
      }
      assign_svalue(&THIS->cur->val, val);
      pop_n_elems(args);
      push_int(0);
    }
  }

#ifdef List_cq__get_iterator_event_handler_defined
static void List_cq__get_iterator_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_List_cq__get_iterator_defined
  case PROG_EVENT_INIT: init_List_cq__get_iterator_struct(); break;

#endif /* internal_init_List_cq__get_iterator_defined */

#ifdef internal_exit_List_cq__get_iterator_defined
  case PROG_EVENT_EXIT: exit_List_cq__get_iterator_struct(); break;

#endif /* internal_exit_List_cq__get_iterator_defined */

#ifdef internal_gc_check_List_cq__get_iterator_defined
  case PROG_EVENT_GC_CHECK: gc_check_List_cq__get_iterator_struct(); break;

#endif /* internal_gc_check_List_cq__get_iterator_defined */

#ifdef internal_gc_recurse_List_cq__get_iterator_defined
  case PROG_EVENT_GC_RECURSE: gc_recurse_List_cq__get_iterator_struct(); break;

#endif /* internal_gc_recurse_List_cq__get_iterator_defined */
  default: break; 
  }
}

#endif /* List_cq__get_iterator_event_handler_defined */
/*! @endclass
   */

#ifdef List_event_handler_defined
static void List_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_List_defined
  case PROG_EVENT_INIT: init_List_struct(); break;

#endif /* internal_init_List_defined */

#ifdef internal_exit_List_defined
  case PROG_EVENT_EXIT: exit_List_struct(); break;

#endif /* internal_exit_List_defined */

#ifdef internal_gc_check_List_defined
  case PROG_EVENT_GC_CHECK: gc_check_List_struct(); break;

#endif /* internal_gc_check_List_defined */

#ifdef internal_gc_recurse_List_defined
  case PROG_EVENT_GC_RECURSE: gc_recurse_List_struct(); break;

#endif /* internal_gc_recurse_List_defined */
  default: break; 
  }
}

#endif /* List_event_handler_defined */
/*! @endclass
 */

/*! @endmodule
 */

/*! @module Pike
 */

/*! @class MasterCodec
 *!
 *! This is a bare-bones codec that is used when loading a dumped master.
 *!
 *! @seealso
 *!   @[Codec]
 */

#undef class_MasterCodec_defined
#define class_MasterCodec_defined
DEFAULT_CMOD_STORAGE struct program *MasterCodec_program=NULL;
static int MasterCodec_program_fun_num=-1;
/*! @decl mixed functionof(mixed symbol)
   *! Look up a function in @[all_constants()].
   */
  #define f_MasterCodec_functionof_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_MasterCodec_functionof_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_MasterCodec_functionof(INT32 args) {
#line 4341 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * symbol;
#line 4341 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("functionof",args,1);
#line 4341 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
symbol=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
{
    mapping_index_no_free(Pike_sp, get_builtin_constants(), symbol);
    Pike_sp++;
    stack_pop_keep_top();
  }
  }
/*! @decl mixed objectof(mixed symbol)
   *! Look up an object in @[all_constants()].
   */
  #define f_MasterCodec_objectof_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_MasterCodec_objectof_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_MasterCodec_objectof(INT32 args) {
#line 4350 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * symbol;
#line 4350 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("objectof",args,1);
#line 4350 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
symbol=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
{
    mapping_index_no_free(Pike_sp, get_builtin_constants(), symbol);
    Pike_sp++;
    stack_pop_keep_top();
  }
  }
/*! @decl mixed programof(mixed symbol)
   *! Look up a program in @[all_constants()].
   */
  #define f_MasterCodec_programof_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_MasterCodec_programof_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_MasterCodec_programof(INT32 args) {
#line 4359 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * symbol;
#line 4359 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("programof",args,1);
#line 4359 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
symbol=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
{
    mapping_index_no_free(Pike_sp, get_builtin_constants(), symbol);
    Pike_sp++;
    stack_pop_keep_top();
  }
  }
/*! @decl object decode_object(object obj, mixed data)
   *! Calls @expr{obj->_decode(@[data])@}.
   */
  #define f_MasterCodec_decode_object_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_MasterCodec_decode_object_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_MasterCodec_decode_object(INT32 args) {
#line 4368 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct object * obj;
#line 4368 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
struct svalue * data;
#line 4368 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(args != 2) wrong_number_of_args_error("decode_object",args,2);
#line 4368 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
if(Pike_sp[0-2].type != PIKE_T_OBJECT) SIMPLE_ARG_TYPE_ERROR("decode_object",1,"object");
#line 4368 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
debug_malloc_pass(obj=Pike_sp[0-2].u.object);
#line 4368 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
data=Pike_sp+1-2; dmalloc_touch_svalue(Pike_sp+1-2);
{
    apply(obj, "_decode", 1);
    pop_stack();
  }
}
/*! @endclass
 */

/*! @endmodule
 */

#line 4381 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
static struct object *val_module;

static void get_val_module()
{
  assert (!val_module);
  push_constant_text ("Val");
  APPLY_MASTER ("resolv", 1);
  if (Pike_sp[-1].type != T_OBJECT)
    Pike_error ("\"Val\" didn't resolve to a module object.\n");
  val_module = (--Pike_sp)->u.object;
}

/* Always do the lookup in the Val module dynamically to allow the
 * values to be replaced. */
#define GET_VAL(NAME)							\
  PMOD_EXPORT struct object *PIKE_CONCAT (get_val_, NAME) (void)	\
  {									\
    struct svalue index, res;						\
    if (!val_module) get_val_module();					\
    index.type = T_STRING;						\
    MAKE_CONST_STRING (index.u.string, TOSTR (NAME));			\
    object_index_no_free (&res, val_module, 0, &index);			\
    if (res.type != T_OBJECT)						\
      Pike_error ("\"Val." TOSTR (NAME) "\" didn't resolve to an object.\n"); \
    return res.u.object;						\
  }

GET_VAL (true)
GET_VAL (false)
GET_VAL (null)

/* Kludge needed for the static null objects in the oracle module. It
 * ought to be fixed to use dynamic lookup of them instead. */
PMOD_EXPORT struct program *get_sql_null_prog(void)
{
  return SqlNull_program;
}

void init_builtin(void)
{
  init_pike_list_node_blocks();
  
#ifdef class_backtrace_frame_defined

#ifdef PROG_BACKTRACE_FRAME_ID
#line 1669 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  START_NEW_PROGRAM_ID(BACKTRACE_FRAME);
#else
#line 1669 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  start_new_program();

#endif /* PROG_BACKTRACE_FRAME_ID */

#ifndef tObjImpl_BACKTRACE_FRAME

#undef tObjImpl_BACKTRACE_FRAME
#define tObjImpl_BACKTRACE_FRAME tObj

#endif /* tObjImpl_BACKTRACE_FRAME */

#ifdef THIS_BACKTRACE_FRAME
  backtrace_frame_storage_offset = ADD_STORAGE(struct backtrace_frame_struct);
#endif /* THIS_BACKTRACE_FRAME */

#ifdef var_cq__fun_backtrace_frame_defined
  PIKE_MAP_VARIABLE("_fun", backtrace_frame_storage_offset + OFFSETOF(backtrace_frame_struct, _fun),
                    tMix, PIKE_T_MIXED, ID_PROTECTED|ID_PRIVATE);
#endif /* var_cq__fun_backtrace_frame_defined */

#ifdef var_oprog_backtrace_frame_defined
  PIKE_MAP_VARIABLE("oprog", backtrace_frame_storage_offset + OFFSETOF(backtrace_frame_struct, oprog),
                    tPrg(tObj), PIKE_T_PROGRAM, ID_PROTECTED|ID_PRIVATE);
#endif /* var_oprog_backtrace_frame_defined */

#ifdef var_args_backtrace_frame_defined
  PIKE_MAP_VARIABLE("args", backtrace_frame_storage_offset + OFFSETOF(backtrace_frame_struct, args),
                    tArray, PIKE_T_ARRAY, 0);
#endif /* var_args_backtrace_frame_defined */

#ifdef var_prog_backtrace_frame_defined
  PIKE_MAP_VARIABLE("prog", backtrace_frame_storage_offset + OFFSETOF(backtrace_frame_struct, prog),
                    tPrg(tObj), PIKE_T_PROGRAM, ID_PROTECTED|ID_PRIVATE);
#endif /* var_prog_backtrace_frame_defined */

#ifdef backtrace_frame_event_handler_defined
  pike_set_prog_event_callback(backtrace_frame_event_handler);

#ifndef backtrace_frame_gc_live_obj
  Pike_compiler->new_program->flags &= ~PROGRAM_LIVE_OBJ;

#endif /* backtrace_frame_gc_live_obj */

#endif /* backtrace_frame_event_handler_defined */

#ifdef f_backtrace_frame_cq__backtick_2D_3Efun_defined
  f_backtrace_frame_cq__backtick_2D_3Efun_fun_num =
#line 1709 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("`->fun", f_backtrace_frame_cq__backtick_2D_3Efun, tFunc(tNone,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_backtrace_frame_cq__backtick_2D_3Efun_defined */

#ifdef f_backtrace_frame_cq__backtick_2D_3Efun_eq_defined
  f_backtrace_frame_cq__backtick_2D_3Efun_eq_fun_num =
#line 1714 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("`->fun=", f_backtrace_frame_cq__backtick_2D_3Efun_eq, tFunc(tMix,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_backtrace_frame_cq__backtick_2D_3Efun_eq_defined */

#ifdef f_backtrace_frame_cq__is_type_defined
  f_backtrace_frame_cq__is_type_fun_num =
#line 1731 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("_is_type", f_backtrace_frame_cq__is_type, tFunc(tString,"\10\0\0\0\0\0\0\0\1"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_backtrace_frame_cq__is_type_defined */

#ifdef f_backtrace_frame_cq__sprintf_defined
  f_backtrace_frame_cq__sprintf_fun_num =
#line 1777 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("_sprintf", f_backtrace_frame_cq__sprintf, tFunc("\10\200\0\0\0\177\377\377\377" tOr(tMapping,tVoid),tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_backtrace_frame_cq__sprintf_defined */

#ifdef f_backtrace_frame_cq__sizeof_defined
  f_backtrace_frame_cq__sizeof_fun_num =
#line 1837 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("_sizeof", f_backtrace_frame_cq__sizeof, tFunc(tNone,"\10\0\0\0\3\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_backtrace_frame_cq__sizeof_defined */

#ifdef f_backtrace_frame_cq__backtick_5B_5D_defined
  f_backtrace_frame_cq__backtick_5B_5D_fun_num =
#line 1849 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("`[]", f_backtrace_frame_cq__backtick_5B_5D, tFunc("\10\200\0\0\0\177\377\377\377" tOr("\10\200\0\0\0\177\377\377\377",tVoid),tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_backtrace_frame_cq__backtick_5B_5D_defined */

#ifdef f_backtrace_frame_cq__backtick_5B_5D_eq_defined
  f_backtrace_frame_cq__backtick_5B_5D_eq_fun_num =
#line 1929 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("`[]=", f_backtrace_frame_cq__backtick_5B_5D_eq, tFunc("\10\200\0\0\0\177\377\377\377" tMix,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_backtrace_frame_cq__backtick_5B_5D_eq_defined */
#line 1669 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  backtrace_frame_program=end_program();
#line 1669 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  backtrace_frame_program_fun_num=add_program_constant("backtrace_frame",backtrace_frame_program,0);

#endif /* class_backtrace_frame_defined */

#ifdef class_Buffer_defined

#ifdef PROG_BUFFER_ID
#line 2209 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  START_NEW_PROGRAM_ID(BUFFER);
#else
#line 2209 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  start_new_program();

#endif /* PROG_BUFFER_ID */

#ifndef tObjImpl_BUFFER

#undef tObjImpl_BUFFER
#define tObjImpl_BUFFER tObj

#endif /* tObjImpl_BUFFER */

#ifdef THIS_BUFFER
  Buffer_storage_offset = ADD_STORAGE(struct Buffer_struct);
#endif /* THIS_BUFFER */

#ifdef Buffer_event_handler_defined
  pike_set_prog_event_callback(Buffer_event_handler);

#ifndef Buffer_gc_live_obj
  Pike_compiler->new_program->flags &= ~PROGRAM_LIVE_OBJ;

#endif /* Buffer_gc_live_obj */

#endif /* Buffer_event_handler_defined */

#ifdef f_Buffer_create_defined
  f_Buffer_create_fun_num =
#line 2228 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("create", f_Buffer_create, tFunc(tOr("\10\200\0\0\0\177\377\377\377",tVoid),tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_create_defined */

#ifdef f_Buffer_cq__sprintf_defined
  f_Buffer_cq__sprintf_fun_num =
#line 2241 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("_sprintf", f_Buffer_cq__sprintf, tFunc("\10\200\0\0\0\177\377\377\377" tMapping,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_cq__sprintf_defined */

#ifdef f_Buffer_cast_defined
  f_Buffer_cast_fun_num =
#line 2289 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("cast", f_Buffer_cast, tFunc(tString,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_cast_defined */

#ifdef f_Buffer_cq__backtick_add_defined
  f_Buffer_cq__backtick_add_fun_num =
#line 2322 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("`+", f_Buffer_cq__backtick_add, tFunc(tString,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_cq__backtick_add_defined */

#ifdef f_Buffer_cq__backtick_add_eq_defined
  f_Buffer_cq__backtick_add_eq_fun_num =
#line 2336 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("`+=", f_Buffer_cq__backtick_add_eq, tFunc(tString,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_cq__backtick_add_eq_defined */

#ifdef f_Buffer_add_defined
  f_Buffer_add_fun_num =
#line 2347 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("add", f_Buffer_add, tFuncV(tNone,tString,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_add_defined */

#ifdef f_Buffer_putchar_defined
  f_Buffer_putchar_fun_num =
#line 2396 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("putchar", f_Buffer_putchar, tFunc("\10\200\0\0\0\177\377\377\377",tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_putchar_defined */

#ifdef f_Buffer_get_copy_defined
  f_Buffer_get_copy_fun_num =
#line 2408 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("get_copy", f_Buffer_get_copy, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_get_copy_defined */

#ifdef f_Buffer_get_defined
  f_Buffer_get_fun_num =
#line 2442 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("get", f_Buffer_get, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_get_defined */

#ifdef f_Buffer_cq__sizeof_defined
  f_Buffer_cq__sizeof_fun_num =
#line 2461 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("_sizeof", f_Buffer_cq__sizeof, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_cq__sizeof_defined */
#line 2209 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  Buffer_program=end_program();
#line 2209 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  Buffer_program_fun_num=add_program_constant("Buffer",Buffer_program,0);

#endif /* class_Buffer_defined */

#ifdef class_multi_string_replace_defined

#ifdef PROG_MULTI_STRING_REPLACE_ID
#line 2501 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  START_NEW_PROGRAM_ID(MULTI_STRING_REPLACE);
#else
#line 2501 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  start_new_program();

#endif /* PROG_MULTI_STRING_REPLACE_ID */

#ifndef tObjImpl_MULTI_STRING_REPLACE

#undef tObjImpl_MULTI_STRING_REPLACE
#define tObjImpl_MULTI_STRING_REPLACE tObj

#endif /* tObjImpl_MULTI_STRING_REPLACE */

#ifdef THIS_MULTI_STRING_REPLACE
  multi_string_replace_storage_offset = ADD_STORAGE(struct multi_string_replace_struct);
#endif /* THIS_MULTI_STRING_REPLACE */

#ifdef var_from_multi_string_replace_defined
  PIKE_MAP_VARIABLE("from", multi_string_replace_storage_offset + OFFSETOF(multi_string_replace_struct, from),
                    tArray, PIKE_T_ARRAY, ID_PROTECTED);
#endif /* var_from_multi_string_replace_defined */

#ifdef var_to_multi_string_replace_defined
  PIKE_MAP_VARIABLE("to", multi_string_replace_storage_offset + OFFSETOF(multi_string_replace_struct, to),
                    tArray, PIKE_T_ARRAY, ID_PROTECTED);
#endif /* var_to_multi_string_replace_defined */

#ifdef multi_string_replace_event_handler_defined
  pike_set_prog_event_callback(multi_string_replace_event_handler);

#ifndef multi_string_replace_gc_live_obj
  Pike_compiler->new_program->flags &= ~PROGRAM_LIVE_OBJ;

#endif /* multi_string_replace_gc_live_obj */

#endif /* multi_string_replace_event_handler_defined */

#ifdef f_multi_string_replace_create_defined
  f_multi_string_replace_create_fun_num =
#line 2511 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("create", f_multi_string_replace_create, tFunc(tOr3(tArr(tString),tMap(tString,tString),tVoid) tOr3(tArr(tString),tString,tVoid),tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multi_string_replace_create_defined */

#ifdef f_multi_string_replace_cq__backtick_28_29_defined
  f_multi_string_replace_cq__backtick_28_29_fun_num =
#line 2593 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("`()", f_multi_string_replace_cq__backtick_28_29, tFunc(tString,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multi_string_replace_cq__backtick_28_29_defined */

#ifdef f_multi_string_replace_cq__encode_defined
  f_multi_string_replace_cq__encode_fun_num =
#line 2605 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("_encode", f_multi_string_replace_cq__encode, tFunc(tNone,tArr(tArr(tString))), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multi_string_replace_cq__encode_defined */

#ifdef f_multi_string_replace_cq__decode_defined
  f_multi_string_replace_cq__decode_fun_num =
#line 2622 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("_decode", f_multi_string_replace_cq__decode, tFunc(tArr(tArr(tString)),tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multi_string_replace_cq__decode_defined */
#line 2501 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  multi_string_replace_program=end_program();
#line 2501 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  multi_string_replace_program_fun_num=add_program_constant("multi_string_replace",multi_string_replace_program,0);

#endif /* class_multi_string_replace_defined */

#ifdef class_single_string_replace_defined

#ifdef PROG_SINGLE_STRING_REPLACE_ID
#line 2659 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  START_NEW_PROGRAM_ID(SINGLE_STRING_REPLACE);
#else
#line 2659 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  start_new_program();

#endif /* PROG_SINGLE_STRING_REPLACE_ID */

#ifndef tObjImpl_SINGLE_STRING_REPLACE

#undef tObjImpl_SINGLE_STRING_REPLACE
#define tObjImpl_SINGLE_STRING_REPLACE tObj

#endif /* tObjImpl_SINGLE_STRING_REPLACE */

#ifdef THIS_SINGLE_STRING_REPLACE
  single_string_replace_storage_offset = ADD_STORAGE(struct single_string_replace_struct);
#endif /* THIS_SINGLE_STRING_REPLACE */

#ifdef var_del_single_string_replace_defined
  PIKE_MAP_VARIABLE("del", single_string_replace_storage_offset + OFFSETOF(single_string_replace_struct, del),
                    tString, PIKE_T_STRING, ID_PROTECTED|ID_PRIVATE);
#endif /* var_del_single_string_replace_defined */

#ifdef var_to_single_string_replace_defined
  PIKE_MAP_VARIABLE("to", single_string_replace_storage_offset + OFFSETOF(single_string_replace_struct, to),
                    tString, PIKE_T_STRING, ID_PROTECTED|ID_PRIVATE);
#endif /* var_to_single_string_replace_defined */

#ifdef extra_single_string_replace_defined
#line 2666 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
    MAP_VARIABLE ("o", tObj, ID_PROTECTED|ID_PRIVATE,
		  single_string_replace_storage_offset +
		  OFFSETOF (single_string_replace_struct, mojt.container),
		  T_OBJECT);
  }

  
#endif /* extra_single_string_replace_defined */

#ifdef f_single_string_replace_create_defined
  f_single_string_replace_create_fun_num =
    ADD_FUNCTION2("create", f_single_string_replace_create, tFunc(tOr(tString,tVoid) tOr(tString,tVoid),tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_single_string_replace_create_defined */

#ifdef f_single_string_replace_cq__backtick_28_29_defined
  f_single_string_replace_cq__backtick_28_29_fun_num =
#line 2713 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("`()", f_single_string_replace_cq__backtick_28_29, tFunc(tString,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_single_string_replace_cq__backtick_28_29_defined */

#ifdef f_single_string_replace_cq__encode_defined
  f_single_string_replace_cq__encode_fun_num =
#line 2801 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("_encode", f_single_string_replace_cq__encode, tFunc(tNone,tArr(tString)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_single_string_replace_cq__encode_defined */

#ifdef f_single_string_replace_cq__decode_defined
  f_single_string_replace_cq__decode_fun_num =
#line 2814 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("_decode", f_single_string_replace_cq__decode, tFunc(tOr(tArr(tString),"\10\0\0\0\0\0\0\0\0"),tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_single_string_replace_cq__decode_defined */
#line 2659 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  single_string_replace_program=end_program();
#line 2659 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  single_string_replace_program_fun_num=add_program_constant("single_string_replace",single_string_replace_program,0);

#endif /* class_single_string_replace_defined */

#ifdef class_bootstring_defined

#ifdef PROG_BOOTSTRING_ID
#line 2839 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  START_NEW_PROGRAM_ID(BOOTSTRING);
#else
#line 2839 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  start_new_program();

#endif /* PROG_BOOTSTRING_ID */

#ifndef tObjImpl_BOOTSTRING

#undef tObjImpl_BOOTSTRING
#define tObjImpl_BOOTSTRING tObj

#endif /* tObjImpl_BOOTSTRING */

#ifdef THIS_BOOTSTRING
  bootstring_storage_offset = ADD_STORAGE(struct bootstring_struct);
#endif /* THIS_BOOTSTRING */

#ifdef var_digits_bootstring_defined
  PIKE_MAP_VARIABLE("digits", bootstring_storage_offset + OFFSETOF(bootstring_struct, digits),
                    tString, PIKE_T_STRING, ID_PROTECTED|ID_PRIVATE);
#endif /* var_digits_bootstring_defined */

#ifdef f_bootstring_decode_defined
  f_bootstring_decode_fun_num =
#line 2882 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("decode", f_bootstring_decode, tFunc(tString,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_bootstring_decode_defined */

#ifdef f_bootstring_encode_defined
  f_bootstring_encode_fun_num =
#line 2974 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("encode", f_bootstring_encode, tFunc(tString,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_bootstring_encode_defined */

#ifdef f_bootstring_create_defined
  f_bootstring_create_fun_num =
#line 3065 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("create", f_bootstring_create, tFunc("\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" tString,tVoid), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_bootstring_create_defined */
#line 2839 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  bootstring_program=end_program();
#line 2839 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  bootstring_program_fun_num=add_program_constant("bootstring",bootstring_program,0);

#endif /* class_bootstring_defined */

#ifdef class_Time_defined

#ifdef PROG_TIME_ID
#line 3111 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  START_NEW_PROGRAM_ID(TIME);
#else
#line 3111 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  start_new_program();

#endif /* PROG_TIME_ID */

#ifndef tObjImpl_TIME

#undef tObjImpl_TIME
#define tObjImpl_TIME tObj

#endif /* tObjImpl_TIME */

#ifdef THIS_TIME
  Time_storage_offset = ADD_STORAGE(struct Time_struct);
#endif /* THIS_TIME */

#ifdef f_Time_cq__backtick_2D_3E_defined
  f_Time_cq__backtick_2D_3E_fun_num =
#line 3133 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("`->", f_Time_cq__backtick_2D_3E, tFunc(tString,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Time_cq__backtick_2D_3E_defined */

#ifdef f_Time_cq__backtick_5B_5D_defined
  f_Time_cq__backtick_5B_5D_fun_num =
#line 3173 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("`[]", f_Time_cq__backtick_5B_5D, tFunc(tString,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Time_cq__backtick_5B_5D_defined */

#ifdef f_Time_create_defined
  f_Time_create_fun_num =
#line 3186 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("create", f_Time_create, tFunc(tOr("\10\200\0\0\0\177\377\377\377",tVoid),tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Time_create_defined */
#line 3111 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  Time_program=end_program();
#line 3111 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  Time_program_fun_num=add_program_constant("Time",Time_program,0);

#endif /* class_Time_defined */

#ifdef class_Timer_defined

#ifdef PROG_TIMER_ID
#line 3197 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  START_NEW_PROGRAM_ID(TIMER);
#else
#line 3197 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  start_new_program();

#endif /* PROG_TIMER_ID */

#ifndef tObjImpl_TIMER

#undef tObjImpl_TIMER
#define tObjImpl_TIMER tObj

#endif /* tObjImpl_TIMER */

#ifdef THIS_TIMER
  Timer_storage_offset = ADD_STORAGE(struct Timer_struct);
#endif /* THIS_TIMER */

#ifdef f_Timer_peek_defined
  f_Timer_peek_fun_num =
#line 3205 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("peek", f_Timer_peek, tFunc(tNone,tFloat), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Timer_peek_defined */

#ifdef f_Timer_get_defined
  f_Timer_get_fun_num =
#line 3221 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("get", f_Timer_get, tFunc(tNone,tFloat), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Timer_get_defined */

#ifdef f_Timer_create_defined
  f_Timer_create_fun_num =
#line 3239 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("create", f_Timer_create, tFunc(tOr("\10\200\0\0\0\177\377\377\377",tVoid),tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Timer_create_defined */
#line 3197 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  Timer_program=end_program();
#line 3197 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  Timer_program_fun_num=add_program_constant("Timer",Timer_program,0);

#endif /* class_Timer_defined */

#ifdef class_automap_marker_defined

#ifdef PROG_AUTOMAP_MARKER_ID
#line 3256 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  START_NEW_PROGRAM_ID(AUTOMAP_MARKER);
#else
#line 3256 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  start_new_program();

#endif /* PROG_AUTOMAP_MARKER_ID */

#ifndef tObjImpl_AUTOMAP_MARKER

#undef tObjImpl_AUTOMAP_MARKER
#define tObjImpl_AUTOMAP_MARKER tObj

#endif /* tObjImpl_AUTOMAP_MARKER */

#ifdef THIS_AUTOMAP_MARKER
  automap_marker_storage_offset = ADD_STORAGE(struct automap_marker_struct);
#endif /* THIS_AUTOMAP_MARKER */

#ifdef var_arg_automap_marker_defined
  PIKE_MAP_VARIABLE("arg", automap_marker_storage_offset + OFFSETOF(automap_marker_struct, arg),
                    tArray, PIKE_T_ARRAY, 0);
#endif /* var_arg_automap_marker_defined */

#ifdef var_depth_automap_marker_defined
  PIKE_MAP_VARIABLE("depth", automap_marker_storage_offset + OFFSETOF(automap_marker_struct, depth),
                    "\10\200\0\0\0\177\377\377\377", PIKE_T_INT, 0);
#endif /* var_depth_automap_marker_defined */

#ifdef f_automap_marker_create_defined
  f_automap_marker_create_fun_num =
#line 3261 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("create", f_automap_marker_create, tFunc(tArray "\10\200\0\0\0\177\377\377\377",tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_automap_marker_create_defined */

#ifdef f_automap_marker_cq__sprintf_defined
  f_automap_marker_cq__sprintf_fun_num =
#line 3268 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("_sprintf", f_automap_marker_cq__sprintf, tFunc("\10\200\0\0\0\177\377\377\377" tMapping,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_automap_marker_cq__sprintf_defined */
#line 3256 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  automap_marker_program=end_program();
#line 3256 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  automap_marker_program_fun_num=add_program_constant("automap_marker",automap_marker_program,0);

#endif /* class_automap_marker_defined */

#ifdef class_SqlNull_defined

#ifdef PROG_SQLNULL_ID
#line 3538 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  START_NEW_PROGRAM_ID(SQLNULL);
#else
#line 3538 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  start_new_program();

#endif /* PROG_SQLNULL_ID */

#ifndef tObjImpl_SQLNULL

#undef tObjImpl_SQLNULL
#define tObjImpl_SQLNULL tObj

#endif /* tObjImpl_SQLNULL */

#ifdef extra_SqlNull_defined
#line 3540 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
{
    /*! @decl constant is_sql_null = 1
     *!
     *! SQL Null marker.
     */
    add_integer_constant("is_sql_null", 1, 0);
  }

  
#endif /* extra_SqlNull_defined */

#ifdef f_SqlNull_cq__backtick_21_defined
  f_SqlNull_cq__backtick_21_fun_num =
#line 3548 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("`!", f_SqlNull_cq__backtick_21, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_SqlNull_cq__backtick_21_defined */

#ifdef f_SqlNull_cq__sprintf_defined
  f_SqlNull_cq__sprintf_fun_num =
    ADD_FUNCTION2("_sprintf", f_SqlNull_cq__sprintf, tFuncV("\10\200\0\0\0\177\377\377\377",tMix,tString), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_SqlNull_cq__sprintf_defined */

#ifdef f_SqlNull_cq___hash_defined
  f_SqlNull_cq___hash_fun_num =
#line 3565 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("__hash", f_SqlNull_cq___hash, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_SqlNull_cq___hash_defined */

#ifdef f_SqlNull_cq__backtick_eq_eq_defined
  f_SqlNull_cq__backtick_eq_eq_fun_num =
#line 3572 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("`==", f_SqlNull_cq__backtick_eq_eq, tFunc(tMix,"\10\200\0\0\0\177\377\377\377"), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_SqlNull_cq__backtick_eq_eq_defined */

#ifdef f_SqlNull_encode_json_defined
  f_SqlNull_encode_json_fun_num =
#line 3604 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("encode_json", f_SqlNull_encode_json, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_SqlNull_encode_json_defined */
#line 3538 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  SqlNull_program=end_program();
#line 3538 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  SqlNull_program_fun_num=add_program_constant("SqlNull",SqlNull_program,0);

#endif /* class_SqlNull_defined */

#ifdef class_List_defined

#ifdef PROG_LIST_ID
#line 3623 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  START_NEW_PROGRAM_ID(LIST);
#else
#line 3623 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  start_new_program();

#endif /* PROG_LIST_ID */

#ifndef tObjImpl_LIST

#undef tObjImpl_LIST
#define tObjImpl_LIST tObj

#endif /* tObjImpl_LIST */

#ifdef THIS_LIST
  List_storage_offset = ADD_STORAGE(struct List_struct);
#endif /* THIS_LIST */

#ifdef class_List_cq__get_iterator_defined

#ifdef PROG_LIST_CQ__GET_ITERATOR_ID
#line 3921 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  START_NEW_PROGRAM_ID(LIST_CQ__GET_ITERATOR);
#else
#line 3921 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  start_new_program();

#endif /* PROG_LIST_CQ__GET_ITERATOR_ID */

#ifndef tObjImpl_LIST_CQ__GET_ITERATOR

#undef tObjImpl_LIST_CQ__GET_ITERATOR
#define tObjImpl_LIST_CQ__GET_ITERATOR tObj

#endif /* tObjImpl_LIST_CQ__GET_ITERATOR */

#ifdef THIS_LIST_CQ__GET_ITERATOR
  List_cq__get_iterator_storage_offset = ADD_STORAGE(struct List_cq__get_iterator_struct);
#endif /* THIS_LIST_CQ__GET_ITERATOR */

#ifdef List_cq__get_iterator_event_handler_defined
  pike_set_prog_event_callback(List_cq__get_iterator_event_handler);

#ifndef List_cq__get_iterator_gc_live_obj
  Pike_compiler->new_program->flags &= ~PROGRAM_LIVE_OBJ;

#endif /* List_cq__get_iterator_gc_live_obj */

#endif /* List_cq__get_iterator_event_handler_defined */

#ifdef f_List_cq__get_iterator_cq__backtick_21_defined
  f_List_cq__get_iterator_cq__backtick_21_fun_num =
#line 4075 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("`!", f_List_cq__get_iterator_cq__backtick_21, tFunc(tNone,"\10\0\0\0\0\0\0\0\1"), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_List_cq__get_iterator_cq__backtick_21_defined */

#ifdef f_List_cq__get_iterator_index_defined
  f_List_cq__get_iterator_index_fun_num =
#line 4082 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("index", f_List_cq__get_iterator_index, tFunc(tNone,"\10\0\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_List_cq__get_iterator_index_defined */

#ifdef f_List_cq__get_iterator_value_defined
  f_List_cq__get_iterator_value_fun_num =
#line 4097 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("value", f_List_cq__get_iterator_value, tFunc(tNone,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_List_cq__get_iterator_value_defined */

#ifdef f_List_cq__get_iterator_first_defined
  f_List_cq__get_iterator_first_fun_num =
#line 4116 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("first", f_List_cq__get_iterator_first, tFunc(tNone,"\10\0\0\0\0\0\0\0\1"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_List_cq__get_iterator_first_defined */

#ifdef f_List_cq__get_iterator_next_defined
  f_List_cq__get_iterator_next_fun_num =
#line 4151 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("next", f_List_cq__get_iterator_next, tFunc(tNone,"\10\0\0\0\0\0\0\0\1"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_List_cq__get_iterator_next_defined */

#ifdef f_List_cq__get_iterator_prev_defined
  f_List_cq__get_iterator_prev_fun_num =
#line 4179 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("prev", f_List_cq__get_iterator_prev, tFunc(tNone,"\10\0\0\0\0\0\0\0\1"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_List_cq__get_iterator_prev_defined */

#ifdef f_List_cq__get_iterator_cq__backtick_add_eq_defined
  f_List_cq__get_iterator_cq__backtick_add_eq_fun_num =
#line 4203 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("`+=", f_List_cq__get_iterator_cq__backtick_add_eq, tFunc("\10\200\0\0\0\177\377\377\377",tName("Iterator", tObjImpl_ITERATOR)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_List_cq__get_iterator_cq__backtick_add_eq_defined */

#ifdef f_List_cq__get_iterator_insert_defined
  f_List_cq__get_iterator_insert_fun_num =
#line 4228 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("insert", f_List_cq__get_iterator_insert, tFunc(tMix,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_List_cq__get_iterator_insert_defined */

#ifdef f_List_cq__get_iterator_append_defined
  f_List_cq__get_iterator_append_fun_num =
#line 4251 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("append", f_List_cq__get_iterator_append, tFunc(tMix,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_List_cq__get_iterator_append_defined */

#ifdef f_List_cq__get_iterator_delete_defined
  f_List_cq__get_iterator_delete_fun_num =
#line 4277 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("delete", f_List_cq__get_iterator_delete, tFunc(tNone,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_List_cq__get_iterator_delete_defined */

#ifdef f_List_cq__get_iterator_set_defined
  f_List_cq__get_iterator_set_fun_num =
#line 4306 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("set", f_List_cq__get_iterator_set, tFunc(tMix,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_List_cq__get_iterator_set_defined */
#line 3922 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  Pike_compiler->new_program->flags |= PROGRAM_USES_PARENT;
#line 3921 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  List_cq__get_iterator_program=end_program();
#line 3921 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  List_cq__get_iterator_program_fun_num=add_program_constant("_get_iterator",List_cq__get_iterator_program,ID_PROTECTED);

#endif /* class_List_cq__get_iterator_defined */

#ifdef List_event_handler_defined
  pike_set_prog_event_callback(List_event_handler);

#ifndef List_gc_live_obj
  Pike_compiler->new_program->flags &= ~PROGRAM_LIVE_OBJ;

#endif /* List_gc_live_obj */

#endif /* List_event_handler_defined */

#ifdef f_List_is_empty_defined
  f_List_is_empty_fun_num =
#line 3740 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("is_empty", f_List_is_empty, tFunc(tNone,"\10\0\0\0\0\0\0\0\1"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_List_is_empty_defined */

#ifdef f_List_cq__sizeof_defined
  f_List_cq__sizeof_fun_num =
#line 3749 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("_sizeof", f_List_cq__sizeof, tFunc(tNone,"\10\0\0\0\0\177\377\377\377"), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_List_cq__sizeof_defined */

#ifdef f_List_cq__sprintf_defined
  f_List_cq__sprintf_fun_num =
#line 3762 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("_sprintf", f_List_cq__sprintf, tFunc("\10\200\0\0\0\177\377\377\377" tOr(tMap(tString,tMix),tVoid),tString), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_List_cq__sprintf_defined */

#ifdef f_List_head_defined
  f_List_head_fun_num =
#line 3810 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("head", f_List_head, tFunc(tNone,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_List_head_defined */

#ifdef f_List_tail_defined
  f_List_tail_fun_num =
#line 3829 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("tail", f_List_tail, tFunc(tNone,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_List_tail_defined */

#ifdef f_List_pop_defined
  f_List_pop_fun_num =
#line 3848 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("pop", f_List_pop, tFunc(tNone,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_List_pop_defined */

#ifdef f_List_append_defined
  f_List_append_fun_num =
#line 3870 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("append", f_List_append, tFuncV(tNone,tMix,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_List_append_defined */

#ifdef f_List_insert_defined
  f_List_insert_fun_num =
#line 3890 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("insert", f_List_insert, tFuncV(tNone,tMix,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_List_insert_defined */

#ifdef f_List_create_defined
  f_List_create_fun_num =
#line 3910 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("create", f_List_create, tFuncV(tNone,tMix,tVoid), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_List_create_defined */
#line 3623 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  List_program=end_program();
#line 3623 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  List_program_fun_num=add_program_constant("List",List_program,0);

#endif /* class_List_defined */

#ifdef class_MasterCodec_defined

#ifdef PROG_MASTERCODEC_ID
#line 4335 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  START_NEW_PROGRAM_ID(MASTERCODEC);
#else
#line 4335 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  start_new_program();

#endif /* PROG_MASTERCODEC_ID */

#ifndef tObjImpl_MASTERCODEC

#undef tObjImpl_MASTERCODEC
#define tObjImpl_MASTERCODEC tObj

#endif /* tObjImpl_MASTERCODEC */

#ifdef f_MasterCodec_functionof_defined
  f_MasterCodec_functionof_fun_num =
#line 4341 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("functionof", f_MasterCodec_functionof, tFunc(tMix,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_MasterCodec_functionof_defined */

#ifdef f_MasterCodec_objectof_defined
  f_MasterCodec_objectof_fun_num =
#line 4350 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("objectof", f_MasterCodec_objectof, tFunc(tMix,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_MasterCodec_objectof_defined */

#ifdef f_MasterCodec_programof_defined
  f_MasterCodec_programof_fun_num =
#line 4359 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("programof", f_MasterCodec_programof, tFunc(tMix,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_MasterCodec_programof_defined */

#ifdef f_MasterCodec_decode_object_defined
  f_MasterCodec_decode_object_fun_num =
#line 4368 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("decode_object", f_MasterCodec_decode_object, tFunc(tObj tMix,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_MasterCodec_decode_object_defined */
#line 4335 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  MasterCodec_program=end_program();
#line 4335 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  MasterCodec_program_fun_num=add_program_constant("MasterCodec",MasterCodec_program,ID_PROTECTED);

#endif /* class_MasterCodec_defined */

#ifdef f_cq__describe_program_defined
#line 76 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  ADD_EFUN("_describe_program", f_cq__describe_program, tFunc(tMix,tArr(tArr(tOr("\10\200\0\0\0\177\377\377\377",tString)))), 0);

#endif /* f_cq__describe_program_defined */

#ifdef f_basetype_defined
#line 119 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  ADD_EFUN("basetype", f_basetype, tFunc(tMix,tString), OPT_TRY_OPTIMIZE);

#endif /* f_basetype_defined */

#ifdef f_int2char_defined
#line 183 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  ADD_EFUN("int2char", f_int2char, tFunc(tOr("\10\200\0\0\0\177\377\377\377",tObj),tString), OPT_TRY_OPTIMIZE);

#endif /* f_int2char_defined */

#ifdef f_int2hex_defined
#line 236 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  ADD_EFUN("int2hex", f_int2hex, tFunc(tOr("\10\200\0\0\0\177\377\377\377",tObj),tString), OPT_TRY_OPTIMIZE);

#endif /* f_int2hex_defined */

#ifdef f_string2hex_defined
  f_string2hex_fun_num =
#line 315 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("string2hex", f_string2hex, tFunc(tString,tString), 0, OPT_TRY_OPTIMIZE);

#endif /* f_string2hex_defined */

#ifdef f_hex2string_defined
  f_hex2string_fun_num =
#line 345 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("hex2string", f_hex2string, tFunc(tString,tString), 0, OPT_TRY_OPTIMIZE);

#endif /* f_hex2string_defined */

#ifdef f_column_defined
#line 382 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  ADD_EFUN("column", f_column, tFunc(tArray tMix,tArray), OPT_TRY_OPTIMIZE);

#endif /* f_column_defined */

#ifdef f_mkmultiset_defined
#line 398 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  ADD_EFUN("mkmultiset", f_mkmultiset, tFunc(tArr(tSetvar(1,tMix)),tSet(tVar(1))), OPT_TRY_OPTIMIZE|OPT_EXTERNAL_DEPEND);

#endif /* f_mkmultiset_defined */

#ifdef f_trace_defined
#line 462 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  ADD_EFUN("trace", f_trace, tFunc("\10\200\0\0\0\177\377\377\377" tOr(tVoid,tString) tOr(tVoid,"\10\200\0\0\0\177\377\377\377"),"\10\200\0\0\0\177\377\377\377"), OPT_SIDE_EFFECT);

#endif /* f_trace_defined */

#ifdef f_gc_parameters_defined
  f_gc_parameters_fun_num =
#line 546 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("gc_parameters", f_gc_parameters, tFunc(tOr(tVoid,tMap(tString,tMix)),tMap(tString,tMix)), 0, OPT_SIDE_EFFECT);

#endif /* f_gc_parameters_defined */

#ifdef f_ctime_defined
#line 626 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  ADD_EFUN("ctime", f_ctime, tFunc(tInt,tString), OPT_TRY_OPTIMIZE);

#endif /* f_ctime_defined */

#ifdef f_mkmapping_defined
#line 659 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  ADD_EFUN("mkmapping", f_mkmapping, tFunc(tArr(tSetvar(1,tMix)) tArr(tSetvar(2,tMix)),tMap(tVar(1),tVar(2))), OPT_TRY_OPTIMIZE|OPT_EXTERNAL_DEPEND);

#endif /* f_mkmapping_defined */

#ifdef f_string_secure_defined
  f_string_secure_fun_num =
#line 677 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("string_secure", f_string_secure, tFunc(tSetvar(0, tStr), tVar(0)), 0, OPT_SIDE_EFFECT);

#endif /* f_string_secure_defined */

#ifdef f_string_count_defined
  f_string_count_fun_num =
#line 698 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("string_count", f_string_count, tFunc(tString tString,"\10\200\0\0\0\177\377\377\377"), 0, OPT_TRY_OPTIMIZE);

#endif /* f_string_count_defined */

#ifdef f_string_trim_whites_defined
  f_string_trim_whites_fun_num =
#line 737 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("string_trim_whites", f_string_trim_whites, tFunc(tString,tString), 0, OPT_TRY_OPTIMIZE);

#endif /* f_string_trim_whites_defined */

#ifdef f_string_normalize_space_defined
  f_string_normalize_space_fun_num =
#line 787 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("string_normalize_space", f_string_normalize_space, tFunc(tString tOr(tString,tVoid),tString), 0, OPT_TRY_OPTIMIZE);

#endif /* f_string_normalize_space_defined */

#ifdef f_string_trim_all_whites_defined
  f_string_trim_all_whites_fun_num =
#line 924 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("string_trim_all_whites", f_string_trim_all_whites, tFunc(tString,tString), 0, OPT_TRY_OPTIMIZE);

#endif /* f_string_trim_all_whites_defined */

#ifdef f_program_implements_defined
  f_program_implements_fun_num =
#line 971 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("program_implements", f_program_implements, tFunc(tPrg(tObj) tPrg(tObj),"\10\200\0\0\0\177\377\377\377"), 0, OPT_TRY_OPTIMIZE);

#endif /* f_program_implements_defined */

#ifdef f_program_inherits_defined
  f_program_inherits_fun_num =
#line 984 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("program_inherits", f_program_inherits, tFunc(tPrg(tObj) tPrg(tObj),"\10\200\0\0\0\177\377\377\377"), 0, OPT_TRY_OPTIMIZE);

#endif /* f_program_inherits_defined */

#ifdef f_program_defined_defined
  f_program_defined_fun_num =
#line 1003 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("program_defined", f_program_defined, tFunc(tPrg(tObj),tString), 0, OPT_TRY_OPTIMIZE);

#endif /* f_program_defined_defined */

#ifdef f_string_width_defined
  f_string_width_fun_num =
#line 1041 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("string_width", f_string_width, tFunc(tString,tOr3("\10\0\0\0\10\0\0\0\10","\10\0\0\0\20\0\0\0\20","\10\0\0\0\40\0\0\0\40")), 0, OPT_TRY_OPTIMIZE);

#endif /* f_string_width_defined */

#ifdef f_m_delete_defined
#line 1068 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  ADD_EFUN("m_delete", f_m_delete, tOr(tFunc(tMap(tSetvar(0,tMix),tSetvar(1,tMix)) tVar(0),tVar(1)),tFunc(tObj tMix,tMix))
, OPT_SIDE_EFFECT);

#endif /* f_m_delete_defined */

#ifdef f_get_weak_flag_defined
#line 1119 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  ADD_EFUN("get_weak_flag", f_get_weak_flag, tOr3(tFunc(tArray,"\10\200\0\0\0\177\377\377\377"),tFunc(tMapping,"\10\200\0\0\0\177\377\377\377"),tFunc(tMultiset,"\10\200\0\0\0\177\377\377\377")), OPT_EXTERNAL_DEPEND);

#endif /* f_get_weak_flag_defined */

#ifdef f_cq___empty_program_defined
#line 1126 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  ADD_EFUN("__empty_program", f_cq___empty_program, tFunc(tOr("\10\200\0\0\0\177\377\377\377",tVoid) tOr(tString,tVoid),tPrg(tObj)), OPT_EXTERNAL_DEPEND);

#endif /* f_cq___empty_program_defined */

#ifdef f_function_name_defined
#line 1165 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  ADD_EFUN("function_name", f_function_name, tFunc(tOr(tPrg(tObj),tFuncV(tNone,tMix,tAny)),tString), OPT_TRY_OPTIMIZE);

#endif /* f_function_name_defined */

#ifdef f_function_object_defined
#line 1250 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  ADD_EFUN("function_object", f_function_object, tFunc(tFuncV(tNone,tMix,tAny),tObj), OPT_TRY_OPTIMIZE);

#endif /* f_function_object_defined */

#ifdef f_function_program_defined
#line 1294 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  ADD_EFUN("function_program", f_function_program, tFunc(tOr(tPrg(tObj),tFuncV(tNone,tMix,tAny)),tPrg(tObj)), OPT_TRY_OPTIMIZE);

#endif /* f_function_program_defined */

#ifdef f_random_defined
#line 1438 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  ADD_EFUN("random", f_random, tOr6(tFunc(tObj,tMix),tFunc("\10\200\0\0\0\177\377\377\377","\10\200\0\0\0\177\377\377\377"),tFunc(tFloat,tFloat),tFunc(tArr(tSetvar(0,tMix)),tVar(0)),tFunc(tSet(tSetvar(1,tMix)),tVar(1)),tFunc(tMapping,tArray)), OPT_TRY_OPTIMIZE|OPT_EXTERNAL_DEPEND);

#endif /* f_random_defined */

#ifdef f_cq__getenv_defined
  f_cq__getenv_fun_num =
#line 1484 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("_getenv", f_cq__getenv, tOr(tFunc(tStr, tString), tFunc(tVoid, tMap (tStr, tStr))), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_cq__getenv_defined */

#ifdef f_cq__putenv_defined
  f_cq__putenv_fun_num =
#line 1568 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("_putenv", f_cq__putenv, tFunc(tString tOr(tVoid,tString),tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_cq__putenv_defined */

#ifdef f_get_runtime_info_defined
  f_get_runtime_info_fun_num =
#line 2026 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    ADD_FUNCTION2("get_runtime_info", f_get_runtime_info, tFunc(tNone,tMap(tString,tOr("\10\200\0\0\0\177\377\377\377",tString))), 0, OPT_TRY_OPTIMIZE);

#endif /* f_get_runtime_info_defined */

#ifdef f_backtrace_defined
#line 2174 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  ADD_EFUN("backtrace", f_backtrace, tFunc(tNone,tArray), OPT_EXTERNAL_DEPEND);

#endif /* f_backtrace_defined */

#ifdef f_cq___automap___defined
#line 3354 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
  ADD_EFUN("__automap__", f_cq___automap__, tFuncV(tMix,tMix,tArray), 0);

#endif /* f_cq___automap___defined */
#line 4423 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
}

void exit_builtin(void)
{
  if (val_module) free_object (val_module);
  
#ifdef class_backtrace_frame_defined
  if(backtrace_frame_program) {
#line 1669 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    free_program(backtrace_frame_program);
    backtrace_frame_program=0;
  }

#endif /* class_backtrace_frame_defined */

#ifdef class_Buffer_defined
  if(Buffer_program) {
#line 2209 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    free_program(Buffer_program);
    Buffer_program=0;
  }

#endif /* class_Buffer_defined */

#ifdef class_multi_string_replace_defined
  if(multi_string_replace_program) {
#line 2501 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    free_program(multi_string_replace_program);
    multi_string_replace_program=0;
  }

#endif /* class_multi_string_replace_defined */

#ifdef class_single_string_replace_defined
  if(single_string_replace_program) {
#line 2659 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    free_program(single_string_replace_program);
    single_string_replace_program=0;
  }

#endif /* class_single_string_replace_defined */

#ifdef class_bootstring_defined
  if(bootstring_program) {
#line 2839 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    free_program(bootstring_program);
    bootstring_program=0;
  }

#endif /* class_bootstring_defined */

#ifdef class_Time_defined
  if(Time_program) {
#line 3111 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    free_program(Time_program);
    Time_program=0;
  }

#endif /* class_Time_defined */

#ifdef class_Timer_defined
  if(Timer_program) {
#line 3197 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    free_program(Timer_program);
    Timer_program=0;
  }

#endif /* class_Timer_defined */

#ifdef class_automap_marker_defined
  if(automap_marker_program) {
#line 3256 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    free_program(automap_marker_program);
    automap_marker_program=0;
  }

#endif /* class_automap_marker_defined */

#ifdef class_SqlNull_defined
  if(SqlNull_program) {
#line 3538 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    free_program(SqlNull_program);
    SqlNull_program=0;
  }

#endif /* class_SqlNull_defined */

#ifdef class_List_defined

#ifdef class_List_cq__get_iterator_defined
  if(List_cq__get_iterator_program) {
#line 3921 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    free_program(List_cq__get_iterator_program);
    List_cq__get_iterator_program=0;
  }

#endif /* class_List_cq__get_iterator_defined */
  if(List_program) {
#line 3623 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    free_program(List_program);
    List_program=0;
  }

#endif /* class_List_defined */

#ifdef class_MasterCodec_defined
  if(MasterCodec_program) {
#line 4335 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
    free_program(MasterCodec_program);
    MasterCodec_program=0;
  }

#endif /* class_MasterCodec_defined */
#line 4429 "/home/zino/hack/pike-distbuilder/7.8/src/builtin.cmod"
#ifndef DO_PIKE_CLEANUP
  /* This is performed by exit_builtin_modules() at a later point
   * in this case, so that the pike_list_node's are valid at cleanup
   * time, thus avoiding "got invalid pointer" fatals at exit.
   */
  free_all_pike_list_node_blocks();
#endif
#ifndef USE_SETENV
  if (env_allocs) free_mapping (env_allocs);
#endif
}

