/*
 * Permafrost - Physical modelling framework
 *
 * Copyright (C) 2009, 2010 Stefano D'Angelo <zanga.mail@gmail.com>
 *
 * See the COPYING file for license conditions.
 */

#ifndef _TYPES_H_
#define _TYPES_H_

#include <stddef.h>

typedef struct _list * list_t;
typedef struct _expr * expr_t;

enum port_type
  {
	port_type_input,
	port_type_output,
	port_type_w,
	port_type_k
  };

enum port_sync
  {
	port_sync_unknown,
	port_sync_sync,
	port_sync_async
  };

enum conn_elem_type
  {
	conn_elem_type_value,
	conn_elem_type_port,
	conn_elem_type_in,
	conn_elem_type_out
  };

enum delay_buf_type
  {
	delay_buf_type_none,
	delay_buf_type_single,
	delay_buf_type_fixed,
	delay_buf_type_var
  };

struct const_v
  {
	char	*id;
	double	 value;
  };

struct ext_func
  {
	char		*id;
	char		*f_id;
	char		*d_id;
	unsigned long	 n_args;
	char		*include;
	char		*lib;
  };

struct port
  {
	enum port_sync	 sync;
	enum port_type	 type;
	char		*id;
  };

struct component
  {
	union
	  {
		char		*id;
		struct
		  {
			char	 is_macro;
			void	*p;
		  } t;
	  } type;
	char			*id;
  };

struct conn_elem
  {
	enum conn_elem_type			 type;
	union
	  {
		struct
		  {
			char			*component;
			char			*port;
		  } id;
		struct
		  {
			struct component	*component;
			struct port		*port;
		  } p;
		double				 value;
	  } c;
  };

struct connection
  {
	struct conn_elem	output;
	struct conn_elem	input;
  };

struct stmt
  {
	union
	  {
		struct
		  {
			char	*id;
			char	 out;
		  } id;
		struct port	*port;
	  } out;
	expr_t			 expr;
  };

struct block
  {
	char	*id;
	list_t	 ports;
	list_t	 stmts;
  };

struct system
  {
	char	*id;
	list_t	 ports;
	list_t	 components;
	list_t	 connections;
  };

struct expr_signal_id
  {
	char	*id;
	char	 in;
  };

struct delay
  {
	expr_t	delay;
	expr_t	delay_max;
  };

struct scheduled_expr
  {
	struct component	*component;
	struct port		*port;
	char			 is_output;
	expr_t			 expr;
	list_t			 refs;
	list_t			 df_refs;
	list_t			 is_refd;
	char			 is_df_refd;
	size_t			 df_refd_count;
	list_t			 delays;
	enum delay_buf_type	 db_type;
	double			 delay_min;
	size_t			 index;
  };

struct scheduled_system
  {
	struct system	*system;
	list_t		 exprs;
	list_t		 schedule;
	list_t		 schedule_d;
	char		 has_single_delay;
	char		 has_fixed_delay;
	char		 has_var_delay;
	char		 uses_sample_rate;
  };

#endif /* !_TYPES_H_ */
