%{
/*
 * Permafrost - Physical modelling framework
 *
 * Copyright (C) 2009, 2010 Stefano D'Angelo <zanga.mail@gmail.com>
 *
 * See the COPYING file for license conditions.
 */

#include "src/types.h"
#include "src/util.h"
#include "src/parser.tab.h"

#define YY_USER_ACTION \
	yylloc->first_line = yylineno; \
	yylloc->first_column = yycolumn; \
	yycolumn += yyleng; \
	yylloc->last_line = yylloc->first_line; \
	yylloc->last_column = yycolumn - 1;
%}

NEWLINE (\n|\n\r|\r\n)

%option header-file="src/scanner.h"
%option outfile="src/scanner.c"
%option batch
%option 8bit
%option noyywrap
%option bison-bridge
%option bison-locations
%option reentrant
%option nounistd
%option full
%option warn
%option nounput
%option never-interactive

%%

[ ]			/* eat spaces */ ;
\t			yycolumn += 7; yylloc->last_column += 7; /* eat tabs */
{NEWLINE}		yylloc->last_line = ++yylineno; yylloc->last_column = yycolumn = 0; /* eat newlines */
#.*			/* eat comments */ ;

import			return IMPORT;
const			return CONST;
ext_function		return EXT_FUNCTION;
block			return BLOCK;
macro			return MACRO;
system			return SYSTEM;
sync			return SYNC;
async			return ASYNC;
input			return INPUT;
output			return OUTPUT;
w_port			return W_PORT;
k_port			return K_PORT;
in			return IN;
out			return OUT;
sample_rate		return SAMPLE_RATE;

;			return SEMICOLON;
\{			return LBRACE;
\}			return RBRACE;
\.			return DOT;
,			return COMA;
=			return EQUALS;
\+			return PLUS;
\-			return MINUS;
\*			return ASTERISK;
\/			return SLASH;
\(			return LPAR;
\)			return RPAR;
\[			return LSBRACKET;
\]			return RSBRACKET;

[A-Za-z_][A-Za-z0-9_]*	yylval->str = copy_str(yytext); return ID;
\"[A-Za-z0-9_\\/\-\.]*\"	yylval->str = copy_str_no_q(yytext); return STRING;

0|[1-9][0-9]*		sscanf(yytext, "%lu", &yylval->l); return INTEGER;
(0?|[1-9]*[0-9]*)\.[0-9]+([eE][\+\-]?[0-9]+)?|(0|[1-9][0-9]*)\.([eE][\+\-]?[0-9]+)?	sscanf(yytext, "%lf", &yylval->val); return FLOAT;

.			return yytext[0];

%%
