/* Test of freadahead() function.
   Copyright (C) 2007 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.  */

/* Written by Bruno Haible <bruno@clisp.org>, 2007.  */

#include <config.h>

#include "freadahead.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#define ASSERT(expr) \
  do									     \
    {									     \
      if (!(expr))							     \
        {								     \
          fprintf (stderr, "%s:%d: assertion failed\n", __FILE__, __LINE__); \
          abort ();							     \
        }								     \
    }									     \
  while (0)

int
main (int argc, char **argv)
{
  int nbytes = atoi (argv[1]);
  if (nbytes > 0)
    {
      void *buf = malloc (nbytes);
      ASSERT (fread (buf, 1, nbytes, stdin) == nbytes);
    }

  if (nbytes == 0)
    ASSERT (freadahead (stdin) == 0);
  else
    {
      if (lseek (0, 0, SEEK_CUR) == nbytes)
	/* An unbuffered stdio, such as BeOS or on uClibc compiled without
	   __STDIO_BUFFERS.  */
	ASSERT (freadahead (stdin) == 0);
      else
	/* Normal buffered stdio.  */
	ASSERT (freadahead (stdin) != 0);
    }

  return 0;
}
