/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import java.util.ArrayList;
import org.j3d.geom.particle.ParticleSystem;
import org.j3d.util.DefaultErrorReporter;
import org.j3d.util.ErrorReporter;

public class ParticleSystemManager {
    private ArrayList particleSystems = new ArrayList();
    private ArrayList newSystems = new ArrayList();
    protected ErrorReporter errorReporter;

    public ParticleSystemManager() {
        this.particleSystems = new ArrayList();
        this.newSystems = new ArrayList();
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
        int n = this.particleSystems.size();
        for (int i = 0; i < n; ++i) {
            ParticleSystem particleSystem = (ParticleSystem)this.particleSystems.get(i);
            particleSystem.setErrorReporter(errorReporter);
        }
    }

    public void update() {
        ParticleSystem particleSystem;
        int n;
        long l = System.currentTimeMillis();
        for (n = this.newSystems.size() - 1; n >= 0; --n) {
            particleSystem = (ParticleSystem)this.newSystems.get(n);
            particleSystem.initialize(l);
        }
        this.newSystems.clear();
        for (n = this.particleSystems.size() - 1; n >= 0; --n) {
            particleSystem = (ParticleSystem)this.particleSystems.get(n);
            if (particleSystem == null || particleSystem.update(l)) continue;
            particleSystem.onRemove();
            this.particleSystems.remove(n);
        }
    }

    public void addParticleSystem(ParticleSystem particleSystem) {
        this.particleSystems.add(particleSystem);
        this.newSystems.add(particleSystem);
        particleSystem.setErrorReporter(this.errorReporter);
    }

    public void removeParticleSystem(ParticleSystem particleSystem) {
        this.particleSystems.remove(particleSystem);
    }
}

