///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __POVRAY_MESH_EXPORT_INTERFACE_H
#define __POVRAY_MESH_EXPORT_INTERFACE_H

#include <core/Core.h>
#include "POVRayExportInterface.h"
 
namespace POVRay {

/******************************************************************************
* This class exports MeshObjects to a POV-Ray file.
******************************************************************************/
class POVRAY_DLLEXPORT MeshExportInterface : public POVRayExportInterface
{
public:
	/// The default constructor.
	MeshExportInterface() : POVRayExportInterface() {}

	/// Exports the given scene object in the POV-Ray format and returns true.
	/// Return false if the scene object type is not supported by this interface class.
	/// Throws an exception if an error occured.
	virtual bool ExportSceneObject(SceneObject* sceneObj, POVRayWriter& writer, ObjectNode* contextNode, const AffineTransformation& objToWorldTM);

private:
	Q_OBJECT
	DECLARE_PLUGIN_CLASS(MeshExportInterface)
};

};

#endif // __POVRAY_MESH_EXPORT_INTERFACE_H
