///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <core/Core.h>
#include <core/gui/properties/IntegerPropertyUI.h>
#include "PreviewRenderer.h"
#include "PreviewRendererEditor.h"

namespace Core {

IMPLEMENT_PLUGIN_CLASS(PreviewRendererEditor, PropertiesEditor)

/******************************************************************************
* Constructor that creates the UI controls for the editor.
******************************************************************************/
void PreviewRendererEditor::createUI(const RolloutInsertionParameters& rolloutParams)
{
	// Create the rollout.
	QWidget* rollout = createRollout(tr("Preview renderer settings"), rolloutParams, "core.rendering.preview_renderer");
	
	QGridLayout* layout = new QGridLayout(rollout);
	layout->setContentsMargins(4,4,4,4);
	layout->setSpacing(0);
	layout->setColumnStretch(1, 1);
	
	// Antialiasing level	
	IntegerPropertyUI* antialiasingLevelUI = new IntegerPropertyUI(this, PROPERTY_FIELD_DESCRIPTOR(PreviewRenderer, _antialiasingLevel));
	layout->addWidget(antialiasingLevelUI->label(), 0, 0);
	layout->addWidget(antialiasingLevelUI->textBox(), 0, 1);
	layout->addWidget(antialiasingLevelUI->spinner(), 0, 2);
	antialiasingLevelUI->setMinValue(1);
	antialiasingLevelUI->setMaxValue(6);	
}

};
