///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <core/Core.h>
#include <core/actions/ActionManager.h>
#include <core/gui/mainwnd/SettingsDialog.h>
#include <core/gui/mainwnd/MainFrame.h>
#include "StdActions.h"

namespace Core {

/// Constructs the action objects and registers them with the ActionManager. 
OptionsActionsHandler::OptionsActionsHandler()
{
	connect(addCommandAction(ACTION_SETTINGS_DIALOG, tr("&Settings...")), SIGNAL(triggered(bool)), this, SLOT(OnSettingsDialog()));
}

/// Creates and registers a single command action.
ActionProxy* OptionsActionsHandler::addCommandAction(const QString& id, const QString& title, const char* iconPath, const QKeySequence& shortcut) 
{
	ActionProxy* proxy = ACTION_MANAGER.addAction(new Action(id), title, iconPath);
	if(!shortcut.isEmpty()) proxy->setShortcut(shortcut);	
	return proxy;
}

/// Handles ACTION_SETTINGS_DIALOG command.
void OptionsActionsHandler::OnSettingsDialog() 
{
	if(APPLICATION_MANAGER.guiMode()) {
		SettingsDialog dlg(MAIN_FRAME);
		dlg.exec();
	}
}

};

