
/******************************************************************************
**
**  Copyright (C) 2006 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/*****************************************************************************
**
**  File:    common.h
**  Date:    June 2, 2002
**
**  Author:  Brian Wotring
**  Purpose: common globals and constants that this management daemon uses.
**
******************************************************************************/

#ifndef COMMON_H_
#define COMMON_H_


#ifdef WIN32
#define THREAD_FUNCTION_TYPE unsigned __stdcall
#else
#define THREAD_FUNCTION_TYPE void
#endif

#ifdef WIN32
#define THREAD_RETURN_VALUE 0
#else
#define THREAD_RETURN_VALUE
#endif

/* exit codes for this daemon. */

#define EXIT_CODE_ERROR  -1
#define EXIT_CODE_NORMAL  0


#define HOSTS_DIRECTORY_NAME		    "hosts"
#define CERTS_DIRECTORY_NAME		    "certs"
#define KEY_DIRECTORY_NAME		        "private"
#define SHARED_CONFIGS_DIRECTORY_NAME   "configs"
#define NOTIFY_FILTER_DB_NAME           "filter.db"
#define NOTIFY_FILTER_FILE_NAME           "filter"

#define HOST_CONFIG_FILE_NAME		    "host.conf"
#define HOST_CONFIG_DIRECTORY_NAME	    "configs"
#define HOST_DATABASE_DIRECTORY_NAME	"databases"
#define HOST_LOG_DIRECTORY_NAME         "logs"

#define CERT_NAME 			            "osirismd.crt"
#define KEY_NAME  			            "osirismd.key"

#define AUTH_DB_NAME                    "auth.db"
#define TEMP_SCAN_LOG_FILE_NAME         "log.temp"

#ifdef WIN32
#define DEFAULT_CONFIG_PATH		    OSIRISMD_CONF_DIR "\\"\
                                    MANAGEMENT_CONFIG_FILE_NAME
#else
#define DEFAULT_CONFIG_PATH		    OSIRISMD_CONF_DIR "/"\
                                    MANAGEMENT_CONFIG_FILE_NAME
#endif

#define OSI_DEFAULT_PERMISSIONS		0600
#define MAX_SCAN_DATA_ERRORS		5

#define SCAN_LOG_FILE_FORMAT        "%b-%d-%H%M%S-%Y.log"

#endif
