/* Test 0 of OAP HELP.
 * $Id$
 * Description: Test the OAP HELP command.
 *
 * Authors:
 * Matthew Mundell <matthew.mundell@greenbone.net>
 *
 * Copyright:
 * Copyright (C) 2009 Greenbone Networks GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * or, at your option, any later version as published by the Free
 * Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <glib.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "common.h"
#include "../tracef.h"

static char* help_text = "\n"
"    AUTHENTICATE     Authenticate with the administrator.\n"
"    COMMANDS         Run a list of commands.\n"
"    CREATE_USER      Create a new user.\n"
"    DELETE_USER      Delete an existing user.\n"
"    DESCRIBE_AUTH    Get details about the used authentication methods.\n"
"    DESCRIBE_FEED    Get details of the NVT feed this administrator uses.\n"
"    GET_SETTINGS     Get scanner settings.\n"
"    GET_USERS        Get all users.\n"
"    GET_VERSION      Get the OpenVAS Administrator Protocol version.\n"
"    HELP             Get this help text.\n"
"    MODIFY_AUTH      Modify the authentication methods.\n"
"    MODIFY_USER      Modify a user.\n"
"    SYNC_FEED        Synchronize with an NVT feed.\n";

int
main ()
{
  int socket;
  gnutls_session_t session;

  setup_test ();

  socket = connect_to_manager (&session);
  if (socket == -1) return EXIT_FAILURE;

  /* Request the help text. */

  if (omp_authenticate_env (&session))
    {
      close_manager_connection (socket, session);
      return EXIT_FAILURE;
    }

  if (openvas_server_send (&session, "<help/>") == -1)
    {
      close_manager_connection (socket, session);
      return EXIT_FAILURE;
    }

  /* Read the response. */

  entity_t entity = NULL;
  read_entity (&session, &entity);

  /* Compare to expected response. */

  entity_t expected = add_entity (NULL, "help_response", help_text);
  add_attribute (expected, "status", "200");
  add_attribute (expected, "status_text", "OK");

  if (compare_entities (entity, expected))
    {
      free_entity (entity);
      free_entity (expected);
      close_manager_connection (socket, session);
      return EXIT_FAILURE;
    }

  free_entity (expected);
  free_entity (entity);
  close_manager_connection (socket, session);
  return EXIT_SUCCESS;
}
