// $Id: MSXMirrorDevice.cc 9571 2009-04-13 19:37:05Z mthuurne $

#include "MSXMirrorDevice.hh"
#include "MSXMotherBoard.hh"
#include "MSXCPUInterface.hh"
#include "XMLElement.hh"
#include "MSXException.hh"
#include "serialize.hh"

namespace openmsx {

static unsigned getAddressHigh(const XMLElement& config)
{
	unsigned prim = config.getChildDataAsInt("ps");
	unsigned sec  = config.getChildDataAsInt("ss", 0);
	if ((prim >= 4) || (sec >= 4)) {
		throw MSXException("Invalid slot in mirror device.");
	}
	return (prim << 18) | (sec << 16);
}

MSXMirrorDevice::MSXMirrorDevice(MSXMotherBoard& motherBoard, const XMLElement& config)
	: MSXDevice(motherBoard, config)
	, interface(motherBoard.getCPUInterface())
	, addressHigh(getAddressHigh(config))
{
}

byte MSXMirrorDevice::peekMem(word address, EmuTime::param time) const
{
	return interface.peekSlottedMem(addressHigh | address, time);
}

byte MSXMirrorDevice::readMem(word address, EmuTime::param time)
{
	return interface.readSlottedMem(addressHigh | address, time);
}

void MSXMirrorDevice::writeMem(word address, byte value, EmuTime::param time)
{
	interface.writeSlottedMem(addressHigh | address, value, time);
}

const byte* MSXMirrorDevice::getReadCacheLine(word /*start*/) const
{
	return NULL;
}

byte* MSXMirrorDevice::getWriteCacheLine(word /*start*/) const
{
	return NULL;
}

template<typename Archive>
void MSXMirrorDevice::serialize(Archive& ar, unsigned /*version*/)
{
	ar.template serializeBase<MSXDevice>(*this);
}
INSTANTIATE_SERIALIZE_METHODS(MSXMirrorDevice);
REGISTER_MSXDEVICE(MSXMirrorDevice, "Mirror");

} // namespace openmsx
