#ifndef VIEW_H
#define VIEW_H

#include <QWidget>
#include <QAction>
#include <QList>

#include <AIS_InteractiveContext.hxx>
#include <V3d_View.hxx>

class TopoDS_Shape;
class QRubberBand;

class View: public QWidget
{
    Q_OBJECT
    enum CurrentAction3d { CurAction3d_Nothing, CurAction3d_DynamicZooming,
			               CurAction3d_WindowZooming, CurAction3d_DynamicPanning,
			               CurAction3d_GlobalPanning, CurAction3d_DynamicRotation };

public:
    enum ViewAction { ViewFitAllId, ViewFitAreaId, ViewZoomId, ViewPanId, ViewGlobalPanId,
                      ViewFrontId, ViewBackId, ViewTopId, ViewBottomId, ViewLeftId, ViewRightId,
                      ViewAxoId, ViewRotationId, ViewResetId, ViewHlrOffId, ViewHlrOnId };

    View( Handle(AIS_InteractiveContext) theContext,
          QWidget* parent);
    ~View();

    void                          init();
    bool                          dump( Standard_CString theFile );
    QList<QAction*>*              getViewActions();
    void                          noActiveActions();
    bool                          isShadingMode();

    static QString                GetMessages( int type,TopAbs_ShapeEnum aSubShapeType,
                                               TopAbs_ShapeEnum aShapeType );
    static QString                GetShapeType( TopAbs_ShapeEnum aShapeType );

    Standard_EXPORT static void   OnButtonuseraction( int ExerciceSTEP,
						                              Handle(AIS_InteractiveContext)& );
    Standard_EXPORT static void   DoSelection( int Id,
                                               Handle(AIS_InteractiveContext)& );
    Standard_EXPORT static void   OnSetSelectionMode( Handle(AIS_InteractiveContext)&,
                                                      Standard_Integer&,
						                              TopAbs_ShapeEnum& SelectionMode,
						                              Standard_Boolean& );
signals:
    void                          selectionChanged();

public slots:
    void                          fitAll();
    void                          fitArea();
    void                          zoom();
    void                          pan();
    void                          globalPan();
    void                          front();
    void                          back();
    void                          top();
    void                          bottom();
    void                          left();
    void                          right();
    void                          axo();
    void                          rotation();
    void                          reset();
    void                          hlrOn();
    void                          hlrOff();
    void                          updateToggled( bool );
    void                          onBackground();

protected:
    virtual void                  paintEvent( QPaintEvent* );
    virtual void                  resizeEvent( QResizeEvent* );
    virtual void                  mousePressEvent( QMouseEvent* );
    virtual void                  mouseReleaseEvent(QMouseEvent* );
    virtual void                  mouseMoveEvent( QMouseEvent* );

private:
    void                          initCursors();
    void                          initViewActions();
    void                          onLButtonDown( const int nFlags, const QPoint point );
    void                          onMButtonDown( const int nFlags, const QPoint point );
    void                          onRButtonDown( const int nFlags, const QPoint point );
    void                          onLButtonUp( Qt::MouseButtons nFlags, const QPoint point );
    void                          onMButtonUp( Qt::MouseButtons nFlags, const QPoint point );
    void                          onRButtonUp( Qt::MouseButtons nFlags, const QPoint point );
    void                          onMouseMove( Qt::MouseButtons nFlags, const QPoint point );
    void                          DragEvent( const int x, const int y, const int TheState );
    void                          InputEvent( const int x, const int y );
    void                          MoveEvent( const int x, const int y );
    void                          MultiMoveEvent( const int x, const int y );
    void                          MultiDragEvent( const int x, const int y, const int TheState );
    void                          MultiInputEvent( const int x, const int y );
    void                          Popup( const int x, const int y );
    void                          DrawRectangle( const int MinX, const int MinY,
                                                 const int MaxX, const int MaxY, const bool Draw );
    void                          activateCursor( const CurrentAction3d );

private:
    bool                            myFirst;
    bool		                        myDrawRect;           // set when a rect is used for selection or magnify 
    Handle(V3d_View)                myView;
    Handle(AIS_InteractiveContext)  myContext;
    CurrentAction3d                 myCurrentMode;
    Standard_Integer                myXmin;
    Standard_Integer                myYmin;
    Standard_Integer                myXmax;
    Standard_Integer                myYmax;
    Quantity_Factor                 myCurZoom;
    Standard_Boolean                myDegenerateModeIsOn;
    QList<QAction*>*                myViewActions;
    QRubberBand*                    myRectBand; //!< selection rectangle rubber band
};

#endif


