// AISDisplayModeView.cpp : implementation of the CAISDisplayModeView class
//

#include "stdafx.h"
#include "AISDisplayModeApp.h"

#include "AISDisplayModeDoc.h"
#include "AISDisplayModeView.h"

gp_Pnt ConvertClickToPoint(Standard_Real x, Standard_Real y, Handle(V3d_View) aView);

#define ValZWMin 1

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

Handle (AIS_Shape) S;
Handle(V3d_DirectionalLight) alight;
gp_Pnt p1,p2;

/////////////////////////////////////////////////////////////////////////////
// CAISDisplayModeView

IMPLEMENT_DYNCREATE(CAISDisplayModeView, CView)

BEGIN_MESSAGE_MAP(CAISDisplayModeView, OCC_3dView)
	//{{AFX_MSG_MAP(CAISDisplayModeView)
	ON_COMMAND(ID_BUTTONPan, OnBUTTONPan)
	ON_COMMAND(ID_BUTTONPanGlo, OnBUTTONPanGlo)
	ON_COMMAND(ID_BUTTONRot, OnBUTTONRot)
	ON_COMMAND(ID_BUTTONZoomProg, OnBUTTONZoomProg)
	ON_COMMAND(ID_BUTTONZoomWin, OnBUTTONZoomWin)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_UPDATE_COMMAND_UI(ID_BUTTONHlrOff, OnUpdateBUTTONHlrOff)
	ON_UPDATE_COMMAND_UI(ID_BUTTONHlrOn, OnUpdateBUTTONHlrOn)
	ON_UPDATE_COMMAND_UI(ID_BUTTONPanGlo, OnUpdateBUTTONPanGlo)
	ON_UPDATE_COMMAND_UI(ID_BUTTONPan, OnUpdateBUTTONPan)
	ON_UPDATE_COMMAND_UI(ID_BUTTONZoomProg, OnUpdateBUTTONZoomProg)
	ON_UPDATE_COMMAND_UI(ID_BUTTONZoomWin, OnUpdateBUTTONZoomWin)
	ON_UPDATE_COMMAND_UI(ID_BUTTONRot, OnUpdateBUTTONRot)
	ON_COMMAND(ID_LIGTHS, OnLigths)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAISDisplayModeView construction/destruction

CAISDisplayModeView::CAISDisplayModeView()
{
	// TODO: add construction code here
    myCurrentMode = CurrentAction3d_Nothing;
}

CAISDisplayModeView::~CAISDisplayModeView()
{
}

////////////////////////////////////////////////////////////////////////////
// CAISDisplayModeView drawing
void CAISDisplayModeView::OnInitialUpdate() 
{
	OCC_3dView::OnInitialUpdate();
	
    myCurrentMode = CurrentAction3d_Nothing;
}

/////////////////////////////////////////////////////////////////////////////
// CAISDisplayModeView diagnostics

#ifdef _DEBUG
void CAISDisplayModeView::AssertValid() const
{
	CView::AssertValid();
}

void CAISDisplayModeView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CAISDisplayModeDoc* CAISDisplayModeView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CAISDisplayModeDoc)));
	return (CAISDisplayModeDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CAISDisplayModeView message handlers

void CAISDisplayModeView::OnBUTTONPan() 
{  myCurrentMode = CurrentAction3d_DynamicPanning; }

void CAISDisplayModeView::OnBUTTONPanGlo() 
{
  // save the current zoom value 
  myCurZoom = myView->Scale();
  // Do a Global Zoom 
  //myView->FitAll();
  // Set the mode 
  myCurrentMode = CurrentAction3d_GlobalPanning;
}

void CAISDisplayModeView::OnBUTTONRot() 
{   myCurrentMode = CurrentAction3d_DynamicRotation; }

void CAISDisplayModeView::OnBUTTONZoomProg() 
{  myCurrentMode = CurrentAction3d_DynamicZooming; }

void CAISDisplayModeView::OnBUTTONZoomWin() 
{  myCurrentMode = CurrentAction3d_WindowZooming; }

void CAISDisplayModeView::OnLButtonDown(UINT nFlags, CPoint point) 
{
  //  save the current mouse coordinate in min 
  myXmin=point.x;  myYmin=point.y;
  myXmax=point.x;  myYmax=point.y;

  if ( nFlags & MK_CONTROL ) 
	  {
	    // Button MB1 down Control :start zomming 
        // SetCursor(AfxGetApp()->LoadStandardCursor());
	  }
	else // if ( Ctrl )
	  {
        switch (myCurrentMode)
        {
         case CurrentAction3d_Nothing : // start a drag
           if (nFlags & MK_SHIFT)
       	        GetDocument()->ShiftDragEvent(myXmax,myYmax,-1,myView);
           else
                GetDocument()->DragEvent(myXmax,myYmax,-1,myView);
        break;
         break;
         case CurrentAction3d_DynamicZooming : // noting
             // SetCursor(AfxGetApp()->LoadStandardCursor());
         break;
         case CurrentAction3d_WindowZooming : 
         break;
         case CurrentAction3d_DynamicPanning :// noting
             // SetCursor(AfxGetApp()->LoadStandardCursor());
         break;
         case CurrentAction3d_GlobalPanning :// noting
             // SetCursor(AfxGetApp()->LoadStandardCursor());
        break;
        case  CurrentAction3d_DynamicRotation :
             // SetCursor(AfxGetApp()->LoadStandardCursor());
			if (!myDegenerateModeIsOn)
			  myView->SetDegenerateModeOn();
			myView->StartRotation(point.x,point.y);  
        break;
		case CurrentAction3d_FirstPointLight:
			{
			p1 = ConvertClickToPoint(point.x,point.y,myView);
			// Create a directional light
			alight = new V3d_DirectionalLight(GetDocument()->GetViewer(),
											  p1.X(),p1.Y(),p1.Z(),0.,0.,1.);
			p2 = gp_Pnt(p1.X(),p1.Y(),p1.Z()+1.);
			BRepBuilderAPI_MakeEdge E(p1,p2);
			S = new AIS_Shape(E.Edge());
			S->SetColor(Quantity_NOC_YELLOW);
			GetDocument()->GetAISContext()->Display(S);
			//Activate the light in the view
			myView->SetLightOn(alight);
			myCurrentMode = CurrentAction3d_SecondPointLight;
			}
			break;
		case CurrentAction3d_SecondPointLight:
			{
			GetDocument()->GetAISContext()->CloseLocalContext();
			myCurrentMode = CurrentAction3d_Nothing;
			}
			break;
        }
    }
}

void CAISDisplayModeView::OnLButtonUp(UINT nFlags, CPoint point) 
{
   if ( nFlags & MK_CONTROL ) 
	  {
        return;
	  }
	else // if ( Ctrl )
	  {
        switch (myCurrentMode)
        {
         case CurrentAction3d_Nothing :
         if (point.x == myXmin && point.y == myYmin)
         { // no offset between down and up --> selectEvent
            myXmax=point.x;  
            myYmax=point.y;
            if (nFlags & MK_SHIFT )
              GetDocument()->ShiftInputEvent(point.x,point.y,myView);
            else
              GetDocument()->InputEvent     (point.x,point.y,myView);
         } else
         {
            myXmax=point.x;  myYmax=point.y;
            DrawRectangle(myXmin,myYmin,myXmax,myYmax,Standard_False);
		    if (nFlags & MK_SHIFT)
				GetDocument()->ShiftDragEvent(point.x,point.y,1,myView);
			else
				GetDocument()->DragEvent(point.x,point.y,1,myView);
         }
         break;
         case CurrentAction3d_DynamicZooming :
             // SetCursor(AfxGetApp()->LoadStandardCursor());         
	       myCurrentMode = CurrentAction3d_Nothing;
         break;
         case CurrentAction3d_WindowZooming :
            DrawRectangle(myXmin,myYmin,myXmax,myYmax,Standard_False);
           myXmax=point.x;  
           myYmax=point.y;
	       if ((abs(myXmin-myXmax)>ValZWMin) || (abs(myYmin-myYmax)>ValZWMin))
					 // Test if the zoom window is greater than a minimale window.
			{
			  // Do the zoom window between Pmin and Pmax
			  myView->WindowFitAll(myXmin,myYmin,myXmax,myYmax);  
			}  
	       myCurrentMode = CurrentAction3d_Nothing;
         break;
         case CurrentAction3d_DynamicPanning :
           myCurrentMode = CurrentAction3d_Nothing;
         break;
         case CurrentAction3d_GlobalPanning :
	       myView->Place(point.x,point.y,myCurZoom); 
	       myCurrentMode = CurrentAction3d_Nothing;
        break;
        case  CurrentAction3d_DynamicRotation :
	       myCurrentMode = CurrentAction3d_Nothing;
        break;
 
        } //switch (myCurrentMode)
    } //	else // if ( Ctrl )
}

void CAISDisplayModeView::OnMouseMove(UINT nFlags, CPoint point) 
{
    //   ============================  LEFT BUTTON =======================
  if ( nFlags & MK_LBUTTON)
    {
     if ( nFlags & MK_CONTROL ) 
	  {
	    // move with MB1 and Control : on the dynamic zooming  
	    // Do the zoom in function of mouse's coordinates  
	    myView->Zoom(myXmax,myYmax,point.x,point.y); 
	    // save the current mouse coordinate in min 
		myXmax = point.x; 
        myYmax = point.y;	
	  }
	  else // if ( Ctrl )
	  {
        switch (myCurrentMode)
        {
         case CurrentAction3d_Nothing :
            DrawRectangle(myXmin,myYmin,myXmax,myYmax,Standard_False);
		   myXmax = point.x; 
           myYmax = point.y;
           if (nFlags & MK_SHIFT)		
       	     GetDocument()->ShiftDragEvent(myXmax,myYmax,0,myView);
           else
             GetDocument()->DragEvent(myXmax,myYmax,0,myView);
            DrawRectangle(myXmin,myYmin,myXmax,myYmax,Standard_True);
          break;
         case CurrentAction3d_DynamicZooming :
	       myView->Zoom(myXmax,myYmax,point.x,point.y); 
	       // save the current mouse coordinate in min \n";
	       myXmax=point.x;  myYmax=point.y;
         break;
         case CurrentAction3d_WindowZooming :
		   myXmax = point.x; myYmax = point.y;	
            DrawRectangle(myXmin,myYmin,myXmax,myYmax,Standard_False,LongDash);
            DrawRectangle(myXmin,myYmin,myXmax,myYmax,Standard_True,LongDash);
         break;
         case CurrentAction3d_DynamicPanning :
		   myView->Pan(point.x-myXmax,myYmax-point.y); // Realize the panning
		   myXmax = point.x; myYmax = point.y;	
         break;
         case CurrentAction3d_GlobalPanning : // nothing           
        break;
        case  CurrentAction3d_DynamicRotation :
          myView->Rotation(point.x,point.y);
	      myView->Redraw();
        break;

        }//  switch (myCurrentMode)
      }// if ( nFlags & MK_CONTROL )  else 
    } else //   if ( nFlags & MK_LBUTTON) 
    //   ============================  MIDDLE BUTTON =======================
    if ( nFlags & MK_MBUTTON)
    {
     if ( nFlags & MK_CONTROL ) 
	  {
		myView->Pan(point.x-myXmax,myYmax-point.y); // Realize the panning
		myXmax = point.x; myYmax = point.y;	

	  }
    } else //  if ( nFlags & MK_MBUTTON)
    //   ============================  RIGHT BUTTON =======================
    if ( nFlags & MK_RBUTTON)
    {
     if ( nFlags & MK_CONTROL ) 
	  {
      	 myView->Rotation(point.x,point.y);
	  }
    }else //if ( nFlags & MK_RBUTTON)
    //   ============================  NO BUTTON =======================
    {  // No buttons 
	  myXmax = point.x; myYmax = point.y;
	  if (myCurrentMode ==  CurrentAction3d_SecondPointLight) {
		p2 = ConvertClickToPoint(point.x,point.y,myView);
		BRepBuilderAPI_MakeEdge E(p1,p2);
		S->Set(E.Edge());
		GetDocument()->GetAISContext()->Redisplay(S);
		//Update the light dynamically
		alight->SetDirection(p2.X()-p1.X(),p2.Y()-p1.Y(),p2.Z()-p1.Z());
		myView->UpdateLights();
	  }
	  if (nFlags & MK_SHIFT)
		GetDocument()->ShiftMoveEvent(point.x,point.y,myView);
	  else
		GetDocument()->MoveEvent(point.x,point.y,myView);
   }
}

void CAISDisplayModeView::OnLigths() 
{

	myCurrentMode = CurrentAction3d_FirstPointLight;
	GetDocument()->GetAISContext()->OpenLocalContext();
}


void CAISDisplayModeView::OnUpdateBUTTONPanGlo(CCmdUI* pCmdUI) 
{
    pCmdUI->SetCheck (myCurrentMode == CurAction3d_GlobalPanning);
	pCmdUI->Enable   (myCurrentMode != CurAction3d_GlobalPanning);	
	
}

void CAISDisplayModeView::OnUpdateBUTTONPan(CCmdUI* pCmdUI) 
{
    pCmdUI->SetCheck (myCurrentMode == CurAction3d_DynamicPanning);
	pCmdUI->Enable   (myCurrentMode != CurAction3d_DynamicPanning );	
}

void CAISDisplayModeView::OnUpdateBUTTONZoomProg(CCmdUI* pCmdUI) 
{
    pCmdUI->SetCheck (myCurrentMode == CurAction3d_DynamicZooming );
	pCmdUI->Enable   (myCurrentMode != CurAction3d_DynamicZooming);	
}

void CAISDisplayModeView::OnUpdateBUTTONZoomWin(CCmdUI* pCmdUI) 
{
    pCmdUI->SetCheck (myCurrentMode == CurAction3d_WindowZooming);
	pCmdUI->Enable   (myCurrentMode != CurAction3d_WindowZooming);	
}

void CAISDisplayModeView::OnUpdateBUTTONRot(CCmdUI* pCmdUI) 
{
    pCmdUI->SetCheck (myCurrentMode == CurAction3d_DynamicRotation);
	pCmdUI->Enable   (myCurrentMode != CurAction3d_DynamicRotation);	
}
