// AISBasicDoc.cpp: implementation of the CAISBasicDoc class.
//
//////////////////////////////////////////////////////////////////////
#include <stdafx.h>
#include "AISBasicDoc.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

IMPLEMENT_DYNCREATE(CAISBasicDoc, CDocument)

BEGIN_MESSAGE_MAP(CAISBasicDoc, CDocument)
	//{{AFX_MSG_MAP(CAISBasicDoc)
	ON_COMMAND(ID_CIRCLE, OnCircle)
	ON_COMMAND(ID_SPHERE, OnSphere)
	ON_COMMAND(ID_CYLINDER, OnCylinder)
	ON_COMMAND(ID_LINE, OnLine)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


CAISBasicDoc::CAISBasicDoc()
{
	//Create and display a trihedron in the viewer
	Handle(AIS_Trihedron) aTrihedron;
	Handle(Geom_Axis2Placement) anAxis=new Geom_Axis2Placement(gp::XOY());
	aTrihedron=new AIS_Trihedron(anAxis);
	myAISContext->Display(aTrihedron);
}

CAISBasicDoc::~CAISBasicDoc()
{

}

// Create and display a circle with standard tools
void CAISBasicDoc::OnCircle() 
{
	GC_MakeCircle C(gp_Pnt(-100.,-300.,0.),gp_Pnt(-50.,-200.,0.),gp_Pnt(-10.,-250.,0.));
	Handle(AIS_Circle) anAISCirc = new AIS_Circle(C.Value());
	myAISContext->Display(anAISCirc);

TCollection_AsciiString Message ("\
GC_MakeCircle C(gp_Pnt(-100.,-300.,0.),gp_Pnt(-50.,-200.,0.),gp_Pnt(-10.,-250.,0.));  \n\
\n\
Handle(AIS_Circle) anAISCirc = new AIS_Circle(C.Value());  \n\
\n\
myAISContext->Display(anAISCirc);  \n\
\n");

	CString text(Message.ToCString());
	myCResultDialog.SetTitle(CString("Create a circle"));
	myCResultDialog.SetText(text);
	SetTitle(CString("Create a circle"));
}

// Create and display a sphere with standard tools
void CAISBasicDoc::OnSphere() 
{
	BRepPrimAPI_MakeSphere S(gp_Pnt(200.,300.,200.), 100.);
	Handle(AIS_Shape) anAISShape = new AIS_Shape(S.Shape());
	myAISContext->SetColor(anAISShape,Quantity_NOC_AZURE); 
	myAISContext->SetMaterial(anAISShape,Graphic3d_NOM_PLASTIC);    
	myAISContext->SetDisplayMode(anAISShape,1);
	myAISContext->Display(anAISShape);	

TCollection_AsciiString Message ("\
BRepAPI_MakeSphere S(gp_Pnt(200.,300.,200.), 100.);  \n\
\n\
Handle(AIS_Shape) anAISShape = new AIS_Shape(S.Shape());  \n\
\n\
myAISContext->SetColor(anAISShape,Quantity_NOC_AZURE); \n\
\n\
myAISContext->SetMaterial(anAISShape,Graphic3d_NOM_PLASTIC);  \n\
\n\
myAISContext->SetDisplayMode(anAISShape,1);  \n\
\n\
myAISContext->Display(anAISShape);  \n\
\n");

	CString text(Message.ToCString());
	myCResultDialog.SetTitle(CString("Create a blue plastic sphere"));
	myCResultDialog.SetText(text);
	SetTitle(CString("Create a blue plastic sphere"));
}

// Create and display a cylinder with user defined presentation
void CAISBasicDoc::OnCylinder() 
{
	// TODO: Add your command handler code here
	Handle(User_Cylinder) aCyl = new User_Cylinder(100.,200.);
	if (aCyl.IsNull())
		return;
	myAISContext->SetDisplayMode(aCyl,1);
	myAISContext->Display(aCyl);
	
TCollection_AsciiString Message ("\
Handle(User_Cylinder) aCyl = new User_Cylinder(100.,200.);  \n\
\n\
myAISContext->SetDisplayMode(aCyl,1);  \n\
\n\
myAISContext->Display(aCyl); \n\
\n\
NOTE: a User_Cylinder is an object defined by the user.  \n\
The User_Cylinder class inherit from the AIS_InteractiveObject   \n\
Cascade class, it's use is the same as an AIS_InteractiveObject.   \n\
\n");

	CString text(Message.ToCString());
	myCResultDialog.SetTitle(CString("Create a cylinder"));
	myCResultDialog.SetText(text);
	SetTitle(CString("Create a cylinder"));
}

void CAISBasicDoc::OnLine() 
{
	// TODO: Add your command handler code here
	gp_Lin L(gp_Pnt(0.,0.,0.),gp_Dir(1.,0.,0.));
	Handle(Geom_Line) aLine = new Geom_Line(L);
	Handle(AIS_Line) anAISLine = new AIS_Line(aLine);
	myAISContext->Display(anAISLine);	

TCollection_AsciiString Message ("\
gp_Lin L(gp_Pnt(0.,0.,0.),gp_Dir(1.,0.,0.));  \n\
\n\
Handle(Geom_Line) aLine = new Geom_Line(L);  \n\
\n\
Handle(AIS_Line) anAISLine = new AIS_Line(aLine); \n\
\n\
myAISContext->Display(anAISLine);  \n\
\n");

	CString text(Message.ToCString());
	myCResultDialog.SetTitle(CString("Create a line"));
	myCResultDialog.SetText(text);
	SetTitle(CString("Create a line"));
}

void  CAISBasicDoc::Popup(const Standard_Integer  x,
							   const Standard_Integer  y ,
                               const Handle(V3d_View)& aView   ) 
{
  Standard_Integer PopupMenuNumber=0;
  myAISContext->InitCurrent();
  if (myAISContext->MoreCurrent())
    return;



  CMenu menu;
  VERIFY(menu.LoadMenu(IDR_Popup3D));
  CMenu* pPopup = menu.GetSubMenu(PopupMenuNumber);
  ASSERT(pPopup != NULL);
 
  POINT winCoord = { x , y };
  Handle(WNT_Window) aWNTWindow=
  Handle(WNT_Window)::DownCast(aView->Window());
  ClientToScreen ( (HWND)(aWNTWindow->HWindow()),&winCoord);
  pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON , winCoord.x, winCoord.y , 
                         AfxGetMainWnd());
}
