// File:	MDataStd.cxx
//      	------------
// Author:	DAUTRY Philippe
// Copyright:	Matra Datavision 1997

// Version:	0.0
// History:	Version	Date		Purpose
//		0.0	Aug  4 1997	Creation



#include <MDataStd.ixx>
#include <MDF_ASDriverTable.hxx>
#include <MDF_ARDriverTable.hxx>
#include <CDM_MessageDriver.hxx>
//
// Storage
//
#include <MDataStd_ShapeStorageDriver.hxx>
#include <MDataStd_DirectoryStorageDriver.hxx>
#include <MDataStd_UAttributeStorageDriver.hxx>
#include <MDataStd_IntegerArrayStorageDriver.hxx>
#include <MDataStd_RealArrayStorageDriver.hxx>
#include <MDataStd_ExtStringArrayStorageDriver.hxx>
#include <MDataStd_NameStorageDriver.hxx>
#include <MDataStd_CommentStorageDriver.hxx>
#include <MDataStd_IntegerStorageDriver.hxx>
//#include <MDataStd_ReferenceStorageDriver.hxx>
#include <MDataStd_PointStorageDriver.hxx>
#include <MDataStd_AxisStorageDriver.hxx>
#include <MDataStd_RealStorageDriver.hxx>
#include <MDataStd_PlaneStorageDriver.hxx>
#include <MDataStd_GeometryStorageDriver.hxx>
#include <MDataStd_ConstraintStorageDriver.hxx>
#include <MDataStd_PlacementStorageDriver.hxx>
#include <MDataStd_PatternStdStorageDriver.hxx>
#include <MDataStd_VariableStorageDriver.hxx>
#include <MDataStd_ExpressionStorageDriver.hxx>
#include <MDataStd_RelationStorageDriver.hxx>
#include <MDataStd_NoteBookStorageDriver.hxx>
#include <MDataStd_TreeNodeStorageDriver.hxx>

#include <MDataStd_TickStorageDriver.hxx>
#include <MDataStd_IntegerListStorageDriver.hxx>
#include <MDataStd_RealListStorageDriver.hxx>
#include <MDataStd_ExtStringListStorageDriver.hxx>
#include <MDataStd_BooleanListStorageDriver.hxx>
#include <MDataStd_ReferenceListStorageDriver.hxx>
#include <MDataStd_BooleanArrayStorageDriver.hxx>
#include <MDataStd_ReferenceArrayStorageDriver.hxx>
#include <MDataStd_ByteArrayStorageDriver.hxx>
#include <MDataStd_NamedDataStorageDriver.hxx>
#include <MDataStd_AsciiStringStorageDriver.hxx>
#include <MDataStd_IntPackedMapStorageDriver.hxx>
//
// Retrieval
//
#include <MDataStd_ShapeRetrievalDriver.hxx>
#include <MDataStd_DirectoryRetrievalDriver.hxx>
#include <MDataStd_RealArrayRetrievalDriver.hxx>
#include <MDataStd_ExtStringArrayRetrievalDriver.hxx>
#include <MDataStd_UAttributeRetrievalDriver.hxx>
#include <MDataStd_IntegerArrayRetrievalDriver.hxx>
#include <MDataStd_NameRetrievalDriver.hxx>
#include <MDataStd_CommentRetrievalDriver.hxx>
#include <MDataStd_IntegerRetrievalDriver.hxx>
//#include <MDataStd_ReferenceRetrievalDriver.hxx>
#include <MDataStd_PointRetrievalDriver.hxx>
#include <MDataStd_AxisRetrievalDriver.hxx>
#include <MDataStd_RealRetrievalDriver.hxx>
#include <MDataStd_PlaneRetrievalDriver.hxx>
#include <MDataStd_GeometryRetrievalDriver.hxx>
#include <MDataStd_ConstraintRetrievalDriver.hxx>
#include <MDataStd_PlacementRetrievalDriver.hxx>
#include <MDataStd_PatternStdRetrievalDriver.hxx>
#include <MDataStd_VariableRetrievalDriver.hxx>
#include <MDataStd_ExpressionRetrievalDriver.hxx>
#include <MDataStd_RelationRetrievalDriver.hxx>
#include <MDataStd_NoteBookRetrievalDriver.hxx>
#include <MDataStd_TreeNodeRetrievalDriver.hxx>

#include <MDataStd_TickRetrievalDriver.hxx>
#include <MDataStd_IntegerListRetrievalDriver.hxx>
#include <MDataStd_RealListRetrievalDriver.hxx>
#include <MDataStd_ExtStringListRetrievalDriver.hxx>
#include <MDataStd_BooleanListRetrievalDriver.hxx>
#include <MDataStd_ReferenceListRetrievalDriver.hxx>
#include <MDataStd_BooleanArrayRetrievalDriver.hxx>
#include <MDataStd_ReferenceArrayRetrievalDriver.hxx>
#include <MDataStd_ByteArrayRetrievalDriver.hxx>
#include <MDataStd_NamedDataRetrievalDriver.hxx>
#include <MDataStd_AsciiStringRetrievalDriver.hxx>
#include <MDataStd_IntPackedMapRetrievalDriver.hxx>
#include <MDataStd_ByteArrayRetrievalDriver_1.hxx>
#include <MDataStd_IntegerArrayRetrievalDriver_1.hxx>
#include <MDataStd_RealArrayRetrievalDriver_1.hxx>
#include <MDataStd_ExtStringArrayRetrievalDriver_1.hxx>
#include <MDataStd_IntPackedMapRetrievalDriver_1.hxx>

//
// enums
//
#include <TDataStd_RealEnum.hxx>
#include <TDataStd_ConstraintEnum.hxx>
#include <TDataStd_GeometryEnum.hxx>
#include <Standard_DomainError.hxx>

//=======================================================================
//function : AddStorageDriver
//purpose  : 
//=======================================================================

void MDataStd::AddStorageDrivers
(const Handle(MDF_ASDriverHSequence)& aDriverSeq, const Handle(CDM_MessageDriver)& theMsgDriver)
{
  aDriverSeq->Append(new MDataStd_ShapeStorageDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_DirectoryStorageDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_IntegerArrayStorageDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_RealArrayStorageDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_UAttributeStorageDriver(theMsgDriver)); 
  aDriverSeq->Append(new MDataStd_NameStorageDriver(theMsgDriver)); 
  aDriverSeq->Append(new MDataStd_CommentStorageDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_IntegerStorageDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_RealStorageDriver(theMsgDriver));
//  aDriverSeq->Append(new MDataStd_ReferenceStorageDriver());
  aDriverSeq->Append(new MDataStd_PointStorageDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_AxisStorageDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_PlaneStorageDriver(theMsgDriver));   
  aDriverSeq->Append(new MDataStd_GeometryStorageDriver(theMsgDriver));  
  aDriverSeq->Append(new MDataStd_ConstraintStorageDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_PlacementStorageDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_PatternStdStorageDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_VariableStorageDriver(theMsgDriver)); 
  aDriverSeq->Append(new MDataStd_ExpressionStorageDriver(theMsgDriver)); 
  aDriverSeq->Append(new MDataStd_RelationStorageDriver(theMsgDriver));  
  aDriverSeq->Append(new MDataStd_NoteBookStorageDriver(theMsgDriver));  
  aDriverSeq->Append(new MDataStd_TreeNodeStorageDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_ExtStringArrayStorageDriver(theMsgDriver));

  aDriverSeq->Append(new MDataStd_TickStorageDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_IntegerListStorageDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_RealListStorageDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_ExtStringListStorageDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_BooleanListStorageDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_ReferenceListStorageDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_BooleanArrayStorageDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_ReferenceArrayStorageDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_ByteArrayStorageDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_NamedDataStorageDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_AsciiStringStorageDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_IntPackedMapStorageDriver(theMsgDriver));
}


//=======================================================================
//function : AddRetrievalDriver
//purpose  : 
//=======================================================================

void MDataStd::AddRetrievalDrivers
(const Handle(MDF_ARDriverHSequence)& aDriverSeq,const Handle(CDM_MessageDriver)& theMsgDriver)
{
  aDriverSeq->Append(new MDataStd_ShapeRetrievalDriver(theMsgDriver)); 
  aDriverSeq->Append(new MDataStd_DirectoryRetrievalDriver(theMsgDriver)); 
  aDriverSeq->Append(new MDataStd_IntegerArrayRetrievalDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_RealArrayRetrievalDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_UAttributeRetrievalDriver(theMsgDriver)); 
  aDriverSeq->Append(new MDataStd_NameRetrievalDriver(theMsgDriver)); 
  aDriverSeq->Append(new MDataStd_CommentRetrievalDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_IntegerRetrievalDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_RealRetrievalDriver(theMsgDriver));
//  aDriverSeq->Append(new MDataStd_ReferenceRetrievalDriver());
  aDriverSeq->Append(new MDataStd_PointRetrievalDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_AxisRetrievalDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_PlaneRetrievalDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_GeometryRetrievalDriver(theMsgDriver)); 
  aDriverSeq->Append(new MDataStd_ConstraintRetrievalDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_PlacementRetrievalDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_PatternStdRetrievalDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_VariableRetrievalDriver(theMsgDriver));  
  aDriverSeq->Append(new MDataStd_ExpressionRetrievalDriver(theMsgDriver));  
  aDriverSeq->Append(new MDataStd_RelationRetrievalDriver(theMsgDriver)); 
  aDriverSeq->Append(new MDataStd_NoteBookRetrievalDriver(theMsgDriver));  
  aDriverSeq->Append(new MDataStd_TreeNodeRetrievalDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_ExtStringArrayRetrievalDriver(theMsgDriver));

  aDriverSeq->Append(new MDataStd_TickRetrievalDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_IntegerListRetrievalDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_RealListRetrievalDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_ExtStringListRetrievalDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_BooleanListRetrievalDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_ReferenceListRetrievalDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_BooleanArrayRetrievalDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_ReferenceArrayRetrievalDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_ByteArrayRetrievalDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_NamedDataRetrievalDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_AsciiStringRetrievalDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_IntPackedMapRetrievalDriver(theMsgDriver));
  aDriverSeq->Append(new MDataStd_ByteArrayRetrievalDriver_1(theMsgDriver));
  aDriverSeq->Append(new MDataStd_IntegerArrayRetrievalDriver_1(theMsgDriver));
  aDriverSeq->Append(new MDataStd_RealArrayRetrievalDriver_1(theMsgDriver));
  aDriverSeq->Append(new MDataStd_ExtStringArrayRetrievalDriver_1(theMsgDriver));
  aDriverSeq->Append(new MDataStd_IntPackedMapRetrievalDriver_1(theMsgDriver));
}


//=======================================================================
//function : RealDimensionToInteger
//purpose  : 
//=======================================================================

Standard_Integer MDataStd::RealDimensionToInteger(const TDataStd_RealEnum e) 
{
  switch (e) {
  case TDataStd_SCALAR  : return  0;
  case TDataStd_LENGTH  : return  1;
  case TDataStd_ANGULAR : return  2;
    
  default:
    Standard_DomainError::Raise("TDataStd_RealEnum; enum term unknown");
  }
  return 0;
}

//=======================================================================
//function : IntegerToRealDimension
//purpose  : 
//=======================================================================

TDataStd_RealEnum MDataStd::IntegerToRealDimension(const Standard_Integer i) 
{
  switch(i)
    {
      // planar constraints
    case  0 : return TDataStd_SCALAR;
    case  1 : return TDataStd_LENGTH;
    case  2 : return TDataStd_ANGULAR;
      default :
	Standard_DomainError::Raise("TDataStd_RealEnum; enum term unknown ");
    }
  return TDataStd_SCALAR;
}

//=======================================================================
//function : ConstraintTypeToInteger
//purpose  : 
//=======================================================================

Standard_Integer MDataStd::ConstraintTypeToInteger(const TDataStd_ConstraintEnum e) 
{
  switch (e) {
    // planar constraints
  case TDataStd_RADIUS         : return  0;
  case TDataStd_DIAMETER       : return  1;
  case TDataStd_MINOR_RADIUS   : return  2;
  case TDataStd_MAJOR_RADIUS   : return  3;
  case TDataStd_TANGENT        : return  4;
  case TDataStd_PARALLEL       : return  5;
  case TDataStd_PERPENDICULAR  : return  6;
  case TDataStd_CONCENTRIC     : return  7;
  case TDataStd_COINCIDENT     : return  8;
  case TDataStd_DISTANCE       : return  9;
  case TDataStd_ANGLE          : return  10;
  case TDataStd_EQUAL_RADIUS   : return  11;
  case TDataStd_SYMMETRY       : return  12;
  case TDataStd_MIDPOINT       : return  13;   
  case TDataStd_EQUAL_DISTANCE : return  14;
  case TDataStd_FIX            : return  15;
  case TDataStd_RIGID          : return  16;
    // placement constraints
  case TDataStd_FROM           : return  17; 
  case TDataStd_AXIS           : return  18; 
  case TDataStd_MATE           : return  19;
  case TDataStd_ALIGN_FACES    : return  20;
  case TDataStd_ALIGN_AXES     : return  21;
  case TDataStd_AXES_ANGLE     : return  22;
  case TDataStd_FACES_ANGLE    : return  23;
  case TDataStd_ROUND          : return  24;
  case TDataStd_OFFSET         : return  25;
  
  default:
    Standard_DomainError::Raise("TDataStd_ConstraintEnum; enum term unknown");
  }
  return 0;
}

//=======================================================================
//function : IntegerToConstraintType
//purpose  : 
//=======================================================================

TDataStd_ConstraintEnum MDataStd::IntegerToConstraintType(const Standard_Integer i) 
{
  switch(i)
    {
      // planar constraints
    case  0 : return TDataStd_RADIUS;
    case  1 : return TDataStd_DIAMETER;
    case  2 : return TDataStd_MINOR_RADIUS; 
    case  3 : return TDataStd_MAJOR_RADIUS;
    case  4 : return TDataStd_TANGENT;
    case  5 : return TDataStd_PARALLEL;
    case  6 : return TDataStd_PERPENDICULAR;
    case  7 : return TDataStd_CONCENTRIC;
    case  8 : return TDataStd_COINCIDENT;
    case  9 : return TDataStd_DISTANCE;
    case 10 : return TDataStd_ANGLE; 
    case 11 : return TDataStd_EQUAL_RADIUS;
    case 12 : return TDataStd_SYMMETRY;
    case 13 : return TDataStd_MIDPOINT;       
    case 14 : return TDataStd_EQUAL_DISTANCE;
    case 15 : return TDataStd_FIX;   
    case 16 : return TDataStd_RIGID; 
      // placement constraints
    case 17 : return TDataStd_FROM; 
    case 18 : return TDataStd_AXIS; 
    case 19 : return TDataStd_MATE;   
    case 20 : return TDataStd_ALIGN_FACES;
    case 21 : return TDataStd_ALIGN_AXES;
    case 22 : return TDataStd_AXES_ANGLE;
    case 23 : return TDataStd_FACES_ANGLE;
    case 24 : return TDataStd_ROUND;  
    case 25 : return TDataStd_OFFSET; 
      default :
	Standard_DomainError::Raise("TDataStd_ConstraintEnum; enum term unknown ");
    }
  return TDataStd_TANGENT;
}

//=======================================================================
//function : GeometryTypeToInteger
//purpose  : 
//=======================================================================

Standard_Integer MDataStd::GeometryTypeToInteger(const TDataStd_GeometryEnum e) 
{
  switch (e) {
  case TDataStd_ANY_GEOM : return  0;
  case TDataStd_POINT    : return  1;
  case TDataStd_LINE     : return  2;
  case TDataStd_CIRCLE   : return  3;
  case TDataStd_ELLIPSE  : return  4;
    
  default:
    Standard_DomainError::Raise("TDataStd_GeometryEnum; enum term unknown");
  }
  return 0;
}

//=======================================================================
//function : IntegerToGeometryType
//purpose  : 
//=======================================================================

TDataStd_GeometryEnum MDataStd::IntegerToGeometryType(const Standard_Integer i) 
{
  switch(i)
    {
    case  0 : return TDataStd_ANY_GEOM;
    case  1 : return TDataStd_POINT;
    case  2 : return TDataStd_LINE;
    case  3 : return TDataStd_CIRCLE;
    case  4 : return TDataStd_ELLIPSE;

      default :
	Standard_DomainError::Raise("TDataStd_GeometryEnum; enum term unknown ");
    }
  return TDataStd_ANY_GEOM;
}




