
#define VIRTUAL

// File		Graphic3d_GraphicDriver_1.cxx
// Created	Mardi 28 janvier 1997
// Author	CAL
// Modified     02.15.100 : JR : Clutter
// 		GG 27/12/02 IMP120302 Add new method Begin(Aspect_Display)

//-Copyright	MatraDatavision 1997

//-Version	

//-Design	Declaration des variables specifiques aux Drivers

//-Warning	Un driver encapsule les Pex et OpenGl drivers

//-References	

//-Language	C++ 2.0

//-Declarations

// for the class
#include <Graphic3d_GraphicDriver.jxx>

#include <Aspect_DriverDefinitionError.hxx>

extern "C" {
#include <InterfaceGraphic_Cextern.hxx>
}

//-Aliases

//-Global data definitions

//-Methods, in order

#ifdef VIRTUAL
Standard_Boolean Graphic3d_GraphicDriver::Begin (const Standard_CString ) {
	return Standard_True;
#else
Standard_Boolean Graphic3d_GraphicDriver::Begin (const Standard_CString ADisplay) {

Standard_Boolean Result;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_begin");
		PrintString ("Display", ADisplay);
	}
	Result = call_togl_begin (ADisplay);
	if (MyTraceLevel) {
		PrintIResult ("call_togl_begin", Result);
	}

	return Result;

#endif
}

//RIC120302
#ifdef VIRTUAL
Standard_Boolean Graphic3d_GraphicDriver::Begin (const Aspect_Display)
 {
   return Standard_True;
#else
Standard_Boolean Graphic3d_GraphicDriver::Begin (const Aspect_Display ADisplay) {

  Standard_Boolean Result;

  if (MyTraceLevel) {
    PrintFunction ("call_togl_begin_display");
  }
  Result = call_togl_begin_display (ADisplay);
  if (MyTraceLevel) {
    PrintIResult ("call_togl_begin_display", Result);
  }

  return Result;
#endif
}
//RIC120302

void Graphic3d_GraphicDriver::End () {
#ifndef VIRTUAL

	if (MyTraceLevel) {
		PrintFunction ("call_togl_end");
	}
	call_togl_end ();

#endif
}

void Graphic3d_GraphicDriver::BeginAnimation (const Graphic3d_CView&
#ifndef VIRTUAL
                                                                     ACView
#endif
                                             ) {
#ifndef VIRTUAL

Graphic3d_CView MyCView = ACView;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_begin_animation");
		PrintCView (MyCView, 1);
	}
	call_togl_begin_animation (&MyCView);
#endif
}

void Graphic3d_GraphicDriver::EndAnimation (const Graphic3d_CView&
#ifndef VIRTUAL
                                                                   ACView
#endif
                                           ) {
#ifndef VIRTUAL

Graphic3d_CView MyCView = ACView;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_end_animation");
		PrintCView (MyCView, 1);
	}
	call_togl_end_animation (&MyCView);

#endif
}
