// File:	DNaming.cxx
// Created:	Thu Jan  9 17:15:19 1997
// Author:	VAUTHIER Jean-Claude & Fricaud Yves

#include <DNaming.ixx>

#include <DDF.hxx>
#include <DDF_Data.hxx>
#include <Draw.hxx>
#include <TColStd_HArray1OfInteger.hxx>
#include <TColStd_ListIteratorOfListOfInteger.hxx>
#include <TColStd_ListOfInteger.hxx>
#include <TCollection_AsciiString.hxx>
#include <TDF_ChildIterator.hxx>
#include <TDF_LabelList.hxx>
#include <TDF_LabelMap.hxx>
#include <TDF_Tool.hxx>
#include <TDF_TagSource.hxx>
#include <TNaming_Iterator.hxx>
#include <TNaming_Tool.hxx>
#include <TNaming_NamedShape.hxx>
#include <TNaming_Builder.hxx>
#include <TopTools_ListOfShape.hxx>
#include <TopTools_ListIteratorOfListOfShape.hxx>
#include <TopTools_IndexedDataMapOfShapeListOfShape.hxx>
#include <TopTools_IndexedMapOfShape.hxx>
#include <TopTools_DataMapOfShapeShape.hxx>
#include <TopTools_DataMapOfShapeListOfShape.hxx>
#include <TopTools_DataMapIteratorOfDataMapOfShapeListOfShape.hxx>
#include <TopTools_DataMapIteratorOfDataMapOfShapeShape.hxx>
#include <TopTools_MapOfShape.hxx>
#include <TopTools_MapIteratorOfMapOfShape.hxx>
#include <TopExp_Explorer.hxx>
#include <TopExp.hxx>
#include <TopoDS.hxx>
#include <TopoDS_Face.hxx>
#include <BRepTools.hxx>
//=======================================================================
//function : DNaming_DFandUS
//purpose  : 
//=======================================================================

// Standard_Boolean DNaming_DFandUS(char* a,
// 				 Handle(TDF_Data)&           ND,
// 				 Handle(TNaming_UsedShapes)& US) 
// {
//   Handle(DDF_Data) DND = Handle(DDF_Data)::DownCast (Draw::Get(a));
//   if (DND.IsNull ()) return 0;
//   ND = DND->DataFramework ();
//   ND->Root().FindAttribute(TNaming_UsedShapes::GetID(),US);
//   return 1;
// }

//=======================================================================
//function : GetShape
//purpose  : 
//=======================================================================

void DNaming::GetShape (const Standard_CString      LabelName,
			const Handle(TDF_Data)&     DF,
			TopTools_ListOfShape&       L)
{
  L.Clear();
  TDF_Label Label;
  Standard_Boolean Found = DDF::AddLabel (DF, LabelName, Label);
  if (Found) {
    TNaming_Iterator it (Label, DF->Transaction ());
    for (; it.More(); it.Next()) {
      L.Append(it.NewShape());
    }
  }
}

//=======================================================================
//function : BuildMap
//purpose  : 
//=======================================================================

void DNaming_BuildMap(TDF_LabelMap& Updated, 
		      const TDF_Label& Lab)
{
  TDF_ChildIterator it(Lab);
  for (; it.More(); it.Next()) {
    Updated.Add(it.Value());
    DNaming_BuildMap(Updated,it.Value());
  }
}

//=======================================================================
//function : CurrentShape
//purpose  : 
//=======================================================================

TopoDS_Shape DNaming::CurrentShape (const Standard_CString  LabelName,
				    const Handle(TDF_Data)& DF)
{
  TopoDS_Shape S;
  TDF_Label Label; 
  Standard_Boolean Found =  DDF::AddLabel (DF, LabelName, Label);
  if (!Found) {
    cout <<"no labels"<<endl;
    return S;
  }
  if (Found) { 
    Handle(TNaming_NamedShape)  NS;
    Label.FindAttribute(TNaming_NamedShape::GetID(),NS);
    S =  TNaming_Tool::CurrentShape(NS);
    if (S.IsNull())
      cout <<"current shape from "<< LabelName <<" is deleted"<<endl;
    return S;
  }
  return S;
}


//=======================================================================
//function : GetEntry
//purpose  : 
//=======================================================================

TCollection_AsciiString DNaming::GetEntry (const TopoDS_Shape&         Shape,
					   const Handle(TDF_Data)&     DF,
					   Standard_Integer&           Status)
{
  Status = 0;
  //Handle(TNaming_UsedShapes) US;
  //DF->Root().FindAttribute(TNaming_UsedShapes::GetID(),US);

  if (!TNaming_Tool::HasLabel (DF->Root(), Shape)) {
    return TCollection_AsciiString ();
  }
  Standard_Integer Transdef;
  TDF_Label Lab = TNaming_Tool::Label (DF->Root(), Shape,Transdef);
  TCollection_AsciiString entry; TDF_Tool::Entry(Lab,entry);
  //Update Status;
  TNaming_Iterator it(Lab,DF->Transaction());
  for (; it.More(); it.Next()) {
    Status++;
    if (Status == 2) break;
  }
  return entry;
}

//=======================================================================
//function : AllCommands
//purpose  : 
//=======================================================================

void  DNaming::AllCommands(Draw_Interpretor& theCommands)
{
  static Standard_Boolean done = Standard_False;
  if (done) return;
  done = Standard_True;

  DNaming::BasicCommands     (theCommands); 
  DNaming::ToolsCommands     (theCommands);  
  DNaming::SelectionCommands (theCommands);
  // define the TCL variable Draw_NamingData
  const char* com = "set Draw_NamingData 1";
  theCommands.Eval(com);
}

//=======================================================================
//=======================================================================
//function : LoadC0Vertices
//purpose  : Method for internal use. It is used by Load() method.
//=======================================================================

static void LoadC0Vertices(const TopoDS_Shape& S,
			   const Handle(TDF_TagSource)& Tagger)
{
  TopTools_DataMapOfShapeListOfShape vertexNaborFaces;
  TopTools_ListOfShape empty;
  TopExp_Explorer explF(S, TopAbs_FACE);
  for (; explF.More(); explF.Next()) {
    const TopoDS_Shape& aFace = explF.Current();
    TopExp_Explorer explV(aFace, TopAbs_VERTEX);
    for (; explV.More(); explV.Next()) {
      const TopoDS_Shape& aVertex = explV.Current();
      if (!vertexNaborFaces.IsBound(aVertex)) vertexNaborFaces.Bind(aVertex, empty);
      Standard_Boolean faceIsNew = Standard_True;
      TopTools_ListIteratorOfListOfShape itrF(vertexNaborFaces.Find(aVertex));
      for (; itrF.More(); itrF.Next()) {
	if (itrF.Value().IsSame(aFace)) {
	  faceIsNew = Standard_False;
	  break;
	}
      }
      if (faceIsNew) {
	vertexNaborFaces.ChangeFind(aVertex).Append(aFace);
      }
    }
  }

  TopTools_DataMapIteratorOfDataMapOfShapeListOfShape itr(vertexNaborFaces);
  for (; itr.More(); itr.Next()) {
    const TopTools_ListOfShape& naborFaces = itr.Value();
    if (naborFaces.Extent() < 3) {
      TNaming_Builder bC0Vertex(Tagger->NewChild());
      bC0Vertex.Generated(itr.Key());
    }
  }
}

//=======================================================================
//function : LoadC0Edges
//purpose  : Method for internal use. It is used by Load() method.
//=======================================================================

static void LoadC0Edges(const TopoDS_Shape& S,
			const Handle(TDF_TagSource)& Tagger)
{
  TopTools_DataMapOfShapeListOfShape edgeNaborFaces;
  TopTools_ListOfShape empty;
  TopExp_Explorer explF(S, TopAbs_FACE);
  for (; explF.More(); explF.Next()) {
    const TopoDS_Shape& aFace = explF.Current();
    TopExp_Explorer explV(aFace, TopAbs_EDGE);
    for (; explV.More(); explV.Next()) {
      const TopoDS_Shape& anEdge = explV.Current();
      if (!edgeNaborFaces.IsBound(anEdge)) edgeNaborFaces.Bind(anEdge, empty);
      Standard_Boolean faceIsNew = Standard_True;
      TopTools_ListIteratorOfListOfShape itrF(edgeNaborFaces.Find(anEdge));
      for (; itrF.More(); itrF.Next()) {
	if (itrF.Value().IsSame(aFace)) {
	  faceIsNew = Standard_False;
	  break;
	}
      }
      if (faceIsNew) {
	edgeNaborFaces.ChangeFind(anEdge).Append(aFace);
      }
    }
  }
  
  TopTools_MapOfShape anEdgesToDelete;
  TopExp_Explorer anEx(S,TopAbs_EDGE); // mpv: new explorer iterator becouse we need keep edges order
  for(;anEx.More();anEx.Next()) {
    Standard_Boolean aC0 = Standard_False;
    TopoDS_Shape anEdge1 = anEx.Current();
    if (edgeNaborFaces.IsBound(anEdge1)) {
      const TopTools_ListOfShape& aList1 = edgeNaborFaces.Find(anEdge1);
      if (aList1.Extent()<2) continue; // mpv (06.09.2002): these edges already was loaded
      TopTools_DataMapIteratorOfDataMapOfShapeListOfShape itr(edgeNaborFaces);
      for (; itr.More(); itr.Next()) {
	TopoDS_Shape anEdge2 = itr.Key();
	if(anEdgesToDelete.Contains(anEdge2)) continue;
	if (anEdge1.IsSame(anEdge2)) continue;
	const TopTools_ListOfShape& aList2 = itr.Value();
	// compare lists of the neighbour faces of edge1 and edge2
	if (aList1.Extent() == aList2.Extent()) {
	  Standard_Integer aMatches = 0;
	  for(TopTools_ListIteratorOfListOfShape aLIter1(aList1);aLIter1.More();aLIter1.Next())
	    for(TopTools_ListIteratorOfListOfShape aLIter2(aList2);aLIter2.More();aLIter2.Next())
	      if (aLIter1.Value().IsSame(aLIter2.Value())) aMatches++;
	  if (aMatches == aList1.Extent()) {
	    aC0=Standard_True;
	    TNaming_Builder bC0Edge(Tagger->NewChild());
	    bC0Edge.Generated(anEdge2);
	    //edgeNaborFaces.UnBind(anEdge2);
	    anEdgesToDelete.Add(anEdge2);
	  }
	}
      }
      //VUN (10/2/2005) avoid UnBind during iterating -^
      TopTools_MapIteratorOfMapOfShape itDelete(anEdgesToDelete);
      for(;itDelete.More();itDelete.Next()) {
	edgeNaborFaces.UnBind(itDelete.Key());
      }
      edgeNaborFaces.UnBind(anEdge1);
    }
    if (aC0) {
      TNaming_Builder bC0Edge(Tagger->NewChild());
      bC0Edge.Generated(anEdge1);
    }
  }
}
//
//=======================================================================
//function : GetDangleShapes
//purpose  : Returns dangle sub shapes Generator - Dangle.
//=======================================================================

static Standard_Boolean GetDangleShapes(const TopoDS_Shape& ShapeIn,
				 const TopAbs_ShapeEnum GeneratedFrom,
				 TopTools_DataMapOfShapeShape& Dangles) 
{
  Dangles.Clear();
  TopTools_IndexedDataMapOfShapeListOfShape subShapeAndAncestors;
  TopAbs_ShapeEnum GeneratedTo;
  if (GeneratedFrom == TopAbs_FACE) GeneratedTo = TopAbs_EDGE;
  else if (GeneratedFrom == TopAbs_EDGE) GeneratedTo = TopAbs_VERTEX;
  else return Standard_False;
  TopExp::MapShapesAndAncestors(ShapeIn, GeneratedTo, GeneratedFrom, subShapeAndAncestors);
  for (Standard_Integer i = 1; i <= subShapeAndAncestors.Extent(); i++) {
    const TopoDS_Shape& mayBeDangle = subShapeAndAncestors.FindKey(i);
    const TopTools_ListOfShape& ancestors = subShapeAndAncestors.FindFromIndex(i);
    if (ancestors.Extent() == 1) Dangles.Bind(ancestors.First(), mayBeDangle);
  }
  return Dangles.Extent();
}

//=======================================================================
//function : LoadGeneratedDangleShapes
//purpose  : 
//=======================================================================

static void LoadGeneratedDangleShapes(const TopoDS_Shape&          ShapeIn,
				      const TopAbs_ShapeEnum       GeneratedFrom,
				      TNaming_Builder&             Builder)
{
  TopTools_DataMapOfShapeShape dangles;
  if (!GetDangleShapes(ShapeIn, GeneratedFrom, dangles)) return;
  TopTools_DataMapIteratorOfDataMapOfShapeShape itr(dangles);
  for (; itr.More(); itr.Next()) Builder.Generated(itr.Key(), itr.Value());
}

//=======================================================================
//function : LoadNextLevels
//purpose  : Method for internal use. Is used by LoadFirstLevel()
//=======================================================================

static void LoadNextLevels(const TopoDS_Shape& S,
			   const Handle(TDF_TagSource)& Tagger)
{
  
  if (S.ShapeType() == TopAbs_SOLID) {		    
    TopExp_Explorer expl(S, TopAbs_FACE);
    for (; expl.More(); expl.Next()) {
      TNaming_Builder bFace(Tagger->NewChild());
      bFace.Generated(expl.Current());
    }
  } else if (S.ShapeType() == TopAbs_SHELL || S.ShapeType() == TopAbs_FACE) {
    // load faces and all the free edges
    TopTools_IndexedMapOfShape Faces;
    TopExp::MapShapes(S, TopAbs_FACE, Faces);
    if (Faces.Extent() > 1 || (S.ShapeType() == TopAbs_SHELL && Faces.Extent() == 1)) {
      TopExp_Explorer expl(S, TopAbs_FACE);
      for (; expl.More(); expl.Next()) {
	TNaming_Builder bFace(Tagger->NewChild());
	bFace.Generated(expl.Current());
      }
    }
    TopTools_IndexedDataMapOfShapeListOfShape anEdgeAndNeighbourFaces;
    TopExp::MapShapesAndAncestors(S, TopAbs_EDGE, TopAbs_FACE, anEdgeAndNeighbourFaces);
    for (Standard_Integer i = 1; i <= anEdgeAndNeighbourFaces.Extent(); i++) {
      const TopTools_ListOfShape& aLL = anEdgeAndNeighbourFaces.FindFromIndex(i);
      if (aLL.Extent() < 2) {
	TNaming_Builder bFreeEdges(Tagger->NewChild());
	bFreeEdges.Generated(anEdgeAndNeighbourFaces.FindKey(i));
      } else {
	TopTools_ListIteratorOfListOfShape anIter(aLL);
	const TopoDS_Face& aFace = TopoDS::Face(anIter.Value());
	anIter.Next();
	if(aFace.IsEqual(anIter.Value())) {
	  TNaming_Builder bFreeEdges(Tagger->NewChild());
	  bFreeEdges.Generated(anEdgeAndNeighbourFaces.FindKey(i));
	}
      }
    }
  } else if (S.ShapeType() == TopAbs_WIRE) {
    TopTools_IndexedMapOfShape Edges;
    BRepTools::Map3DEdges(S, Edges);
    if (Edges.Extent() == 1) {
      TNaming_Builder bEdge(Tagger->NewChild());
      bEdge.Generated(Edges.FindKey(1));
      TopExp_Explorer expl(S, TopAbs_VERTEX);
      for (; expl.More(); expl.Next()) {
	TNaming_Builder bVertex(Tagger->NewChild());
	bVertex.Generated(expl.Current());    
      }
    } else {
      TopExp_Explorer expl(S, TopAbs_EDGE); 
      for (; expl.More(); expl.Next()) {
	TNaming_Builder bEdge(Tagger->NewChild());
	bEdge.Generated(expl.Current());
      }   
      // and load generated vertices.
      TopTools_DataMapOfShapeShape generated;
      if (GetDangleShapes(S, TopAbs_EDGE, generated)) {
	TNaming_Builder bGenVertices(Tagger->NewChild());
	LoadGeneratedDangleShapes(S, TopAbs_EDGE, bGenVertices);
      }
    }
  } else if (S.ShapeType() == TopAbs_EDGE) {
    TopExp_Explorer expl(S, TopAbs_VERTEX);
    for (; expl.More(); expl.Next()) {
      TNaming_Builder bVertex(Tagger->NewChild());
      bVertex.Generated(expl.Current());    
    }
  }
}

//=======================================================================
//function : LoadFirstLevel
//purpose  : Method for internal use. Is used by Load()
//=======================================================================

static void LoadFirstLevel(const TopoDS_Shape& S,
			   const Handle(TDF_TagSource)& Tagger)
{
  if (S.ShapeType() == TopAbs_COMPOUND || S.ShapeType() == TopAbs_COMPSOLID) {
    TopoDS_Iterator itr(S);
    for (; itr.More(); itr.Next()) {
      TNaming_Builder bIndependantShapes(Tagger->NewChild());
      bIndependantShapes.Generated(itr.Value());
      if (itr.Value().ShapeType() == TopAbs_COMPOUND || itr.Value().ShapeType() == TopAbs_COMPSOLID) {
	LoadFirstLevel(itr.Value(), Tagger);
      } else LoadNextLevels(itr.Value(), Tagger);
    }
  } else LoadNextLevels(S, Tagger); 
} 

//=======================================================================
//function : Load
//purpose  : To load an ImportShape
//           Use this method for a topological naming of an imported shape
//=======================================================================

void DNaming::LoadImportedShape(const TDF_Label& theResultLabel, 
				const TopoDS_Shape& theShape) {
  theResultLabel.ForgetAllAttributes();
  TNaming_Builder aBuilder(theResultLabel);
  aBuilder.Generated(theShape);

  Handle(TDF_TagSource) aTagger = TDF_TagSource::Set(theResultLabel);
  if (aTagger.IsNull()) return;
  aTagger->Set(0);

  LoadFirstLevel(theShape, aTagger);
  LoadC0Edges(theShape, aTagger);
  LoadC0Vertices(theShape, aTagger);
}  

//=======================================================================
//function : LoadPrime
//purpose  : 
//=======================================================================

void DNaming::LoadPrime(const TDF_Label& theResultLabel, 
			const TopoDS_Shape& theShape) {

  Handle(TDF_TagSource) aTagger = TDF_TagSource::Set(theResultLabel);
  if (aTagger.IsNull()) return;
  aTagger->Set(0);

  LoadFirstLevel(theShape, aTagger);
  LoadC0Edges(theShape,    aTagger);
  LoadC0Vertices(theShape, aTagger);
}  
    
