// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Quantity_Convert_HeaderFile
#define _Quantity_Convert_HeaderFile

#ifndef _Quantity_PhysicalQuantity_HeaderFile
#include <Quantity_PhysicalQuantity.hxx>
#endif
#ifndef _Quantity_Coefficient_HeaderFile
#include <Quantity_Coefficient.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class TCollection_AsciiString;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Services to manage units conversion between Front-ends and Engines. <br>
//! This conversion is managed by a table of correspondance between the quantities <br>
//! and their "conversion coefficient". <br>
//! This table is implemented like an external array (TCollection_Array1) regarding <br>
//! to the quantities enumeration. <br>
class Quantity_Convert  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates an object; <br>
Standard_EXPORT Quantity_Convert();
//! Updates the conversion table (correspondances between <br>
//! Quantities and conversion coefficients). <br>
static  void SetQuantity(const Quantity_PhysicalQuantity aQuantity,const Quantity_Coefficient aCoef) ;
//! Converts, from the conversion table, the value <aVal> <br>
//! from the user system to the SI system. <br>
static  Standard_Real ConvertUserToSI(const Quantity_PhysicalQuantity aQuantity,const Standard_Real aVal) ;
//! Converts, from the conversion table, the value <aVal> <br>
//! from the SI system to the user system. <br>
static  Standard_Real ConvertSIToUser(const Quantity_PhysicalQuantity aQuantity,const Standard_Real aVal) ;


//! if (aType is a physical quantity) <br>
//!    returns True and the name of the associated PhysicalQuantity . <br>
//! else <br>
//!    returns False. <br>
Standard_EXPORT static  Standard_Boolean IsPhysicalQuantity(const TCollection_AsciiString& aTypeName,TCollection_AsciiString& anEnum) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};


#include <Quantity_Convert.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
