// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Law_HeaderFile
#define _Law_HeaderFile

#ifndef _Handle_Law_BSpFunc_HeaderFile
#include <Handle_Law_BSpFunc.hxx>
#endif
#ifndef _Handle_Law_Linear_HeaderFile
#include <Handle_Law_Linear.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfReal_HeaderFile
#include <Handle_TColStd_HArray1OfReal.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Law_BSpline_HeaderFile
#include <Handle_Law_BSpline.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Law_BSpFunc;
class Law_Linear;
class TColStd_HArray1OfReal;
class TColStd_Array1OfReal;
class TColStd_Array1OfInteger;
class Law_BSpline;
class Adaptor3d_Curve;
class Law_BSpline;
class Law_Interpolate;
class Law_Function;
class Law_Constant;
class Law_Linear;
class Law_BSpFunc;
class Law_S;
class Law_Interpol;
class Law_Laws;
class Law_Composite;
class Law_BSplineKnotSplitting;
class Law_ListNodeOfLaws;
class Law_ListIteratorOfLaws;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Multiple services concerning 1d functions. <br>
class Law  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT static  Handle_Law_BSpFunc MixBnd(const Handle(Law_Linear)& Lin) ;


Standard_EXPORT static  Handle_TColStd_HArray1OfReal MixBnd(const Standard_Integer Degree,const TColStd_Array1OfReal& Knots,const TColStd_Array1OfInteger& Mults,const Handle(Law_Linear)& Lin) ;


Standard_EXPORT static  Handle_TColStd_HArray1OfReal MixTgt(const Standard_Integer Degree,const TColStd_Array1OfReal& Knots,const TColStd_Array1OfInteger& Mults,const Standard_Boolean NulOnTheRight,const Standard_Integer Index) ;

//! Computes a 1 d curve to  reparametrize a curve. Its an <br>
//!          interpolation of NbPoints  points calculated  at quasi <br>
//!          constant abscissa. <br>
Standard_EXPORT static  Handle_Law_BSpline Reparametrize(const Adaptor3d_Curve& Curve,const Standard_Real First,const Standard_Real Last,const Standard_Boolean HasDF,const Standard_Boolean HasDL,const Standard_Real DFirst,const Standard_Real DLast,const Standard_Boolean Rev,const Standard_Integer NbPoints) ;

//! Computes a 1  d curve to  scale  a field of  tangency. <br>
//!          Value is 1. for t = (First+Last)/2 . <br>
//!          If HasFirst value for t = First is VFirst (null derivative). <br>
//!          If HasLast value for t = Last is VLast (null derivative). <br>
Standard_EXPORT static  Handle_Law_BSpline Scale(const Standard_Real First,const Standard_Real Last,const Standard_Boolean HasF,const Standard_Boolean HasL,const Standard_Real VFirst,const Standard_Real VLast) ;


Standard_EXPORT static  Handle_Law_BSpline ScaleCub(const Standard_Real First,const Standard_Real Last,const Standard_Boolean HasF,const Standard_Boolean HasL,const Standard_Real VFirst,const Standard_Real VLast) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class Law_BSpline;
friend class Law_Interpolate;
friend class Law_Function;
friend class Law_Constant;
friend class Law_Linear;
friend class Law_BSpFunc;
friend class Law_S;
friend class Law_Interpol;
friend class Law_Laws;
friend class Law_Composite;
friend class Law_BSplineKnotSplitting;
friend class Law_ListNodeOfLaws;
friend class Law_ListIteratorOfLaws;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
