// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Interface_FloatWriter_HeaderFile
#define _Interface_FloatWriter_HeaderFile

#ifndef _Standard_Character_HeaderFile
#include <Standard_Character.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class converts a floting number (Real) to a string <br>
//!           It can be used if the standard C-C++ output functions <br>
//!           (sprintf or cout<<) are not convenient. That is to say : <br>
//!           - to suppress trailing '0' and 'E+00' (if desired) <br>
//!           - to control exponant output and floating point output <br>
//! <br>
//!           Formats are given in the form used by printf-sprintf <br>
class Interface_FloatWriter  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates a FloatWriter ready to work, with default options  - <br>
//!           - zero suppress option is set <br>
//!           - main format is set to "%E" <br>
//!           - secondary format is set to "%f" for values between 0.1 and <br>
//!             1000. in absolute values <br>
//!           If <chars> is given (and positive), it will produce options <br>
//!           to produce this count of characters : "%<chars>f","%<chars>%E" <br>
Standard_EXPORT Interface_FloatWriter(const Standard_Integer chars = 0);

//! Sets a specific Format for Sending Reals (main format) <br>
//!           (Default from Creation is "%E") <br>
//!           If <reset> is given True (default), this call clears effects <br>
//!           of former calls to SetFormatForRange and SetZeroSuppress <br>
Standard_EXPORT   void SetFormat(const Standard_CString form,const Standard_Boolean reset = Standard_True) ;

//! Sets a secondary Format for Real, to be applied between R1 and <br>
//!           R2 (in absolute values). A Call to SetRealForm cancels this <br>
//!           secondary form if <reset> is True. <br>
//!           (Default from Creation is "%f" between 0.1 and 1000.) <br>
//!  Warning : if the condition (0. <= R1 < R2) is not fulfilled, this <br>
//!           secondary form is canceled. <br>
Standard_EXPORT   void SetFormatForRange(const Standard_CString form,const Standard_Real R1,const Standard_Real R2) ;

//! Sets Sending Real Parameters to suppress trailing Zeros and <br>
//!           Null Exponant ("E+00"), if <mode> is given True, Resets this <br>
//!           mode if <mode> is False (in addition to Real Forms) <br>
//!           A call to SetRealFrom resets this mode to False ig <reset> is <br>
//!           given True (Default from Creation is True) <br>
Standard_EXPORT   void SetZeroSuppress(const Standard_Boolean mode) ;

//! Sets again options to the defaults given by Create <br>
Standard_EXPORT   void SetDefaults(const Standard_Integer chars = 0) ;

//! Returns active options : <zerosup> is the option ZeroSuppress, <br>
//!           <range> is True if a range is set, False else <br>
//!           R1,R2 give the range (if it is set) <br>
Standard_EXPORT   void Options(Standard_Boolean& zerosup,Standard_Boolean& range,Standard_Real& R1,Standard_Real& R2) const;

//! Returns the main format <br>
//! was C++ : return const <br>
Standard_EXPORT   Standard_CString MainFormat() const;

//! Returns the format for range, if set <br>
//!           Meaningful only if <range> from Options is True <br>
//! was C++ : return const <br>
Standard_EXPORT   Standard_CString FormatForRange() const;

//! Writes a Real value <val> to a string <text> by using the <br>
//!           options. Returns the useful Length of produced string. <br>
//!           It calls the class method Convert. <br>
//!  Warning : <text> is assumed to be wide enough (20-30 is correct) <br>
//!           And, even if declared in, its content will be modified <br>
Standard_EXPORT   Standard_Integer Write(const Standard_Real val,const Standard_CString text) const;

//! This class method converts a Real Value to a string, given <br>
//!           options given as arguments. It can be called independantly. <br>
//!  Warning : even if declared in, content of <text> will be modified <br>
Standard_EXPORT static  Standard_Integer Convert(const Standard_Real val,const Standard_CString text,const Standard_Boolean zerosup,const Standard_Real Range1,const Standard_Real Range2,const Standard_CString mainform,const Standard_CString rangeform) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Character themainform[12];
Standard_Real therange1;
Standard_Real therange2;
Standard_Character therangeform[12];
Standard_Boolean thezerosup;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
