// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IFSelect_WorkSession_HeaderFile
#define _IFSelect_WorkSession_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IFSelect_WorkSession_HeaderFile
#include <Handle_IFSelect_WorkSession.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_IFSelect_ShareOut_HeaderFile
#include <Handle_IFSelect_ShareOut.hxx>
#endif
#ifndef _Handle_IFSelect_WorkLibrary_HeaderFile
#include <Handle_IFSelect_WorkLibrary.hxx>
#endif
#ifndef _Handle_Interface_Protocol_HeaderFile
#include <Handle_Interface_Protocol.hxx>
#endif
#ifndef _Handle_Interface_InterfaceModel_HeaderFile
#include <Handle_Interface_InterfaceModel.hxx>
#endif
#ifndef _Handle_Interface_HGraph_HeaderFile
#include <Handle_Interface_HGraph.hxx>
#endif
#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _Handle_Interface_GTool_HeaderFile
#include <Handle_Interface_GTool.hxx>
#endif
#ifndef _Interface_CheckIterator_HeaderFile
#include <Interface_CheckIterator.hxx>
#endif
#ifndef _TColStd_IndexedDataMapOfTransientTransient_HeaderFile
#include <TColStd_IndexedDataMapOfTransientTransient.hxx>
#endif
#ifndef _Handle_Dico_DictionaryOfTransient_HeaderFile
#include <Handle_Dico_DictionaryOfTransient.hxx>
#endif
#ifndef _Handle_IFSelect_ModelCopier_HeaderFile
#include <Handle_IFSelect_ModelCopier.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Handle_IFSelect_Signature_HeaderFile
#include <Handle_IFSelect_Signature.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _IFSelect_ReturnStatus_HeaderFile
#include <IFSelect_ReturnStatus.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfTransient_HeaderFile
#include <Handle_TColStd_HSequenceOfTransient.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfInteger_HeaderFile
#include <Handle_TColStd_HSequenceOfInteger.hxx>
#endif
#ifndef _Handle_Standard_Type_HeaderFile
#include <Handle_Standard_Type.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfHAsciiString_HeaderFile
#include <Handle_TColStd_HSequenceOfHAsciiString.hxx>
#endif
#ifndef _Handle_IFSelect_IntParam_HeaderFile
#include <Handle_IFSelect_IntParam.hxx>
#endif
#ifndef _Handle_IFSelect_Selection_HeaderFile
#include <Handle_IFSelect_Selection.hxx>
#endif
#ifndef _Handle_IFSelect_SignCounter_HeaderFile
#include <Handle_IFSelect_SignCounter.hxx>
#endif
#ifndef _Handle_IFSelect_Dispatch_HeaderFile
#include <Handle_IFSelect_Dispatch.hxx>
#endif
#ifndef _Handle_IFSelect_GeneralModifier_HeaderFile
#include <Handle_IFSelect_GeneralModifier.hxx>
#endif
#ifndef _Handle_IFSelect_Modifier_HeaderFile
#include <Handle_IFSelect_Modifier.hxx>
#endif
#ifndef _Handle_IFSelect_Transformer_HeaderFile
#include <Handle_IFSelect_Transformer.hxx>
#endif
#ifndef _Handle_IFSelect_PacketList_HeaderFile
#include <Handle_IFSelect_PacketList.hxx>
#endif
#ifndef _IFSelect_RemainMode_HeaderFile
#include <IFSelect_RemainMode.hxx>
#endif
#ifndef _Handle_Message_Messenger_HeaderFile
#include <Handle_Message_Messenger.hxx>
#endif
#ifndef _IFSelect_PrintCount_HeaderFile
#include <IFSelect_PrintCount.hxx>
#endif
#ifndef _Handle_IFSelect_SignatureList_HeaderFile
#include <Handle_IFSelect_SignatureList.hxx>
#endif
class IFSelect_ShareOut;
class IFSelect_WorkLibrary;
class Interface_Protocol;
class Interface_InterfaceModel;
class Interface_HGraph;
class Interface_GTool;
class Dico_DictionaryOfTransient;
class IFSelect_ModelCopier;
class Standard_DomainError;
class IFSelect_Signature;
class Standard_Transient;
class TCollection_HAsciiString;
class Interface_Graph;
class TColStd_HSequenceOfTransient;
class Interface_CheckIterator;
class TColStd_HSequenceOfInteger;
class Standard_Type;
class TColStd_HSequenceOfHAsciiString;
class IFSelect_IntParam;
class TCollection_AsciiString;
class IFSelect_Selection;
class Interface_EntityIterator;
class IFSelect_SelectionIterator;
class IFSelect_SignCounter;
class IFSelect_Dispatch;
class IFSelect_GeneralModifier;
class IFSelect_Modifier;
class IFSelect_Transformer;
class IFSelect_PacketList;
class TColStd_SequenceOfTransient;
class TColStd_SequenceOfInteger;
class Message_Messenger;
class IFSelect_SignatureList;


//! This class can be used to simply manage a process such as <br>
//!           splitting a file, extracting a set of Entities ... <br>
//!           It allows to manage different types of Variables : Integer or <br>
//!           Text Parameters, Selections, Dispatches, in addition to a <br>
//!           ShareOut. To each of these variables, a unique Integer <br>
//!           Identifier is attached. A Name can be attached too as desired. <br>
class IFSelect_WorkSession : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Creates a Work Session <br>
//!           It provides default, empty ShareOut and ModelCopier, which can <br>
//!           be replaced (if required, should be done just after creation). <br>
Standard_EXPORT IFSelect_WorkSession();

//! Changes the Error Handler status (by default, it is not set) <br>
Standard_EXPORT   void SetErrorHandle(const Standard_Boolean hand) ;

//! Returns the Error Handler status <br>
Standard_EXPORT   Standard_Boolean ErrorHandle() const;

//! Returns the ShareOut defined at creation time <br>
Standard_EXPORT  const Handle_IFSelect_ShareOut& ShareOut() const;

//! Sets a new ShareOut. Fills Items which its content <br>
//!  Warning : data from the former ShareOut are lost <br>
Standard_EXPORT   void SetShareOut(const Handle(IFSelect_ShareOut)& shareout) ;

//! Sets a WorkLibrary, which will be used to Read and Write Files <br>
Standard_EXPORT   void SetLibrary(const Handle(IFSelect_WorkLibrary)& lib) ;

//! Returns the WorkLibrary. Null Handle if not yet set <br>
//! should be C++ : return const & <br>
Standard_EXPORT   Handle_IFSelect_WorkLibrary WorkLibrary() const;

//! Sets a Protocol, which will be used to determine Graphs, to <br>
//!           Read and to Write Files <br>
Standard_EXPORT   void SetProtocol(const Handle(Interface_Protocol)& protocol) ;

//! Returns the Protocol. Null Handle if not yet set <br>
//! should be C++ : return const & <br>
Standard_EXPORT   Handle_Interface_Protocol Protocol() const;

//! Sets a specific Signature to be the SignType, i.e. the <br>
//!           Signature which will determine TypeName from the Model <br>
//!           (basic function). It is recorded in the GTool <br>
//!           This Signature is also set as "xst-sign-type" (reserved name) <br>
//! <br>
Standard_EXPORT   void SetSignType(const Handle(IFSelect_Signature)& signtype) ;

//! Returns the current SignType <br>
Standard_EXPORT   Handle_IFSelect_Signature SignType() const;

//! Returns True is a Model has been set <br>
Standard_EXPORT   Standard_Boolean HasModel() const;

//! Sets a Model as input : this will be the Model from which the <br>
//!           ShareOut will work <br>
//!           if <clearpointed> is True (default) all SelectPointed items <br>
//!              are cleared, else they must be managed by the caller <br>
//!           Remark : SetModel clears the Graph, recomputes it if a <br>
//!           Protocol is set and if the Model is not empty, of course <br>
Standard_EXPORT   void SetModel(const Handle(Interface_InterfaceModel)& model,const Standard_Boolean clearpointed = Standard_True) ;

//! Returns the Model of the Work Session (Null Handle if none) <br>
//! should be C++ : return const & <br>
Standard_EXPORT   Handle_Interface_InterfaceModel Model() const;

//! Stores the filename used for read for setting the model <br>
//!           It is cleared by SetModel and ClearData(1) <br>
Standard_EXPORT   void SetLoadedFile(const Standard_CString filename) ;

//! Returns the filename used to load current model <br>
//!           empty if unknown <br>
Standard_EXPORT   Standard_CString LoadedFile() const;

//! Reads a file with the WorkLibrary (sets Model and LoadedFile) <br>
//!           Returns a integer status which can be : <br>
//!           RetDone if OK,  RetVoid if no Protocol not defined, <br>
//!           RetError for file not found, RetFail if fail during read <br>
Standard_EXPORT   IFSelect_ReturnStatus ReadFile(const Standard_CString filename) ;

//! Returns the count of Entities stored in the Model, or 0 <br>
Standard_EXPORT   Standard_Integer NbStartingEntities() const;

//! Returns an  Entity stored in the Model of the WorkSession <br>
//!           (Null Handle is no Model or num out of range) <br>
Standard_EXPORT   Handle_Standard_Transient StartingEntity(const Standard_Integer num) const;

//! Returns the Number of an Entity in the Model <br>
//!           (0 if no Model set or <ent> not in the Model) <br>
Standard_EXPORT   Standard_Integer StartingNumber(const Handle(Standard_Transient)& ent) const;

//! From a given label in Model, returns the corresponding number <br>
//!           Starts from first entity by Default, may start after a given <br>
//!           number : this number may be given negative, its absolute value <br>
//!           is then considered. Hence a loop on NumberFromLabel may be <br>
//!           programmed (stop test is : returned value positive or null) <br>
//! <br>
//!           Returns 0 if not found, < 0 if more than one found (first <br>
//!           found in negative). <br>
//!           If <val> just gives an integer value, returns it <br>
Standard_EXPORT   Standard_Integer NumberFromLabel(const Standard_CString val,const Standard_Integer afternum = 0) const;

//! Returns the label for <ent>, as the Model does <br>
//!           If <ent> is not in the Model or if no Model is loaded, a Null <br>
//!           Handle is returned <br>
Standard_EXPORT   Handle_TCollection_HAsciiString EntityLabel(const Handle(Standard_Transient)& ent) const;

//! Returns the Name of an Entity <br>
//!           This Name is computed by the general service Name <br>
//!           Returns a Null Handle if fails <br>
Standard_EXPORT   Handle_TCollection_HAsciiString EntityName(const Handle(Standard_Transient)& ent) const;

//! Returns the Category Number determined for an entity <br>
//!           it is computed by the class Category <br>
//!           An unknown entity (number 0) gives a value -1 <br>
Standard_EXPORT   Standard_Integer CategoryNumber(const Handle(Standard_Transient)& ent) const;

//! Returns the Category Name determined for an entity <br>
//!           it is computed by the class Category <br>
//!           Remark : an unknown entity gives an empty string <br>
Standard_EXPORT   Standard_CString CategoryName(const Handle(Standard_Transient)& ent) const;

//! Returns the Validity Name determined for an entity <br>
//!           it is computed by the class SignValidity <br>
//!           Remark : an unknown entity gives an empty string <br>
Standard_EXPORT   Standard_CString ValidityName(const Handle(Standard_Transient)& ent) const;

//! Clears recorded data (not the items) according mode : <br>
//!           1 : all Data : Model, Graph, CheckList, + ClearData 4 <br>
//!           2 : Graph and CheckList (they will then be recomputed later) <br>
//!           3 : CheckList (it will be recomputed by ComputeCheck) <br>
//!           4 : just content of SelectPointed and Counters <br>
//!           Plus 0 : does nothing but called by SetModel <br>
//!           ClearData is virtual, hence it can be redefined to clear <br>
//!             other data of a specialised Work Session <br>
Standard_EXPORT virtual  void ClearData(const Standard_Integer mode) ;

//! Computes the Graph used for Selections, Displays ... <br>
//!           If a HGraph is already set, with same model as given by method <br>
//!           Model, does nothing. Else, computes a new Graph. <br>
//!           If <enforce> is given True, computes a new Graph anyway. <br>
//!           Remark that a call to ClearGraph will cause ComputeGraph to <br>
//!           really compute a new Graph <br>
//!           Returns True if Graph is OK, False else (i.e. if no Protocol <br>
//!           is set, or if Model is absent or empty). <br>
Standard_EXPORT   Standard_Boolean ComputeGraph(const Standard_Boolean enforce = Standard_False) ;

//! Returns the Computed Graph as HGraph (Null Handle if not set) <br>
Standard_EXPORT   Handle_Interface_HGraph HGraph() ;

//! Returns the Computed Graph, for Read only <br>
Standard_EXPORT  const Interface_Graph& Graph() ;

//! Returns the list of entities shared by <ent> (can be empty) <br>
//!           Returns a null Handle if <ent> is unknown <br>
Standard_EXPORT   Handle_TColStd_HSequenceOfTransient Shareds(const Handle(Standard_Transient)& ent) ;

//! Returns the list of entities sharing <ent> (can be empty) <br>
//!           Returns a null Handle if <ent> is unknown <br>
Standard_EXPORT   Handle_TColStd_HSequenceOfTransient Sharings(const Handle(Standard_Transient)& ent) ;

//! Returns True if a Model is defined and really loaded (not <br>
//!           empty), a Protocol is set and a Graph has been computed. <br>
//!           In this case, the WorkSession can start to work <br>
Standard_EXPORT   Standard_Boolean IsLoaded() const;

//! Computes the CheckList for the Model currently loaded <br>
//!           It can then be used for displays, querries ... <br>
//!           Returns True if OK, False else (i.e. no Protocol set, or Model <br>
//!           absent). If <enforce> is False, works only if not already done <br>
//!           or if a new Model has been loaded from last call. <br>
//! Remark : computation is enforced by every call to <br>
//!          SetModel or RunTransformer <br>
Standard_EXPORT   Standard_Boolean ComputeCheck(const Standard_Boolean enforce = Standard_False) ;

//! Returns the Check List for the Model currently loaded : <br>
//!           <complete> = True  : complete (syntactic & semantic messages), <br>
//!               computed if not yet done <br>
//!           <complete> = False : only syntactic (check file form) <br>
Standard_EXPORT   Interface_CheckIterator ModelCheckList(const Standard_Boolean complete = Standard_True) ;

//! Returns a Check for a single entity, under the form of a <br>
//!           CheckIterator (this gives only one form for the user) <br>
//!           if <ent> is Null or equates the current Model, it gives the <br>
//!           Global Check, else the Check for the given entity <br>
//!           <complete> as for ModelCheckList <br>
Standard_EXPORT   Interface_CheckIterator CheckOne(const Handle(Standard_Transient)& ent,const Standard_Boolean complete = Standard_True) ;

//! Returns the Check List produced by the last execution of <br>
//!           either : EvaluateFile(for Split), SendSplit, SendAll, <br>
//!           SendSelected, RunTransformer-RunModifier <br>
//!           Cleared by SetModel or ClearData(1) <br>
//!           The field is protected, hence a specialized WorkSession may <br>
//!           fill it <br>
Standard_EXPORT   Interface_CheckIterator LastRunCheckList() const;

//! Returns the Maximum Value for an Item Identifier. It can be <br>
//!           greater to the count of known Items, because some can have <br>
//!           been removed <br>
Standard_EXPORT   Standard_Integer MaxIdent() const;

//! Returns an Item, given its Ident. Returns a Null Handle if <br>
//!           no Item corresponds to this Ident. <br>
Standard_EXPORT   Handle_Standard_Transient Item(const Standard_Integer id) const;

//! Returns the Ident attached to an Item in the WorkSession, or <br>
//!           Zero if it is unknown <br>
Standard_EXPORT   Standard_Integer ItemIdent(const Handle(Standard_Transient)& item) const;

//! Returns the Item which corresponds to a Variable, given its <br>
//!           Name (whatever the type of this Item). <br>
//!           Returns a Null Handle if this Name is not recorded <br>
Standard_EXPORT   Handle_Standard_Transient NamedItem(const Standard_CString name) const;

//! Same as above, but <name> is given through a Handle <br>
//!           Especially Usefull with methods SelectionNames, etc... <br>
Standard_EXPORT   Handle_Standard_Transient NamedItem(const Handle(TCollection_HAsciiString)& name) const;

//! Returns the Ident attached to a Name, 0 if name not recorded <br>
Standard_EXPORT   Standard_Integer NameIdent(const Standard_CString name) const;

//! Returns True if an Item of the WorkSession has an attached Name <br>
Standard_EXPORT   Standard_Boolean HasName(const Handle(Standard_Transient)& item) const;

//! Returns the Name attached to an Item as a Variable of this <br>
//!           WorkSession. If <item> is Null or not recorded, returns an <br>
//!           empty string. <br>
Standard_EXPORT   Handle_TCollection_HAsciiString Name(const Handle(Standard_Transient)& item) const;

//! Adds an Item and returns its attached Ident. Does nothing <br>
//!           if <item> is already recorded (and returns its attached Ident) <br>
//!           <active> if True commands call to SetActive (see below) <br>
//!           Remark : the determined Ident is used if <item> is a Dispatch, <br>
//!           to fill the ShareOut <br>
Standard_EXPORT   Standard_Integer AddItem(const Handle(Standard_Transient)& item,const Standard_Boolean active = Standard_True) ;

//! Adds an Item with an attached Name. If the Name is already <br>
//!           known in the WorkSession, the older item losts it <br>
//!           Returns Ident if Done, 0 else, i.e. if <item> is null <br>
//!           If <name> is empty, works as AddItem (i.e. with no name) <br>
//!           If <item> is already known but with no attached Name, this <br>
//!           method tries to attached a Name to it <br>
//!           <active> if True commands call to SetActive (see below) <br>
Standard_EXPORT   Standard_Integer AddNamedItem(const Standard_CString name,const Handle(Standard_Transient)& item,const Standard_Boolean active = Standard_True) ;

//! Following the type of <item> : <br>
//!           - Dispatch : Adds or Removes it in the ShareOut & FileNaming <br>
//!           - GeneralModifier : Adds or Removes it for final sending <br>
//!             (i.e. in the ModelCopier) <br>
//!           Returns True if it did something, False else (state unchanged) <br>
Standard_EXPORT   Standard_Boolean SetActive(const Handle(Standard_Transient)& item,const Standard_Boolean mode) ;

//! Removes an Item from the Session, given its Name <br>
//!           Returns True if Done, False else (Name not recorded) <br>
//!           (Applies only on Item which are Named) <br>
Standard_EXPORT   Standard_Boolean RemoveNamedItem(const Standard_CString name) ;

//! Removes a Name without removing the Item <br>
//!           Returns True if Done, False else (Name not recorded) <br>
Standard_EXPORT   Standard_Boolean RemoveName(const Standard_CString name) ;

//! Removes an Item given its Ident. Returns False if <id> is <br>
//!           attached to no Item in the WorkSession. For a Named Item, <br>
//!           also removes its Name. <br>
Standard_EXPORT   Standard_Boolean RemoveItem(const Handle(Standard_Transient)& item) ;

//! Clears all the recorded Items : Selections, Dispatches, <br>
//!           Modifiers, and Strings & IntParams, with their Idents & Names. <br>
//!           Remark that if a Model has been loaded, it is not cleared. <br>
Standard_EXPORT   void ClearItems() ;

//! Returns a Label which illustrates the content of an Item, <br>
//!           given its Ident. This Label is : <br>
//!           - for a Text Parameter, "Text:<text value>" <br>
//!           - for an Integer Parameter, "Integer:<integer value>" <br>
//!           - for a Selection, a Dispatch or a Modifier, its Label <br>
//!             (see these classes) <br>
//!           - for any other kind of Variable, its cdl type <br>
Standard_EXPORT   Handle_TCollection_HAsciiString ItemLabel(const Standard_Integer id) const;

//! Fills a Sequence with the List of Idents attached to the Items <br>
//!           of which Type complies with (IsKind) <type> (alphabetic order) <br>
//!           Remark : <type> = TYPE(Standard_Transient) gives all the <br>
//!           Idents which are suitable in the WorkSession <br>
Standard_EXPORT   Handle_TColStd_HSequenceOfInteger ItemIdents(const Handle(Standard_Type)& type) const;

//! Fills a Sequence with the list of the Names attached to Items <br>
//!           of which Type complies with (IsKind) <type> (alphabetic order) <br>
//!           Remark : <type> = TYPE(Standard_Transient) gives all the Names <br>
Standard_EXPORT   Handle_TColStd_HSequenceOfHAsciiString ItemNames(const Handle(Standard_Type)& type) const;

//! Fills a Sequence with the NAMES of the control items, of which <br>
//!           the label matches <label> (contain it) : see NextIdentForLabel <br>
//!           Search mode is fixed to "contained" <br>
//!           If <label> is empty, returns all Names <br>
Standard_EXPORT   Handle_TColStd_HSequenceOfHAsciiString ItemNamesForLabel(const Standard_CString label) const;

//! For query by Label with possible iterations <br>
//!           Searches the Ident of which Item has a Label which matches a <br>
//!           given one, the search starts from an initial Ident. <br>
//!           Returns the first found Ident which follows <id>, or ZERO <br>
//! <br>
//!           The search must start with <id> = 0, it returns the next Ident <br>
//!           which matches. To iterate, call again this method which this <br>
//!           returned value as <id>. Once an Ident has been returned, the <br>
//!           Item can be obtained by the method Item <br>
//! <br>
//!           <mode> precises the required matching mode : <br>
//!           - 0 (Default) : <label> must match exactly with the Item Label <br>
//!           - 1 : <label> must match the exact beginning (the end is free) <br>
//!           - 2 : <label> must be at least once wherever in the Item Label <br>
//!           - other values are ignored <br>
Standard_EXPORT   Standard_Integer NextIdentForLabel(const Standard_CString label,const Standard_Integer id,const Standard_Integer mode = 0) const;

//! Creates a parameter as being bound to a Static <br>
//!           If the Static is Integer, this creates an IntParam bound to <br>
//!           it by its name. Else this creates a String which is the value <br>
//!           of the Static. <br>
//!           Returns a null handle if <statname> is unknown as a Static <br>
Standard_EXPORT   Handle_Standard_Transient NewParamFromStatic(const Standard_CString statname,const Standard_CString name = "") ;

//! Returns an IntParam, given its Ident in the Session <br>
//!           Null result if <id> is not suitable for an IntParam <br>
//!           (undefined, or defined for another kind of variable) <br>
Standard_EXPORT   Handle_IFSelect_IntParam IntParam(const Standard_Integer id) const;

//! Returns Integer Value of an IntParam <br>
Standard_EXPORT   Standard_Integer IntValue(const Handle(IFSelect_IntParam)& it) const;

//! Creates a new IntParam. A Name can be set (Optional) <br>
//!           Returns the created IntParam, or a Null Handle in case of <br>
//!           Failure (see AddItem/AddNamedItem) <br>
Standard_EXPORT   Handle_IFSelect_IntParam NewIntParam(const Standard_CString name = "") ;

//! Changes the Integer Value of an IntParam <br>
//!           Returns True if Done, False if <it> is not in the WorkSession <br>
Standard_EXPORT   Standard_Boolean SetIntValue(const Handle(IFSelect_IntParam)& it,const Standard_Integer val) ;

//! Returns a TextParam, given its Ident in the Session <br>
//!           Null result if <id> is not suitable for a TextParam <br>
//!           (undefined, or defined for another kind of variable) <br>
Standard_EXPORT   Handle_TCollection_HAsciiString TextParam(const Standard_Integer id) const;

//! Returns Text Value of a TextParam (a String) <br>
//!           or an empty string if <it> is not in the WorkSession <br>
Standard_EXPORT   TCollection_AsciiString TextValue(const Handle(TCollection_HAsciiString)& par) const;

//! Creates a new (empty) TextParam. A Name can be set (Optional) <br>
//!           Returns the created TextParam (as an HAsciiString), or a Null <br>
//!           Handle in case of Failure (see AddItem/AddNamedItem) <br>
Standard_EXPORT   Handle_TCollection_HAsciiString NewTextParam(const Standard_CString name = "") ;

//! Changes the Text Value of a TextParam (an HAsciiString) <br>
//!           Returns True if Done, False if <it> is not in the WorkSession <br>
Standard_EXPORT   Standard_Boolean SetTextValue(const Handle(TCollection_HAsciiString)& par,const Standard_CString val) ;

//! Returns a Signature, given its Ident in the Session <br>
//!           Null result if <id> is not suitable for a Signature <br>
//!           (undefined, or defined for another kind of variable) <br>
Standard_EXPORT   Handle_IFSelect_Signature Signature(const Standard_Integer id) const;

//! Returns the Value computed by a Signature for an Entity <br>
//!           Returns an empty string if the entity does not belong to the <br>
//!           loaded model <br>
Standard_EXPORT   Standard_CString SignValue(const Handle(IFSelect_Signature)& sign,const Handle(Standard_Transient)& ent) const;

//! Returns a Selection, given its Ident in the Session <br>
//!           Null result if <id> is not suitable for a Selection <br>
//!           (undefined, or defined for another kind of variable) <br>
Standard_EXPORT   Handle_IFSelect_Selection Selection(const Standard_Integer id) const;

//! Evaluates the effect of a Selection applied on the input Model <br>
//!           Returned Result remains empty if no input Model has been set <br>
Standard_EXPORT   Interface_EntityIterator EvalSelection(const Handle(IFSelect_Selection)& sel) const;

//! Returns the Selections which are source of Selection, given <br>
//!           its rank in the List of Selections (see SelectionIterator) <br>
//!           Returned value is empty if <num> is out of range or if <br>
//!           <sel> is not in the WorkSession <br>
Standard_EXPORT   IFSelect_SelectionIterator Sources(const Handle(IFSelect_Selection)& sel) const;

//! Returns the result of a Selection, computed by EvalSelection <br>
//!           (see above) under the form of a HSequence (hence, it can be <br>
//!           used by a frontal-engine logic). It can be empty <br>
//!           Returns a Null Handle if <sel> is not in the WorkSession <br>
Standard_EXPORT   Handle_TColStd_HSequenceOfTransient SelectionResult(const Handle(IFSelect_Selection)& sel) const;

//! Returns the result of a Selection, by forcing its input with <br>
//!           a given list <list> (unless <list> is Null). <br>
//!               RULES : <br>
//!           <list> applies only for a SelectDeduct kind Selection : <br>
//!           its Input is considered : if it is a SelectDeduct kind <br>
//!            Selection, its Input is considered, etc... until an Input <br>
//!           is not a Deduct/Extract : its result is replaced by <list> <br>
//!           and all the chain of deductions is applied <br>
Standard_EXPORT   Handle_TColStd_HSequenceOfTransient SelectionResultFromList(const Handle(IFSelect_Selection)& sel,const Handle(TColStd_HSequenceOfTransient)& list) const;

//! Sets a Selection as input for an item, according its type : <br>
//!           if <item> is a Dispatch : as Final Selection <br>
//!           if <item> is a GeneralModifier (i.e. any kind of Modifier) : <br>
//!             as Selection used to filter entities to modify <br>
//!           <sel>  Null  causes this Selection to be nullified <br>
//!           Returns False if <item> is not of a suitable type, or <br>
//!             <item> or <sel> is not in the WorkSession <br>
Standard_EXPORT   Standard_Boolean SetItemSelection(const Handle(Standard_Transient)& item,const Handle(IFSelect_Selection)& sel) ;

//! Resets input Selection which was set by SetItemSelection <br>
//!           Same conditions as for SetItemSelection <br>
//!           Returns True if done, False if <item> is not in the WorkSession <br>
Standard_EXPORT   Standard_Boolean ResetItemSelection(const Handle(Standard_Transient)& item) ;

//! Returns the Selection of a Dispatch or a GeneralModifier. <br>
//!           Returns a Null Handle if none is defined or <item> not good type <br>
Standard_EXPORT   Handle_IFSelect_Selection ItemSelection(const Handle(Standard_Transient)& item) const;

//! Returns a SignCounter from its ident in the Session <br>
//!           Null result if <id> is not suitable for a SignCounter <br>
//!           (undefined, or defined for another kind of variable) <br>
Standard_EXPORT   Handle_IFSelect_SignCounter SignCounter(const Standard_Integer id) const;

//! Computes the content of a SignCounter when it is defined with <br>
//!           a Selection, then returns True <br>
//!           Returns False if the SignCounter is not defined with a <br>
//!           Selection, or if its Selection Mode is inhibited <br>
//!           <forced> to work around optimisations <br>
Standard_EXPORT   Standard_Boolean ComputeCounter(const Handle(IFSelect_SignCounter)& counter,const Standard_Boolean forced = Standard_False) ;

//! Computes the content of a SignCounter from an input list <br>
//!           If <list> is Null, uses internal definition of the Counter : <br>
//!             a Selection, else the whole Model (recomputation forced) <br>
//!           If <clear> is True (D), starts from scratch <br>
//!           Else, cumulates computations <br>
Standard_EXPORT   Standard_Boolean ComputeCounterFromList(const Handle(IFSelect_SignCounter)& counter,const Handle(TColStd_HSequenceOfTransient)& list,const Standard_Boolean clear = Standard_True) ;

//! Returns the ordered list of dispatches stored by the ShareOut <br>
Standard_EXPORT   Handle_TColStd_HSequenceOfInteger AppliedDispatches() const;

//! Clears the list of Dispatches recorded by the ShareOut <br>
//!           if <only> disp is True, tha's all. Else, clears also the lists <br>
//!           of Modifiers recorded by the ShareOut <br>
Standard_EXPORT   void ClearShareOut(const Standard_Boolean onlydisp) ;

//! Returns a Dispatch, given its Ident in the Session <br>
//!           Null result if <id> is not suitable for a Dispatch <br>
//!           (undefined, or defined for another kind of variable) <br>
Standard_EXPORT   Handle_IFSelect_Dispatch Dispatch(const Standard_Integer id) const;

//! Returns the rank of a Dispatch in the ShareOut, or 0 if <disp> <br>
//!           is not in the ShareOut or not in the WorkSession <br>
Standard_EXPORT   Standard_Integer DispatchRank(const Handle(IFSelect_Dispatch)& disp) const;

//! Gives access to the complete ModelCopier <br>
Standard_EXPORT   Handle_IFSelect_ModelCopier ModelCopier() const;

//! Sets a new ModelCopier. Fills Items which its content <br>
Standard_EXPORT   void SetModelCopier(const Handle(IFSelect_ModelCopier)& copier) ;

//! Returns the count of Modifiers applied to final sending <br>
//!           Model Modifiers if <formodel> is True, File Modifiers else <br>
//!           (i.e. Modifiers which apply once the Models have been filled) <br>
Standard_EXPORT   Standard_Integer NbFinalModifiers(const Standard_Boolean formodel) const;

//! Fills a Sequence with a list of Idents, those attached to <br>
//!           the Modifiers applied to final sending. <br>
//!           Model Modifiers if <formodel> is True, File Modifiers else <br>
//!           This list is given in the order in which they will be applied <br>
//!           (which takes into account the Changes to Modifier Ranks) <br>
Standard_EXPORT   Handle_TColStd_HSequenceOfInteger FinalModifierIdents(const Standard_Boolean formodel) const;

//! Returns a Modifier, given its Ident in the Session <br>
//!           Null result if <id> is not suitable for a Modifier <br>
//!           (undefined, or defined for another kind of variable) <br>
Standard_EXPORT   Handle_IFSelect_GeneralModifier GeneralModifier(const Standard_Integer id) const;

//! Returns a Model Modifier, given its Ident in the Session, <br>
//!           i.e. typed as a Modifier (not simply a GeneralModifier) <br>
//!           Null result if <id> is not suitable for a Modifier <br>
//!           (undefined, or defined for another kind of variable) <br>
Standard_EXPORT   Handle_IFSelect_Modifier ModelModifier(const Standard_Integer id) const;

//! Returns the Rank of a Modifier given its Ident. Model or File <br>
//!           Modifier according its type (ModelModifier or not) <br>
//!           Remember that Modifiers are applied sequencially following <br>
//!           their Rank : first Model Modifiers then File Modifiers <br>
//!           Rank is given by rank of call to AddItem and can be <br>
//!           changed by ChangeModifierRank <br>
Standard_EXPORT   Standard_Integer ModifierRank(const Handle(IFSelect_GeneralModifier)& item) const;

//! Changes the Rank of a Modifier in the Session : <br>
//!           Model Modifiers if <formodel> is True, File Modifiers else <br>
//!           the Modifier n0 <before> is put to n0 <after> <br>
//!           Return True if Done, False if <before> or <after> out of range <br>
Standard_EXPORT   Standard_Boolean ChangeModifierRank(const Standard_Boolean formodel,const Standard_Integer before,const Standard_Integer after) ;

//! Removes all the Modifiers active in the ModelCopier : they <br>
//!           become inactive and they are removed from the Session <br>
Standard_EXPORT   void ClearFinalModifiers() ;

//! Sets a GeneralModifier to be applied to an item : <br>
//!           - item = ShareOut : applies for final sending (all dispatches) <br>
//!           - item is a Dispatch : applies for this dispatch only <br>
//!           Returns True if done, False if <modif> or <item> not in <me> <br>
Standard_EXPORT   Standard_Boolean SetAppliedModifier(const Handle(IFSelect_GeneralModifier)& modif,const Handle(Standard_Transient)& item) ;

//! Resets a GeneralModifier to be applied <br>
//!           Returns True if done, False if <modif> was not applied <br>
Standard_EXPORT   Standard_Boolean ResetAppliedModifier(const Handle(IFSelect_GeneralModifier)& modif) ;

//! Returns the item on which a GeneralModifier is applied : <br>
//!           the ShareOut, or a given Dispatch <br>
//!           Returns a Null Handle if <modif> is not applied <br>
Standard_EXPORT   Handle_Standard_Transient UsesAppliedModifier(const Handle(IFSelect_GeneralModifier)& modif) const;

//! Returns a Transformer, given its Ident in the Session <br>
//!           Null result if <id> is not suitable for a Transformer <br>
//!           (undefined, or defined for another kind of variable) <br>
Standard_EXPORT   Handle_IFSelect_Transformer Transformer(const Standard_Integer id) const;

//! Runs a Transformer on starting Model, which can then be edited <br>
//!           or replaced by a new one. The Protocol can also be changed. <br>
//!           Fills LastRunCheckList <br>
//! <br>
//!           Returned status is 0 if nothing done (<transf> or model <br>
//!             undefined), positive if OK, negative else : <br>
//!           0  : Nothing done <br>
//!           1  : OK, edition on the spot with no change to the graph <br>
//!                of dependances (purely local) <br>
//!           2  : OK, model edited on the spot (graph recomputed, may <br>
//!               have changed), protocol unchanged <br>
//!           3  : OK, new model produced, same protocol <br>
//!           4  : OK, model edited on the spot (graph recomputed), <br>
//!                but protocol has changed <br>
//!           5  : OK, new model produced, protocol has changed <br>
//!           -1 : Error on the spot (slight changes), data may be corrupted <br>
//!                (remark : corruption should not be profound) <br>
//!           -2 : Error on edition the spot, data may be corrupted <br>
//!                (checking them is recommanded) <br>
//!           -3 : Error with a new data set, transformation ignored <br>
//!           -4 : OK as 4, but graph of dependances count not be recomputed <br>
//!                (the former one is kept) : check the protocol <br>
Standard_EXPORT   Standard_Integer RunTransformer(const Handle(IFSelect_Transformer)& transf) ;

//! Runs a Modifier on Starting Model. It can modify entities, or <br>
//!           add new ones. But the Model or the Protocol is unchanged. <br>
//!           The Modifier is applied on each entity of the Model. See also <br>
//!             RunModifierSelected <br>
//!           Fills LastRunCheckList <br>
//! <br>
//!           <copy> : if True, a new data set is produced which brings <br>
//!             the modifications (Model + its Entities) <br>
//!           if False, data are modified on the spot <br>
//! <br>
//!           It works through a TransformStandard defined with <modif> <br>
//!           Returned status as RunTransformer : 0 nothing done, >0 OK, <br>
//!           <0 problem, but only between -3 and 3 (protocol unchanged) <br>
//!           Remark : <copy> True will give <effect> = 3 or -3 <br>
Standard_EXPORT   Standard_Integer RunModifier(const Handle(IFSelect_Modifier)& modif,const Standard_Boolean copy) ;

//! Acts as RunModifier, but the Modifier is applied on the list <br>
//!           determined by a Selection, rather than on the whole Model <br>
//!           If the selection is a null handle, the whole model is taken <br>
Standard_EXPORT   Standard_Integer RunModifierSelected(const Handle(IFSelect_Modifier)& modif,const Handle(IFSelect_Selection)& sel,const Standard_Boolean copy) ;

//! Creates and returns a TransformStandard, empty, with its <br>
//!           Copy Option (True = Copy, False = On the Spot) and an <br>
//!           optional name. <br>
//!           To a TransformStandard, the method SetAppliedModifier applies <br>
Standard_EXPORT   Handle_IFSelect_Transformer NewTransformStandard(const Standard_Boolean copy,const Standard_CString name = "") ;

//! Defines a new content from the former one <br>
//!           If <keep> is True, it is given by entities selected by <br>
//!              Selection <sel>  (and all shared entities) <br>
//!           Else, it is given by all the former content but entities <br>
//!              selected by the Selection <sel> (and properly shared ones) <br>
//!           Returns True if done. Returns False if the selected list <br>
//!           (from <sel>) is empty, hence nothing is done <br>
Standard_EXPORT   Standard_Boolean SetModelContent(const Handle(IFSelect_Selection)& sel,const Standard_Boolean keep) ;

//! Returns the defined File Prefix. Null Handle if not defined <br>
Standard_EXPORT   Handle_TCollection_HAsciiString FilePrefix() const;

//! Returns the defined Default File Root. It is used for <br>
//!           Dispatches which have no specific root attached. <br>
//!           Null Handle if not defined <br>
Standard_EXPORT   Handle_TCollection_HAsciiString DefaultFileRoot() const;

//! Returns the defined File Extension. Null Handle if not defined <br>
Standard_EXPORT   Handle_TCollection_HAsciiString FileExtension() const;

//! Returns the File Root defined for a Dispatch. Null if no <br>
//!           Root Name is defined for it (hence, no File will be produced) <br>
Standard_EXPORT   Handle_TCollection_HAsciiString FileRoot(const Handle(IFSelect_Dispatch)& disp) const;

//! Defines a File Prefix <br>
Standard_EXPORT   void SetFilePrefix(const Standard_CString name) ;

//! Defines a Default File Root Name. Clears it is <name> = "" <br>
//!           Returns True if OK, False if <name> already set for a Dispatch <br>
Standard_EXPORT   Standard_Boolean SetDefaultFileRoot(const Standard_CString name) ;

//! Defines a File Extension <br>
Standard_EXPORT   void SetFileExtension(const Standard_CString name) ;

//! Defines a Root for a Dispatch <br>
//!           If <name> is empty, clears Root Name <br>
//!           This has as effect to inhibit the production of File by <disp> <br>
//!           Returns False if <disp> is not in the WorkSession or if a <br>
//!           root name is already defined for it <br>
Standard_EXPORT   Standard_Boolean SetFileRoot(const Handle(IFSelect_Dispatch)& disp,const Standard_CString name) ;

//! Extracts File Root Name from a given complete file name <br>
//!           (uses OSD_Path) <br>
Standard_EXPORT   Standard_CString GiveFileRoot(const Standard_CString file) const;

//! Completes a file name as required, with Prefix and Extension <br>
//!           (if defined; for a non-defined item, completes nothing) <br>
Standard_EXPORT   Standard_CString GiveFileComplete(const Standard_CString file) const;

//! Erases all stored data from the File Evaluation <br>
//!           (i.e. ALL former naming informations are lost) <br>
Standard_EXPORT   void ClearFile() ;

//! Performs and stores a File Evaluation. The Results are a List <br>
//!           of produced Models and a List of names (Strings), in parallel <br>
//!           Fills LastRunCheckList <br>
Standard_EXPORT   void EvaluateFile() ;

//! Returns the count of produced Models <br>
Standard_EXPORT   Standard_Integer NbFiles() const;

//! Returns a Model, given its rank in the Evaluation List <br>
Standard_EXPORT   Handle_Interface_InterfaceModel FileModel(const Standard_Integer num) const;

//! Returns the name of a file corresponding to a produced Model, <br>
//!           given its rank in the Evaluation List <br>
Standard_EXPORT   TCollection_AsciiString FileName(const Standard_Integer num) const;

//! Commands file sending to clear the list of already sent files, <br>
//!           commands to record a new one if <record> is True <br>
//!           This list is managed by the ModelCopier when SendSplit is called <br>
//!           It allows a global exploitation of the set of sent files <br>
Standard_EXPORT   void BeginSentFiles(const Standard_Boolean record) ;

//! Returns the list of recorded sent files, or a Null Handle is <br>
//!           recording has not been enabled <br>
Standard_EXPORT   Handle_TColStd_HSequenceOfHAsciiString SentFiles() const;

//! Performs creation of derived files from the input Model <br>
//!           Takes its data (sub-models and names), from result EvaluateFile <br>
//!           if active, else by dynamic Evaluation (not stored) <br>
//!           After SendSplit, result of EvaluateFile is Cleared <br>
//!           Fills LastRunCheckList <br>
//! <br>
//!           Works with the WorkLibrary which acts on specific type of Model <br>
//!           and can work with File Modifiers (managed by the Model Copier) <br>
//!           and a ModelCopier, which can work with Model Modifiers <br>
//!           Returns False if, either WorkLibrary has failed on at least <br>
//!           one sub-file, or the Work Session is badly conditionned <br>
//!           (no Model defined, or FileNaming not in phase with ShareOut) <br>
Standard_EXPORT   Standard_Boolean SendSplit() ;

//! Returns an Evaluation of the whole ShareOut definition : i.e. <br>
//!           how the entities of the starting model are forecast to be sent <br>
//!           to various files :  list of packets according the dispatches, <br>
//!           effective lists of roots for each packet (which determine the <br>
//!           content of the corresponding file); plus evaluation of which <br>
//!           entities are : forgotten (sent into no file), duplicated (sent <br>
//!           into more than one file), sent into a given file. <br>
//!           See the class PacketList for more details. <br>
Standard_EXPORT   Handle_IFSelect_PacketList EvalSplit() const;

//! Returns the list of Entities sent in files, accourding the <br>
//!           count of files each one has been sent (these counts are reset <br>
//!           by SetModel or SetRemaining(Forget) ) stored in Graph Status <br>
//!           <count> = -1 (default) is for ENtities sent at least once <br>
//!           <count> = 0 is for the Remaining List (entities not yet sent) <br>
//!           <count> = 1 is for entities sent in one and only one file <br>
//!             (the ideal case) <br>
//!           Remaining Data are computed on each Sending/Copying output <br>
//!           files (see methods EvaluateFile and SendSplit) <br>
//!           Graph Status is 0 for Remaining Entity, <count> for Sent into <br>
//!           <count> files <br>
//!           This status is set to 0 (not yet sent) for all by SetModel <br>
//!           and by SetRemaining(mode=Forget,Display) <br>
Standard_EXPORT   Interface_EntityIterator SentList(const Standard_Integer count = -1) const;

//! Returns the greater count of different files in which any of <br>
//!           the starting entities could be sent. <br>
//!           Before any file output, this count is 0. <br>
//!           Ideal count is 1. More than 1 means that duplications occur. <br>
Standard_EXPORT   Standard_Integer MaxSendingCount() const;

//! Processes Remaining data (after having sent files), mode : <br>
//!           Forget  : forget remaining info (i.e. clear all "Sent" status) <br>
//!           Compute : compute and keep remaining (does nothing if : <br>
//!                 remaining is empty or if no files has been sent) <br>
//!           Display : display entities recorded as remaining <br>
//!           Undo    : restore former state of data (after Remaining(1) ) <br>
//!           Returns True if OK, False else (i.e. mode = 2 and Remaining <br>
//!           List is either empty or takes all the entities, or mode = 3 <br>
//!           and no former computation of remaining data was done) <br>
Standard_EXPORT   Standard_Boolean SetRemaining(const IFSelect_RemainMode mode) ;

//! Sends the starting Model into one file, without splitting, <br>
//!           managing remaining data or anything else. <br>
//!           <computegraph> true commands the Graph to be recomputed before <br>
//!           sending : required when a Model is filled in several steps <br>
//! <br>
//!           The Model and File Modifiers recorded to be applied on sending <br>
//!           files are. <br>
//!           Returns a status of execution : Done if OK, Void if no def. <br>
//!             available, Error if errors occured, Fail if no file written <br>
//!           Fills LastRunCheckList <br>
Standard_EXPORT   IFSelect_ReturnStatus SendAll(const Standard_CString filename,const Standard_Boolean computegraph = Standard_False) ;

//! Sends a part of the starting Model into one file, without <br>
//!           splitting. But remaining data are managed. <br>
//!           <computegraph> true commands the Graph to be recomputed before <br>
//!           sending : required when a Model is filled in several steps <br>
//! <br>
//!           The Model and File Modifiers recorded to be applied on sending <br>
//!           files are. <br>
//!           Returns a status : Done if OK,  Fail if error during send, <br>
//!            Error : WorkLibrary not defined, Void : selection list empty <br>
//!           Fills LastRunCheckList <br>
Standard_EXPORT   IFSelect_ReturnStatus SendSelected(const Standard_CString filename,const Handle(IFSelect_Selection)& sel,const Standard_Boolean computegraph = Standard_False) ;

//! Writes the current Interface Model globally to a File, and <br>
//!           returns a write status which can be : <br>
//!             Done OK, Fail file could not be written, Error no norm is selected <br>
//! Remark  : It is a simple, one-file writing, other operations are <br>
//!           available (such as splitting ...) which calls SendAll <br>
Standard_EXPORT   IFSelect_ReturnStatus WriteFile(const Standard_CString filename) ;

//! Writes a sub-part of the current Interface Model to a File, <br>
//!           as defined by a Selection <sel>, recomputes the Graph, and <br>
//!           returns a write status which can be : <br>
//!             Done OK, Fail file could not be written, Error no norm is selected <br>
//! Remark  : It is a simple, one-file writing, other operations are <br>
//!           available (such as splitting ...) which calls SendSelected <br>
Standard_EXPORT   IFSelect_ReturnStatus WriteFile(const Standard_CString filename,const Handle(IFSelect_Selection)& sel) ;

//! Returns the count of Input Selections known for a Selection, <br>
//!           or 0 if <sel> not in the WorkSession. This count is one for a <br>
//!           SelectDeduct / SelectExtract kind, two for SelectControl kind, <br>
//!           variable for a SelectCombine (Union/Intersection), zero else <br>
Standard_EXPORT   Standard_Integer NbSources(const Handle(IFSelect_Selection)& sel) const;

//! Returns the <num>th Input Selection of a Selection <br>
//!           (see NbSources). <br>
//!           Returns a Null Handle if <sel> is not in the WorkSession or if <br>
//!           <num> is out of the range <1-NbSources> <br>
//!           To obtain more details, see the method Sources <br>
Standard_EXPORT   Handle_IFSelect_Selection Source(const Handle(IFSelect_Selection)& sel,const Standard_Integer num = 1) const;

//! Returns True if <sel> a Reversed SelectExtract, False else <br>
Standard_EXPORT   Standard_Boolean IsReversedSelectExtract(const Handle(IFSelect_Selection)& sel) const;

//! Toggles the Sense (Direct <-> Reversed) of a SelectExtract <br>
//!           Returns True if Done, False if <sel> is not a SelectExtract or <br>
//!           is not in the WorkSession <br>
Standard_EXPORT   Standard_Boolean ToggleSelectExtract(const Handle(IFSelect_Selection)& sel) ;

//! Sets an Input Selection (as <input>) to a SelectExtract or <br>
//!           a SelectDeduct (as <sel>). <br>
//!           Returns True if Done, False if <sel> is neither a <br>
//!           SelectExtract nor a SelectDeduct, or not in the WorkSession <br>
Standard_EXPORT   Standard_Boolean SetInputSelection(const Handle(IFSelect_Selection)& sel,const Handle(IFSelect_Selection)& input) ;

//! Sets an Input Selection, Main if <formain> is True, Second else <br>
//!           (as <sc>) to a SelectControl (as <sel>). Returns True if Done, <br>
//!           False if <sel> is not a SelectControl, or <sc> or <sel> is not <br>
//!           in the WorkSession <br>
Standard_EXPORT   Standard_Boolean SetControl(const Handle(IFSelect_Selection)& sel,const Handle(IFSelect_Selection)& sc,const Standard_Boolean formain = Standard_True) ;

//! Adds an input selection to a SelectCombine (Union or Inters.). <br>
//!           Returns new count of inputs for this SelectCombine if Done or <br>
//!           0 if <sel> is not kind of SelectCombine, or if <seladd> or <br>
//!           <sel> is not in the WorkSession <br>
//!           By default, adding is done at the end of the list <br>
//!           Else, it is an insertion to rank <atnum> (usefull for Un-ReDo) <br>
Standard_EXPORT   Standard_Integer CombineAdd(const Handle(IFSelect_Selection)& selcomb,const Handle(IFSelect_Selection)& seladd,const Standard_Integer atnum = 0) ;

//! Removes an input selection from a SelectCombine (Union or <br>
//!           Intersection). Returns True if done, False if <selcomb> is not <br>
//!           kind of SelectCombine or <selrem> is not source of <selcomb> <br>
Standard_EXPORT   Standard_Boolean CombineRemove(const Handle(IFSelect_Selection)& selcomb,const Handle(IFSelect_Selection)& selrem) ;

//! Creates a new Selection, of type SelectPointed, its content <br>
//!           starts with <list>. A name must be given (can be empty) <br>
Standard_EXPORT   Handle_IFSelect_Selection NewSelectPointed(const Handle(TColStd_HSequenceOfTransient)& list,const Standard_CString name) ;

//! Changes the content of a Selection of type SelectPointed <br>
//!           According <mode> : 0  set <list> as new content (clear former) <br>
//!             1  : adds <list> to actual content <br>
//!            -1  : removes <list> from actual content <br>
//!           Returns True if done, False if <sel> is not a SelectPointed <br>
Standard_EXPORT   Standard_Boolean SetSelectPointed(const Handle(IFSelect_Selection)& sel,const Handle(TColStd_HSequenceOfTransient)& list,const Standard_Integer mode) const;

//! Returns a Selection from a Name : <br>
//!           - the name of a Selection : this Selection <br>
//!           - the name of a Signature + criteria between (..) : a new <br>
//!             Selection from this Signature <br>
//!           - an entity or a list of entities : a new SelectPointed <br>
//!           Else, returns a Null Handle <br>
Standard_EXPORT   Handle_IFSelect_Selection GiveSelection(const Standard_CString selname) const;

//! Determines a list of entities from an object : <br>
//!           <obj> already HSequenceOfTransient : returned itself <br>
//!           <obj> Selection : its Result of Evaluation is returned <br>
//!           <obj> an entity of the Model : a HSequence which contains it <br>
//!           else, an empty HSequence <br>
//!           <obj> the Model it self : ALL its content (not only the roots) <br>
Standard_EXPORT   Handle_TColStd_HSequenceOfTransient GiveList(const Handle(Standard_Transient)& obj) const;

//! Computes a List of entities from two alphanums, <br>
//!           first and second, as follows : <br>
//!           if <first> is a Number or Label of an entity : this entity <br>
//!           if <first> is a list of Numbers/Labels : the list of entities <br>
//!           if <first> is the name of a Selection in <WS>, and <second> <br>
//!             not defined, the standard result of this Selection <br>
//!           else, let's consider "first second" : this whole phrase is <br>
//!           splitted by blanks, as follows (RECURSIVE CALL) : <br>
//!           - the leftest term is the final selection <br>
//!           - the other terms define the result of the selection <br>
//!           - and so on (the "leftest minus one" is a selection, of which <br>
//!             the input is given by the remaining ...) <br>
Standard_EXPORT   Handle_TColStd_HSequenceOfTransient GiveList(const Standard_CString first,const Standard_CString second = "") const;

//! Computes a List of entities from the model as follows <br>
//!           <first> beeing a Selection or a combination of Selections, <br>
//!             <ent> beeing an entity or a list <br>
//!           of entities (as a HSequenceOfTransient) : <br>
//!             the standard result of this selection applied to this list <br>
//!           if <ent> is Null, the standard definition of the selection is <br>
//!             used (which contains a default input selection) <br>
//!           if <selname> is erroneous, a null handle is returned <br>
//! <br>
//!           REMARK : selname is processed as <first second> of preceeding <br>
//!             GiveList <br>
Standard_EXPORT   Handle_TColStd_HSequenceOfTransient GiveListFromList(const Standard_CString selname,const Handle(Standard_Transient)& ent) const;

//! Combines two lists and returns the result, according to mode : <br>
//!           <mode> < 0 : entities in <l1> AND NOT in <l2> <br>
//!           <mode> = 0 : entities in <l1> AND in <l2> <br>
//!           <mode> > 0 : entities in <l1> OR  in <l2> <br>
Standard_EXPORT   Handle_TColStd_HSequenceOfTransient GiveListCombined(const Handle(TColStd_HSequenceOfTransient)& l1,const Handle(TColStd_HSequenceOfTransient)& l2,const Standard_Integer mode) const;

//! Loads data from a check iterator to query status on it <br>
Standard_EXPORT   void QueryCheckList(const Interface_CheckIterator& chl) ;

//! Determines check status for an entity regarding last call to <br>
//!           QueryCheckList : <br>
//!           -1 : <ent> unknown in the model, ignored <br>
//!            0 : no check at all, immediate or inherited thru Graph <br>
//!            1 : immediate warning (no fail), no inherited check <br>
//!            2 : immediate fail, no inherited check <br>
//!           +10 : idem but some inherited warning (no fail) <br>
//!           +20 : idem but some inherited fail <br>
Standard_EXPORT   Standard_Integer QueryCheckStatus(const Handle(Standard_Transient)& ent) const;

//! Determines if <entdad> is parent of <entson> (in the graph), <br>
//!           returns : -1 if no; 0 if <entdad> = <entson> <br>
//!           1 if immediate parent, > 1 if parent, gives count of steps <br>
Standard_EXPORT   Standard_Integer QueryParent(const Handle(Standard_Transient)& entdad,const Handle(Standard_Transient)& entson) const;

//! Sets a list of Parameters, i.e. TypedValue, to be handled <br>
//!           through an Editor <br>
//!           The two lists are parallel, if <params> is longer than <uses>, <br>
//!           surnumeral parameters are for general use <br>
//! <br>
//!           EditForms are created to handle these parameters (list, edit) <br>
//!           on the basis of a ParamEditor  xst-params-edit <br>
//! <br>
//!           A use number dispatches the parameter to a given EditForm <br>
//!           EditForms are defined as follows <br>
//!           Name                Use   Means <br>
//!           xst-params          all   All Parameters (complete list) <br>
//!           xst-params-general  1     Generals <br>
//!           xst-params-load     2     LoadFile (no Transfer) <br>
//!           xst-params-send     3     SendFile (Write, no Transfer) <br>
//!           xst-params-split    4     Split <br>
//!           xst-param-read      5     Transfer on Reading <br>
//!           xst-param-write     6     Transfer on Writing <br>
Standard_EXPORT   void SetParams(const TColStd_SequenceOfTransient& params,const TColStd_SequenceOfInteger& uselist) ;

//! Traces the Statics attached to a given use number <br>
//!           If <use> is given positive (normal), the trace is embedded <br>
//!           with a header and a trailer <br>
//!           If <use> is negative, just values are printed <br>
//!             (this allows to make compositions) <br>
//!           Remark : use number  5 commands use -2 to be traced <br>
//!           Remark : use numbers 4 and 6 command use -3 to be traced <br>
Standard_EXPORT   void TraceStatics(const Standard_Integer use,const Standard_Integer mode = 0) const;

//! Dumps contents of the ShareOut (on "cout") <br>
Standard_EXPORT   void DumpShare() const;

//! Lists the Labels of all Items of the WorkSession <br>
//!           If <label> is defined, lists labels which contain it <br>
Standard_EXPORT   void ListItems(const Standard_CString label = "") const;

//! Lists the Modifiers of the session (for each one, displays <br>
//!           its Label). Listing is done following Ranks (Modifiers are <br>
//!           invoked following their ranks) <br>
//!           Model Modifiers if <formodel> is True, File Modifiers else <br>
Standard_EXPORT   void ListFinalModifiers(const Standard_Boolean formodel) const;

//! Lists a Selection and its Sources (see SelectionIterator), <br>
//!           given its rank in the list <br>
Standard_EXPORT   void DumpSelection(const Handle(IFSelect_Selection)& sel) const;

//! Lists the content of the Input Model (if there is one) <br>
//!           According level : 0 -> gives only count of Entities and Roots <br>
//!           1 -> Lists also Roots;  2 -> Lists all Entities (by TraceType) <br>
//!           3 -> Performs a call to CheckList (Fails) and lists the result <br>
//!           4 -> as 3 but all CheckList (Fails + Warnings) <br>
//!           5,6,7  : as 3 but resp. Count,List,Labels by Fail <br>
//!           8,9,10 : as 4 but resp. Count,List,Labels by message <br>
Standard_EXPORT   void DumpModel(const Standard_Integer level,const Handle(Message_Messenger)& S) ;

//! Dumps the current Model (as inherited DumpModel), on currently <br>
//!           defined Default Trace File (default is standard output) <br>
Standard_EXPORT   void TraceDumpModel(const Standard_Integer mode) ;

//! Dumps a starting entity according to the current norm. <br>
//!           To do this, it calls DumpEntity from WorkLibrary. <br>
//!           <level> is to be interpreted for each norm : see specific <br>
//!           classes of WorkLibrary for it. Generally, 0 if for very basic <br>
//!           (only type ...), greater values give more and more details. <br>
Standard_EXPORT   void DumpEntity(const Handle(Standard_Transient)& ent,const Standard_Integer level,const Handle(Message_Messenger)& S) const;

//! Prints main informations about an entity : its number, type, <br>
//!           validity (and checks if any), category, shareds and sharings.. <br>
//!           mutable because it can recompute checks as necessary <br>
Standard_EXPORT   void PrintEntityStatus(const Handle(Standard_Transient)& ent,const Handle(Message_Messenger)& S) ;

//! Dumps an entity from the current Model as inherited DumpEntity <br>
//!           on currently defined Default Trace File <br>
//!           (<level> interpreted according to the Norm, see WorkLibrary) <br>
Standard_EXPORT   void TraceDumpEntity(const Handle(Standard_Transient)& ent,const Standard_Integer level) const;

//! Prints a CheckIterator to the current Trace File, controlled <br>
//!           with the current Model <br>
//!           complete or fails only, according to <failsonly> <br>
//!           <mode> defines the mode of printing <br>
//!           0 : sequential, according entities; else with a CheckCounter <br>
//!           1 : according messages, count of entities <br>
//!           2 : id but with list of entities, designated by their numbers <br>
//!           3 : as 2 but with labels of entities <br>
Standard_EXPORT   void PrintCheckList(const Interface_CheckIterator& checklist,const Standard_Boolean failsonly,const IFSelect_PrintCount mode) const;

//! Prints a SignatureList to the current Trace File, controlled <br>
//!           with the current Model <br>
//!           <mode> defines the mode of printing (see SignatureList) <br>
Standard_EXPORT   void PrintSignatureList(const Handle(IFSelect_SignatureList)& signlist,const IFSelect_PrintCount mode) const;

//! Displays the list of Entities selected by a Selection (i.e. <br>
//!           the result of EvalSelection). <br>
Standard_EXPORT   void EvaluateSelection(const Handle(IFSelect_Selection)& sel) const;

//! Displays the result of applying a Dispatch on the input Model <br>
//!           (also shows Remainder if there is) <br>
//!           <mode> = 0 (default), displays nothing else <br>
//!           <mode> = 1 : displays also duplicated entities (because of <br>
//!              this dispatch) <br>
//!           <mode> = 2 : displays the entities of the starting Model <br>
//!              which are not taken by this dispatch (forgotten entities) <br>
//!           <mode> = 3 : displays both duplicated and forgotten entities <br>
//!           Remark : EvaluateComplete displays these data evaluated for <br>
//!           for all the dispatches, if there are several <br>
Standard_EXPORT   void EvaluateDispatch(const Handle(IFSelect_Dispatch)& disp,const Standard_Integer mode = 0) const;

//! Displays the effect of applying the ShareOut on the input <br>
//!           Model. <br>
//!           <mode> = 0 (default) : displays only roots for each packet, <br>
//!           <mode> = 1 : displays all entities for each packet, plus <br>
//!             duplicated entities <br>
//!           <mode> = 2 : same as <mode> = 1, plus displays forgotten <br>
//!             entities (which are in no packet at all) <br>
Standard_EXPORT   void EvaluateComplete(const Standard_Integer mode = 0) const;

//! Internal method which displays an EntityIterator <br>
//!           <mode> 0 gives short display (only entity numbers) <br>
//!           1 gives a more complete trace (1 line per Entity) <br>
//!           (can be used each time a trace has to be output from a list) <br>
//!           2 gives a form suitable for givelist : (n1,n2,n3...) <br>
Standard_EXPORT   void ListEntities(const Interface_EntityIterator& iter,const Standard_Integer mode) const;
//Standard_EXPORT ~IFSelect_WorkSession();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
Handle_Interface_HGraph thegraph;
Interface_CheckIterator thecheckrun;
TColStd_IndexedDataMapOfTransientTransient theitems;
Handle_Dico_DictionaryOfTransient thenames;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean theerrhand;
Handle_IFSelect_ShareOut theshareout;
Handle_IFSelect_WorkLibrary thelibrary;
Handle_Interface_Protocol theprotocol;
Handle_Interface_InterfaceModel themodel;
TCollection_AsciiString theloaded;
Handle_Interface_GTool thegtool;
Standard_Boolean thecheckdone;
Interface_CheckIterator thechecklist;
TCollection_AsciiString thecheckana;
Handle_IFSelect_ModelCopier thecopier;
Handle_Interface_InterfaceModel theoldel;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
