// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Hermit_HeaderFile
#define _Hermit_HeaderFile

#ifndef _Handle_Geom2d_BSplineCurve_HeaderFile
#include <Handle_Geom2d_BSplineCurve.hxx>
#endif
#ifndef _Handle_Geom_BSplineCurve_HeaderFile
#include <Handle_Geom_BSplineCurve.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Geom2d_BSplineCurve;
class Geom_BSplineCurve;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This  is used to  reparameterize Rational  BSpline <br>
//!           Curves so that we can   concatenate them later to <br>
//!          build C1 Curves  It builds and 1D-reparameterizing <br>
//!          function starting from an Hermite interpolation and <br>
//!          adding knots and modifying poles of the 1D BSpline <br>
//!          obtained that way. The goal is to build a(u) so that <br>
//!          if we consider a BSpline curve <br>
//!                          N(u) <br>
//!                 f(u) =  ----- <br>
//!                          D(u) <br>
//! <br>
//!          the function a(u)D(u) has value 1 at the umin and umax <br>
//!          and has 0.0e0 derivative value a umin and umax. <br>
//!          The details of the computation occuring in this package <br>
//!          can be found by reading : <br>
//!          " Etude sur la concatenation de NURBS en vue du <br>
//!            balayage de surfaces" PFE n S85 Ensam Lille <br>
class Hermit  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT static  Handle_Geom2d_BSplineCurve Solution(const Handle(Geom_BSplineCurve)& BS,const Standard_Real TolPoles = 0.000001,const Standard_Real TolKnots = 0.000001) ;


Standard_EXPORT static  Handle_Geom2d_BSplineCurve Solution(const Handle(Geom2d_BSplineCurve)& BS,const Standard_Real TolPoles = 0.000001,const Standard_Real TolKnots = 0.000001) ;

//!returns the knots to insert to a(u) to <br>
//!         stay with a constant sign and in the <br>
//!         tolerances. <br>
Standard_EXPORT static  void Solutionbis(const Handle(Geom_BSplineCurve)& BS,Standard_Real& Knotmin,Standard_Real& Knotmax,const Standard_Real TolPoles = 0.000001,const Standard_Real TolKnots = 0.000001) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
