// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Blend_Point_HeaderFile
#define _Blend_Point_HeaderFile

#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _gp_Vec_HeaderFile
#include <gp_Vec.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _gp_Vec2d_HeaderFile
#include <gp_Vec2d.hxx>
#endif
class Standard_DomainError;
class gp_Pnt;
class gp_Vec;
class gp_Vec2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class Blend_Point  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT Blend_Point();

//! Creates a point on 2 surfaces, with tangents. <br>
Standard_EXPORT Blend_Point(const gp_Pnt& Pt1,const gp_Pnt& Pt2,const Standard_Real Param,const Standard_Real U1,const Standard_Real V1,const Standard_Real U2,const Standard_Real V2,const gp_Vec& Tg1,const gp_Vec& Tg2,const gp_Vec2d& Tg12d,const gp_Vec2d& Tg22d);

//! Creates a point on 2 surfaces, without tangents. <br>
Standard_EXPORT Blend_Point(const gp_Pnt& Pt1,const gp_Pnt& Pt2,const Standard_Real Param,const Standard_Real U1,const Standard_Real V1,const Standard_Real U2,const Standard_Real V2);

//! Creates a point on a surface and a curve, with tangents. <br>
Standard_EXPORT Blend_Point(const gp_Pnt& Pts,const gp_Pnt& Ptc,const Standard_Real Param,const Standard_Real U,const Standard_Real V,const Standard_Real W,const gp_Vec& Tgs,const gp_Vec& Tgc,const gp_Vec2d& Tg2d);

//! Creates a point on a surface and a curve, without tangents. <br>
Standard_EXPORT Blend_Point(const gp_Pnt& Pts,const gp_Pnt& Ptc,const Standard_Real Param,const Standard_Real U,const Standard_Real V,const Standard_Real W);

//! Creates a point on a surface and a curve on surface, <br>
//!          with tangents. <br>
Standard_EXPORT Blend_Point(const gp_Pnt& Pt1,const gp_Pnt& Pt2,const Standard_Real Param,const Standard_Real U1,const Standard_Real V1,const Standard_Real U2,const Standard_Real V2,const Standard_Real PC,const gp_Vec& Tg1,const gp_Vec& Tg2,const gp_Vec2d& Tg12d,const gp_Vec2d& Tg22d);

//! Creates a point on a surface and a curve on surface, <br>
//!          without tangents. <br>
Standard_EXPORT Blend_Point(const gp_Pnt& Pt1,const gp_Pnt& Pt2,const Standard_Real Param,const Standard_Real U1,const Standard_Real V1,const Standard_Real U2,const Standard_Real V2,const Standard_Real PC);

//! Creates a point on two curves on surfaces, with tangents. <br>
Standard_EXPORT Blend_Point(const gp_Pnt& Pt1,const gp_Pnt& Pt2,const Standard_Real Param,const Standard_Real U1,const Standard_Real V1,const Standard_Real U2,const Standard_Real V2,const Standard_Real PC1,const Standard_Real PC2,const gp_Vec& Tg1,const gp_Vec& Tg2,const gp_Vec2d& Tg12d,const gp_Vec2d& Tg22d);

//! Creates a point on two curves on surfaces, with tangents. <br>
Standard_EXPORT Blend_Point(const gp_Pnt& Pt1,const gp_Pnt& Pt2,const Standard_Real Param,const Standard_Real U1,const Standard_Real V1,const Standard_Real U2,const Standard_Real V2,const Standard_Real PC1,const Standard_Real PC2);

//! Set the values for a point on 2 surfaces, with tangents. <br>
Standard_EXPORT   void SetValue(const gp_Pnt& Pt1,const gp_Pnt& Pt2,const Standard_Real Param,const Standard_Real U1,const Standard_Real V1,const Standard_Real U2,const Standard_Real V2,const gp_Vec& Tg1,const gp_Vec& Tg2,const gp_Vec2d& Tg12d,const gp_Vec2d& Tg22d) ;

//! Set the values for a point on 2 surfaces, without tangents. <br>
Standard_EXPORT   void SetValue(const gp_Pnt& Pt1,const gp_Pnt& Pt2,const Standard_Real Param,const Standard_Real U1,const Standard_Real V1,const Standard_Real U2,const Standard_Real V2) ;

//! Set the values for a point on a surface and a curve, <br>
//!          with tangents. <br>
Standard_EXPORT   void SetValue(const gp_Pnt& Pts,const gp_Pnt& Ptc,const Standard_Real Param,const Standard_Real U,const Standard_Real V,const Standard_Real W,const gp_Vec& Tgs,const gp_Vec& Tgc,const gp_Vec2d& Tg2d) ;

//! Set the values for a point on a surface and a curve, <br>
//!          without tangents. <br>
Standard_EXPORT   void SetValue(const gp_Pnt& Pts,const gp_Pnt& Ptc,const Standard_Real Param,const Standard_Real U,const Standard_Real V,const Standard_Real W) ;

//! Creates a point on a surface and a curve on surface, <br>
//!          with tangents. <br>
Standard_EXPORT   void SetValue(const gp_Pnt& Pt1,const gp_Pnt& Pt2,const Standard_Real Param,const Standard_Real U1,const Standard_Real V1,const Standard_Real U2,const Standard_Real V2,const Standard_Real PC,const gp_Vec& Tg1,const gp_Vec& Tg2,const gp_Vec2d& Tg12d,const gp_Vec2d& Tg22d) ;

//! Creates a point on a surface and a curve on surface, <br>
//!          without tangents. <br>
Standard_EXPORT   void SetValue(const gp_Pnt& Pt1,const gp_Pnt& Pt2,const Standard_Real Param,const Standard_Real U1,const Standard_Real V1,const Standard_Real U2,const Standard_Real V2,const Standard_Real PC) ;

//! Creates a point on two curves on surfaces, with tangents. <br>
Standard_EXPORT   void SetValue(const gp_Pnt& Pt1,const gp_Pnt& Pt2,const Standard_Real Param,const Standard_Real U1,const Standard_Real V1,const Standard_Real U2,const Standard_Real V2,const Standard_Real PC1,const Standard_Real PC2,const gp_Vec& Tg1,const gp_Vec& Tg2,const gp_Vec2d& Tg12d,const gp_Vec2d& Tg22d) ;

//! Creates a point on two curves on surfaces, without tangents. <br>
Standard_EXPORT   void SetValue(const gp_Pnt& Pt1,const gp_Pnt& Pt2,const Standard_Real Param,const Standard_Real U1,const Standard_Real V1,const Standard_Real U2,const Standard_Real V2,const Standard_Real PC1,const Standard_Real PC2) ;

//! Creates a point on two curves. <br>
Standard_EXPORT   void SetValue(const gp_Pnt& Pt1,const gp_Pnt& Pt2,const Standard_Real Param,const Standard_Real PC1,const Standard_Real PC2) ;

  Standard_Real Parameter() const;
//! Returns Standard_True if it was not possible to compute <br>
//!          the tangent vectors at PointOnS1 and/or PointOnS2. <br>
  Standard_Boolean IsTangencyPoint() const;

 const gp_Pnt& PointOnS1() const;

 const gp_Pnt& PointOnS2() const;

  void ParametersOnS1(Standard_Real& U,Standard_Real& V) const;

  void ParametersOnS2(Standard_Real& U,Standard_Real& V) const;

 const gp_Vec& TangentOnS1() const;

 const gp_Vec& TangentOnS2() const;

  gp_Vec2d Tangent2dOnS1() const;

  gp_Vec2d Tangent2dOnS2() const;

 const gp_Pnt& PointOnS() const;

 const gp_Pnt& PointOnC() const;

  void ParametersOnS(Standard_Real& U,Standard_Real& V) const;

  Standard_Real ParameterOnC() const;

 const gp_Vec& TangentOnS() const;

 const gp_Vec& TangentOnC() const;

  gp_Vec2d Tangent2d() const;

 const gp_Pnt& PointOnC1() const;

 const gp_Pnt& PointOnC2() const;

  Standard_Real ParameterOnC1() const;

  Standard_Real ParameterOnC2() const;

 const gp_Vec& TangentOnC1() const;

 const gp_Vec& TangentOnC2() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
gp_Pnt pt1;
gp_Pnt pt2;
gp_Vec tg1;
gp_Vec tg2;
Standard_Real prm;
Standard_Real u1;
Standard_Real v1;
Standard_Real u2;
Standard_Real v2;
Standard_Real pc1;
Standard_Real pc2;
Standard_Real utg12d;
Standard_Real vtg12d;
Standard_Real utg22d;
Standard_Real vtg22d;
Standard_Boolean hass1;
Standard_Boolean hass2;
Standard_Boolean hasc1;
Standard_Boolean hasc2;
Standard_Boolean istgt;


};


#include <Blend_Point.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
