// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepOffsetAPI_MakeFilling_HeaderFile
#define _BRepOffsetAPI_MakeFilling_HeaderFile

#ifndef _BRepFill_Filling_HeaderFile
#include <BRepFill_Filling.hxx>
#endif
#ifndef _BRepBuilderAPI_MakeShape_HeaderFile
#include <BRepBuilderAPI_MakeShape.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
class StdFail_NotDone;
class Standard_OutOfRange;
class Standard_ConstructionError;
class TopoDS_Face;
class TopoDS_Edge;
class gp_Pnt;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! N-Side Filling <br>
//!  This algorithm avoids to build a face from: <br>
//!  * a set of edges defining the bounds of the face and some <br>
//!    constraints the surface of the face has to satisfy <br>
//!  * a set of edges and points defining some constraints <br>
//!    the support surface has to satisfy <br>
//!  * an initial surface to deform for satisfying the constraints <br>
//!  * a set of parameters to control the constraints. <br>
class BRepOffsetAPI_MakeFilling  : public BRepBuilderAPI_MakeShape {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Constructs a wire filling object defined by <br>
//! - the energy minimizing criterion Degree <br>
//! - the number of points on the curve NbPntsOnCur <br>
//! - the number of iterations NbIter <br>
//! - the Boolean Anisotropie <br>
//! - the 2D tolerance Tol2d <br>
//! - the 3D tolerance Tol3d <br>
//! - the angular tolerance TolAng <br>
//! - the tolerance for curvature TolCur <br>
//! - the highest polynomial degree MaxDeg <br>
//! - the greatest number of segments MaxSeg. <br>
//! If the Boolean Anistropie is true, the algorithm's <br>
//! performance is better in cases where the ratio of the <br>
//! length U and the length V indicate a great difference <br>
//! between the two. In other words, when the surface is, for <br>
//! example, extremely long. <br>
Standard_EXPORT BRepOffsetAPI_MakeFilling(const Standard_Integer Degree = 3,const Standard_Integer NbPtsOnCur = 15,const Standard_Integer NbIter = 2,const Standard_Boolean Anisotropie = Standard_False,const Standard_Real Tol2d = 0.00001,const Standard_Real Tol3d = 0.0001,const Standard_Real TolAng = 0.01,const Standard_Real TolCurv = 0.1,const Standard_Integer MaxDeg = 8,const Standard_Integer MaxSegments = 9);

//! Sets the values of Tolerances used to control the constraint. <br>
//!	Tol2d: <br>
//!	Tol3d:   it is the maximum distance allowed between the support surface <br>
//!	         and the constraints <br>
//!	TolAng:  it is the maximum angle allowed between the normal of the surface <br>
//!	         and the constraints <br>
//!	TolCurv: it is the maximum difference of curvature allowed between <br>
//!	         the surface and the constraint <br>
Standard_EXPORT   void SetConstrParam(const Standard_Real Tol2d = 0.00001,const Standard_Real Tol3d = 0.0001,const Standard_Real TolAng = 0.01,const Standard_Real TolCurv = 0.1) ;

//! Sets the parameters used for resolution. <br>
//!	The default values of these parameters have been chosen for a good <br>
//!	ratio quality/performance. <br>
//!	Degree:      it is the order of energy criterion to minimize for computing <br>
//!	             the deformation of the surface. <br>
//!	             The default value is 3 <br>
//!	             The recommanded value is i+2 where i is the maximum order of the <br>
//!	             constraints. <br>
//!	NbPtsOnCur:  it is the average number of points for discretisation <br>
//!	             of the edges. <br>
//!	NbIter:      it is the maximum number of iterations of the process. <br>
//!	             For each iteration the number of discretisation points is <br>
//!	             increased. <br>
//!	Anisotropie: <br>
Standard_EXPORT   void SetResolParam(const Standard_Integer Degree = 3,const Standard_Integer NbPtsOnCur = 15,const Standard_Integer NbIter = 2,const Standard_Boolean Anisotropie = Standard_False) ;

//! Sets the parameters used to approximate the filling <br>
//! surface. These include: <br>
//! - MaxDeg - the highest degree which the polynomial <br>
//!   defining the filling surface can have <br>
//! - MaxSegments - the greatest number of segments <br>
//!   which the filling surface can have. <br>
Standard_EXPORT   void SetApproxParam(const Standard_Integer MaxDeg = 8,const Standard_Integer MaxSegments = 9) ;

//! Loads the initial surface Surf to <br>
//! begin the construction of the surface. <br>
//! This optional function is useful if the surface resulting from <br>
//! construction for the algorithm is likely to be complex. <br>
//! The support surface of the face under construction is computed by a <br>
//! deformation of Surf which satisfies the given constraints. <br>
//! The set of bounding edges defines the wire of the face. <br>
//! If no initial surface is given, the algorithm computes it <br>
//! automatically. If the set of edges is not connected (Free constraint), <br>
//! missing edges are automatically computed. <br>
Standard_EXPORT   void LoadInitSurface(const TopoDS_Face& Surf) ;

//! Adds a new constraint which also defines an edge of the wire <br>
//!	        of the face <br>
//!	Order: Order of the constraint: <br>
//!	       GeomAbs_C0 : the surface has to pass by 3D representation <br>
//!	                    of the edge <br>
//!	       GeomAbs_G1 : the surface has to pass by 3D representation <br>
//!	                    of the edge and to respect tangency with the first <br>
//!	                    face of the edge <br>
//!	       GeomAbs_G2 : the surface has to pass by 3D representation <br>
//!	                    of the edge and to respect tangency and curvature <br>
//!	                    with the first face of the edge. <br>
//!  Raises ConstructionError if the edge has no representation on a face and Order is <br>
//! GeomAbs_G1 or GeomAbs_G2. <br>
Standard_EXPORT   Standard_Integer Add(const TopoDS_Edge& Constr,const GeomAbs_Shape Order,const Standard_Boolean IsBound = Standard_True) ;

//! Adds a new constraint which also defines an edge of the wire <br>
//!	        of the face <br>
//!	Order: Order of the constraint: <br>
//!	       GeomAbs_C0 : the surface has to pass by 3D representation <br>
//!	                    of the edge <br>
//!	       GeomAbs_G1 : the surface has to pass by 3D representation <br>
//!	                    of the edge and to respect tangency with the <br>
//!	                    given face <br>
//!	       GeomAbs_G2 : the surface has to pass by 3D representation <br>
//!	                    of the edge and to respect tangency and curvature <br>
//!                    with the given face. <br>
//! Raises ConstructionError if the edge has no 2d representation on the given face <br>
Standard_EXPORT   Standard_Integer Add(const TopoDS_Edge& Constr,const TopoDS_Face& Support,const GeomAbs_Shape Order,const Standard_Boolean IsBound = Standard_True) ;

//! Adds a free constraint on a face. The corresponding edge has to <br>
//!	be automatically recomputed. It is always a bound. <br>
Standard_EXPORT   Standard_Integer Add(const TopoDS_Face& Support,const GeomAbs_Shape Order) ;

//! Adds a punctual constraint. <br>
Standard_EXPORT   Standard_Integer Add(const gp_Pnt& Point) ;

//! Adds a punctual constraint. <br>
Standard_EXPORT   Standard_Integer Add(const Standard_Real U,const Standard_Real V,const TopoDS_Face& Support,const GeomAbs_Shape Order) ;

//! Builds the resulting faces <br>
Standard_EXPORT virtual  void Build() ;

//! Tests whether computation of the filling plate has been completed. <br>
Standard_EXPORT virtual  Standard_Boolean IsDone() const;

//! Returns the maximum distance between the result and <br>
//! the constraints. This is set at construction time. <br>
Standard_EXPORT   Standard_Real G0Error() const;

//! Returns the maximum angle between the result and the <br>
//! constraints. This is set at construction time. <br>
Standard_EXPORT   Standard_Real G1Error() const;

//! Returns the maximum angle between the result and the <br>
//! constraints. This is set at construction time. <br>
Standard_EXPORT   Standard_Real G2Error() const;

//! Returns the maximum distance attained between the <br>
//! result and the constraint Index. This is set at construction time. <br>
Standard_EXPORT   Standard_Real G0Error(const Standard_Integer Index) ;

//! Returns the maximum angle between the result and the <br>
//! constraints. This is set at construction time. <br>
Standard_EXPORT   Standard_Real G1Error(const Standard_Integer Index) ;

//! Returns the greatest difference in curvature found <br>
//! between the result and the constraint Index. <br>
Standard_EXPORT   Standard_Real G2Error(const Standard_Integer Index) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
BRepFill_Filling myFilling;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
