//
// C++ Implementation: PlainPicture
//
// Description:
//
//
// Author: Yorn <yorn@gmx.net>, (C) 2009
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "plainPicture.h"
#include "pictureResize.h"
#include "pictureLoader.h"
#include <cstdlib>

PlainPicture::PlainPicture()
    : Effector(), state(unconfigured), framecounter(0)
{
}


PlainPicture::~PlainPicture()
{
}

Effector & PlainPicture::operator >>(RGBPlane & plane)
{

  if (!available())
    return(*this);

  plane = presentationPlane;

  framecounter++;
  if (framecounter > config.sequenceLength) {
    state = unavailable;
  }

  return(*this);
}

void PlainPicture::configure(PlainPictureConfig & _config)
{

  framecounter = 0;
  config = _config;

  /* resize the picture to the correct size */
  presentationPlane = PictureResize::reframe(config.origPlane, config.outputWidth, config.outputHeight);

  state = presentation;

}

bool PlainPicture::available()
{

  return((state!=unavailable) && (state!=unconfigured));

}


