//
// C++ Implementation: cmdlineextractor
//
// Description:
//
//
// Author: Yorn <yorn@gmx.net>, (C) 2009
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "cmdlineextractor.h"

#include <iostream>
#include <sstream>
#include <vector>
#include <string>

#include "definition.h"
#include "oggComment.h"
#include "pictureLoader.h"

CmdlineExtractor::CmdlineExtractor()
{
}


CmdlineExtractor::~CmdlineExtractor()
{
}


void CmdlineExtractor::extractCommentPairs ( std::vector<OggComment>& list,
    const std::string& _argument, char tokenSeparator, char commentSeparator )
{
  std::string argument ( _argument );
  std::stringstream str;
  std::string substr;

  // delete all invalid data
  std::size_t pos;
  while ( ( pos = argument.find_first_not_of ( validTextChars ) )
          != std::string::npos ) {
#ifdef DEBUG
    std::cerr << "Erasing sign <"<<argument.at ( pos ) <<"> - it is invalid\n";
#endif
    argument.erase ( pos, 1 );
  }

  // if there is no argument given, the first frame will be created as a thumbnail
  if ( argument.empty() ) {
    return;
  }

  str << argument;

  while ( !str.eof() ) {
    getline ( str, substr, tokenSeparator );

    std::size_t commentSeparatorPos;
    if ( ( commentSeparatorPos = substr.find_first_of ( commentSeparator ) )
         != std::string::npos ) {
      OggComment comment;
      comment.tag = substr.substr ( 0, commentSeparatorPos );
      comment.value = substr.substr ( commentSeparatorPos+1,
                                      std::string::npos );
      list.push_back ( comment );
//			std::cerr << "Found pair "<<comment.tag<<" "<<comment.value
//			<<std::endl;
    }

  }

}

void CmdlineExtractor::extractUint32 ( std::deque<uint32>& list, const std::string& _argument,
                                       char seperator )
{
  std::string argument ( _argument );
  std::stringstream str;
  std::string substr;

  // delete all invalid data
  std::size_t pos;
  while ( ( pos = argument.find_first_not_of ( validChars ) ) != std::string::npos ) {
#ifdef DEBUG
    std::cerr << "erasing <"<<argument.at ( pos ) <<">\n";
#endif
    argument.erase ( pos, 1 );
  }

  // if there is no argument given, the first frame will be created as a thumbnail
  if ( argument.empty() ) {
    list.push_back ( 0 );
    return;
  }

  str << argument;

  uint32 value ( 0 );
  while ( !str.eof() ) {
    std::stringstream part;
    getline ( str, substr, seperator );
    part << substr;
    part >> value;
    list.push_back ( value );
  }

}

void CmdlineExtractor::extractBlend ( std::vector<BlendElement>& list, const std::string& _argument,
                                      char tokenSeparator, char valueSeparator )
{

  std::string argument ( _argument );
  std::stringstream str;
  std::string substr;

  // delete all invalid data
  std::size_t pos;
  while ( ( pos = argument.find_first_not_of ( validTextChars ) )
          != std::string::npos ) {
    argument.erase ( pos, 1 );
  }

  // if there is no argument given, the first frame will be created as a thumbnail
  if ( argument.empty() ) {
    return;
  }

  str << argument;

  while ( !str.eof() ) {
    getline ( str, substr, tokenSeparator );

    /* extract picture name */
    std::size_t valueSeparatorPos = substr.find_first_of ( valueSeparator );

    std::string filename = substr.substr ( 0, valueSeparatorPos );

    /* extract all extra data if some (start time, end time, smoothing)*/
    double startTime ( 0 );
    double endTime ( -1 );
    bool smooth ( false );
    std::stringstream tmp;

    /* are there any other information given? */
    if ( valueSeparatorPos != std::string::npos ) {

      /* analysing start time */
      substr = substr.substr ( valueSeparatorPos+1 );

      valueSeparatorPos = substr.find_first_of ( valueSeparator );

      tmp << substr.substr ( 0, valueSeparatorPos );
      tmp >> startTime;
      tmp.clear();

      if ( valueSeparatorPos != std::string::npos ) {

        /* analysing start time */
        substr = substr.substr ( valueSeparatorPos+1 );

        valueSeparatorPos = substr.find_first_of ( valueSeparator );

        tmp << substr.substr ( 0, valueSeparatorPos );
        tmp >> endTime;

        if ( valueSeparatorPos != std::string::npos ) {

          /* analysing start time */
          substr = substr.substr ( valueSeparatorPos+1 );

          if ( substr.substr ( 0, valueSeparator ) == "s" )
            smooth = true;
        }
      }

    }

    RGBPlane plane;
    try {

      if ( PictureLoader::load (plane, filename ) ) {
        BlendElement elem ( plane, startTime, endTime, smooth );
        list.push_back ( elem );
      }

    } catch ( char* data ) {
      std::cerr << "Error: "<<data<<std::endl;
    }

  }

#ifdef DEBUG
  for ( uint32 i ( 0 ); i<list.size(); ++i ) {
    std::cerr << "Info: picture"<<i<<": startTime="<<list[i].startTime
              <<" endTime="<<list[i].endTime<<" smooth=";
    if ( list[i].smooth == true )
      std::cerr << "true\n";
    else
      std::cerr << "false\n";

  }
#endif
}


