#include "converter.h"

#include <tjutils/tjlog_code.h>

const char* OdinData::get_compName() {return "Data";}
LOGGROUNDWORK(OdinData)


#ifdef USE_OIL
extern "C" {
#include <liboil/liboil.h>
}

/** some liboil based explicit implementations of convert_array_impl(const Src* src, Dst* dst, unsigned int count) */

#define IMPL_CONVERT_NC(SRC_TYPE,DST_TYPE,SRC_KEY,DST_KEY)                                           \
void Converter::convert_array_impl(const SRC_TYPE  *src,DST_TYPE *dst, unsigned int count){     \
	Log<OdinData> odinlog("Converter","convert_array_impl(liboil)");                             \
	ODINLOG(odinlog,normalDebug) << "calling oil_conv for " <<                                                 \
	TypeTraits::type2label(*src) << "=>" << TypeTraits::type2label(*dst) << STD_endl;                 \
  oil_conv_ ## DST_KEY ## _ ## SRC_KEY (dst,sizeof(DST_TYPE),src,sizeof(SRC_TYPE),count);            \
}

//>>s32
IMPL_CONVERT_NC(float,int32_t,f32,s32)
IMPL_CONVERT_NC(double,int32_t,f64,s32)
IMPL_CONVERT_NC(uint32_t,int32_t,u32,s32)
IMPL_CONVERT_NC(int16_t,int32_t,s16,s32)
IMPL_CONVERT_NC(uint16_t,int32_t,u16,s32)
IMPL_CONVERT_NC(int8_t,int32_t,s8,s32)
IMPL_CONVERT_NC(uint8_t,int32_t,u8,s32)

//>>u32
//IMPL_CONVERT_NC(float,uint32_t,f32,u32)
//IMPL_CONVERT_NC(double,uint32_t,f64,u32)
IMPL_CONVERT_NC(int32_t,uint32_t,s32,u32)
//IMPL_CONVERT_NC(int16_t,uint32_t,s16,u32) ** Not available in liboil - but should be imho
IMPL_CONVERT_NC(uint16_t,uint32_t,u16,u32)
//IMPL_CONVERT_NC(int8_t,uint32_t,s8,u32) ** Not available in liboil - but should be imho
IMPL_CONVERT_NC(uint8_t,uint32_t,u8,u32)

//>>s16
IMPL_CONVERT_NC(float,int16_t,f32,s16)
IMPL_CONVERT_NC(double,int16_t,f64,s16)
IMPL_CONVERT_NC(int32_t,int16_t,s32,s16)
IMPL_CONVERT_NC(uint32_t,int16_t,u32,s16)
IMPL_CONVERT_NC(uint16_t,int16_t,u16,s16)
IMPL_CONVERT_NC(int8_t,int16_t,s8,s16)
IMPL_CONVERT_NC(uint8_t,int16_t,u8,s16)

//>>u16
IMPL_CONVERT_NC(float,uint16_t,f32,u16)
IMPL_CONVERT_NC(double,uint16_t,f64,u16)
IMPL_CONVERT_NC(int32_t,uint16_t,s32,u16)
IMPL_CONVERT_NC(uint32_t,uint16_t,u32,u16)
IMPL_CONVERT_NC(int16_t,uint16_t,s16,u16)
//IMPL_CONVERT_NC(int8_t,uint16_t,s8,u16) ** Not available in liboil - but should be imho
IMPL_CONVERT_NC(uint8_t,uint16_t,u8,u16)

//>>s8
IMPL_CONVERT_NC(float,int8_t,f32,s8)
IMPL_CONVERT_NC(double,int8_t,f64,s8)
IMPL_CONVERT_NC(int32_t,int8_t,s32,s8)
IMPL_CONVERT_NC(uint32_t,int8_t,u32,s8)
IMPL_CONVERT_NC(int16_t,int8_t,s16,s8)
IMPL_CONVERT_NC(uint16_t,int8_t,u16,s8)
IMPL_CONVERT_NC(uint8_t,int8_t,u8,s8)

//>>u8
IMPL_CONVERT_NC(float,uint8_t,f32,u8)
IMPL_CONVERT_NC(double,uint8_t,f64,u8)
IMPL_CONVERT_NC(int32_t,uint8_t,s32,u8)
IMPL_CONVERT_NC(uint32_t,uint8_t,u32,u8)
IMPL_CONVERT_NC(int16_t,uint8_t,s16,u8)
IMPL_CONVERT_NC(uint16_t,uint8_t,u16,u8)
IMPL_CONVERT_NC(int8_t,uint8_t,s8,u8)

//>>f32
IMPL_CONVERT_NC(double,float,f64,f32)
IMPL_CONVERT_NC(int32_t,float,s32,f32)
IMPL_CONVERT_NC(uint32_t,float,u32,f32)
IMPL_CONVERT_NC(int16_t,float,s16,f32)
IMPL_CONVERT_NC(uint16_t,float,u16,f32)
IMPL_CONVERT_NC(int8_t,float,s8,f32)
IMPL_CONVERT_NC(uint8_t,float,u8,f32)

//>>f64
IMPL_CONVERT_NC(float,double,f32,f64)
IMPL_CONVERT_NC(int32_t,double,s32,f64)
IMPL_CONVERT_NC(uint32_t,double,u32,f64)
IMPL_CONVERT_NC(int16_t,double,s16,f64)
IMPL_CONVERT_NC(uint16_t,double,u16,f64)
IMPL_CONVERT_NC(int8_t,double,s8,f64)
IMPL_CONVERT_NC(uint8_t,double,u8,f64)

#define IMPL_SCALED_CONVERT(SRC_TYPE,DST_TYPE,SRC_KEY,DST_KEY)                                                                         \
void Converter::convert_array_impl(const SRC_TYPE  *src,DST_TYPE *dst,const unsigned int count,const double scale,const double offset){\
	Log<OdinData> odinlog("Converter","convert_array_impl(Using liboil)");                                                               \
	ODINLOG(odinlog,normalDebug) << "calling oil_scaleconv for " <<                                                                              \
	TypeTraits::type2label(*src) << "=>" << TypeTraits::type2label(*dst) << STD_endl;                                                   \
	oil_scaleconv_ ## DST_KEY ## _ ## SRC_KEY (dst,src,count,&offset,&scale);                                                          \
}

//scale>>s32
IMPL_SCALED_CONVERT(float,int32_t,f32,s32)
IMPL_SCALED_CONVERT(double,int32_t,f64,s32)

//scale>>u32
//IMPL_SCALED_CONVERT(float,uint32_t,f32,u32)
//IMPL_SCALED_CONVERT(double,uint32_t,f64,u32)

//scale>>s16
IMPL_SCALED_CONVERT(float,int16_t,f32,s16)
IMPL_SCALED_CONVERT(double,int16_t,f64,s16)

//scale>>u16
IMPL_SCALED_CONVERT(float,uint16_t,f32,u16)
IMPL_SCALED_CONVERT(double,uint16_t,f64,u16)

//scale>>s8
IMPL_SCALED_CONVERT(float,int8_t,f32,s8)
IMPL_SCALED_CONVERT(double,int8_t,f64,s8)

//scale>>u8
IMPL_SCALED_CONVERT(float,uint8_t,f32,u8)
IMPL_SCALED_CONVERT(double,uint8_t,f64,u8)

//scale>>f32
IMPL_SCALED_CONVERT(int32_t,float,s32,f32)
IMPL_SCALED_CONVERT(uint32_t,float,u32,f32)
IMPL_SCALED_CONVERT(int16_t,float,s16,f32)
IMPL_SCALED_CONVERT(uint16_t,float,u16,f32)
IMPL_SCALED_CONVERT(int8_t,float,s8,f32)
IMPL_SCALED_CONVERT(uint8_t,float,u8,f32)

//scale>>f64
IMPL_SCALED_CONVERT(int32_t,double,s32,f64)
IMPL_SCALED_CONVERT(uint32_t,double,u32,f64)
IMPL_SCALED_CONVERT(int16_t,double,s16,f64)
IMPL_SCALED_CONVERT(uint16_t,double,u16,f64)
IMPL_SCALED_CONVERT(int8_t,double,s8,f64)
IMPL_SCALED_CONVERT(uint8_t,double,u8,f64)

#undef IMPL_CONVERT
#undef IMPL_CONVERT_NC
#undef IMPL_SCALED_CONVERT
#endif //USE_OIL


/*!
    \fn Converter::init()
 */
void Converter::init(){
#ifdef USE_OIL
	Log<OdinData> odinlog("Converter","init");
  oil_init();
#endif
}

