// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BRepLib_MakeFace_HeaderFile
#define _BRepLib_MakeFace_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _BRepLib_FaceError_HeaderFile
#include <BRepLib_FaceError.hxx>
#endif
#ifndef _BRepLib_MakeShape_HeaderFile
#include <BRepLib_MakeShape.hxx>
#endif
#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class StdFail_NotDone;
class TopoDS_Face;
class gp_Pln;
class gp_Cylinder;
class gp_Cone;
class gp_Sphere;
class gp_Torus;
class Geom_Surface;
class TopoDS_Wire;


//! Provides methods to build faces. <br>
//! <br>
//!          A face may be built : <br>
//! <br>
//!          * From a surface. <br>
//! <br>
//!             - Elementary surface from gp. <br>
//! <br>
//!             - Surface from Geom. <br>
//! <br>
//!          * From a surface and U,V values. <br>
//! <br>
//!          * From a wire. <br>
//! <br>
//!            - Find the surface automatically if possible. <br>
//! <br>
//!          * From a surface and a wire. <br>
//! <br>
//!            - A flag Inside is given, when this flag is True <br>
//!            the  wire is  oriented to bound a finite area on <br>
//!            the surface. <br>
//! <br>
//!          * From a face and a wire. <br>
//! <br>
//!            - The new wire is a perforation. <br>
class BRepLib_MakeFace  : public BRepLib_MakeShape {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! Not done. <br>
  Standard_EXPORT   BRepLib_MakeFace();
  //! Load a face. Usefull to add wires. <br>
  Standard_EXPORT   BRepLib_MakeFace(const TopoDS_Face& F);
  //! Make a face from a plane. <br>
  Standard_EXPORT   BRepLib_MakeFace(const gp_Pln& P);
  //! Make a face from a cylinder. <br>
  Standard_EXPORT   BRepLib_MakeFace(const gp_Cylinder& C);
  //! Make a face from a cone. <br>
  Standard_EXPORT   BRepLib_MakeFace(const gp_Cone& C);
  //! Make a face from a sphere. <br>
  Standard_EXPORT   BRepLib_MakeFace(const gp_Sphere& S);
  //! Make a face from a torus. <br>
  Standard_EXPORT   BRepLib_MakeFace(const gp_Torus& C);
  //! Make a face from a Surface. <br>
  Standard_EXPORT   BRepLib_MakeFace(const Handle(Geom_Surface)& S);
  //! Make a face from a plane. <br>
  Standard_EXPORT   BRepLib_MakeFace(const gp_Pln& P,const Standard_Real UMin,const Standard_Real UMax,const Standard_Real VMin,const Standard_Real VMax);
  //! Make a face from a cylinder. <br>
  Standard_EXPORT   BRepLib_MakeFace(const gp_Cylinder& C,const Standard_Real UMin,const Standard_Real UMax,const Standard_Real VMin,const Standard_Real VMax);
  //! Make a face from a cone. <br>
  Standard_EXPORT   BRepLib_MakeFace(const gp_Cone& C,const Standard_Real UMin,const Standard_Real UMax,const Standard_Real VMin,const Standard_Real VMax);
  //! Make a face from a sphere. <br>
  Standard_EXPORT   BRepLib_MakeFace(const gp_Sphere& S,const Standard_Real UMin,const Standard_Real UMax,const Standard_Real VMin,const Standard_Real VMax);
  //! Make a face from a torus. <br>
  Standard_EXPORT   BRepLib_MakeFace(const gp_Torus& C,const Standard_Real UMin,const Standard_Real UMax,const Standard_Real VMin,const Standard_Real VMax);
  //! Make a face from a Surface. <br>
  Standard_EXPORT   BRepLib_MakeFace(const Handle(Geom_Surface)& S,const Standard_Real UMin,const Standard_Real UMax,const Standard_Real VMin,const Standard_Real VMax);
  //! Find a surface from the wire and make a face. <br>
//!          if <OnlyPlane> is true, the computed surface will be <br>
//!          a plane. If it is not possible to find a plane, the <br>
//!          flag NotDone will be set. <br>
  Standard_EXPORT   BRepLib_MakeFace(const TopoDS_Wire& W,const Standard_Boolean OnlyPlane = Standard_False);
  //! Make a face from a plane and a wire. <br>
  Standard_EXPORT   BRepLib_MakeFace(const gp_Pln& P,const TopoDS_Wire& W,const Standard_Boolean Inside = Standard_True);
  //! Make a face from a cylinder and a wire. <br>
  Standard_EXPORT   BRepLib_MakeFace(const gp_Cylinder& C,const TopoDS_Wire& W,const Standard_Boolean Inside = Standard_True);
  //! Make a face from a cone and a wire. <br>
  Standard_EXPORT   BRepLib_MakeFace(const gp_Cone& C,const TopoDS_Wire& W,const Standard_Boolean Inside = Standard_True);
  //! Make a face from a sphere and a wire. <br>
  Standard_EXPORT   BRepLib_MakeFace(const gp_Sphere& S,const TopoDS_Wire& W,const Standard_Boolean Inside = Standard_True);
  //! Make a face from a torus and a wire. <br>
  Standard_EXPORT   BRepLib_MakeFace(const gp_Torus& C,const TopoDS_Wire& W,const Standard_Boolean Inside = Standard_True);
  //! Make a face from a Surface and a wire. <br>
  Standard_EXPORT   BRepLib_MakeFace(const Handle(Geom_Surface)& S,const TopoDS_Wire& W,const Standard_Boolean Inside = Standard_True);
  //! Adds the wire <W> in the face <F> <br>
  Standard_EXPORT   BRepLib_MakeFace(const TopoDS_Face& F,const TopoDS_Wire& W);
  //! Load the face. <br>
  Standard_EXPORT     void Init(const TopoDS_Face& F) ;
  //! Creates the face  from the  surface.  If Bound  is <br>
//!          True a wire is made from the natural bounds. <br>
  Standard_EXPORT     void Init(const Handle(Geom_Surface)& S,const Standard_Boolean Bound = Standard_True) ;
  //! Creates the face from the surface  and the min-max <br>
//!          values. <br>
  Standard_EXPORT     void Init(const Handle(Geom_Surface)& S,const Standard_Real UMin,const Standard_Real UMax,const Standard_Real VMin,const Standard_Real VMax) ;
  //! Adds the wire <W> in the current face. <br>
  Standard_EXPORT     void Add(const TopoDS_Wire& W) ;
  
  Standard_EXPORT     BRepLib_FaceError Error() const;
  //! Returns the new face. <br>
//! <br>
  Standard_EXPORT    const TopoDS_Face& Face() const;
Standard_EXPORT operator TopoDS_Face() const;





protected:





private:

  //! Reorient the current face if  the boundary  is not <br>
//!          finite. <br>
  Standard_EXPORT     void CheckInside() ;


BRepLib_FaceError myError;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
