// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _ChFiDS_Spine_HeaderFile
#define _ChFiDS_Spine_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_ChFiDS_Spine_HeaderFile
#include <Handle_ChFiDS_Spine.hxx>
#endif

#ifndef _BRepAdaptor_Curve_HeaderFile
#include <BRepAdaptor_Curve.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _ChFiDS_State_HeaderFile
#include <ChFiDS_State.hxx>
#endif
#ifndef _TopTools_SequenceOfShape_HeaderFile
#include <TopTools_SequenceOfShape.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfReal_HeaderFile
#include <Handle_TColStd_HArray1OfReal.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _ChFiDS_ListOfHElSpine_HeaderFile
#include <ChFiDS_ListOfHElSpine.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _gp_Vec_HeaderFile
#include <gp_Vec.hxx>
#endif
#ifndef _ChFiDS_ErrorStatus_HeaderFile
#include <ChFiDS_ErrorStatus.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Handle_ChFiDS_HElSpine_HeaderFile
#include <Handle_ChFiDS_HElSpine.hxx>
#endif
#ifndef _GeomAbs_CurveType_HeaderFile
#include <GeomAbs_CurveType.hxx>
#endif
class TColStd_HArray1OfReal;
class TopoDS_Edge;
class ChFiDS_HElSpine;
class ChFiDS_ListOfHElSpine;
class gp_Pnt;
class gp_Vec;
class BRepAdaptor_Curve;
class gp_Lin;
class gp_Circ;
class TopoDS_Vertex;


//! Contains information necessary for construction of <br>
//!          a 3D fillet : <br>
//! <br>
//! <br>
//!          - guideline composed of edges of the solid, tangents <br>
//!          between them, and borders by faces tangents <br>
//!          between them. <br>
//! <br>
//!          Tools for construction of the Sp <br>
//!          by propagation from an edge of solid <br>
//!          are provided in the Builder of Fil3d. <br>
//! <br>
//!          The Spine contains among others the <br>
//!          information about the nature of extremities <br>
//!          of the fillet ( on free border , on section or closed ). <br>
//! <br>
//!          IMPORTANT NOTE  :    the guideline <br>
//!          represented in this way is not C2, although the path <br>
//!          claims it. Several palliative workarounds <br>
//!          (see the methods at the end) are planned, <br>
//!          but they are not enough. It is necessary to change <br>
//!          the approach and double the Spine of line C2 with <br>
//!          the known consequences for management of <br>
//!          interactions between KPart Blend in Fil3d. <br>
class ChFiDS_Spine : public MMgt_TShared {

public:

  
  Standard_EXPORT   ChFiDS_Spine();
  
  Standard_EXPORT   ChFiDS_Spine(const Standard_Real Tol);
  //! store edges composing the guideline <br>
        void SetEdges(const TopoDS_Edge& E) ;
  //! store the edge at the first position before all others <br>
        void PutInFirst(const TopoDS_Edge& E) ;
  
        Standard_Integer NbEdges() const;
  
       const TopoDS_Edge& Edges(const Standard_Integer I) const;
  //! stores if the start of a set of edges starts on a <br>
//! section of free border or forms  a closed contour <br>
        void SetFirstStatus(const ChFiDS_State S) ;
  //! stores if the end of a set of edges starts on a <br>
//! section of free border or forms  a closed contour <br>
        void SetLastStatus(const ChFiDS_State S) ;
  
  Standard_EXPORT   virtual  void AppendElSpine(const Handle(ChFiDS_HElSpine)& Els) ;
  
  Standard_EXPORT     Handle_ChFiDS_HElSpine ElSpine(const Standard_Integer IE) const;
  
  Standard_EXPORT     Handle_ChFiDS_HElSpine ElSpine(const TopoDS_Edge& E) const;
  
  Standard_EXPORT     Handle_ChFiDS_HElSpine ElSpine(const Standard_Real W) const;
  
  Standard_EXPORT     ChFiDS_ListOfHElSpine& ChangeElSpines() ;
  
  Standard_EXPORT   virtual  void Reset(const Standard_Boolean AllData = Standard_False) ;
  
  Standard_EXPORT     Standard_Boolean SplitDone() const;
  
  Standard_EXPORT     void SplitDone(const Standard_Boolean B) ;
  //! prepare the guideline depending on the edges that <br>
//!          are elementary arks (take parameters from <br>
//!          a single curvilinear abscissa); to be able to call <br>
//!          methods on the geometry (first,last,value,d1,d2) <br>
//!          it is necessary to start with preparation otherwise an <br>
//!          exception will be raised <br>
  Standard_EXPORT     void Load() ;
  
  Standard_EXPORT     Standard_Real Resolution(const Standard_Real R3d) const;
  
  Standard_EXPORT     Standard_Boolean IsClosed() const;
  
  Standard_EXPORT     Standard_Real FirstParameter() const;
  
  Standard_EXPORT     Standard_Real LastParameter() const;
  
  Standard_EXPORT     void SetFirstParameter(const Standard_Real Par) ;
  
  Standard_EXPORT     void SetLastParameter(const Standard_Real Par) ;
  //! gives the total length of all arcs before the <br>
//!          number IndexSp <br>
  Standard_EXPORT     Standard_Real FirstParameter(const Standard_Integer IndexSpine) const;
  //! gives the total length till the ark with number <br>
//!          IndexSpine (inclus) <br>
  Standard_EXPORT     Standard_Real LastParameter(const Standard_Integer IndexSpine) const;
  //! gives the length of ark with number IndexSp <br>
  Standard_EXPORT     Standard_Real Length(const Standard_Integer IndexSpine) const;
  
  Standard_EXPORT     Standard_Boolean IsPeriodic() const;
  
  Standard_EXPORT     Standard_Real Period() const;
  
  Standard_EXPORT     Standard_Real Absc(const Standard_Real U) ;
  
  Standard_EXPORT     Standard_Real Absc(const Standard_Real U,const Standard_Integer I) ;
  
  Standard_EXPORT     void Parameter(const Standard_Real AbsC,Standard_Real& U,const Standard_Boolean Oriented = Standard_True) ;
  
  Standard_EXPORT     void Parameter(const Standard_Integer Index,const Standard_Real AbsC,Standard_Real& U,const Standard_Boolean Oriented = Standard_True) ;
  
  Standard_EXPORT     gp_Pnt Value(const Standard_Real AbsC) ;
  
  Standard_EXPORT     void D0(const Standard_Real AbsC,gp_Pnt& P) ;
  
  Standard_EXPORT     void D1(const Standard_Real AbsC,gp_Pnt& P,gp_Vec& V1) ;
  
  Standard_EXPORT     void D2(const Standard_Real AbsC,gp_Pnt& P,gp_Vec& V1,gp_Vec& V2) ;
  
  Standard_EXPORT     void SetCurrent(const Standard_Integer Index) ;
  //! sets the current curve and returns it <br>
  Standard_EXPORT    const BRepAdaptor_Curve& CurrentElementarySpine(const Standard_Integer Index) ;
  
        Standard_Integer CurrentIndexOfElementarySpine() const;
  
  Standard_EXPORT     GeomAbs_CurveType GetType() const;
  
  Standard_EXPORT     gp_Lin Line() const;
  
  Standard_EXPORT     gp_Circ Circle() const;
  //! returns if the set of edges starts on a free boundary <br>
//!          or if the first vertex is a breakpoint or if the set is <br>
//!          closed <br>
        ChFiDS_State FirstStatus() const;
  //! returns the state at the end of the set <br>
        ChFiDS_State LastStatus() const;
  
        ChFiDS_State Status(const Standard_Boolean IsFirst) const;
  
        void SetStatus(const ChFiDS_State S,const Standard_Boolean IsFirst) ;
  //!  returns   if the  set  of  edges starts (or   end) on <br>
//!          Tangency point. <br>
        Standard_Boolean IsTangencyExtremity(const Standard_Boolean IsFirst) const;
  
        void SetTangencyExtremity(const Standard_Boolean IsTangency,const Standard_Boolean IsFirst) ;
  
  Standard_EXPORT     Standard_Real Absc(const TopoDS_Vertex& V) const;
  
  Standard_EXPORT     TopoDS_Vertex FirstVertex() const;
  
  Standard_EXPORT     TopoDS_Vertex LastVertex() const;
  
  Standard_EXPORT     void SetFirstTgt(const Standard_Real W) ;
  
  Standard_EXPORT     void SetLastTgt(const Standard_Real W) ;
  
  Standard_EXPORT     Standard_Boolean HasFirstTgt() const;
  
  Standard_EXPORT     Standard_Boolean HasLastTgt() const;
  //! set a parameter reference for the approx. <br>
  Standard_EXPORT     void SetReference(const Standard_Real W) ;
  //! set  a  parameter  reference  for  the approx,  at the <br>
//!          middle  of edge I. <br>
  Standard_EXPORT     void SetReference(const Standard_Integer I) ;
  
  Standard_EXPORT     Standard_Integer Index(const Standard_Real W,const Standard_Boolean Forward = Standard_True) const;
  
  Standard_EXPORT     Standard_Integer Index(const TopoDS_Edge& E) const;
  
  Standard_EXPORT     void UnsetReference() ;
  
  Standard_EXPORT     void SetErrorStatus(const ChFiDS_ErrorStatus state) ;
  
  Standard_EXPORT     ChFiDS_ErrorStatus ErrorStatus() const;




  DEFINE_STANDARD_RTTI(ChFiDS_Spine)

protected:


Standard_Boolean splitdone;
ChFiDS_ListOfHElSpine elspines;


private: 

  
  Standard_EXPORT     void Prepare(Standard_Real& L,Standard_Integer& Index) const;

BRepAdaptor_Curve myCurve;
Standard_Integer indexofcurve;
ChFiDS_State firstState;
ChFiDS_State lastState;
TopTools_SequenceOfShape spine;
Handle_TColStd_HArray1OfReal abscissa;
Standard_Real tolesp;
Standard_Real firstparam;
Standard_Real lastparam;
Standard_Boolean firstprolon;
Standard_Boolean lastprolon;
Standard_Boolean firstistgt;
Standard_Boolean lastistgt;
Standard_Real firsttgtpar;
Standard_Real lasttgtpar;
Standard_Boolean hasfirsttgt;
Standard_Boolean haslasttgt;
gp_Pnt firstori;
gp_Pnt lastori;
gp_Vec firsttgt;
gp_Vec lasttgt;
Standard_Real valref;
Standard_Boolean hasref;
ChFiDS_ErrorStatus errorstate;


};


#include <ChFiDS_Spine.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
