/*
 * nzb
 *
 * Copyright (C) 2004-2006 Mattias Nordstrom <matta at ftlight net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * Authors:
 *   Mattias Nordstrom <matta at ftlight net>
 *
 * $Id: mainwindow.h,v 1.6 2005/10/03 19:04:55 mnordstr Exp $
 *   This file provides the GUI.
 */


#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui>

#include "nzbdata.h"
#include "downloader.h"
#include "decoder.h"
#include "output.h"

#include "ui_options.h"

class QAction;
class QMenu;

class MainWindow : public QMainWindow
{
	Q_OBJECT
public:
	MainWindow();
	void loadFile(const QString &fileName);
	bool shuttingDown() const { return shutting_down; }
	QSettings* getConfig() { return config; }
	void setConfig(QSettings *config) { this->config = config; }
	QTableWidgetItem* getDownloaderItem(int thread_id) { return d->item(thread_id, 0); }

public slots:
	void downloadEvent(QString message, int row, int type);
	void decodeEvent(QString message, int row, int type);
	void outputEvent(QString message, int type);

protected:
	void closeEvent(QCloseEvent *event);

private slots:
	void open();
	void about();
	void start();
	void stop();
	void stream();
	void options();
	void sortList();
	void clearList() { clearData(); }
	
signals:
	void processDecoder();
	void processOutput();
	void processDownloader();
	void fullStop();

private:
	void createActions();
	void createMenus();
	void createToolBars();
	void createStatusBar();
	void readSettings();
	void writeSettings();
	void clearData();
	void populateList();

	QTableWidget *l, *d;
	QSplitter *split;
    
	QTableView *view;
    
	NzbList nzblist;
	QList<Downloader*> downloaders;
	QList<Decoder*> decoders;
	Output *output;
	
	QMutex file_lock;
	//QWaitCondition dc_done;

	QMenu *fileMenu;
	QMenu *editMenu;
	QMenu *helpMenu;
	QMenu *toolsMenu;
	QMenu *actionsMenu;
	QToolBar *fileToolBar, *actionToolBar;
	QAction *openAct;
	QAction *exitAct;
	QAction *aboutAct;
	QAction *optionsAct;
	QAction *startAct;
	QAction *stopAct;
	QAction *streamAct;
	QAction *sortAct;
	QAction *clearAct;
	
	QLabel *totalSpeed;
	QLabel *totalSize;
	QProgressBar *totalProgress;
	
	bool shutting_down;
	
	QSettings *config;
};

class OptionsDlg : public QDialog
{
	Q_OBJECT

public:
	OptionsDlg(QWidget *parent = 0);

private:
	Ui::OptionsDlg ui;
	QObject *parent;
	
private slots:
	void accept();
	void reject();
	void browseSave();
	void browseMedia();
	void enableGuess(int state);
	void sslChange(int state);
	void useFile();
};

#endif
