#include "portable.h"

#include <stdio.h>

#include <ac/ctype.h>
#include <ac/socket.h>
#include <ac/string.h> 
#include <ac/time.h>

#include <pwd.h>

#include "slap.h"
#include "external.h"
#include <ldap_pvt.h>
#include "nws_back_cache.h"
#include "nws_back.h"

int
nws_back_modify(BackendDB *be,
				Connection *conn,
				Operation *op,
				const char *dn,
				const char *ndn,
				Modifications *modlist)
{
  nwsCacheConfig *ncc;
  struct nws_series_collection *nser_coll;
  Rb_node rb_ptr;
  char *name;
  char *rdn;

  Modification *mod;
  Modifications *ml;

  int i;

  Debug(LDAP_DEBUG_TRACE,"==>nws_back_modify()\n",0,0,0);

  ncc = (nwsCacheConfig *)be->be_private;

  if (!ncc)  {
	Debug(LDAP_DEBUG_TRACE,"nws_back_modify(): be_private is NULL.\n",0,0,0);
	send_ldap_result(conn,op,LDAP_OTHER,"","NWS error",NULL,NULL);
	return(-1);
  }

  if(strncmp(ndn,"VO-GRID",sizeof("vo-grid")-1)) {
	Debug(LDAP_DEBUG_TRACE,"nws_back_modify(): ndn \"%s\" is invalid.\n",
		  ndn,0,0);
	exit(-1);
  }

  if (ncc->grid_count < 1) {
	send_ldap_result(conn,op,LDAP_OTHER,"","VOgrid support not enabled",
					 NULL,NULL);
	return(0);
  }

  rdn = dn_rdn(be, dn);
  name = rdn_attr_value(rdn);

  pthread_mutex_lock(&ncc->nser_coll_mutex);
  rb_ptr = rb_find_key_n(ncc->nser_coll_tree, name, &i);
  

  if (i != 0) {
	/* if it already exists, delete it and make another. */
	/* send_ldap_result(conn,op,LDAP_OTHER,"","VOGrid already exists",NULL,NULL); 
	   return(0); */
	nser_coll = (struct nws_series_collection *)rb_ptr->v.val;
	rb_delete_node(rb_ptr);
	nws_free_coll(ncc, nser_coll);
  }

  /* Debug(LDAP_DEBUG_TRACE,"nws_back_modify(): ndn: '%s'\n", ndn,0,0); */
  Debug(LDAP_DEBUG_TRACE,"nws_back_modify(): dn: '%s'\n", dn,0,0);

  for(ml=modlist; ml!=NULL; ml=ml->sml_next) {
	mod=&ml->sml_mod;

	if(!strcmp(mod->sm_desc->ad_cname->bv_val, "members")) {
	  nws_make_coll(ncc, name, mod->sm_bvalues[0]->bv_val, "user");
	}
	else if(!strcmp(mod->sm_desc->ad_cname->bv_val, "grid-member")) {
	  nser_coll = nws_new_coll(ncc);
	  nser_coll->name = strdup(name);
	  nser_coll->type = strdup("user");
	  for ( i = 0; mod->sm_bvalues[i] != NULL; i++ ) {
		nws_coll_addmember(ncc, nser_coll, mod->sm_bvalues[i]->bv_val);
	  }
	  nws_cache_infer((nwsBackConfig *)ncc, ncc->nws_obj_list, nser_coll);
	  rb_insert(ncc->nser_coll_tree, nser_coll->name, (char *)nser_coll);
	}

	if( mod->sm_bvalues != NULL ) {
	  for ( i = 0; mod->sm_bvalues[i] != NULL; i++ ) {
		Debug(LDAP_DEBUG_TRACE,"nws_back_modify(): modifications: '%s':'%s'\n",
		  mod->sm_desc->ad_cname->bv_val, mod->sm_bvalues[i]->bv_val,0);
	  }
	}

	/*
	switch(mod->sm_op) {
	case LDAP_MOD_REPLACE:
	case LDAP_MOD_ADD:
	case LDAP_MOD_DELETE:
	  break;
	}
	*/
  }

  pthread_mutex_unlock(&ncc->nser_coll_mutex);

  if(name != NULL) {free(name);}

  send_ldap_result(conn,op,LDAP_SUCCESS,"",NULL,NULL,NULL);

  Debug(LDAP_DEBUG_TRACE,"<==nws_back_modify()\n",0,0,0);
  return 0;
}
