#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Copyright(C) 2007 INL
Written by Romain Bignon <romain AT inl.fr>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 3 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

$Id: conf-l10n.py 10567 2007-10-26 08:14:10Z romain $
"""

import re
import os

mypath = os.path.dirname(__file__) + os.sep

# #: nulog-web/xml/nulog.xml:21
# msgid ""
# "Search"
# msgstr ""

class Parser:

	def __init__(self):

		self.titles = {}

	def parse(self, filename):

		f = file(mypath + os.sep + filename)

		i = 0
		for line in f.readlines():

			i += 1
			page = re.compile('page.([a-zA-Z0-9_]+).title (.*)')
			frags = re.compile('frag.([a-zA-Z0-9_]+).arg.title (.*)')

			regs = page.match(line)
			if not regs:
				regs = frags.match(line)
				if not regs:
					continue

			try:
				self.titles[regs.group(2)] += [(filename, i)]
			except:
				self.titles[regs.group(2)] = [(filename, i)]

	def render(self):

		for title, files in self.titles.items():

			print '#: %s' % ' ,'.join(['%s:%d' % (f,i) for f, i in files])
			print 'msgid ""'
			print '"%s"' % title
			print 'msgstr""'
			print ''

	def main(self):

		for racine, reps, files in os.walk(mypath):
			for f in files:
				if not f.endswith('.conf'):
					continue

				self.parse(f)

		self.render()

if __name__ == '__main__':

	p = Parser()
	p.main()
