/****************************************************************************/
/* |\   ======   /| **               MCL                ** |\   ======   /| */
/* |__\========/__| **       Masar Class Libraries      ** |__\========/__| */
/* |\            /| ** -------------------------------- ** |\            /| */
/* |  \        /  | **  Maurizio Sartori (c) 1998-2000  ** |  \        /  | */
/* |    \    /    | ** -------------------------------- ** |    \    /    | */
/* |    /=\/=\    | **            Written  by           ** |    /=\/=\    | */
/* |  /========\  | **     Maurizio Sartori 'masar'     ** |  /========\  | */
/* |/   ======   \| **     e-mail:  masar@libero.it     ** |/   ======   \| */
/****************************************************************************/
/*              This program comes with ABSOLUTELY NO WARRANTY              */
/*            for details refer to the GNU General Public License           */
/****************************************************************************/
/*\F $Id: adb.hpp,v 1.1.1.1 2003/03/17 09:49:20 carlo Exp $
*****************************************************************************/
#ifndef  _MCL_UTIL_ADB_H_
#define  _MCL_UTIL_ADB_H_

#include <iostream>

#include <mcl/mcl.hpp>

class MCL_ASCII_DB_RECORD;                      // Forward declaration

/****************************************************************************/
/*                             class MCL_ASCII_DB                           */
/****************************************************************************/
class MCL_ASCII_DB
   {
   private:
      /**********************************************************************/
      /*                            Private Data                            */
      /**********************************************************************/
      PSZ       psz_Buff;
      PSZ       psz_BuffPos;
      PSZ       psz_BuffEnd;
      INT       i_BuffSize;
      PCSZ    * apcsz_Fields;
      INT       i_FieldsSize;
      INT       i_FieldsUsed;
      istream & is_IStream;
      LONG      l_StreamPos;
      CHAR      ch_FieldSep;
      PCSZ      pcsz_Default;

      /**********************************************************************/
      /*                         Private Functions                          */
      /**********************************************************************/
      MCL_ASCII_DB (const MCL_ASCII_DB & obj);               // Don't Use
      MCL_ASCII_DB & operator= (const MCL_ASCII_DB & obj);   // Don't Use

      MCL_APIRET ReadBuffer (VOID);
      MCL_APIRET ReallocBuffer (VOID);

      MCL_APIRET AddField (PCSZ pcszField);
      MCL_APIRET ReallocField (VOID);
      MCL_APIRET RecalcField (PCSZ pcszNewField0);
      MCL_APIRET ResetField (VOID);
//      MCL_APIRET TerminateField (VOID);

   public:
      /**********************************************************************/
      /*                          Public Functions                          */
      /**********************************************************************/
      MCL_ASCII_DB (istream & isIStream, CHAR chFieldSep = '\t',
                    PCSZ pcszDefault = NULL);

      MCL_APIRET Next (VOID);

      PCSZ operator [] (INT i) const
         {
         return (((i < i_FieldsUsed) && (i >= 0)) ?
                  apcsz_Fields[i] : pcsz_Default);
         }

      INT  QueryFields (VOID) const       { return (i_FieldsUsed); }
      LONG QueryPos (VOID) const          { return (l_StreamPos); }

      MCL_APIRET CopyRecord (MCL_ASCII_DB_RECORD & mclAdbRecord);
   };  /* end-class MCL_ASCII_DB */

/****************************************************************************/
/*                         class MCL_ASCII_DB_RECORD                        */
/****************************************************************************/
class MCL_ASCII_DB_RECORD
   {
   private:
      /**********************************************************************/
      /*                            Private Data                            */
      /**********************************************************************/
      PSZ       psz_Buff;
      INT       i_BuffSize;
      PCSZ    * apcsz_Fields;
      INT       i_FieldsSize;
      INT       i_FieldsUsed;
      PCSZ      pcsz_Default;

      /**********************************************************************/
      /*                         Private Functions                          */
      /**********************************************************************/
      MCL_ASCII_DB_RECORD (const MCL_ASCII_DB_RECORD & obj);
      MCL_ASCII_DB_RECORD & operator= (const MCL_ASCII_DB_RECORD & obj);

   public:
      /**********************************************************************/
      /*                          Public Functions                          */
      /**********************************************************************/
      MCL_ASCII_DB_RECORD (PCSZ pcszDefault = NULL);
      ~MCL_ASCII_DB_RECORD (VOID);

      PCSZ operator [] (INT i) const
         {
         return (((i < i_FieldsUsed) && (i >= 0)) ?
                  apcsz_Fields[i] : pcsz_Default);
         }

      INT  QueryFields (VOID) const       { return (i_FieldsUsed); }

      friend MCL_APIRET MCL_ASCII_DB::CopyRecord (
                  MCL_ASCII_DB_RECORD & mclAdbRecord);
   };  /* end-class MCL_ASCII_DB_RECORD */

/****************************************************************************/
#endif   // !defined (_MCL_UTIL_ADB_H_)
