/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/

// UserHandle.cpp: implementation of the UserHandle class.
//
//////////////////////////////////////////////////////////////////////

#include "UserHandle.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


UserHandle UserHandle::EmptyInstance;

UserHandle::UserHandle(const UserHandle & other)
{
	m_Datas = NULL;
	m_UserId = 0;
	*this = other;
}

UserHandle::UserHandle()
{
	m_Datas = NULL;
	m_UserId = 0;
}

UserHandle::~UserHandle()
{
}

const mString & UserHandle::GetUserName() const
{
	return m_UserName;
}

void UserHandle::SetUserName(const mString & UserName)
{
	m_UserName = UserName;
}

const mString & UserHandle::GetPassword() const
{
	return m_Password;
}

void UserHandle::SetPassword(const mString & Password)
{
	m_Password = Password;
}

bool UserHandle::SetUserCert(const PKI_CERT & UserCert)
{
	m_UserCert = UserCert;
	return true;
}

const PKI_CERT & UserHandle::GetUserCert() const
{
	return m_UserCert;
}

const void * UserHandle::GetClientData() const
{
	return m_Datas;
}

void UserHandle::SetClientData(void *Datas)
{
	m_Datas = Datas;
}

void UserHandle::SetUserId(unsigned long UserId)
{
	m_UserId = UserId;
}

unsigned long UserHandle::GetUserId() const
{
	return m_UserId;
}

UserHandle::operator int() const
{
	if(!m_UserCert && !m_UserName.size())
		return 0;
	else
		return 1;
}

bool UserHandle::operator=(const UserHandle &other)
{
	SetUserCert(other.GetUserCert());
	SetUserName(other.GetUserName());
	SetPassword(other.GetPassword());
	SetUserId(other.GetUserId());
	SetClientData((void*)other.GetClientData());
	return true;
}

const mString & UserHandle::get_context(const mString & name) const
{
	return ((UserHandle*)this)->m_context[name];
}

mString & UserHandle::get_context(const mString & name)
{
	return m_context[name];
}


