/**
	Cyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// PubStore.h: interface for the PubStore class.
//
//////////////////////////////////////////////////////////////////////

#ifndef PUBSTORE_H
#define PUBSTORE_H


#include "NewPKIStore.h"
#include <PKI_CRL.h>


/*!
	This class is the store for a Publication entity
*/
class PubStore : public NewPKIStore  
{
public:
	/*! \brief This is the constructor.
	 *  \param EntityName [IN] The name of the entity.
	 *  \param e [IN] The ENGINE, can be NULL.
	 */
	PubStore(const mString & EntityName, ENGINE * e);

	/*! \brief This is the destructor.
	 */
	virtual ~PubStore();

	bool CreateTables(const SQL_Connection * DbConn);

	/*! \brief This function declares a new CRL to the OCSP responder.
	 *  \param Crl [IN] The CRL.
	 *  \param issuer_name [IN] The name of the CRL's issuer.
	 *  \param issuer_pkey [IN] The public key of the CRL's issuer.
	 *  \return true on success, false on failure.
	 */
	bool OnNewCrl(const PKI_CRL & Crl, const X509_NAME *issuer_name, const X509_PUBKEY *issuer_pkey);

	/*! \brief This function declares a new certificate to the OCSP responder.
	 *  \param serial [IN] The serial of the new certificate.
	 *  \param issuer_name [IN] The name of the certificate's issuer.
	 *  \param issuer_pkey [IN] The public key of the certificate's issuer.
	 *  \return true on success, false on failure.
	 */
	bool OnNewCertificate(unsigned long serial, const X509_NAME * issuer_name, const X509_PUBKEY * issuer_pkey);

	/*! \brief This function declares as new revocation to the OCSP responder.
	 *  \param serial [IN] The serial of the revoked certificate.
	 *  \param rev_date [IN] The revocation date.
	 *  \param issuer_name [IN] The name of the certificate's issuer.
	 *  \param issuer_pkey [IN] The public key of the certificate's issuer.
	 *  \return true on success, false on failure.
	 */
	bool OnNewRevocation(unsigned long serial, time_t rev_date, const X509_NAME * issuer_name, const X509_PUBKEY * issuer_pkey);

	/*! \brief This function check the status of a certificate.
	 *  \param serial [IN] The serial to check.
	 *  \param issuer_name [IN] The name of the certificate's issuer.
	 *  \param issuer_pkey [IN] The public key of the certificate's issuer.
	 *  \param OcspStatus [OUT] The OCSP status.
	 *  \param rev_date [OUT] The revocation date.
	 *  \return true on success, false on failure.
	 */
	bool GetCertStatus(unsigned long serial, const X509_NAME * issuer_name, const X509_PUBKEY * issuer_pkey, int & OcspStatus, time_t & rev_date);
private:
	bool GetOcspCertIdStr(unsigned long serial, const X509_NAME *issuer_name, const X509_PUBKEY *issuer_pkey, mString & CertIdStr);
	#define PUBSTORE_CREATE_1				"create table rev_certs (ocsp_certid VARCHAR(41) NOT NULL PRIMARY KEY, revdate INT UNSIGNED NOT NULL, INDEX (ocsp_certid));"
	
	#define PUBSTORE_INSERT_CERT			"REPLACE INTO rev_certs (ocsp_certid, revdate) VALUES ('%s', '%ld');"
	#define PUBSTORE_GET_REV				"SELECT revdate FROM rev_certs WHERE ocsp_certid='%s';"
};

#endif
