/*
 	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com).
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


#include "Entity_RA_ASN1.h"
#include <PKI_ERR.h>
#include <openssl/asn1t.h>

ASN1_SEQUENCE(LOCAL_RA_CONF) = {
	ASN1_SIMPLE(LOCAL_RA_CONF, conf, ENTITY_CONF),
	ASN1_SIMPLE(LOCAL_RA_CONF, cas, INTERNAL_PKI_CA),
}ASN1_SEQUENCE_END(LOCAL_RA_CONF)
ASN1_SEQUENCE(LOCAL_RA_CONF_BETA4) = {
	ASN1_SIMPLE(LOCAL_RA_CONF_BETA4, conf, ENTITY_CONF_BETA4),
	ASN1_SIMPLE(LOCAL_RA_CONF_BETA4, cas, INTERNAL_PKI_CA),
}ASN1_SEQUENCE_END(LOCAL_RA_CONF_BETA4)
LocalRaConf LocalRaConf::EmptyInstance;
bool LocalRaConf::set_cas(const InternalPkiCa & c_cas)
{
	m_cas = c_cas;
	return true;
}

const InternalPkiCa & LocalRaConf::get_cas() const
{
	return m_cas;
}

InternalPkiCa & LocalRaConf::get_cas()
{
	return m_cas;
}

bool LocalRaConf::set_conf(const EntityConf & c_conf)
{
	m_conf = c_conf;
	return true;
}

const EntityConf & LocalRaConf::get_conf() const
{
	return m_conf;
}

EntityConf & LocalRaConf::get_conf()
{
	return m_conf;
}

bool LocalRaConf::to_SignEncrypt(Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey, const EVP_MD * sig_md, const EVP_CIPHER * crypt_cypher) const
{
	LOCAL_RA_CONF * c_localvar = NULL;
	if(!give_Datas(&c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Private_toSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE*)c_localvar, sig_pkey, crypt_pkey, sig_md, crypt_cypher))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

bool LocalRaConf::from_SignEncrypt(const Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey)
{
	LOCAL_RA_CONF * c_localvar = NULL;
	if(!Private_fromSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE**)&c_localvar, sig_pkey, crypt_pkey))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!load_Datas(c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
		return false;
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

LocalRaConf::LocalRaConf():NewPKIObject(), LocalEntityConf()
{
	resetAll();
}

LocalRaConf::LocalRaConf(const LocalRaConf & other):NewPKIObject(), LocalEntityConf()
{
	resetAll();
	*this = other;
}

LocalRaConf::~LocalRaConf()
{
	Clear();
}

void LocalRaConf::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void LocalRaConf::freeAll()
{
}

void LocalRaConf::resetAll()
{
	m_cas.Clear();
	m_conf.Clear();
}

bool LocalRaConf::load_Datas(const LOCAL_RA_CONF * Datas)
{
	Clear();
	if(Datas->cas)
	{
		if(!m_cas.load_Datas(Datas->cas))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->conf)
	{
		if(!m_conf.load_Datas(Datas->conf))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool LocalRaConf::give_Datas(LOCAL_RA_CONF ** Datas) const
{
	if(!(*Datas) && !(*Datas = (LOCAL_RA_CONF*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->cas && !((*Datas)->cas = (INTERNAL_PKI_CA*)ASN1_item_new(ASN1_ITEM_rptr(INTERNAL_PKI_CA))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_cas.give_Datas(&(*Datas)->cas))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->cas, ASN1_ITEM_rptr(INTERNAL_PKI_CA));
		(*Datas)->cas = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->conf && !((*Datas)->conf = (ENTITY_CONF*)ASN1_item_new(ASN1_ITEM_rptr(ENTITY_CONF))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_conf.give_Datas(&(*Datas)->conf))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->conf, ASN1_ITEM_rptr(ENTITY_CONF));
		(*Datas)->conf = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool LocalRaConf::operator=(const LocalRaConf & other)
{
	Clear();
	m_cas = other.m_cas;
	m_conf = other.m_conf;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * LocalRaConf::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(LOCAL_RA_CONF);
}
LocalRaConfBeta4 LocalRaConfBeta4::EmptyInstance;
bool LocalRaConfBeta4::set_cas(const InternalPkiCa & c_cas)
{
	m_cas = c_cas;
	return true;
}

const InternalPkiCa & LocalRaConfBeta4::get_cas() const
{
	return m_cas;
}

InternalPkiCa & LocalRaConfBeta4::get_cas()
{
	return m_cas;
}

bool LocalRaConfBeta4::set_conf(const EntityConfBeta4 & c_conf)
{
	m_conf = c_conf;
	return true;
}

const EntityConfBeta4 & LocalRaConfBeta4::get_conf() const
{
	return m_conf;
}

EntityConfBeta4 & LocalRaConfBeta4::get_conf()
{
	return m_conf;
}

bool LocalRaConfBeta4::to_SignEncrypt(Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey, const EVP_MD * sig_md, const EVP_CIPHER * crypt_cypher) const
{
	LOCAL_RA_CONF_BETA4 * c_localvar = NULL;
	if(!give_Datas(&c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Private_toSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE*)c_localvar, sig_pkey, crypt_pkey, sig_md, crypt_cypher))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

bool LocalRaConfBeta4::from_SignEncrypt(const Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey)
{
	LOCAL_RA_CONF_BETA4 * c_localvar = NULL;
	if(!Private_fromSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE**)&c_localvar, sig_pkey, crypt_pkey))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!load_Datas(c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
		return false;
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

LocalRaConfBeta4::LocalRaConfBeta4():NewPKIObject(), LocalEntityConfBeta4()
{
	resetAll();
}

LocalRaConfBeta4::LocalRaConfBeta4(const LocalRaConfBeta4 & other):NewPKIObject(), LocalEntityConfBeta4()
{
	resetAll();
	*this = other;
}

LocalRaConfBeta4::~LocalRaConfBeta4()
{
	Clear();
}

void LocalRaConfBeta4::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void LocalRaConfBeta4::freeAll()
{
}

void LocalRaConfBeta4::resetAll()
{
	m_cas.Clear();
	m_conf.Clear();
}

bool LocalRaConfBeta4::load_Datas(const LOCAL_RA_CONF_BETA4 * Datas)
{
	Clear();
	if(Datas->cas)
	{
		if(!m_cas.load_Datas(Datas->cas))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->conf)
	{
		if(!m_conf.load_Datas(Datas->conf))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool LocalRaConfBeta4::give_Datas(LOCAL_RA_CONF_BETA4 ** Datas) const
{
	if(!(*Datas) && !(*Datas = (LOCAL_RA_CONF_BETA4*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->cas && !((*Datas)->cas = (INTERNAL_PKI_CA*)ASN1_item_new(ASN1_ITEM_rptr(INTERNAL_PKI_CA))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_cas.give_Datas(&(*Datas)->cas))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->cas, ASN1_ITEM_rptr(INTERNAL_PKI_CA));
		(*Datas)->cas = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->conf && !((*Datas)->conf = (ENTITY_CONF_BETA4*)ASN1_item_new(ASN1_ITEM_rptr(ENTITY_CONF_BETA4))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_conf.give_Datas(&(*Datas)->conf))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->conf, ASN1_ITEM_rptr(ENTITY_CONF_BETA4));
		(*Datas)->conf = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool LocalRaConfBeta4::operator=(const LocalRaConfBeta4 & other)
{
	Clear();
	m_cas = other.m_cas;
	m_conf = other.m_conf;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * LocalRaConfBeta4::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(LOCAL_RA_CONF_BETA4);
}
