/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/

// Entity_PUBLICATION.h: interface for the Entity_PUBLICATION class.
//
//////////////////////////////////////////////////////////////////////

#ifndef ENTITY_PUBLICATION_H
#define ENTITY_PUBLICATION_H


#include "Entity.h"
#include "Entity_PUBLICATION_ASN1.h"
#include "PublicationMethod.h"
#include "PubStore.h"
#include <PKI_P7B.h>
#include <openssl/ocsp.h>

#include "OcspServers.h"
#include <mVector.h>
using namespace std;


/*!
	This class represents a Publication Entity
*/
class Entity_PUBLICATION : public Entity  
{
public:
	void PrintInfo(FILE * out);
	Entity_PUBLICATION(ENTITY_CONSTRUCTOR_PARAMETERS);
	virtual ~Entity_PUBLICATION();

	bool Responder_ValidateRequest(const NewpkiRequest & Request, const X509_PUBKEY * Requester, mString & SenderName);
	bool Responder_TreatRequest(const NewpkiRequest & Request, const mString & SenderName, NewpkiResponse & Response);

	bool Load();
	bool Create(const EntityCreationDatas & Params, AdminResponseBody & response);
	bool Upgrade(const char * Version);
	bool Init(const EntitySignatureResp & init_datas);
	bool ParseAdminCommand(AdminResponseBody & response, const PKI_CERT & ClientCert, const AdminRequest & AdminRequest);

	/*! \brief This function returns the list of types of logs the entity generates.
	 *  \param cLogsType [OUT] The list.
	 */
	static void LogsTypeGet(mVector<unsigned long> & cLogsType);

	/*! \brief This function returns the list of types of ACL the entity handles.
	 *  \param acl_list [OUT] The list.
	 */
	static void GetACL_List(mVector<unsigned long> & acl_list);

	/*! \brief This function is called to initialize the OCSP responder.
	 *  \param OcspServersHandler [IN] The OCSP servers provider.
	 */
	void SetOcspServersHandler(OcspServers * OcspServersHandler);

	/*! \brief This function is called when a new OCSP request arrives.
	 *  \param Ip [IN] The IP of the requester.
	 *  \param request [IN] The OCSP request.
	 *  \param response [OUT] The OCSP response.
	 *  \return true on success, false on failure.
	 */
	bool OnNewOCSP(const char * Ip, const OCSP_REQUEST *request, OCSP_RESPONSE **response);

private:
	bool PrepareConfToWrite();
	#define PUB_ENTITY_CREATE_1			"create table ocsp_cert (id INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY, ocsp_cert TEXT NOT NULL, ocsp_key TEXT NOT NULL);"
	#define PUB_ENTITY_SET_OCSP			"REPLACE INTO ocsp_cert (id, ocsp_cert, ocsp_key) VALUES (1, '%s', '%s');"
	#define PUB_ENTITY_GET_OCSP			"SELECT * FROM ocsp_cert;" 

	void LoadOcsp();
	bool Private_OnNewOCSP(const char * Ip, const OCSP_REQUEST * request, OCSP_RESPONSE ** response);
	X509 * GetIssuer(const mVector<PKI_CERT> & ParentCerts, X509 * Cert, X509_CRL * Crl);
	void AddUnknownCAs(const mVector<PKI_CERT> & CAs);
	bool GetOcspCertStatus(OCSP_CERTID *cid, int & OcspStatus, time_t & rev_date, mString & CaName, unsigned long & RequestSerial);
	void UnloadAllPub();
	bool LoginUser(UserHandle & hUser, int & UserType);
	void LogoutUser(const UserHandle & hUser);
	
	static bool Private_ParseAdminCommand(bool ExecuteCmd, Entity * me_this, mVector<unsigned long> &  mLogsType, AdminResponseBody & response, const PKI_CERT & ClientCert, const AdminRequest & AdminRequest, UserHandle & hUser);

	bool ParseNewConf();

	LocalPublicationConf myConf;

	ReadersWriter ListPublicationsLock;
	mVector<PublicationMethod*> ListPublications;
	PKI_CERT m_OcspCert;
	PKI_RSA m_OcspKey;

	PubStore PublicationStore;
	OcspServers * m_OcspServersHandler;

	NewpkiThread hThreadWorker;

#define MY_PUBLICATION_CONF_PTR body->d.conf
	DECLARE_COMMAND_PARSER(Entity_PUBLICATION);
};

#endif
