/*
 * Copyright (C) 2009, 2010  Daniel Borkmann <daniel@netsniff-ng.org> and 
 *                           Emmanuel Roullit <emmanuel@netsniff-ng.org>
 *
 * This program is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation; either version 2 of the License, or (at 
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along 
 * with this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St, Fifth Floor, Boston, MA 02110, USA
 */

#ifndef _NET_ETHER_TYPES_H_
#define _NET_ETHER_TYPES_H_

#include <stdint.h>

struct ether_type {
	uintptr_t id;
	char *type;
};

/* Partly taken from linux/if_ether.h and some other places on the net. */
static const struct ether_type ether_types[] = {
	{0x0000, "IEEE802.3 Length Field"},
	{0x0060, "Ethernet Loopback packet"},
	{0x0101, "Experimental"},
	{0x0200, "Xerox PUP packet"},
	{0x0201, "Xerox PUP Addr Trans packet"},
	{0x0400, "Nixdorf (conflicts with 802.3 Length Field)"},
	{0x05f8, "Ethernet II"},
	{0x0600, "XEROX NS IDP"},
	{0x0601, "XNS Address Translation (3Mb only)"},
	{0x0660, "DLOG"},
	{0x0661, "DLOG"},
	{0x0800, "IPv4"},
	{0x0801, "X.75 Internet"},
	{0x0802, "NBS Internet"},
	{0x0803, "ECMA Internet"},
	{0x0804, "Chaosnet"},
	{0x0805, "CCITT X.25"},
	{0x0806, "ARP"},
	{0x0807, "XNS Compatability"},
	{0x0808, "Frame Relay ARP"},
	{0x081C, "Symbolics Private"},
	{0x0888, "Xyplex"},
	{0x08FF, "G8BPQ AX.25 Ethernet Packet"},
	{0x0900, "Ungermann-Bass net debugger"},
	{0x0A00, "Xerox IEEE802.3 PUP packet"},
	{0x0A01, "Xerox IEEE802.3 PUP Addr Trans packet"},
	{0x0BAD, "Banyan VINES"},
	{0x0BAE, "VINES Loopback"},
	{0x0BAF, "VINES Echo"},
	{0x1000, "Berkeley Trailer nego"},
	{0x1001, "Berkeley Trailer encapsulation for IP"},
	{0x1002, "Berkeley Trailer encapsulation for IP"},
	{0x1003, "Berkeley Trailer encapsulation for IP"},
	{0x1004, "Berkeley Trailer encapsulation for IP"},
	{0x1005, "Berkeley Trailer encapsulation for IP"},
	{0x1006, "Berkeley Trailer encapsulation for IP"},
	{0x1007, "Berkeley Trailer encapsulation for IP"},
	{0x1008, "Berkeley Trailer encapsulation for IP"},
	{0x1009, "Berkeley Trailer encapsulation for IP"},
	{0x100A, "Berkeley Trailer encapsulation for IP"},
	{0x100B, "Berkeley Trailer encapsulation for IP"},
	{0x100C, "Berkeley Trailer encapsulation for IP"},
	{0x100D, "Berkeley Trailer encapsulation for IP"},
	{0x100E, "Berkeley Trailer encapsulation for IP"},
	{0x100F, "Berkeley Trailer encapsulation for IP"},
	{0x1234, "DCA - Multicast"},
	{0x1600, "Valid Systems"},
	{0x1989,
	 "Artificial Horizons (\"Aviator\" dogfight simulator [on Sun])"},
	{0x1995, "Datapoint Corporation (RCL lan protocol)"},
	{0x3C00, "3Com NBP virtual circuit datagram (like XNS SPP)"},
	{0x3C01, "3Com NBP System control datagram"},
	{0x3C02, "3Com NBP Connect request (virtual cct)"},
	{0x3C03, "3Com NBP Connect repsonse"},
	{0x3C04, "3Com NBP Connect complete"},
	{0x3C05, "3Com NBP Close request (virtual cct)"},
	{0x3C06, "3Com NBP Close response"},
	{0x3C07, "3Com NBP Datagram (like XNS IDP)"},
	{0x3C08, "3Com NBP Datagram broadcast"},
	{0x3C09, "3Com NBP Claim NetBIOS name"},
	{0x3C0A, "3Com NBP Delete Netbios name"},
	{0x3C0B, "3Com NBP Remote adaptor status"},
	{0x3C0C, "3Com NBP Remote adaptor response"},
	{0x3C0D, "3Com NBP Reset"},
	{0x4242, "PCS Basic Block Protocol"},
	{0x424C, "Information Modes Little Big LAN diagnostic"},
	{0x4321, "THD - Diddle"},
	{0x4C42, "Information Modes Little Big LAN"},
	{0x5208, "BBN Simnet"},
	{0x6000, "DEC Assigned proto"},
	{0x6001, "DEC DNA Dump/Load"},
	{0x6002, "DEC DNA Remote Console"},
	{0x6003, "DEC DNA Routing"},
	{0x6004, "DEC LAT"},
	{0x6005, "DEC Diagnostics"},
	{0x6006, "DEC Customer use"},
	{0x6007, "DEC Systems Comms Arch"},
	{0x6008, "DEC Unassigned"},
	{0x6009, "DEC MUMPS"},
	{0x6010, "3Com Corporation"},
	{0x6011, "3Com Corporation"},
	{0x6012, "3Com Corporation"},
	{0x6013, "3Com Corporation"},
	{0x6014, "3Com Corporation"},
	{0x6558, "Trans Ether Bridging"},
	{0x6559, "Raw Frame Relay"},
	{0x7000, "Ungermann-Bass download"},
	{0x7001, "Ungermann-Bass NIUs"},
	{0x7002, "Ungermann-Bass dia/loop"},
	{0x7003, "Ungermann-Bass ??? (NMC to/from UB Bridge)"},
	{0x7005, "Ungermann-Bass Bridge Spanning Tree"},
	{0x7007, "OS/9 Microware"},
	{0x7009, "OS/9 Net?"},
	{0x7020, "LRT (England) (now Sintrom)"},
	{0x7021, "LRT (England) (now Sintrom)"},
	{0x7022, "LRT (England) (now Sintrom)"},
	{0x7023, "LRT (England) (now Sintrom)"},
	{0x7024, "LRT (England) (now Sintrom)"},
	{0x7025, "LRT (England) (now Sintrom)"},
	{0x7026, "LRT (England) (now Sintrom)"},
	{0x7027, "LRT (England) (now Sintrom)"},
	{0x7028, "LRT (England) (now Sintrom)"},
	{0x7029, "LRT (England) (now Sintrom)"},
	{0x7030, "Proteon / Racal-Interlan"},
	{0x7031, "Prime NTS (Network Terminal Service)"},
	{0x7034, "Cabletron"},
	{0x8003, "Cronus VLN"},
	{0x8004, "Cronus Direct"},
	{0x8005, "HP Probe"},
	{0x8006, "Nestar"},
	{0x8008, "AT&T"},
	{0x8010, "Excelan"},
	{0x8013, "SGI diagnostics"},
	{0x8014, "SGI network games"},
	{0x8015, "SGI reserved"},
	{0x8016, "SGI bounce server"},
	{0x8019, "Apollo Domain"},
	{0x802E, "Tymshare"},
	{0x802F, "Tigan, Inc."},
	{0x8035, "RARP"},
	{0x8036, "Aeonic Systems"},
	{0x8037, "IPX (Novell Netware?)"},
	{0x8038, "DEC LanBridge Management"},
	{0x8039, "DEC DSM/DDP"},
	{0x803A, "DEC Argonaut Console"},
	{0x803B, "DEC VAXELN"},
	{0x803C, "DEC DNS Naming Service"},
	{0x803D, "DEC Ethernet CSMA/CD Encryption Protocol"},
	{0x803E, "DEC Distributed Time Service"},
	{0x803F, "DEC LAN Traffic Monitor Protocol"},
	{0x8040, "8040 DEC PATHWORKS DECnet NETBIOS Emulation"},
	{0x8041, "DEC Local Area System Transport"},
	{0x8042, "DEC unassigned"},
	{0x8044, "Planning Research Corp."},
	{0x8046, "AT&T"},
	{0x8047, "AT&T"},
	{0x8048,
	 "DEC Availability Manager for Distributed Systems DECamds (?)"},
	{0x8049, "ExperData"},
	{0x805B,
	 "VMTP (Versatile Message Transaction Protocol, RFC-1045) (Stanford)"},
	{0x805C, "Stanford V Kernel, version 6.0"},
	{0x805D, "Evans & Sutherland"},
	{0x8060, "Little Machines"},
	{0x8062, "Counterpoint Computers"},
	{0x8065, "Univ. of Mass. @ Amherst"},
	{0x8066, "Univ. of Mass. @ Amherst"},
	{0x8067, "Veeco Integrated Auto."},
	{0x8068, "General Dynamics"},
	{0x8069, "AT&T"},
	{0x806A, "Autophon"},
	{0x806C, "ComDesign"},
	{0x806D, "Computgraphic Corp."},
	{0x806E, "Landmark Graphics Corp."},
	{0x807A, "Matra"},
	{0x807B, "Dansk Data Elektronik"},
	{0x807C, "Merit Internodal"},
	{0x807D, "Vitalink Communications"},
	{0x8080, "Vitalink TransLAN III"},
	{0x8081, "Counterpoint Computers"},
	{0x809B, "Appletalk DDP"},
	{0x809C, "Datability"},
	{0x809F, "Spider Systems Ltd."},
	{0x80A3, "Nixdorf Computers"},
	{0x80A4, "Siemens Gammasonics Inc."},
	{0x80C0, "DCA Data Exchange Cluster"},
	{0x80C4, "Banyan Systems"},
	{0x80C5, "Banyan Systems"},
	{0x80C6, "Pacer Software"},
	{0x80C7, "Applitek Corporation"},
	{0x80C8, "Intergraph Corporation"},
	{0x80CD, "Harris Corporation"},
	{0x80CF, "Taylor Instrument"},
	{0x80D3, "Rosemount Corporation"},
	{0x80D5, "IBM SNA Service on Ether"},
	{0x80DD, "Varian Associates"},
	{0x80DE, "Integrated Solutions TRFS"},
	{0x80E0, "Allen-Bradley"},
	{0x80E4, "Datability"},
	{0x80F2, "Retix"},
	{0x80F3, "AppleTalk Address Resolution Protocol (AARP)"},
	{0x80F4, "Kinetics"},
	{0x80F7, "Apollo Computer"},
	{0x80FF, "Wellfleet Communications"},
	{0x8100, "802.1Q VLAN Extended Header"},
	{0x8101, "Wellfleet Communications"},
	{0x8102, "Wellfleet; BOFL (Breath OF Life) pkts [every 5-10 secs.]"},
	{0x8103, "Wellfleet Communications"},
	{0x8107, "Symbolics Private"},
	{0x812B, "Talaris"},
	{0x8130, "Hayes Microcomputers"},
	{0x8131, "VG Laboratory Systems"},
	{0x8132, "Bridge Communications"},
	{0x8137, "IPX over DIX"},
	{0x8138, "Novell, Inc."},
	{0x8139, "KTI"},
	{0x813F, "M/MUMPS data sharing"},
	{0x8145, "Vrije Universiteit (NL), Amoeba 4 RPC (obsolete)"},
	{0x8146,
	 "Vrije Universiteit (NL), FLIP (Fast Local Internet Protocol)"},
	{0x8147, "Vrije Universiteit (NL) [reserved]"},
	{0x8148, "Logicraft"},
	{0x8149, "Network Computing Devices"},
	{0x814A, "Alpha Micro"},
	{0x814C, "SNMP over Ethernet (see RFC1089)"},
	{0x814D, "BIIN"},
	{0x814E, "BIIN"},
	{0x814F, "Technically Elite Concept"},
	{0x8150, "Rational Corp"},
	{0x8151, "Qualcomm"},
	{0x815C, "Computer Protocol Pty Ltd"},
	{0x8164, "Charles River Data System"},
	{0x817D, "XTP"},
	{0x817E, "SGI/Time Warner prop."},
	{0x8180, "HIPPI-FP encapsulation"},
	{0x8181, "Spanning Tree Protocol (STP), HIPPI-ST"},
	{0x8182, "Reserved for HIPPI-6400"},
	{0x8183, "Reserved for HIPPI-6400"},
	{0x8184, "Silicon Graphics prop."},
	{0x818D, "Motorola Computer"},
	{0x8191, "PowerLAN NetBIOS/NetBEUI (PC)"},
	{0x819A, "Qualcomm"},
	{0x81A4, "ARAI Bunkichi"},
	{0x81A5, "RAD Network Devices"},
	{0x81B7, "Xyplex"},
	{0x81CC, "Apricot Computers"},
	{0x81D6, "Artisoft"},
	{0x81D7, "Artisoft"},
	{0x81E6, "Polygon"},
	{0x81F0, "Comsat Labs"},
	{0x81F3, "SAIC"},
	{0x81F6, "VG Analytical"},
	{0x8203, "Quantum Software"},
	{0x8221, "Ascom Banking Systems"},
	{0x823E, "Advanced Encryption Systems"},
	{0x827F, "Athena Programming"},
	{0x8263, "Charles River Data System"},
	{0x829A, "Inst Ind Info Tech"},
	{0x829C, "Taurus Controls"},
	{0x82AC, "Walker Richer & Quinn"},
	{0x8390, "Accton Technologies (unregistered)"},
	{0x852B, "Talaris multicast"},
	{0x8582, "Kalpana"},
	{0x8694, "Idea Courier"},
	{0x869E, "Computer Network Tech"},
	{0x86A3, "Gateway Communications"},
	{0x86DB, "SECTRA"},
	{0x86DE, "Delta Controls"},
	{0x86DD, "IPv6"},
	{0x86DF, "ATOMIC"},
	{0x86E0, "Landis & Gyr Powers"},
	{0x8700, "Motorola"},
	{0x8739, "Control Technology Inc. RDP Without IP"},
	{0x873A, "Control Technology Inc. Mcast Industrial Ctrl Proto."},
	{0x873B, "Control Technology Inc. Proprietary"},
	{0x873C, "Control Technology Inc. Proprietary"},
	{0x876B, "TCP/IP Compression"},
	{0x876C, "IP Autonomous Systems"},
	{0x876D, "Secure Data"},
	{0x8808, "IEEE Pause frame"},
	{0x8809, "Slow Protocol"},
	{0x880B, "PPP, Point-to-Point Protocol"},
	{0x880C, "GSMP, General Switch Management Protocol"},
	{0x8820, "Hitachi Cable (Optoelectronic Systems Laboratory)"},
	{0x883E, "Web-cache coordination protocol"},
	{0x8847, "MPLS Unicast traffic"},
	{0x8848, "MPLS Multicast traffic"},
	{0x884c, "MultiProtocol Over ATM"},
	{0x8856, "Axis Communications AB proprietary bootstrap/config"},
	{0x8863, "PPPoE Discovery Stage"},
	{0x8864, "PPPoE Session Stage"},
	{0x8884, "Frame-based ATM Transport over Ethernet"},
	{0x8888, "HP LanProbe test?"},
	{0x888E, "Port Access Entity"},
	{0x88A2, "ATA over Ethernet"},
	{0x88BB, "LWAPP, Light Weight Access Point Protocol"},
	{0x88CA, "TIPC"},
	{0x88CC, "LLDP, Link Layer Discovery Protocol"},
	{0x88F7, "IEEE 1588 Timesync"},
	{0x8906, "Fibre Channel over Ethernet"},
	{0x8914, "FCoE Initialization Protocol"},
	{0x8A96, "Invisible Software"},
	{0x8E88, "EAPOL, EAP over LAN"},
	{0x9000, "Loopback"},
	{0x9001, "3Com(Bridge) XNS Systems Management"},
	{0x9002, "3Com(Bridge) TCP/IP Systems Management"},
	{0x9003, "3Com(Bridge) loopback detection"},
	{0x9100, "VLAN Tag Protocol Identifier"},
	{0x9200, "VLAN Tag Protocol Identifier"},
	{0xAAAA, "DECNET? Used by VAX 6220 DEBNI"},
	{0xDADA, "Ethertype DSA"},
	{0xFAF5, "Sonix Arpeggio"},
	{0xFF00, "BBN VITAL-LanBridge cache wakeups (?)"},
	{0xFFFF, "Reserved"},
};

char type_unknown[] = "Unknown";

#endif				/* _NET_ETHER_TYPES_H_ */
