/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: connections.h,v 1.24 2008-02-23 08:35:04 anton Exp $ */

//////////////////////////////////////////////////////////////////////////
class Connection: public Object {
	public:
		pthread_t t_id;
		
		Connection();
		~Connection();
		Service *service;
		User *user;
		unsigned permissions;
		struct sockaddr_in *addr;
		Debug debug;
		time_t t_connected;
		time_t t_lastcmd;
		int socket;
		
		struct cli_def *cli;

		void setConnection(int fd, struct sockaddr_in *sock_addr);
		void clearConnection();
	};

class ConnectionsList: public List {
	public:
		unsigned last_conn_id;
		
		ConnectionsList();
		~ConnectionsList() {};
		Connection *getConnectionByThr(pthread_t t);
		unsigned getConnectionsLastId() { return last_conn_id; }
		void listConnections(struct cli_def *cli);
		void CancellAll();
	};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

