--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Narval.Configurator.Abstract_Actors_Coordination;
with Events_Receivers;

package Narval.Narval_Naming_Registry is

   pragma Remote_Call_Interface;

   --  inscriptions
   procedure Add_Sub_System
     (Sub_System_Name : String;
      Host_Name : String;
      Config : Configurator.Abstract_Actors_Coordination.Configuration_Access);
   procedure Remove_Sub_System (Sub_System_Name : String);
   Sub_System_Name_Already_Used : exception;

   function Get_Sub_Systems_Names return String;

   function Get_Configuration (Name : String) return
     Configurator.Abstract_Actors_Coordination.Configuration_Access;
   function Number_Of_Sub_Systems return Natural;

   Sub_System_Already_Present : exception;
   No_Such_Sub_System : exception;

   function Is_This_The_End return Boolean;
   procedure End_Registry_Service;
   Unable_To_End_Registry_Service : exception;

   function Get_Event_Receiver
     return Events_Receivers.Events_Receivers_Class_Access;
   No_Event_Receiver : exception;
   procedure Subscribe
     (Event_Receiver : Events_Receivers.Events_Receivers_Class_Access);
   Already_Existent_Receiver : exception;

end Narval.Narval_Naming_Registry;
