--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Narval.Actors;

package Narval.Configurator.Abstract_Actors_Coordination is
   pragma Remote_Types;

   type Configuration_Type is abstract tagged limited private;
   type Configuration_Access is access all Configuration_Type'Class;

   function Get_Configuration_Files
     (Config : access Configuration_Type)
     return String is abstract;
   procedure Special_Domi (Config : access Configuration_Type) is abstract;
   function Get_Xml (Config : access Configuration_Type;
                     Parameter : String) return String is abstract;
   function Get_Image (Config : access Configuration_Type;
                       Parameter_Name : String) return String is abstract;
   procedure Set (Config : access Configuration_Type;
                  Parameter : String;
                  Value : String) is abstract;
   procedure Trig_Event (Config : access Configuration_Type;
                         Event : String) is abstract;
   function Arguments (Config : access Configuration_Type;
                       Xml : Boolean := True)
                      return String is abstract;

   procedure Register (Config : access Configuration_Type;
                       Name : String;
                       Pointer : Actors.Actor_Class_Access) is abstract;
   function Get_Actor (Config : access Configuration_Type; Name : String)
                      return Actors.Actor_Class_Access is abstract;

   function Get_Active_Actors
     (Config : access Configuration_Type)
     return Actors.Actor_Class_Access_Array is abstract;

   function Get_Informations (Config : access Configuration_Type;
                              Name : String) return
     String is abstract;

   function Current_State (Config : access Configuration_Type)
                          return Acquisition_State_Type is abstract;
   function Order_Coherency (Config : access Configuration_Type;
                             Order : Action) return Boolean is abstract;
   function Available_Orders (Config : access Configuration_Type)
                             return Action_Array is abstract;

   procedure End_Actor_Handler (Config : access Configuration_Type)
      is abstract;
   procedure Change_State (Config : access Configuration_Type;
                           Order : Action) is abstract;
   No_More_Argument : exception;
   No_Such_Actor_In_Configuration : exception;
private
   type Configuration_Type is abstract tagged limited null record;
end Narval.Configurator.Abstract_Actors_Coordination;
